/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.animation.core;

import androidx.annotation.FloatRange;
import androidx.collection.IntObjectMap;
import androidx.collection.MutableIntList;
import androidx.collection.MutableIntObjectMap;
import androidx.compose.animation.core.AnimationVector;
import androidx.compose.animation.core.DurationBasedAnimationSpec;
import androidx.compose.animation.core.Easing;
import androidx.compose.animation.core.KeyframesSpec;
import androidx.compose.animation.core.KeyframesSpecBaseConfig;
import androidx.compose.animation.core.TwoWayConverter;
import androidx.compose.animation.core.VectorizedDurationBasedAnimationSpec;
import androidx.compose.animation.core.VectorizedMonoSplineKeyframesSpec;
import androidx.compose.runtime.Immutable;
import androidx.compose.runtime.internal.StabilityInferred;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002:\u0001\u0012B\u0015\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006B!\b\u0016\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u0012\b\b\u0001\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\u0005\u0010\tJ,\u0010\f\u001a\b\u0012\u0004\u0012\u0002H\u000e0\r\"\b\b\u0001\u0010\u000e*\u00020\u000f2\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u0002H\u000e0\u0011H\u0016R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Landroidx/compose/animation/core/KeyframesWithSplineSpec;", "T", "Landroidx/compose/animation/core/DurationBasedAnimationSpec;", "config", "Landroidx/compose/animation/core/KeyframesWithSplineSpec$KeyframesWithSplineSpecConfig;", "<init>", "(Landroidx/compose/animation/core/KeyframesWithSplineSpec$KeyframesWithSplineSpecConfig;)V", "periodicBias", "", "(Landroidx/compose/animation/core/KeyframesWithSplineSpec$KeyframesWithSplineSpecConfig;F)V", "getConfig", "()Landroidx/compose/animation/core/KeyframesWithSplineSpec$KeyframesWithSplineSpecConfig;", "vectorize", "Landroidx/compose/animation/core/VectorizedDurationBasedAnimationSpec;", "V", "Landroidx/compose/animation/core/AnimationVector;", "converter", "Landroidx/compose/animation/core/TwoWayConverter;", "KeyframesWithSplineSpecConfig", "animation-core"})
@Immutable
@SourceDebugExtension(value={"SMAP\nAnimationSpec.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AnimationSpec.kt\nandroidx/compose/animation/core/KeyframesWithSplineSpec\n+ 2 IntObjectMap.kt\nandroidx/collection/IntObjectMap\n+ 3 ScatterMap.kt\nandroidx/collection/ScatterMapKt\n*L\n1#1,1073:1\n382#2,4:1074\n354#2,6:1078\n364#2,3:1085\n367#2,9:1089\n386#2:1098\n425#2:1099\n425#2:1100\n1399#3:1084\n1270#3:1088\n*S KotlinDebug\n*F\n+ 1 AnimationSpec.kt\nandroidx/compose/animation/core/KeyframesWithSplineSpec\n*L\n764#1:1074,4\n764#1:1078,6\n764#1:1085,3\n764#1:1089,9\n764#1:1098\n768#1:1099\n771#1:1100\n764#1:1084\n764#1:1088\n*E\n"})
public final class KeyframesWithSplineSpec<T>
implements DurationBasedAnimationSpec<T> {
    @NotNull
    private final KeyframesWithSplineSpecConfig<T> config;
    private float periodicBias;
    public static final int $stable;

    public KeyframesWithSplineSpec(@NotNull KeyframesWithSplineSpecConfig<T> config2) {
        Intrinsics.checkNotNullParameter(config2, "config");
        this.config = config2;
        this.periodicBias = Float.NaN;
    }

    @NotNull
    public final KeyframesWithSplineSpecConfig<T> getConfig() {
        return this.config;
    }

    public KeyframesWithSplineSpec(@NotNull KeyframesWithSplineSpecConfig<T> config2, @FloatRange(from=0.0, to=1.0) float periodicBias) {
        Intrinsics.checkNotNullParameter(config2, "config");
        this(config2);
        this.periodicBias = periodicBias;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public <V extends AnimationVector> VectorizedDurationBasedAnimationSpec<V> vectorize(@NotNull TwoWayConverter<T, V> converter) {
        Intrinsics.checkNotNullParameter(converter, "converter");
        MutableIntObjectMap keyframes = this.config.getKeyframes$animation_core();
        MutableIntList timestamps = new MutableIntList(keyframes.getSize() + 2);
        MutableIntObjectMap<Pair<V, Easing>> timeToVectorMap = new MutableIntObjectMap<Pair<V, Easing>>(keyframes.getSize());
        IntObjectMap this_$iv = keyframes;
        boolean $i$f$forEach = false;
        int[] k$iv = this_$iv.keys;
        Object[] v$iv = this_$iv.values;
        IntObjectMap this_$iv$iv = this_$iv;
        boolean $i$f$forEachIndexed = false;
        long[] m$iv$iv = this_$iv$iv.metadata;
        int lastIndex$iv$iv = m$iv$iv.length - 2;
        int i$iv$iv = 0;
        if (i$iv$iv <= lastIndex$iv$iv) {
            while (true) {
                long slot$iv$iv;
                long $this$maskEmptyOrDeleted$iv$iv$iv = slot$iv$iv = m$iv$iv[i$iv$iv];
                boolean $i$f$maskEmptyOrDeleted = false;
                if (($this$maskEmptyOrDeleted$iv$iv$iv & ($this$maskEmptyOrDeleted$iv$iv$iv ^ 0xFFFFFFFFFFFFFFFFL) << 7 & 0x8080808080808080L) != -9187201950435737472L) {
                    int bitCount$iv$iv = 8 - (~(i$iv$iv - lastIndex$iv$iv) >>> 31);
                    for (int j$iv$iv = 0; j$iv$iv < bitCount$iv$iv; ++j$iv$iv) {
                        long value$iv$iv$iv = slot$iv$iv & 0xFFL;
                        boolean $i$f$isFull = false;
                        if (value$iv$iv$iv < 128L) {
                            void value;
                            int index$iv$iv;
                            int index$iv = index$iv$iv = (i$iv$iv << 3) + j$iv$iv;
                            boolean bl = false;
                            KeyframesSpec.KeyframeEntity keyframeEntity = (KeyframesSpec.KeyframeEntity)v$iv[index$iv];
                            int key = k$iv[index$iv];
                            boolean bl2 = false;
                            timestamps.add(key);
                            timeToVectorMap.set(key, new Pair<V, Easing>(converter.getConvertToVector().invoke(value.getValue$animation_core()), value.getEasing$animation_core()));
                        }
                        slot$iv$iv >>= 8;
                    }
                    if (bitCount$iv$iv != 8) break;
                }
                if (i$iv$iv == lastIndex$iv$iv) break;
                ++i$iv$iv;
            }
        }
        this_$iv = keyframes;
        int key$iv = 0;
        boolean $i$f$contains = false;
        if (!this_$iv.containsKey(key$iv)) {
            timestamps.add(0, 0);
        }
        this_$iv = keyframes;
        key$iv = this.config.getDurationMillis();
        $i$f$contains = false;
        if (!this_$iv.containsKey(key$iv)) {
            timestamps.add(this.config.getDurationMillis());
        }
        timestamps.sort();
        return new VectorizedMonoSplineKeyframesSpec(timestamps, (IntObjectMap)timeToVectorMap, this.config.getDurationMillis(), this.config.getDelayMillis(), this.periodicBias);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0007\u0018\u0000*\u0004\b\u0001\u0010\u00012\u0014\u0012\u0004\u0012\u0002H\u0001\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00010\u00030\u0002B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001d\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00010\u00032\u0006\u0010\u0007\u001a\u00028\u0001H\u0010\u00a2\u0006\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Landroidx/compose/animation/core/KeyframesWithSplineSpec$KeyframesWithSplineSpecConfig;", "T", "Landroidx/compose/animation/core/KeyframesSpecBaseConfig;", "Landroidx/compose/animation/core/KeyframesSpec$KeyframeEntity;", "<init>", "()V", "createEntityFor", "value", "createEntityFor$animation_core", "(Ljava/lang/Object;)Landroidx/compose/animation/core/KeyframesSpec$KeyframeEntity;", "animation-core"})
    @StabilityInferred(parameters=0)
    public static final class KeyframesWithSplineSpecConfig<T>
    extends KeyframesSpecBaseConfig<T, KeyframesSpec.KeyframeEntity<T>> {
        public static final int $stable = 8;

        public KeyframesWithSplineSpecConfig() {
            super(null);
        }

        @Override
        @NotNull
        public KeyframesSpec.KeyframeEntity<T> createEntityFor$animation_core(T value) {
            return new KeyframesSpec.KeyframeEntity(value, null, 0, 6, null);
        }
    }
}

