/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.runtime;

import androidx.collection.ScatterSet;
import androidx.collection.ScatterSetKt;
import androidx.compose.runtime.Applier;
import androidx.compose.runtime.Composer;
import androidx.compose.runtime.ComposerImpl;
import androidx.compose.runtime.CompositionContext;
import androidx.compose.runtime.CompositionImpl;
import androidx.compose.runtime.PausedComposition;
import androidx.compose.runtime.PausedCompositionState;
import androidx.compose.runtime.RecomposeScopeImpl;
import androidx.compose.runtime.RecordingApplier;
import androidx.compose.runtime.RememberObserver;
import androidx.compose.runtime.ShouldPauseCallback;
import androidx.compose.runtime.SynchronizedObject;
import androidx.compose.runtime.internal.RememberEventDispatcher;
import androidx.compose.runtime.internal.StabilityInferred;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0001\u0018\u00002\u00020\u0001B`\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u0012\u0011\u0010\u000b\u001a\r\u0012\u0004\u0012\u00020\r0\f\u00a2\u0006\u0002\b\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\n\u0010\u0011\u001a\u0006\u0012\u0002\b\u00030\u0012\u0012\n\u0010\u0013\u001a\u00060\u0014j\u0002`\u0015\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u0010\u00107\u001a\u00020\u00102\u0006\u00108\u001a\u000209H\u0016J\b\u0010:\u001a\u00020\rH\u0016J\b\u0010;\u001a\u00020\rH\u0016J\b\u0010<\u001a\u00020\rH\u0002J\b\u0010=\u001a\u00020\rH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u001e\u0010\u000b\u001a\r\u0012\u0004\u0012\u00020\r0\f\u00a2\u0006\u0002\b\u000e\u00a2\u0006\n\n\u0002\u0010 \u001a\u0004\b\u001e\u0010\u001fR\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u0015\u0010\u0011\u001a\u0006\u0012\u0002\b\u00030\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R\u0017\u0010\u0013\u001a\u00060\u0014j\u0002`\u0015\u00a2\u0006\n\n\u0002\u0010'\u001a\u0004\b%\u0010&R\u000e\u0010(\u001a\u00020)X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010*\u001a\b\u0012\u0004\u0012\u00020,0+X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010-\u001a\u00020.X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b/\u00100R\u001c\u00101\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010302X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b4\u00105R\u0014\u00106\u001a\u00020\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b6\u0010\"\u00a8\u0006>"}, d2={"Landroidx/compose/runtime/PausedCompositionImpl;", "Landroidx/compose/runtime/PausedComposition;", "composition", "Landroidx/compose/runtime/CompositionImpl;", "context", "Landroidx/compose/runtime/CompositionContext;", "composer", "Landroidx/compose/runtime/ComposerImpl;", "abandonSet", "", "Landroidx/compose/runtime/RememberObserver;", "content", "Lkotlin/Function0;", "", "Landroidx/compose/runtime/Composable;", "reusable", "", "applier", "Landroidx/compose/runtime/Applier;", "lock", "Landroidx/compose/runtime/SynchronizedObject;", "Landroidx/compose/runtime/platform/SynchronizedObject;", "<init>", "(Landroidx/compose/runtime/CompositionImpl;Landroidx/compose/runtime/CompositionContext;Landroidx/compose/runtime/ComposerImpl;Ljava/util/Set;Lkotlin/jvm/functions/Function2;ZLandroidx/compose/runtime/Applier;Landroidx/compose/runtime/SynchronizedObject;)V", "getComposition", "()Landroidx/compose/runtime/CompositionImpl;", "getContext", "()Landroidx/compose/runtime/CompositionContext;", "getComposer", "()Landroidx/compose/runtime/ComposerImpl;", "getContent", "()Lkotlin/jvm/functions/Function2;", "Lkotlin/jvm/functions/Function2;", "getReusable", "()Z", "getApplier", "()Landroidx/compose/runtime/Applier;", "getLock", "()Landroidx/compose/runtime/SynchronizedObject;", "Landroidx/compose/runtime/SynchronizedObject;", "state", "Landroidx/compose/runtime/PausedCompositionState;", "invalidScopes", "Landroidx/collection/ScatterSet;", "Landroidx/compose/runtime/RecomposeScopeImpl;", "rememberManager", "Landroidx/compose/runtime/internal/RememberEventDispatcher;", "getRememberManager$runtime", "()Landroidx/compose/runtime/internal/RememberEventDispatcher;", "pausableApplier", "Landroidx/compose/runtime/RecordingApplier;", "", "getPausableApplier$runtime", "()Landroidx/compose/runtime/RecordingApplier;", "isComplete", "resume", "shouldPause", "Landroidx/compose/runtime/ShouldPauseCallback;", "apply", "cancel", "markComplete", "applyChanges", "runtime"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nPausableComposition.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PausableComposition.kt\nandroidx/compose/runtime/PausedCompositionImpl\n+ 2 Synchronization.desktop.kt\nandroidx/compose/runtime/platform/Synchronization_desktopKt\n*L\n1#1,392:1\n26#2:393\n*S KotlinDebug\n*F\n+ 1 PausableComposition.kt\nandroidx/compose/runtime/PausedCompositionImpl\n*L\n247#1:393\n*E\n"})
public final class PausedCompositionImpl
implements PausedComposition {
    @NotNull
    private final CompositionImpl composition;
    @NotNull
    private final CompositionContext context;
    @NotNull
    private final ComposerImpl composer;
    @NotNull
    private final Function2<Composer, Integer, Unit> content;
    private final boolean reusable;
    @NotNull
    private final Applier<?> applier;
    @NotNull
    private final SynchronizedObject lock;
    @NotNull
    private PausedCompositionState state;
    @NotNull
    private ScatterSet<RecomposeScopeImpl> invalidScopes;
    @NotNull
    private final RememberEventDispatcher rememberManager;
    @NotNull
    private final RecordingApplier<Object> pausableApplier;
    public static final int $stable = 8;

    public PausedCompositionImpl(@NotNull CompositionImpl composition2, @NotNull CompositionContext context2, @NotNull ComposerImpl composer, @NotNull Set<RememberObserver> abandonSet, @NotNull Function2<? super Composer, ? super Integer, Unit> content2, boolean reusable, @NotNull Applier<?> applier, @NotNull SynchronizedObject lock) {
        Intrinsics.checkNotNullParameter(composition2, "composition");
        Intrinsics.checkNotNullParameter(context2, "context");
        Intrinsics.checkNotNullParameter(composer, "composer");
        Intrinsics.checkNotNullParameter(abandonSet, "abandonSet");
        Intrinsics.checkNotNullParameter(content2, "content");
        Intrinsics.checkNotNullParameter(applier, "applier");
        Intrinsics.checkNotNullParameter(lock, "lock");
        this.composition = composition2;
        this.context = context2;
        this.composer = composer;
        this.content = content2;
        this.reusable = reusable;
        this.applier = applier;
        this.lock = lock;
        this.state = PausedCompositionState.InitialPending;
        this.invalidScopes = ScatterSetKt.emptyScatterSet();
        this.rememberManager = new RememberEventDispatcher(abandonSet);
        this.pausableApplier = new RecordingApplier(this.applier.getCurrent());
    }

    @NotNull
    public final CompositionImpl getComposition() {
        return this.composition;
    }

    @NotNull
    public final CompositionContext getContext() {
        return this.context;
    }

    @NotNull
    public final ComposerImpl getComposer() {
        return this.composer;
    }

    @NotNull
    public final Function2<Composer, Integer, Unit> getContent() {
        return this.content;
    }

    public final boolean getReusable() {
        return this.reusable;
    }

    @NotNull
    public final Applier<?> getApplier() {
        return this.applier;
    }

    @NotNull
    public final SynchronizedObject getLock() {
        return this.lock;
    }

    @NotNull
    public final RememberEventDispatcher getRememberManager$runtime() {
        return this.rememberManager;
    }

    @NotNull
    public final RecordingApplier<Object> getPausableApplier$runtime() {
        return this.pausableApplier;
    }

    @Override
    public boolean isComplete() {
        return this.state.compareTo((Enum)PausedCompositionState.ApplyPending) >= 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean resume(@NotNull ShouldPauseCallback shouldPause) {
        Intrinsics.checkNotNullParameter(shouldPause, "shouldPause");
        try {
            switch (WhenMappings.$EnumSwitchMapping$0[this.state.ordinal()]) {
                case 1: {
                    if (this.reusable) {
                        this.composer.startReuseFromRoot();
                    }
                    try {
                        this.invalidScopes = this.context.composeInitialPaused$runtime(this.composition, shouldPause, this.content);
                    }
                    finally {
                        if (this.reusable) {
                            this.composer.endReuseFromRoot();
                        }
                    }
                    this.state = PausedCompositionState.RecomposePending;
                    if (this.invalidScopes.isEmpty()) {
                        this.markComplete();
                    }
                    break;
                }
                case 2: {
                    this.invalidScopes = this.context.recomposePaused$runtime(this.composition, shouldPause, this.invalidScopes);
                    if (this.invalidScopes.isEmpty()) {
                        this.markComplete();
                    }
                    break;
                }
                case 3: {
                    throw new IllegalStateException("Pausable composition is complete and apply() should be applied".toString());
                }
                case 4: {
                    throw new IllegalStateException("The paused composition has been applied".toString());
                }
                case 5: {
                    throw new IllegalStateException("The paused composition has been cancelled".toString());
                }
                case 6: {
                    throw new IllegalStateException("The paused composition is invalid because of a previous exception".toString());
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
        }
        catch (Exception e) {
            this.state = PausedCompositionState.Invalid;
            throw e;
        }
        return this.isComplete();
    }

    @Override
    public void apply() {
        try {
            switch (WhenMappings.$EnumSwitchMapping$0[this.state.ordinal()]) {
                case 1: 
                case 2: {
                    throw new IllegalStateException("The paused composition has not completed yet".toString());
                }
                case 3: {
                    this.applyChanges();
                    this.state = PausedCompositionState.Applied;
                    break;
                }
                case 4: {
                    throw new IllegalStateException("The paused composition has already been applied".toString());
                }
                case 5: {
                    throw new IllegalStateException("The paused composition has been cancelled".toString());
                }
                case 6: {
                    throw new IllegalStateException("The paused composition is invalid because of a previous exception".toString());
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
        }
        catch (Exception e) {
            this.state = PausedCompositionState.Invalid;
            throw e;
        }
    }

    @Override
    public void cancel() {
        this.state = PausedCompositionState.Cancelled;
        this.rememberManager.dispatchAbandons();
        this.composition.pausedCompositionFinished$runtime();
    }

    private final void markComplete() {
        this.state = PausedCompositionState.ApplyPending;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void applyChanges() {
        SynchronizedObject lock$iv = this.lock;
        boolean $i$f$synchronized = false;
        SynchronizedObject synchronizedObject = lock$iv;
        synchronized (synchronizedObject) {
            boolean bl = false;
            try {
                Applier<?> applier = this.applier;
                Intrinsics.checkNotNull(applier, "null cannot be cast to non-null type androidx.compose.runtime.Applier<kotlin.Any?>");
                this.pausableApplier.playTo(applier);
                this.rememberManager.dispatchRememberObservers();
                this.rememberManager.dispatchSideEffects();
            }
            finally {
                this.rememberManager.dispatchAbandons();
                this.composition.pausedCompositionFinished$runtime();
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[PausedCompositionState.values().length];
            try {
                nArray[PausedCompositionState.InitialPending.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PausedCompositionState.RecomposePending.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PausedCompositionState.ApplyPending.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PausedCompositionState.Applied.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PausedCompositionState.Cancelled.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PausedCompositionState.Invalid.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

