/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.runtime.internal;

import androidx.compose.runtime.internal.StabilityInferred;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0016\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0005\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0001\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u000e\u0010\u0006\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\u000b\u001a\u0004\u0018\u00010\u00012\u0006\u0010\f\u001a\u00020\rJ\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001J\u0018\u0010\u0011\u001a\u00020\u00002\u0006\u0010\f\u001a\u00020\r2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001J\u0010\u0010\u0012\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\rH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0006\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0007X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\n\u00a8\u0006\u0013"}, d2={"Landroidx/compose/runtime/internal/ThreadMap;", "", "size", "", "keys", "", "values", "", "<init>", "(I[J[Ljava/lang/Object;)V", "[Ljava/lang/Object;", "get", "key", "", "trySet", "", "value", "newWith", "find", "runtime"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nSnapshotThreadLocal.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SnapshotThreadLocal.kt\nandroidx/compose/runtime/internal/ThreadMap\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,154:1\n12797#2,3:155\n*S KotlinDebug\n*F\n+ 1 SnapshotThreadLocal.kt\nandroidx/compose/runtime/internal/ThreadMap\n*L\n84#1:155,3\n*E\n"})
public final class ThreadMap {
    private final int size;
    @NotNull
    private final long[] keys;
    @NotNull
    private final Object[] values;
    public static final int $stable = 8;

    public ThreadMap(int size2, @NotNull long[] keys2, @NotNull Object[] values2) {
        Intrinsics.checkNotNullParameter(keys2, "keys");
        Intrinsics.checkNotNullParameter(values2, "values");
        this.size = size2;
        this.keys = keys2;
        this.values = values2;
    }

    @Nullable
    public final Object get(long key) {
        int index2 = this.find(key);
        return index2 >= 0 ? this.values[index2] : null;
    }

    public final boolean trySet(long key, @Nullable Object value) {
        int index2 = this.find(key);
        if (index2 < 0) {
            return false;
        }
        this.values[index2] = value;
        return true;
    }

    @NotNull
    public final ThreadMap newWith(long key, @Nullable Object value) {
        int size2 = this.size;
        Object[] $this$count$iv = this.values;
        boolean $i$f$count = false;
        int count$iv = 0;
        int n = $this$count$iv.length;
        for (int j = 0; j < n; ++j) {
            Object element$iv;
            Object it = element$iv = $this$count$iv[j];
            boolean bl = false;
            if (!(it != null)) continue;
            ++count$iv;
        }
        int newSize = count$iv + 1;
        long[] newKeys = new long[newSize];
        Object[] newValues = new Object[newSize];
        if (newSize > 1) {
            Object oldValue;
            int source2;
            int dest = 0;
            for (source2 = 0; dest < newSize && source2 < size2; ++source2) {
                long oldKey = this.keys[source2];
                oldValue = this.values[source2];
                if (oldKey > key) {
                    newKeys[dest] = key;
                    newValues[dest] = value;
                    ++dest;
                    break;
                }
                if (oldValue == null) continue;
                newKeys[dest] = oldKey;
                newValues[dest] = oldValue;
                ++dest;
            }
            if (source2 == size2) {
                newKeys[newSize - 1] = key;
                newValues[newSize - 1] = value;
            } else {
                while (dest < newSize) {
                    long oldKey = this.keys[source2];
                    oldValue = this.values[source2];
                    if (oldValue != null) {
                        newKeys[dest] = oldKey;
                        newValues[dest] = oldValue;
                        ++dest;
                    }
                    ++source2;
                }
            }
        } else {
            newKeys[0] = key;
            newValues[0] = value;
        }
        return new ThreadMap(newSize, newKeys, newValues);
    }

    private final int find(long key) {
        int high = this.size - 1;
        switch (high) {
            case -1: {
                return -1;
            }
            case 0: {
                return this.keys[0] == key ? 0 : (this.keys[0] > key ? -2 : -1);
            }
        }
        int low = 0;
        while (low <= high) {
            int mid = low + high >>> 1;
            long midVal = this.keys[mid];
            long comparison = midVal - key;
            if (comparison < 0L) {
                low = mid + 1;
                continue;
            }
            if (comparison > 0L) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }
}

