/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.focus;

import androidx.compose.runtime.collection.MutableVector;
import androidx.compose.ui.focus.FocusTargetNode;
import androidx.compose.ui.focus.FocusTraversalKt;
import androidx.compose.ui.node.DelegatableNodeKt;
import androidx.compose.ui.node.LayoutNode;
import java.util.Comparator;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c2\u0002\u0018\u00002\u0012\u0012\u0004\u0012\u00020\u00020\u0001j\b\u0012\u0004\u0012\u00020\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\u0002H\u0016J\u0016\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\fH\u0002\u00a8\u0006\u000e"}, d2={"Landroidx/compose/ui/focus/FocusableChildrenComparator;", "Ljava/util/Comparator;", "Landroidx/compose/ui/focus/FocusTargetNode;", "Lkotlin/Comparator;", "<init>", "()V", "compare", "", "a", "b", "pathFromRoot", "Landroidx/compose/runtime/collection/MutableVector;", "Landroidx/compose/ui/node/LayoutNode;", "layoutNode", "ui"})
@SourceDebugExtension(value={"SMAP\nOneDimensionalFocusSearch.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OneDimensionalFocusSearch.kt\nandroidx/compose/ui/focus/FocusableChildrenComparator\n+ 2 MutableVector.kt\nandroidx/compose/runtime/collection/MutableVector\n+ 3 MutableVector.kt\nandroidx/compose/runtime/collection/MutableVectorKt\n*L\n1#1,280:1\n44#2:281\n472#2:282\n472#2:283\n1101#3:284\n1083#3,2:285\n*S KotlinDebug\n*F\n+ 1 OneDimensionalFocusSearch.kt\nandroidx/compose/ui/focus/FocusableChildrenComparator\n*L\n259#1:281\n263#1:282\n264#1:283\n271#1:284\n271#1:285,2\n*E\n"})
final class FocusableChildrenComparator
implements Comparator<FocusTargetNode> {
    @NotNull
    public static final FocusableChildrenComparator INSTANCE = new FocusableChildrenComparator();

    private FocusableChildrenComparator() {
    }

    @Override
    public int compare(@NotNull FocusTargetNode a2, @NotNull FocusTargetNode b2) {
        LayoutNode layoutNode2;
        Intrinsics.checkNotNullParameter(a2, "a");
        Intrinsics.checkNotNullParameter(b2, "b");
        if (!FocusTraversalKt.isEligibleForFocusSearch(a2) || !FocusTraversalKt.isEligibleForFocusSearch(b2)) {
            if (FocusTraversalKt.isEligibleForFocusSearch(a2)) {
                return -1;
            }
            if (FocusTraversalKt.isEligibleForFocusSearch(b2)) {
                return 1;
            }
            return 0;
        }
        LayoutNode layoutNode1 = DelegatableNodeKt.requireLayoutNode(a2);
        if (Intrinsics.areEqual(layoutNode1, layoutNode2 = DelegatableNodeKt.requireLayoutNode(b2))) {
            return 0;
        }
        MutableVector<LayoutNode> pathFromRoot1 = this.pathFromRoot(layoutNode1);
        MutableVector<LayoutNode> pathFromRoot2 = this.pathFromRoot(layoutNode2);
        int depth = 0;
        MutableVector<LayoutNode> this_$iv22 = pathFromRoot1;
        boolean $i$f$getLastIndex = false;
        int this_$iv22 = this_$iv22.getSize() - 1;
        MutableVector<LayoutNode> this_$iv32 = pathFromRoot2;
        boolean $i$f$getLastIndex2 = false;
        int this_$iv32 = this_$iv32.getSize() - 1;
        int n = Math.min(this_$iv22, this_$iv32);
        if (depth <= n) {
            while (true) {
                MutableVector<LayoutNode> this_$iv = pathFromRoot1;
                boolean $i$f$get = false;
                this_$iv = pathFromRoot2;
                $i$f$get = false;
                if (!Intrinsics.areEqual(this_$iv.content[depth], this_$iv.content[depth])) {
                    this_$iv = pathFromRoot1;
                    $i$f$get = false;
                    this_$iv = pathFromRoot2;
                    $i$f$get = false;
                    return Intrinsics.compare(((LayoutNode)this_$iv.content[depth]).getPlaceOrder$ui(), ((LayoutNode)this_$iv.content[depth]).getPlaceOrder$ui());
                }
                if (depth == n) break;
                ++depth;
            }
        }
        throw new IllegalStateException("Could not find a common ancestor between the two FocusModifiers.".toString());
    }

    private final MutableVector<LayoutNode> pathFromRoot(LayoutNode layoutNode) {
        boolean $i$f$mutableVectorOf = false;
        int capacity$iv$iv = 16;
        boolean $i$f$MutableVector = false;
        MutableVector<LayoutNode> path = new MutableVector<LayoutNode>(new LayoutNode[capacity$iv$iv], 0);
        for (LayoutNode current = layoutNode; current != null; current = current.getParent$ui()) {
            path.add(0, current);
        }
        return path;
    }
}

