/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.platform;

import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.ui.geometry.Rect;
import androidx.compose.ui.platform.InputMethodRequestsImpl;
import androidx.compose.ui.platform.PlatformComponent;
import androidx.compose.ui.text.input.ImeOptions;
import androidx.compose.ui.text.input.PlatformTextInputService2;
import androidx.compose.ui.text.input.TextEditingScope;
import androidx.compose.ui.text.input.TextEditorState;
import java.awt.event.InputMethodEvent;
import java.awt.event.KeyEvent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0001\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005JL\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r22\u0010\u000e\u001a.\u0012$\u0012\"\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\t0\u000f\u00a2\u0006\u0002\b\u0011\u00a2\u0006\f\b\u0012\u0012\b\b\u0013\u0012\u0004\b\b(\u0014\u0012\u0004\u0012\u00020\t0\u000fH\u0016J\b\u0010\u0015\u001a\u00020\tH\u0016J\u0010\u0010\u0016\u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u000e\u0010\u0019\u001a\u00020\t2\u0006\u0010\u001a\u001a\u00020\u001bJ\u000e\u0010\u001c\u001a\u00020\t2\u0006\u0010\u001d\u001a\u00020\u001eR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Landroidx/compose/ui/platform/DesktopTextInputService2;", "Landroidx/compose/ui/text/input/PlatformTextInputService2;", "component", "Landroidx/compose/ui/platform/PlatformComponent;", "<init>", "(Landroidx/compose/ui/platform/PlatformComponent;)V", "currentInputMethodRequests", "Landroidx/compose/ui/platform/InputMethodRequestsImpl;", "startInput", "", "state", "Landroidx/compose/ui/text/input/TextEditorState;", "imeOptions", "Landroidx/compose/ui/text/input/ImeOptions;", "editText", "Lkotlin/Function1;", "Landroidx/compose/ui/text/input/TextEditingScope;", "Lkotlin/ExtensionFunctionType;", "Lkotlin/ParameterName;", "name", "block", "stopInput", "focusedRectChanged", "rect", "Landroidx/compose/ui/geometry/Rect;", "onKeyEvent", "keyEvent", "Ljava/awt/event/KeyEvent;", "inputMethodTextChanged", "event", "Ljava/awt/event/InputMethodEvent;", "ui"})
@StabilityInferred(parameters=0)
public final class DesktopTextInputService2
implements PlatformTextInputService2 {
    @NotNull
    private final PlatformComponent component;
    @Nullable
    private InputMethodRequestsImpl currentInputMethodRequests;
    public static final int $stable = 8;

    public DesktopTextInputService2(@NotNull PlatformComponent component) {
        Intrinsics.checkNotNullParameter(component, "component");
        this.component = component;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void startInput(@NotNull TextEditorState state2, @NotNull ImeOptions imeOptions, @NotNull Function1<? super Function1<? super TextEditingScope, Unit>, Unit> editText) {
        void it;
        InputMethodRequestsImpl inputMethodRequestsImpl;
        Intrinsics.checkNotNullParameter(state2, "state");
        Intrinsics.checkNotNullParameter(imeOptions, "imeOptions");
        Intrinsics.checkNotNullParameter(editText, "editText");
        InputMethodRequestsImpl inputMethodRequestsImpl2 = inputMethodRequestsImpl = new InputMethodRequestsImpl(this.component, state2, editText);
        PlatformComponent platformComponent = this.component;
        boolean bl = false;
        this.currentInputMethodRequests = it;
        platformComponent.enableInput(inputMethodRequestsImpl);
    }

    @Override
    public void stopInput() {
        this.component.disableInput();
        this.currentInputMethodRequests = null;
    }

    @Override
    public void focusedRectChanged(@NotNull Rect rect2) {
        block0: {
            Intrinsics.checkNotNullParameter(rect2, "rect");
            InputMethodRequestsImpl inputMethodRequestsImpl = this.currentInputMethodRequests;
            if (inputMethodRequestsImpl == null) break block0;
            inputMethodRequestsImpl.setFocusedRect(rect2);
        }
    }

    public final void onKeyEvent(@NotNull KeyEvent keyEvent) {
        Intrinsics.checkNotNullParameter(keyEvent, "keyEvent");
        switch (keyEvent.getID()) {
            case 400: {
                InputMethodRequestsImpl inputMethodRequestsImpl = this.currentInputMethodRequests;
                if (inputMethodRequestsImpl != null) {
                    inputMethodRequestsImpl.setCharKeyPressed(true);
                }
                break;
            }
            case 402: {
                InputMethodRequestsImpl inputMethodRequestsImpl = this.currentInputMethodRequests;
                if (inputMethodRequestsImpl == null) break;
                inputMethodRequestsImpl.setCharKeyPressed(false);
                break;
            }
        }
    }

    public final void inputMethodTextChanged(@NotNull InputMethodEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        InputMethodRequestsImpl inputMethodRequestsImpl = this.currentInputMethodRequests;
        if (inputMethodRequestsImpl == null) {
            return;
        }
        InputMethodRequestsImpl inputMethodRequests = inputMethodRequestsImpl;
        if (!event.isConsumed()) {
            inputMethodRequests.replaceInputMethodText(event);
            event.consume();
        }
    }
}

