/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.text.platform;

import androidx.compose.runtime.internal.StabilityInferred;
import java.lang.reflect.Field;
import java.lang.reflect.InaccessibleObjectException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.ArrayIteratorKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\b\u0006\b\u00c1\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J=\u0010\u0004\u001a\u0004\u0018\u00010\u00052\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u00072\u0006\u0010\b\u001a\u00020\t2\u001a\u0010\n\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\u00070\u000b\"\u0006\u0012\u0002\b\u00030\u0007\u00a2\u0006\u0002\u0010\fJA\u0010\r\u001a\u0004\u0018\u0001H\u000e\"\u0004\b\u0000\u0010\u000e2\n\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\u00072\b\u0010\u0010\u001a\u0004\u0018\u00010\u00012\u000e\u0010\u0011\u001a\n\u0012\u0004\u0012\u0002H\u000e\u0018\u00010\u00072\u0006\u0010\u0012\u001a\u00020\t\u00a2\u0006\u0002\u0010\u0013J*\u0010\u0014\u001a\u00020\u00152\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u00072\f\u0010\u0011\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00072\b\b\u0001\u0010\u0012\u001a\u00020\tJ,\u0010\u0016\u001a\u0004\u0018\u00010\u00152\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u00072\f\u0010\u0011\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00072\b\b\u0001\u0010\u0012\u001a\u00020\tJ$\u0010\u0017\u001a\u0004\u0018\u00010\u00152\n\u0010\u0018\u001a\u0006\u0012\u0002\b\u00030\u00072\u000e\u0010\u0019\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u00150\u001aJE\u0010\u001b\u001a\u0004\u0018\u00010\u00152\u0010\u0010\u001c\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00070\u000b2\u0012\u0010\u001d\u001a\u000e\u0012\n\b\u0000\u0012\u0006\u0012\u0002\b\u00030\u00070\u001e2\u000e\u0010\u0019\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u00150\u001aH\u0002\u00a2\u0006\u0002\u0010\u001fJ'\u0010 \u001a\u0004\u0018\u0001H\u000e\"\u0004\b\u0000\u0010\u000e2\u0006\u0010!\u001a\u00020\u00152\b\u0010\"\u001a\u0004\u0018\u00010\u0001H\u0002\u00a2\u0006\u0002\u0010#\u00a8\u0006$"}, d2={"Landroidx/compose/ui/text/platform/ReflectionUtil;", "", "<init>", "()V", "getDeclaredMethodOrNull", "Ljava/lang/reflect/Method;", "clazz", "Ljava/lang/Class;", "name", "", "parameters", "", "(Ljava/lang/Class;Ljava/lang/String;[Ljava/lang/Class;)Ljava/lang/reflect/Method;", "getFieldValueOrNull", "T", "objectClass", "object", "fieldType", "fieldName", "(Ljava/lang/Class;Ljava/lang/Object;Ljava/lang/Class;Ljava/lang/String;)Ljava/lang/Object;", "getAssignableField", "Ljava/lang/reflect/Field;", "findAssignableField", "findFieldInHierarchy", "rootClass", "checker", "Ljava/util/function/Predicate;", "processInterfaces", "interfaces", "visited", "", "([Ljava/lang/Class;Ljava/util/Set;Ljava/util/function/Predicate;)Ljava/lang/reflect/Field;", "getFieldValue", "field", "instance", "(Ljava/lang/reflect/Field;Ljava/lang/Object;)Ljava/lang/Object;", "ui-text"})
@StabilityInferred(parameters=1)
@SourceDebugExtension(value={"SMAP\nReflectionUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ReflectionUtil.kt\nandroidx/compose/ui/text/platform/ReflectionUtil\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,130:1\n1#2:131\n*E\n"})
public final class ReflectionUtil {
    @NotNull
    public static final ReflectionUtil INSTANCE = new ReflectionUtil();
    public static final int $stable;

    private ReflectionUtil() {
    }

    @Nullable
    public final Method getDeclaredMethodOrNull(@NotNull Class<?> clazz, @NotNull String name, Class<?> ... parameters) {
        Method method;
        Intrinsics.checkNotNullParameter(clazz, "clazz");
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(parameters, "parameters");
        try {
            Method $this$getDeclaredMethodOrNull_u24lambda_u240 = method = clazz.getDeclaredMethod(name, Arrays.copyOf(parameters, parameters.length));
            boolean bl = false;
            $this$getDeclaredMethodOrNull_u24lambda_u240.setAccessible(true);
        }
        catch (NoSuchMethodException e) {
            method = null;
        }
        catch (InaccessibleObjectException e) {
            method = null;
        }
        return method;
    }

    @Nullable
    public final <T> T getFieldValueOrNull(@NotNull Class<?> objectClass, @Nullable Object object, @Nullable Class<T> fieldType, @NotNull String fieldName) {
        T t;
        Intrinsics.checkNotNullParameter(objectClass, "objectClass");
        Intrinsics.checkNotNullParameter(fieldName, "fieldName");
        try {
            Field field = this.getAssignableField(objectClass, fieldType, fieldName);
            t = this.getFieldValue(field, object);
        }
        catch (NoSuchFieldException e) {
            t = null;
        }
        return t;
    }

    @NotNull
    public final Field getAssignableField(@NotNull Class<?> clazz, @Nullable Class<?> fieldType, @NonNls @NotNull String fieldName) {
        Intrinsics.checkNotNullParameter(clazz, "clazz");
        Intrinsics.checkNotNullParameter(fieldName, "fieldName");
        Field field = this.findAssignableField(clazz, fieldType, fieldName);
        if (field == null) {
            throw new NoSuchFieldException("Class: " + clazz + " fieldName: " + fieldName + " fieldType: " + fieldType);
        }
        return field;
    }

    @Nullable
    public final Field findAssignableField(@NotNull Class<?> clazz, @Nullable Class<?> fieldType, @NonNls @NotNull String fieldName) {
        Intrinsics.checkNotNullParameter(clazz, "clazz");
        Intrinsics.checkNotNullParameter(fieldName, "fieldName");
        Field result2 = this.findFieldInHierarchy(clazz, arg_0 -> ReflectionUtil.findAssignableField$lambda$2(arg_0 -> ReflectionUtil.findAssignableField$lambda$1(fieldName, fieldType, arg_0), arg_0));
        return result2;
    }

    @Nullable
    public final Field findFieldInHierarchy(@NotNull Class<?> rootClass, @NotNull Predicate<? super Field> checker) {
        Intrinsics.checkNotNullParameter(rootClass, "rootClass");
        Intrinsics.checkNotNullParameter(checker, "checker");
        try {
            for (Class<?> aClass = rootClass; aClass != null; aClass = aClass.getSuperclass()) {
                Iterator<Field> iterator2 = ArrayIteratorKt.iterator(aClass.getDeclaredFields());
                while (iterator2.hasNext()) {
                    Field field = iterator2.next();
                    Intrinsics.checkNotNull(field);
                    if (!checker.test(field)) continue;
                    field.setAccessible(true);
                    return field;
                }
            }
        }
        catch (InaccessibleObjectException e) {
            return null;
        }
        Class<?>[] classArray = rootClass.getInterfaces();
        Intrinsics.checkNotNullExpressionValue(classArray, "getInterfaces(...)");
        return this.processInterfaces(classArray, new HashSet(), checker);
    }

    private final Field processInterfaces(Class<?>[] interfaces, Set<? super Class<?>> visited, Predicate<? super Field> checker) {
        for (Class<?> anInterface : interfaces) {
            if (!visited.add(anInterface)) continue;
            Iterator<Field> iterator2 = ArrayIteratorKt.iterator(anInterface.getDeclaredFields());
            while (iterator2.hasNext()) {
                Field field = iterator2.next();
                Intrinsics.checkNotNull(field);
                if (!checker.test(field)) continue;
                field.setAccessible(true);
                return field;
            }
            Class<?>[] classArray = anInterface.getInterfaces();
            Intrinsics.checkNotNullExpressionValue(classArray, "getInterfaces(...)");
            Field field = this.processInterfaces(classArray, visited, checker);
            if (field == null) continue;
            return field;
        }
        return null;
    }

    private final <T> T getFieldValue(Field field, Object instance) {
        Object object;
        try {
            object = field.get(instance);
        }
        catch (IllegalAccessException e) {
            object = null;
        }
        return (T)object;
    }

    private static final boolean findAssignableField$lambda$1(String $fieldName, Class $fieldType, Field field) {
        Intrinsics.checkNotNullParameter(field, "field");
        return Intrinsics.areEqual($fieldName, field.getName()) && ($fieldType == null || $fieldType.isAssignableFrom(field.getType()));
    }

    private static final boolean findAssignableField$lambda$2(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }
}

