/*
 * Decompiled with CFR 0.152.
 */
package androidx.navigation;

import androidx.annotation.RestrictTo;
import androidx.navigation.NavDestination;
import androidx.navigation.serialization.RouteSerializerKt;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlin.text.HexExtensionsKt;
import kotlinx.serialization.SerializersKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0016\u0018\u00002\u00020\u0001:\u0001$B1\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u0012\u0006\u0010\b\u001a\u00020\u0003\u00a2\u0006\u0004\b\t\u0010\nB3\b\u0010\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\f\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u0012\u0006\u0010\b\u001a\u00020\u0003\u00a2\u0006\u0004\b\t\u0010\rB7\b\u0010\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\f\u0010\u000e\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u000f\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u0012\u0006\u0010\b\u001a\u00020\u0003\u00a2\u0006\u0004\b\t\u0010\u0010B1\b\u0010\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0011\u001a\u00020\u0001\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u0012\u0006\u0010\b\u001a\u00020\u0003\u00a2\u0006\u0004\b\t\u0010\u0012J\u0006\u0010\u001c\u001a\u00020\u0003J\u0006\u0010\u001d\u001a\u00020\u0003J\u0006\u0010\u001e\u001a\u00020\u0003J\u0006\u0010\u001f\u001a\u00020\u0003J\u0013\u0010 \u001a\u00020\u00032\b\u0010!\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\"\u001a\u00020\u0006H\u0016J\b\u0010#\u001a\u00020\fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0007\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\u000b\u001a\u0004\u0018\u00010\f2\b\u0010\u0015\u001a\u0004\u0018\u00010\f@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R*\u0010\u000e\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u000f2\f\u0010\u0015\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u000f@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\"\u0010\u0011\u001a\u0004\u0018\u00010\u00012\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006%"}, d2={"Landroidx/navigation/NavOptions;", "", "singleTop", "", "restoreState", "popUpToId", "", "popUpToInclusive", "popUpToSaveState", "<init>", "(ZZIZZ)V", "popUpToRoute", "", "(ZZLjava/lang/String;ZZ)V", "popUpToRouteClass", "Lkotlin/reflect/KClass;", "(ZZLkotlin/reflect/KClass;ZZ)V", "popUpToRouteObject", "(ZZLjava/lang/Object;ZZ)V", "getPopUpToId", "()I", "value", "getPopUpToRoute", "()Ljava/lang/String;", "getPopUpToRouteClass", "()Lkotlin/reflect/KClass;", "getPopUpToRouteObject", "()Ljava/lang/Object;", "shouldLaunchSingleTop", "shouldRestoreState", "isPopUpToInclusive", "shouldPopUpToSaveState", "equals", "other", "hashCode", "toString", "Builder", "navigation-common"})
public final class NavOptions {
    private final boolean singleTop;
    private final boolean restoreState;
    private final int popUpToId;
    private final boolean popUpToInclusive;
    private final boolean popUpToSaveState;
    @Nullable
    private String popUpToRoute;
    @Nullable
    private KClass<?> popUpToRouteClass;
    @Nullable
    private Object popUpToRouteObject;

    public NavOptions(boolean singleTop, boolean restoreState, int popUpToId, boolean popUpToInclusive, boolean popUpToSaveState) {
        this.singleTop = singleTop;
        this.restoreState = restoreState;
        this.popUpToId = popUpToId;
        this.popUpToInclusive = popUpToInclusive;
        this.popUpToSaveState = popUpToSaveState;
    }

    public final int getPopUpToId() {
        return this.popUpToId;
    }

    @Nullable
    public final String getPopUpToRoute() {
        return this.popUpToRoute;
    }

    @Nullable
    public final KClass<?> getPopUpToRouteClass() {
        return this.popUpToRouteClass;
    }

    @Nullable
    public final Object getPopUpToRouteObject() {
        return this.popUpToRouteObject;
    }

    public NavOptions(boolean singleTop, boolean restoreState, @Nullable String popUpToRoute, boolean popUpToInclusive, boolean popUpToSaveState) {
        this(singleTop, restoreState, NavDestination.Companion.createRoute(popUpToRoute).hashCode(), popUpToInclusive, popUpToSaveState);
        this.popUpToRoute = popUpToRoute;
    }

    public NavOptions(boolean singleTop, boolean restoreState, @Nullable KClass<?> popUpToRouteClass, boolean popUpToInclusive, boolean popUpToSaveState) {
        KClass<?> kClass = popUpToRouteClass;
        Intrinsics.checkNotNull(kClass);
        this(singleTop, restoreState, RouteSerializerKt.generateHashCode(SerializersKt.serializer(kClass)), popUpToInclusive, popUpToSaveState);
        this.popUpToRouteClass = popUpToRouteClass;
    }

    public NavOptions(boolean singleTop, boolean restoreState, @NotNull Object popUpToRouteObject, boolean popUpToInclusive, boolean popUpToSaveState) {
        Intrinsics.checkNotNullParameter(popUpToRouteObject, "popUpToRouteObject");
        this(singleTop, restoreState, RouteSerializerKt.generateHashCode(SerializersKt.serializer(Reflection.getOrCreateKotlinClass(popUpToRouteObject.getClass()))), popUpToInclusive, popUpToSaveState);
        this.popUpToRouteObject = popUpToRouteObject;
    }

    public final boolean shouldLaunchSingleTop() {
        return this.singleTop;
    }

    public final boolean shouldRestoreState() {
        return this.restoreState;
    }

    public final boolean isPopUpToInclusive() {
        return this.popUpToInclusive;
    }

    public final boolean shouldPopUpToSaveState() {
        return this.popUpToSaveState;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || !(other instanceof NavOptions)) {
            return false;
        }
        return this.singleTop == ((NavOptions)other).singleTop && this.restoreState == ((NavOptions)other).restoreState && this.popUpToId == ((NavOptions)other).popUpToId && Intrinsics.areEqual(this.popUpToRoute, ((NavOptions)other).popUpToRoute) && Intrinsics.areEqual(this.popUpToRouteClass, ((NavOptions)other).popUpToRouteClass) && Intrinsics.areEqual(this.popUpToRouteObject, ((NavOptions)other).popUpToRouteObject) && this.popUpToInclusive == ((NavOptions)other).popUpToInclusive && this.popUpToSaveState == ((NavOptions)other).popUpToSaveState;
    }

    public int hashCode() {
        int result2 = this.shouldLaunchSingleTop() ? 1 : 0;
        result2 = 31 * result2 + (this.shouldRestoreState() ? 1 : 0);
        result2 = 31 * result2 + this.popUpToId;
        String string2 = this.popUpToRoute;
        result2 = 31 * result2 + (string2 != null ? string2.hashCode() : 0);
        KClass<?> kClass = this.popUpToRouteClass;
        result2 = 31 * result2 + (kClass != null ? ((Object)kClass).hashCode() : 0);
        Object object = this.popUpToRouteObject;
        result2 = 31 * result2 + (object != null ? object.hashCode() : 0);
        result2 = 31 * result2 + (this.isPopUpToInclusive() ? 1 : 0);
        result2 = 31 * result2 + (this.shouldPopUpToSaveState() ? 1 : 0);
        return result2;
    }

    @NotNull
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(Reflection.getOrCreateKotlinClass(this.getClass()).getSimpleName());
        sb.append("(");
        if (this.singleTop) {
            sb.append("launchSingleTop ");
        }
        if (this.restoreState) {
            sb.append("restoreState ");
        }
        if ((this.popUpToRoute != null || this.popUpToId != -1) && this.popUpToRoute != null) {
            StringBuilder stringBuilder;
            sb.append("popUpTo(");
            if (this.popUpToRoute != null) {
                stringBuilder = sb.append(this.popUpToRoute);
            } else if (this.popUpToRouteClass != null) {
                stringBuilder = sb.append(this.popUpToRouteClass);
            } else if (this.popUpToRouteObject != null) {
                stringBuilder = sb.append(this.popUpToRouteObject);
            } else {
                sb.append("0x");
                stringBuilder = sb.append(HexExtensionsKt.toHexString$default(this.popUpToId, null, 1, null));
            }
            if (this.popUpToInclusive) {
                sb.append(" inclusive");
            }
            if (this.popUpToSaveState) {
                sb.append(" saveState");
            }
            sb.append(")");
        }
        String string2 = sb.toString();
        Intrinsics.checkNotNullExpressionValue(string2, "toString(...)");
        return string2;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0010\u001a\u00020\u00002\u0006\u0010\u0004\u001a\u00020\u0005J\u000e\u0010\u0011\u001a\u00020\u00002\u0006\u0010\u0006\u001a\u00020\u0005J\"\u0010\u0012\u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\u00052\b\b\u0002\u0010\u0015\u001a\u00020\u0005H\u0007J$\u0010\u0012\u001a\u00020\u00002\b\u0010\u0016\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0014\u001a\u00020\u00052\b\b\u0002\u0010\u0015\u001a\u00020\u0005H\u0007J'\u0010\u0012\u001a\u00020\u0000\"\n\b\u0000\u0010\u0017\u0018\u0001*\u00020\u00012\u0006\u0010\u0014\u001a\u00020\u00052\b\b\u0002\u0010\u0015\u001a\u00020\u0005H\u0087\bJ2\u0010\u0012\u001a\u00020\u0000\"\b\b\u0000\u0010\u0017*\u00020\u00012\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u0002H\u00170\f2\u0006\u0010\u0014\u001a\u00020\u00052\b\b\u0002\u0010\u0015\u001a\u00020\u0005H\u0007J1\u0010\u0012\u001a\u00020\u0000\"\b\b\u0000\u0010\u0017*\u00020\u00012\u0006\u0010\u0016\u001a\u0002H\u00172\u0006\u0010\u0014\u001a\u00020\u00052\b\b\u0002\u0010\u0015\u001a\u00020\u0005H\u0007\u00a2\u0006\u0002\u0010\u0018J\u0006\u0010\u0019\u001a\u00020\u001aR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0002\b\u0003\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u0001X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Landroidx/navigation/NavOptions$Builder;", "", "<init>", "()V", "singleTop", "", "restoreState", "popUpToId", "", "popUpToRoute", "", "popUpToRouteClass", "Lkotlin/reflect/KClass;", "popUpToRouteObject", "popUpToInclusive", "popUpToSaveState", "setLaunchSingleTop", "setRestoreState", "setPopUpTo", "destinationId", "inclusive", "saveState", "route", "T", "(Ljava/lang/Object;ZZ)Landroidx/navigation/NavOptions$Builder;", "build", "Landroidx/navigation/NavOptions;", "navigation-common"})
    @SourceDebugExtension(value={"SMAP\nNavOptions.nonAndroid.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NavOptions.nonAndroid.kt\nandroidx/navigation/NavOptions$Builder\n*L\n1#1,307:1\n234#1:308\n202#1:309\n240#1,2:310\n*S KotlinDebug\n*F\n+ 1 NavOptions.nonAndroid.kt\nandroidx/navigation/NavOptions$Builder\n*L\n-1#1:308\n-1#1:309\n-1#1:310,2\n*E\n"})
    public static final class Builder {
        private boolean singleTop;
        private boolean restoreState;
        private int popUpToId = -1;
        @Nullable
        private String popUpToRoute;
        @Nullable
        private KClass<?> popUpToRouteClass;
        @Nullable
        private Object popUpToRouteObject;
        private boolean popUpToInclusive;
        private boolean popUpToSaveState;

        @NotNull
        public final Builder setLaunchSingleTop(boolean singleTop) {
            this.singleTop = singleTop;
            return this;
        }

        @NotNull
        public final Builder setRestoreState(boolean restoreState) {
            this.restoreState = restoreState;
            return this;
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @JvmOverloads
        @NotNull
        public final Builder setPopUpTo(int destinationId, boolean inclusive, boolean saveState) {
            this.popUpToId = destinationId;
            this.popUpToRoute = null;
            this.popUpToInclusive = inclusive;
            this.popUpToSaveState = saveState;
            return this;
        }

        public static /* synthetic */ Builder setPopUpTo$default(Builder builder, int n, boolean bl, boolean bl2, int n2, Object object) {
            if ((n2 & 4) != 0) {
                bl2 = false;
            }
            return builder.setPopUpTo(n, bl, bl2);
        }

        @JvmOverloads
        @NotNull
        public final Builder setPopUpTo(@Nullable String route, boolean inclusive, boolean saveState) {
            this.popUpToRoute = route;
            this.popUpToId = -1;
            this.popUpToInclusive = inclusive;
            this.popUpToSaveState = saveState;
            return this;
        }

        public static /* synthetic */ Builder setPopUpTo$default(Builder builder, String string2, boolean bl, boolean bl2, int n, Object object) {
            if ((n & 4) != 0) {
                bl2 = false;
            }
            return builder.setPopUpTo(string2, bl, bl2);
        }

        @JvmOverloads
        public final /* synthetic */ <T> Builder setPopUpTo(boolean inclusive, boolean saveState) {
            boolean $i$f$setPopUpTo = false;
            Intrinsics.reifiedOperationMarker(4, "T");
            this.setPopUpTo((T)Reflection.getOrCreateKotlinClass(Object.class), inclusive, saveState);
            return this;
        }

        public static /* synthetic */ Builder setPopUpTo$default(Builder $this, boolean inclusive, boolean saveState, int n, Object object) {
            if ((n & 2) != 0) {
                saveState = false;
            }
            boolean $i$f$setPopUpTo = false;
            Intrinsics.reifiedOperationMarker(4, "T");
            $this.setPopUpTo((Object)Reflection.getOrCreateKotlinClass(Object.class), inclusive, saveState);
            return $this;
        }

        @JvmOverloads
        @NotNull
        public final <T> Builder setPopUpTo(@NotNull KClass<T> route, boolean inclusive, boolean saveState) {
            Intrinsics.checkNotNullParameter(route, "route");
            this.popUpToRouteClass = route;
            this.popUpToId = -1;
            this.popUpToInclusive = inclusive;
            this.popUpToSaveState = saveState;
            return this;
        }

        public static /* synthetic */ Builder setPopUpTo$default(Builder builder, KClass kClass, boolean bl, boolean bl2, int n, Object object) {
            if ((n & 4) != 0) {
                bl2 = false;
            }
            return builder.setPopUpTo((Object)kClass, bl, bl2);
        }

        @JvmOverloads
        @NotNull
        public final <T> Builder setPopUpTo(@NotNull T route, boolean inclusive, boolean saveState) {
            Intrinsics.checkNotNullParameter(route, "route");
            this.popUpToRouteObject = route;
            this.setPopUpTo(RouteSerializerKt.generateHashCode(SerializersKt.serializer(Reflection.getOrCreateKotlinClass(route.getClass()))), inclusive, saveState);
            return this;
        }

        public static /* synthetic */ Builder setPopUpTo$default(Builder builder, Object object, boolean bl, boolean bl2, int n, Object object2) {
            if ((n & 4) != 0) {
                bl2 = false;
            }
            return builder.setPopUpTo(object, bl, bl2);
        }

        @NotNull
        public final NavOptions build() {
            NavOptions navOptions;
            if (this.popUpToRoute != null) {
                navOptions = new NavOptions(this.singleTop, this.restoreState, this.popUpToRoute, this.popUpToInclusive, this.popUpToSaveState);
            } else if (this.popUpToRouteClass != null) {
                navOptions = new NavOptions(this.singleTop, this.restoreState, this.popUpToRouteClass, this.popUpToInclusive, this.popUpToSaveState);
            } else if (this.popUpToRouteObject != null) {
                Object object = this.popUpToRouteObject;
                Intrinsics.checkNotNull(object);
                navOptions = new NavOptions(this.singleTop, this.restoreState, object, this.popUpToInclusive, this.popUpToSaveState);
            } else {
                navOptions = new NavOptions(this.singleTop, this.restoreState, this.popUpToId, this.popUpToInclusive, this.popUpToSaveState);
            }
            return navOptions;
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @JvmOverloads
        @NotNull
        public final Builder setPopUpTo(int destinationId, boolean inclusive) {
            return Builder.setPopUpTo$default(this, destinationId, inclusive, false, 4, null);
        }

        @JvmOverloads
        @NotNull
        public final Builder setPopUpTo(@Nullable String route, boolean inclusive) {
            return Builder.setPopUpTo$default(this, route, inclusive, false, 4, null);
        }

        @JvmOverloads
        public final /* synthetic */ <T> Builder setPopUpTo(boolean inclusive) {
            boolean $i$f$setPopUpTo = false;
            boolean saveState$iv = false;
            boolean $i$f$setPopUpTo2 = false;
            Intrinsics.reifiedOperationMarker(4, "T");
            this.setPopUpTo((T)Reflection.getOrCreateKotlinClass(Object.class), inclusive, saveState$iv);
            return this;
        }

        @JvmOverloads
        @NotNull
        public final <T> Builder setPopUpTo(@NotNull KClass<T> route, boolean inclusive) {
            Intrinsics.checkNotNullParameter(route, "route");
            return Builder.setPopUpTo$default(this, route, inclusive, false, 4, null);
        }

        @JvmOverloads
        @NotNull
        public final <T> Builder setPopUpTo(@NotNull T route, boolean inclusive) {
            Intrinsics.checkNotNullParameter(route, "route");
            return Builder.setPopUpTo$default(this, route, inclusive, false, 4, null);
        }
    }
}

