/*
 * Decompiled with CFR 0.152.
 */
package androidx.room;

import androidx.annotation.RestrictTo;
import androidx.room.DatabaseConfiguration;
import androidx.room.InvalidationTracker;
import androidx.room.RoomConnectionManager;
import androidx.room.RoomDatabaseKt;
import androidx.room.RoomOpenDelegate;
import androidx.room.RoomOpenDelegateMarker;
import androidx.room.Transactor;
import androidx.room.concurrent.CloseBarrier;
import androidx.room.migration.AutoMigrationSpec;
import androidx.room.migration.Migration;
import androidx.room.util.MigrationUtil;
import androidx.sqlite.SQLiteConnection;
import androidx.sqlite.SQLiteDriver;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.Pair;
import kotlin.PublishedApi;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.ContinuationInterceptor;
import kotlin.coroutines.CoroutineContext;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.SupervisorKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b&\u0018\u00002\u00020\u0001:\u0004BCDEB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0000\u00a2\u0006\u0002\b\u0018J\u0015\u0010\u0019\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u0017H\u0000\u00a2\u0006\u0002\b\u001aJ\b\u0010\u001b\u001a\u00020\u001cH\u0015J\b\u0010\u001d\u001a\u00020\fH$J\b\u0010\u001e\u001a\u00020\u0007H\u0007J\u0016\u0010\u001f\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020!0\n0 H\u0017J*\u0010\"\u001a\b\u0012\u0004\u0012\u00020$0#2\u001a\u0010%\u001a\u0016\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020!0\n\u0012\u0004\u0012\u00020!0&H\u0017J%\u0010'\u001a\u0002H(\"\b\b\u0000\u0010(*\u00020\u00012\f\u0010)\u001a\b\u0012\u0004\u0012\u0002H(0\nH\u0007\u00a2\u0006\u0002\u0010*J!\u0010+\u001a\u00020\u00152\n\u0010,\u001a\u0006\u0012\u0002\b\u00030\n2\u0006\u0010-\u001a\u00020\u0001H\u0000\u00a2\u0006\u0002\b.J\"\u0010/\u001a\u001c\u0012\b\u0012\u0006\u0012\u0002\b\u00030\n\u0012\u000e\u0012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\n0#0&H\u0015J\u0010\u00103\u001a\u00020\u00152\u0006\u00104\u001a\u000205H\u0005J\u0006\u00106\u001a\u00020\u0015J\b\u00107\u001a\u00020\u0015H\u0002JB\u00108\u001a\u0002H9\"\u0004\b\u0000\u001092\u0006\u0010:\u001a\u00020;2\"\u0010<\u001a\u001e\b\u0001\u0012\u0004\u0012\u00020>\u0012\n\u0012\b\u0012\u0004\u0012\u0002H90?\u0012\u0006\u0012\u0004\u0018\u00010\u00010=H\u0080@\u00a2\u0006\u0004\b@\u0010AR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082.\u00a2\u0006\u0002\n\u0000R\u001e\u0010\b\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\n\u0012\u0004\u0012\u00020\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000b\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\fX\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\u00020\u0011X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R.\u00100\u001a\u001c\u0012\b\u0012\u0006\u0012\u0002\b\u00030\n\u0012\u000e\u0012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\n0#0&8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b1\u00102\u00a8\u0006F"}, d2={"Landroidx/room/RoomDatabase;", "", "<init>", "()V", "connectionManager", "Landroidx/room/RoomConnectionManager;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "typeConverters", "", "Lkotlin/reflect/KClass;", "invalidationTracker", "Landroidx/room/InvalidationTracker;", "getInvalidationTracker", "()Landroidx/room/InvalidationTracker;", "internalTracker", "closeBarrier", "Landroidx/room/concurrent/CloseBarrier;", "getCloseBarrier$room_runtime", "()Landroidx/room/concurrent/CloseBarrier;", "init", "", "configuration", "Landroidx/room/DatabaseConfiguration;", "init$room_runtime", "createConnectionManager", "createConnectionManager$room_runtime", "createOpenDelegate", "Landroidx/room/RoomOpenDelegateMarker;", "createInvalidationTracker", "getCoroutineScope", "getRequiredAutoMigrationSpecClasses", "", "Landroidx/room/migration/AutoMigrationSpec;", "createAutoMigrations", "", "Landroidx/room/migration/Migration;", "autoMigrationSpecs", "", "getTypeConverter", "T", "klass", "(Lkotlin/reflect/KClass;)Ljava/lang/Object;", "addTypeConverter", "kclass", "converter", "addTypeConverter$room_runtime", "getRequiredTypeConverterClasses", "requiredTypeConverterClassesMap", "getRequiredTypeConverterClassesMap$room_runtime", "()Ljava/util/Map;", "internalInitInvalidationTracker", "connection", "Landroidx/sqlite/SQLiteConnection;", "close", "onClosed", "useConnection", "R", "isReadOnly", "", "block", "Lkotlin/Function2;", "Landroidx/room/Transactor;", "Lkotlin/coroutines/Continuation;", "useConnection$room_runtime", "(ZLkotlin/jvm/functions/Function2;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "JournalMode", "Builder", "MigrationContainer", "Callback", "room-runtime"})
public abstract class RoomDatabase {
    private RoomConnectionManager connectionManager;
    private CoroutineScope coroutineScope;
    @NotNull
    private final Map<KClass<?>, Object> typeConverters = new LinkedHashMap();
    private InvalidationTracker internalTracker;
    @NotNull
    private final CloseBarrier closeBarrier = new CloseBarrier(new Function0<Unit>((Object)this){

        public final void invoke() {
            RoomDatabase.access$onClosed((RoomDatabase)this.receiver);
        }
    });

    @NotNull
    public final InvalidationTracker getInvalidationTracker() {
        InvalidationTracker invalidationTracker = this.internalTracker;
        if (invalidationTracker == null) {
            Intrinsics.throwUninitializedPropertyAccessException("internalTracker");
            invalidationTracker = null;
        }
        return invalidationTracker;
    }

    @NotNull
    public final CloseBarrier getCloseBarrier$room_runtime() {
        return this.closeBarrier;
    }

    public final void init$room_runtime(@NotNull DatabaseConfiguration configuration) {
        Intrinsics.checkNotNullParameter(configuration, "configuration");
        this.connectionManager = this.createConnectionManager$room_runtime(configuration);
        this.internalTracker = this.createInvalidationTracker();
        CoroutineContext coroutineContext = configuration.getQueryCoroutineContext();
        if (coroutineContext == null) {
            String string2 = "Required value was null.";
            throw new IllegalStateException(string2.toString());
        }
        Job parentJob = (Job)coroutineContext.get(Job.Key);
        this.coroutineScope = CoroutineScopeKt.CoroutineScope(configuration.getQueryCoroutineContext().plus(SupervisorKt.SupervisorJob(parentJob)));
        RoomDatabaseKt.validateAutoMigrations(this, configuration);
        RoomDatabaseKt.validateTypeConverters(this, configuration);
    }

    @NotNull
    public final RoomConnectionManager createConnectionManager$room_runtime(@NotNull DatabaseConfiguration configuration) {
        Intrinsics.checkNotNullParameter(configuration, "configuration");
        SQLiteDriver sQLiteDriver = configuration.getSqliteDriver();
        if (sQLiteDriver == null) {
            String string2 = "Required value was null.";
            throw new IllegalStateException(string2.toString());
        }
        RoomOpenDelegateMarker roomOpenDelegateMarker = this.createOpenDelegate();
        Intrinsics.checkNotNull(roomOpenDelegateMarker, "null cannot be cast to non-null type androidx.room.RoomOpenDelegate");
        RoomOpenDelegate roomOpenDelegate = (RoomOpenDelegate)roomOpenDelegateMarker;
        List<Callback> list2 = configuration.getCallbacks();
        if (list2 == null) {
            list2 = CollectionsKt.emptyList();
        }
        return new RoomConnectionManager(configuration, sQLiteDriver, roomOpenDelegate, list2);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
    @NotNull
    protected RoomOpenDelegateMarker createOpenDelegate() {
        throw new NotImplementedError(null, 1, null);
    }

    @NotNull
    protected abstract InvalidationTracker createInvalidationTracker();

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @NotNull
    public final CoroutineScope getCoroutineScope() {
        CoroutineScope coroutineScope = this.coroutineScope;
        if (coroutineScope == null) {
            Intrinsics.throwUninitializedPropertyAccessException("coroutineScope");
            coroutineScope = null;
        }
        return coroutineScope;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
    @NotNull
    public Set<KClass<? extends AutoMigrationSpec>> getRequiredAutoMigrationSpecClasses() {
        throw new NotImplementedError(null, 1, null);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
    @NotNull
    public List<Migration> createAutoMigrations(@NotNull Map<KClass<? extends AutoMigrationSpec>, ? extends AutoMigrationSpec> autoMigrationSpecs) {
        Intrinsics.checkNotNullParameter(autoMigrationSpecs, "autoMigrationSpecs");
        throw new NotImplementedError(null, 1, null);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
    @NotNull
    public final <T> T getTypeConverter(@NotNull KClass<T> klass) {
        Intrinsics.checkNotNullParameter(klass, "klass");
        Object object = this.typeConverters.get(klass);
        Intrinsics.checkNotNull(object, "null cannot be cast to non-null type T of androidx.room.RoomDatabase.getTypeConverter");
        return (T)object;
    }

    public final void addTypeConverter$room_runtime(@NotNull KClass<?> kclass, @NotNull Object converter) {
        Intrinsics.checkNotNullParameter(kclass, "kclass");
        Intrinsics.checkNotNullParameter(converter, "converter");
        this.typeConverters.put(kclass, converter);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
    @NotNull
    protected Map<KClass<?>, List<KClass<?>>> getRequiredTypeConverterClasses() {
        throw new NotImplementedError(null, 1, null);
    }

    @NotNull
    public final Map<KClass<?>, List<KClass<?>>> getRequiredTypeConverterClassesMap$room_runtime() {
        return this.getRequiredTypeConverterClasses();
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
    protected final void internalInitInvalidationTracker(@NotNull SQLiteConnection connection) {
        Intrinsics.checkNotNullParameter(connection, "connection");
        this.getInvalidationTracker().internalInit$room_runtime(connection);
    }

    public final void close() {
        this.closeBarrier.close$room_runtime();
    }

    private final void onClosed() {
        CoroutineScope coroutineScope = this.coroutineScope;
        if (coroutineScope == null) {
            Intrinsics.throwUninitializedPropertyAccessException("coroutineScope");
            coroutineScope = null;
        }
        CoroutineScopeKt.cancel$default(coroutineScope, null, 1, null);
        this.getInvalidationTracker().stop$room_runtime();
        RoomConnectionManager roomConnectionManager = this.connectionManager;
        if (roomConnectionManager == null) {
            Intrinsics.throwUninitializedPropertyAccessException("connectionManager");
            roomConnectionManager = null;
        }
        roomConnectionManager.close();
    }

    @Nullable
    public final <R> Object useConnection$room_runtime(boolean isReadOnly, @NotNull Function2<? super Transactor, ? super Continuation<? super R>, ? extends Object> block2, @NotNull Continuation<? super R> $completion) {
        RoomConnectionManager roomConnectionManager = this.connectionManager;
        if (roomConnectionManager == null) {
            Intrinsics.throwUninitializedPropertyAccessException("connectionManager");
            roomConnectionManager = null;
        }
        return roomConnectionManager.useConnection(isReadOnly, block2, $completion);
    }

    public static final /* synthetic */ void access$onClosed(RoomDatabase $this) {
        $this.onClosed();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0015\n\u0002\b\n\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003B/\b\u0001\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00000\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0014\u0010\"\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u0006\u0010\f\u001a\u00020\rJ%\u0010#\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u0012\u0010$\u001a\n\u0012\u0006\b\u0001\u0012\u00020&0%\"\u00020&\u00a2\u0006\u0002\u0010'J\u0014\u0010(\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u0006\u0010)\u001a\u00020\u001dJ\u0014\u0010*\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u0006\u0010+\u001a\u00020\u001fJ\u0014\u0010,\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u0006\u0010+\u001a\u00020\u001fJ \u0010-\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u0006\u0010+\u001a\u00020\u001f2\n\u0010.\u001a\u00020/\"\u00020\u001aJ\u0014\u00100\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u0006\u00101\u001a\u00020\u0003J\u0014\u00102\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u0006\u0010\u0012\u001a\u00020\u0013J\u0014\u00103\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u0006\u00104\u001a\u00020\u0015J\u0014\u00105\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u0006\u00106\u001a\u00020\u0010J\u000b\u00107\u001a\u00028\u0000\u00a2\u0006\u0002\u00108R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00000\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00030\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001d0\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00069"}, d2={"Landroidx/room/RoomDatabase$Builder;", "T", "Landroidx/room/RoomDatabase;", "", "klass", "Lkotlin/reflect/KClass;", "name", "", "factory", "Lkotlin/Function0;", "<init>", "(Lkotlin/reflect/KClass;Ljava/lang/String;Lkotlin/jvm/functions/Function0;)V", "driver", "Landroidx/sqlite/SQLiteDriver;", "callbacks", "", "Landroidx/room/RoomDatabase$Callback;", "typeConverters", "journalMode", "Landroidx/room/RoomDatabase$JournalMode;", "queryCoroutineContext", "Lkotlin/coroutines/CoroutineContext;", "migrationContainer", "Landroidx/room/RoomDatabase$MigrationContainer;", "migrationsNotRequiredFrom", "", "", "migrationStartAndEndVersions", "autoMigrationSpecs", "Landroidx/room/migration/AutoMigrationSpec;", "requireMigration", "", "allowDestructiveMigrationOnDowngrade", "allowDestructiveMigrationForAllTables", "setDriver", "addMigrations", "migrations", "", "Landroidx/room/migration/Migration;", "([Landroidx/room/migration/Migration;)Landroidx/room/RoomDatabase$Builder;", "addAutoMigrationSpec", "autoMigrationSpec", "fallbackToDestructiveMigration", "dropAllTables", "fallbackToDestructiveMigrationOnDowngrade", "fallbackToDestructiveMigrationFrom", "startVersions", "", "addTypeConverter", "typeConverter", "setJournalMode", "setQueryCoroutineContext", "context", "addCallback", "callback", "build", "()Landroidx/room/RoomDatabase;", "room-runtime"})
    @SourceDebugExtension(value={"SMAP\nRoomDatabase.jvmNative.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RoomDatabase.jvmNative.kt\nandroidx/room/RoomDatabase$Builder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,624:1\n1#2:625\n*E\n"})
    public static final class Builder<T extends RoomDatabase> {
        @NotNull
        private final KClass<T> klass;
        @Nullable
        private final String name;
        @NotNull
        private final Function0<T> factory;
        @Nullable
        private SQLiteDriver driver;
        @NotNull
        private final List<Callback> callbacks;
        @NotNull
        private final List<Object> typeConverters;
        @NotNull
        private JournalMode journalMode;
        @Nullable
        private CoroutineContext queryCoroutineContext;
        @NotNull
        private final MigrationContainer migrationContainer;
        @NotNull
        private Set<Integer> migrationsNotRequiredFrom;
        @NotNull
        private final Set<Integer> migrationStartAndEndVersions;
        @NotNull
        private final List<AutoMigrationSpec> autoMigrationSpecs;
        private boolean requireMigration;
        private boolean allowDestructiveMigrationOnDowngrade;
        private boolean allowDestructiveMigrationForAllTables;

        @PublishedApi
        public Builder(@NotNull KClass<T> klass, @Nullable String name, @NotNull Function0<? extends T> factory2) {
            Intrinsics.checkNotNullParameter(klass, "klass");
            Intrinsics.checkNotNullParameter(factory2, "factory");
            this.klass = klass;
            this.name = name;
            this.factory = factory2;
            this.callbacks = new ArrayList();
            this.typeConverters = new ArrayList();
            this.journalMode = JournalMode.WRITE_AHEAD_LOGGING;
            this.migrationContainer = new MigrationContainer();
            this.migrationsNotRequiredFrom = new LinkedHashSet();
            this.migrationStartAndEndVersions = new LinkedHashSet();
            this.autoMigrationSpecs = new ArrayList();
            this.requireMigration = true;
        }

        @NotNull
        public final Builder<T> setDriver(@NotNull SQLiteDriver driver) {
            Builder builder;
            Intrinsics.checkNotNullParameter(driver, "driver");
            Builder $this$setDriver_u24lambda_u240 = builder = this;
            boolean bl = false;
            $this$setDriver_u24lambda_u240.driver = driver;
            return builder;
        }

        @NotNull
        public final Builder<T> addMigrations(Migration ... migrations) {
            Builder builder;
            Intrinsics.checkNotNullParameter(migrations, "migrations");
            Builder $this$addMigrations_u24lambda_u241 = builder = this;
            boolean bl = false;
            int n = migrations.length;
            for (int j = 0; j < n; ++j) {
                Migration migration = migrations[j];
                $this$addMigrations_u24lambda_u241.migrationStartAndEndVersions.add(migration.getStartVersion());
                $this$addMigrations_u24lambda_u241.migrationStartAndEndVersions.add(migration.getEndVersion());
            }
            $this$addMigrations_u24lambda_u241.migrationContainer.addMigrations(ArraysKt.toList(migrations));
            return builder;
        }

        @NotNull
        public final Builder<T> addAutoMigrationSpec(@NotNull AutoMigrationSpec autoMigrationSpec) {
            Builder builder;
            Intrinsics.checkNotNullParameter(autoMigrationSpec, "autoMigrationSpec");
            Builder $this$addAutoMigrationSpec_u24lambda_u242 = builder = this;
            boolean bl = false;
            $this$addAutoMigrationSpec_u24lambda_u242.autoMigrationSpecs.add(autoMigrationSpec);
            return builder;
        }

        @NotNull
        public final Builder<T> fallbackToDestructiveMigration(boolean dropAllTables) {
            Builder builder;
            Builder $this$fallbackToDestructiveMigration_u24lambda_u243 = builder = this;
            boolean bl = false;
            $this$fallbackToDestructiveMigration_u24lambda_u243.requireMigration = false;
            $this$fallbackToDestructiveMigration_u24lambda_u243.allowDestructiveMigrationOnDowngrade = true;
            $this$fallbackToDestructiveMigration_u24lambda_u243.allowDestructiveMigrationForAllTables = dropAllTables;
            return builder;
        }

        @NotNull
        public final Builder<T> fallbackToDestructiveMigrationOnDowngrade(boolean dropAllTables) {
            Builder builder;
            Builder $this$fallbackToDestructiveMigrationOnDowngrade_u24lambda_u244 = builder = this;
            boolean bl = false;
            $this$fallbackToDestructiveMigrationOnDowngrade_u24lambda_u244.requireMigration = true;
            $this$fallbackToDestructiveMigrationOnDowngrade_u24lambda_u244.allowDestructiveMigrationOnDowngrade = true;
            $this$fallbackToDestructiveMigrationOnDowngrade_u24lambda_u244.allowDestructiveMigrationForAllTables = dropAllTables;
            return builder;
        }

        @NotNull
        public final Builder<T> fallbackToDestructiveMigrationFrom(boolean dropAllTables, int ... startVersions) {
            Builder builder;
            Intrinsics.checkNotNullParameter(startVersions, "startVersions");
            Builder $this$fallbackToDestructiveMigrationFrom_u24lambda_u245 = builder = this;
            boolean bl = false;
            for (int startVersion : startVersions) {
                $this$fallbackToDestructiveMigrationFrom_u24lambda_u245.migrationsNotRequiredFrom.add(startVersion);
            }
            $this$fallbackToDestructiveMigrationFrom_u24lambda_u245.allowDestructiveMigrationForAllTables = dropAllTables;
            return builder;
        }

        @NotNull
        public final Builder<T> addTypeConverter(@NotNull Object typeConverter) {
            Builder builder;
            Intrinsics.checkNotNullParameter(typeConverter, "typeConverter");
            Builder $this$addTypeConverter_u24lambda_u246 = builder = this;
            boolean bl = false;
            $this$addTypeConverter_u24lambda_u246.typeConverters.add(typeConverter);
            return builder;
        }

        @NotNull
        public final Builder<T> setJournalMode(@NotNull JournalMode journalMode) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)journalMode, "journalMode");
            Builder $this$setJournalMode_u24lambda_u247 = builder = this;
            boolean bl = false;
            $this$setJournalMode_u24lambda_u247.journalMode = journalMode;
            return builder;
        }

        @NotNull
        public final Builder<T> setQueryCoroutineContext(@NotNull CoroutineContext context2) {
            Builder builder;
            Intrinsics.checkNotNullParameter(context2, "context");
            Builder $this$setQueryCoroutineContext_u24lambda_u249 = builder = this;
            boolean bl = false;
            if (!(context2.get(ContinuationInterceptor.Key) != null)) {
                boolean bl2 = false;
                String string2 = "It is required that the coroutine context contain a dispatcher.";
                throw new IllegalArgumentException(string2.toString());
            }
            $this$setQueryCoroutineContext_u24lambda_u249.queryCoroutineContext = context2;
            return builder;
        }

        @NotNull
        public final Builder<T> addCallback(@NotNull Callback callback) {
            Builder builder;
            Intrinsics.checkNotNullParameter(callback, "callback");
            Builder $this$addCallback_u24lambda_u2410 = builder = this;
            boolean bl = false;
            $this$addCallback_u24lambda_u2410.callbacks.add(callback);
            return builder;
        }

        @NotNull
        public final T build() {
            if (this.driver == null) {
                boolean $i$a$-requireNotNull-RoomDatabase$Builder$build$22 = false;
                String $i$a$-requireNotNull-RoomDatabase$Builder$build$22 = "Cannot create a RoomDatabase without providing a SQLiteDriver via setDriver().";
                throw new IllegalArgumentException($i$a$-requireNotNull-RoomDatabase$Builder$build$22.toString());
            }
            RoomDatabaseKt.validateMigrationsNotRequired(this.migrationStartAndEndVersions, this.migrationsNotRequiredFrom);
            CoroutineContext coroutineContext = this.queryCoroutineContext;
            if (coroutineContext == null) {
                coroutineContext = Dispatchers.getIO();
            }
            DatabaseConfiguration configuration = new DatabaseConfiguration(this.name, this.migrationContainer, this.callbacks, this.journalMode, this.requireMigration, this.allowDestructiveMigrationOnDowngrade, this.migrationsNotRequiredFrom, this.typeConverters, this.autoMigrationSpecs, this.allowDestructiveMigrationForAllTables, this.driver, coroutineContext);
            RoomDatabase db = (RoomDatabase)this.factory.invoke();
            db.init$room_runtime(configuration);
            return (T)db;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\t\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\n"}, d2={"Landroidx/room/RoomDatabase$Callback;", "", "<init>", "()V", "onCreate", "", "connection", "Landroidx/sqlite/SQLiteConnection;", "onDestructiveMigration", "onOpen", "room-runtime"})
    public static abstract class Callback {
        public void onCreate(@NotNull SQLiteConnection connection) {
            Intrinsics.checkNotNullParameter(connection, "connection");
        }

        public void onDestructiveMigration(@NotNull SQLiteConnection connection) {
            Intrinsics.checkNotNullParameter(connection, "connection");
        }

        public void onOpen(@NotNull SQLiteConnection connection) {
            Intrinsics.checkNotNullParameter(connection, "connection");
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Landroidx/room/RoomDatabase$JournalMode;", "", "<init>", "(Ljava/lang/String;I)V", "TRUNCATE", "WRITE_AHEAD_LOGGING", "room-runtime"})
    public static final class JournalMode
    extends Enum<JournalMode> {
        public static final /* enum */ JournalMode TRUNCATE = new JournalMode();
        public static final /* enum */ JournalMode WRITE_AHEAD_LOGGING = new JournalMode();
        private static final /* synthetic */ JournalMode[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static JournalMode[] values() {
            return (JournalMode[])$VALUES.clone();
        }

        public static JournalMode valueOf(String value) {
            return Enum.valueOf(JournalMode.class, value);
        }

        @NotNull
        public static EnumEntries<JournalMode> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = journalModeArray = new JournalMode[]{JournalMode.TRUNCATE, JournalMode.WRITE_AHEAD_LOGGING};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0010\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u001c\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\b\u001a\u001a\u0012\u0004\u0012\u00020\u0006\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\t0\tJ\u0014\u0010\n\u001a\u00020\u000b2\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00070\fJ\u0010\u0010\r\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u0007H\u0007J\u0016\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u0006J5\u0010\u0013\u001a\"\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u0015\u0018\u00010\u00142\u0006\u0010\u0016\u001a\u00020\u0006H\u0000\u00a2\u0006\u0002\b\u0017J5\u0010\u0018\u001a\"\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u0015\u0018\u00010\u00142\u0006\u0010\u0016\u001a\u00020\u0006H\u0000\u00a2\u0006\u0002\b\u0019R&\u0010\u0004\u001a\u001a\u0012\u0004\u0012\u00020\u0006\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Landroidx/room/RoomDatabase$MigrationContainer;", "", "<init>", "()V", "migrations", "", "", "Landroidx/room/migration/Migration;", "getMigrations", "", "addMigrations", "", "", "addMigration", "migration", "contains", "", "startVersion", "endVersion", "getSortedNodes", "Lkotlin/Pair;", "", "migrationStart", "getSortedNodes$room_runtime", "getSortedDescendingNodes", "getSortedDescendingNodes$room_runtime", "room-runtime"})
    @SourceDebugExtension(value={"SMAP\nRoomDatabase.jvmNative.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RoomDatabase.jvmNative.kt\nandroidx/room/RoomDatabase$MigrationContainer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,624:1\n1863#2,2:625\n381#3,7:627\n*S KotlinDebug\n*F\n+ 1 RoomDatabase.jvmNative.kt\nandroidx/room/RoomDatabase$MigrationContainer\n*L\n546#1:625,2\n559#1:627,7\n*E\n"})
    public static final class MigrationContainer {
        @NotNull
        private final Map<Integer, Map<Integer, Migration>> migrations = new LinkedHashMap();

        @NotNull
        public final Map<Integer, Map<Integer, Migration>> getMigrations() {
            return this.migrations;
        }

        public final void addMigrations(@NotNull List<? extends Migration> migrations) {
            Intrinsics.checkNotNullParameter(migrations, "migrations");
            Iterable $this$forEach$iv = migrations;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Migration p0 = (Migration)element$iv;
                boolean bl = false;
                this.addMigration(p0);
            }
        }

        /*
         * WARNING - void declaration
         */
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        public final void addMigration(@NotNull Migration migration) {
            Object object;
            void $this$getOrPut$iv;
            Intrinsics.checkNotNullParameter(migration, "migration");
            int start2 = migration.getStartVersion();
            int end = migration.getEndVersion();
            Map<Integer, Map<Integer, Migration>> map2 = this.migrations;
            Integer key$iv = start2;
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(key$iv);
            if (value$iv == null) {
                boolean bl = false;
                Map answer$iv = new LinkedHashMap();
                $this$getOrPut$iv.put(key$iv, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            Map targetMap = (Map)object;
            Integer n = end;
            targetMap.put(n, migration);
        }

        public final boolean contains(int startVersion, int endVersion) {
            return MigrationUtil.contains(this, startVersion, endVersion);
        }

        @Nullable
        public final Pair<Map<Integer, Migration>, Iterable<Integer>> getSortedNodes$room_runtime(int migrationStart) {
            Map<Integer, Migration> map2 = this.migrations.get(migrationStart);
            if (map2 == null) {
                return null;
            }
            Map<Integer, Migration> targetNodes = map2;
            return TuplesKt.to(targetNodes, CollectionsKt.sorted((Iterable)targetNodes.keySet()));
        }

        @Nullable
        public final Pair<Map<Integer, Migration>, Iterable<Integer>> getSortedDescendingNodes$room_runtime(int migrationStart) {
            Map<Integer, Migration> map2 = this.migrations.get(migrationStart);
            if (map2 == null) {
                return null;
            }
            Map<Integer, Migration> targetNodes = map2;
            return TuplesKt.to(targetNodes, CollectionsKt.sortedDescending((Iterable)targetNodes.keySet()));
        }
    }
}

