/*
 * Decompiled with CFR 0.152.
 */
package androidx.room.util;

import androidx.annotation.RestrictTo;
import androidx.room.DatabaseConfiguration;
import androidx.room.RoomDatabase;
import androidx.room.migration.Migration;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u00000\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\b\u0002\u001a\u001c\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0000\u001a\u001c\u0010\u0006\u001a\u00020\u0001*\u00020\u00072\u0006\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u0004H\u0000\u001a$\u0010\n\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u000b*\u00020\u00072\u0006\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u0004H\u0000\u001a:\u0010\u000f\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u000b*\u00020\u00072\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\f0\u00112\u0006\u0010\u0012\u001a\u00020\u00012\u0006\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u0004H\u0002\u00a8\u0006\u0013"}, d2={"isMigrationRequired", "", "Landroidx/room/DatabaseConfiguration;", "fromVersion", "", "toVersion", "contains", "Landroidx/room/RoomDatabase$MigrationContainer;", "startVersion", "endVersion", "findMigrationPath", "", "Landroidx/room/migration/Migration;", "start", "end", "findUpMigrationPath", "result", "", "upgrade", "room-runtime"})
@JvmName(name="MigrationUtil")
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public final class MigrationUtil {
    public static final boolean isMigrationRequired(@NotNull DatabaseConfiguration $this$isMigrationRequired, int fromVersion, int toVersion) {
        boolean bl;
        boolean isDowngrade;
        Intrinsics.checkNotNullParameter($this$isMigrationRequired, "<this>");
        boolean bl2 = isDowngrade = fromVersion > toVersion;
        if (isDowngrade && $this$isMigrationRequired.getAllowDestructiveMigrationOnDowngrade()) {
            bl = false;
        } else {
            Set<Integer> migrationNotRequiredFrom = $this$isMigrationRequired.getMigrationNotRequiredFrom$room_runtime();
            bl = $this$isMigrationRequired.getRequireMigration() && (migrationNotRequiredFrom == null || !migrationNotRequiredFrom.contains(fromVersion));
        }
        return bl;
    }

    public static final boolean contains(@NotNull RoomDatabase.MigrationContainer $this$contains, int startVersion, int endVersion) {
        Intrinsics.checkNotNullParameter($this$contains, "<this>");
        Map<Integer, Map<Integer, Migration>> migrations = $this$contains.getMigrations();
        if (migrations.containsKey(startVersion)) {
            Map<Integer, Migration> map2 = migrations.get(startVersion);
            if (map2 == null) {
                map2 = MapsKt.emptyMap();
            }
            Map<Integer, Migration> startVersionMatches = map2;
            return startVersionMatches.containsKey(endVersion);
        }
        return false;
    }

    @Nullable
    public static final List<Migration> findMigrationPath(@NotNull RoomDatabase.MigrationContainer $this$findMigrationPath, int start2, int end) {
        Intrinsics.checkNotNullParameter($this$findMigrationPath, "<this>");
        if (start2 == end) {
            return CollectionsKt.emptyList();
        }
        boolean migrateUp = end > start2;
        List result2 = new ArrayList();
        return MigrationUtil.findUpMigrationPath($this$findMigrationPath, result2, migrateUp, start2, end);
    }

    private static final List<Migration> findUpMigrationPath(RoomDatabase.MigrationContainer $this$findUpMigrationPath, List<Migration> result2, boolean upgrade, int start2, int end) {
        block3: {
            boolean found;
            int migrationStart = start2;
            block0: do {
                Pair<Map<Integer, Migration>, Iterable<Integer>> pair;
                boolean bl = upgrade ? migrationStart < end : migrationStart > end;
                if (!bl) break block3;
                if ((upgrade ? $this$findUpMigrationPath.getSortedDescendingNodes$room_runtime(migrationStart) : $this$findUpMigrationPath.getSortedNodes$room_runtime(migrationStart)) == null) {
                    return null;
                }
                pair = pair;
                Map<Integer, Migration> targetNodes = pair.component1();
                Iterable<Integer> keySet = pair.component2();
                found = false;
                Iterator<Integer> iterator2 = keySet.iterator();
                while (iterator2.hasNext()) {
                    int targetVersion = ((Number)iterator2.next()).intValue();
                    boolean bl2 = upgrade ? (migrationStart + 1 <= targetVersion ? targetVersion <= end : false) : (end <= targetVersion ? targetVersion < migrationStart : false);
                    boolean shouldAddToPath = bl2;
                    if (!shouldAddToPath) continue;
                    Migration migration = targetNodes.get(targetVersion);
                    Intrinsics.checkNotNull(migration);
                    result2.add(migration);
                    migrationStart = targetVersion;
                    found = true;
                    continue block0;
                }
            } while (found);
            return null;
        }
        return result2;
    }
}

