/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.http;

import io.ktor.http.URLDecodeException;
import io.ktor.utils.io.charsets.EncodingKt;
import io.ktor.utils.io.core.BufferKt;
import io.ktor.utils.io.core.ByteReadPacketKt;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.CharRange;
import kotlin.text.CharsKt;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import kotlinx.io.Buffer;
import kotlinx.io.Source;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000T\n\u0002\u0010\u000e\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\"\n\u0002\u0010\f\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\r\n\u0002\b\u0003\n\u0002\u0010\u0005\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\b\b\u001a3\u0010\u0007\u001a\u00020\u0000*\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00012\b\b\u0002\u0010\u0003\u001a\u00020\u00012\f\b\u0002\u0010\u0006\u001a\u00060\u0004j\u0002`\u0005\u00a2\u0006\u0004\b\u0007\u0010\b\u001a\u0011\u0010\t\u001a\u00020\u0000*\u00020\u0000\u00a2\u0006\u0004\b\t\u0010\n\u001a%\u0010\r\u001a\u00020\u0000*\u00020\u00002\b\b\u0002\u0010\u000b\u001a\u00020\u00012\b\b\u0002\u0010\f\u001a\u00020\u0001\u00a2\u0006\u0004\b\r\u0010\u000e\u001a\u0011\u0010\u000f\u001a\u00020\u0000*\u00020\u0000\u00a2\u0006\u0004\b\u000f\u0010\n\u001a\u001b\u0010\u0010\u001a\u00020\u0000*\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0010\u0010\u0011\u001a!\u0010\u0015\u001a\u00020\u0000*\u00020\u00002\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0000\u00a2\u0006\u0004\b\u0015\u0010\u0016\u001a\u0013\u0010\u0017\u001a\u00020\u0000*\u00020\u0000H\u0000\u00a2\u0006\u0004\b\u0017\u0010\n\u001a=\u0010\u001c\u001a\u00020\u0000*\u00020\u00002\b\b\u0002\u0010\u0019\u001a\u00020\u00182\b\b\u0002\u0010\u001a\u001a\u00020\u00182\b\b\u0002\u0010\u001b\u001a\u00020\u00012\f\b\u0002\u0010\u0006\u001a\u00060\u0004j\u0002`\u0005\u00a2\u0006\u0004\b\u001c\u0010\u001d\u001a3\u0010\u001e\u001a\u00020\u0000*\u00020\u00002\b\b\u0002\u0010\u0019\u001a\u00020\u00182\b\b\u0002\u0010\u001a\u001a\u00020\u00182\f\b\u0002\u0010\u0006\u001a\u00060\u0004j\u0002`\u0005\u00a2\u0006\u0004\b\u001e\u0010\u001f\u001a7\u0010 \u001a\u00020\u0000*\u00020\u00002\u0006\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u00012\n\u0010\u0006\u001a\u00060\u0004j\u0002`\u0005H\u0002\u00a2\u0006\u0004\b \u0010\u001d\u001a?\u0010#\u001a\u00020\u0000*\u00020!2\u0006\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u00182\u0006\u0010\"\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u00012\n\u0010\u0006\u001a\u00060\u0004j\u0002`\u0005H\u0002\u00a2\u0006\u0004\b#\u0010$\u001a\u0013\u0010\u0015\u001a\u00020\u0000*\u00020%H\u0002\u00a2\u0006\u0004\b\u0015\u0010&\u001a\u0017\u0010(\u001a\u00020\u00182\u0006\u0010'\u001a\u00020\u0013H\u0002\u00a2\u0006\u0004\b(\u0010)\u001a\u0017\u0010+\u001a\u00020\u00132\u0006\u0010*\u001a\u00020\u0018H\u0002\u00a2\u0006\u0004\b+\u0010,\u001a'\u00101\u001a\u00020/*\u00020-2\u0012\u00100\u001a\u000e\u0012\u0004\u0012\u00020%\u0012\u0004\u0012\u00020/0.H\u0002\u00a2\u0006\u0004\b1\u00102\"\u001a\u00103\u001a\b\u0012\u0004\u0012\u00020%0\u00128\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b3\u00104\"\u001a\u00105\u001a\b\u0012\u0004\u0012\u00020\u00130\u00128\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b5\u00104\"\u001a\u00106\u001a\b\u0012\u0004\u0012\u00020\u00130\u00128\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b6\u00104\"\u001a\u00108\u001a\b\u0012\u0004\u0012\u00020%078\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b8\u00109\"\u001a\u0010:\u001a\b\u0012\u0004\u0012\u00020\u00130\u00128\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b:\u00104\" \u0010;\u001a\b\u0012\u0004\u0012\u00020\u00130\u00128\u0000X\u0080\u0004\u00a2\u0006\f\n\u0004\b;\u00104\u001a\u0004\b<\u0010=\"\u001a\u0010>\u001a\b\u0012\u0004\u0012\u00020%078\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b>\u00109\u00a8\u0006?"}, d2={"", "", "encodeFull", "spaceToPlus", "Ljava/nio/charset/Charset;", "Lio/ktor/utils/io/charsets/Charset;", "charset", "encodeURLQueryComponent", "(Ljava/lang/String;ZZLjava/nio/charset/Charset;)Ljava/lang/String;", "encodeURLPathPart", "(Ljava/lang/String;)Ljava/lang/String;", "encodeSlash", "encodeEncoded", "encodeURLPath", "(Ljava/lang/String;ZZ)Ljava/lang/String;", "encodeOAuth", "encodeURLParameter", "(Ljava/lang/String;Z)Ljava/lang/String;", "", "", "allowedSet", "percentEncode", "(Ljava/lang/String;Ljava/util/Set;)Ljava/lang/String;", "encodeURLParameterValue", "", "start", "end", "plusIsSpace", "decodeURLQueryComponent", "(Ljava/lang/String;IIZLjava/nio/charset/Charset;)Ljava/lang/String;", "decodeURLPart", "(Ljava/lang/String;IILjava/nio/charset/Charset;)Ljava/lang/String;", "decodeScan", "", "prefixEnd", "decodeImpl", "(Ljava/lang/CharSequence;IIIZLjava/nio/charset/Charset;)Ljava/lang/String;", "", "(B)Ljava/lang/String;", "c2", "charToHexDigit", "(C)I", "digit", "hexDigitToChar", "(I)C", "Lkotlinx/io/Source;", "Lkotlin/Function1;", "", "block", "forEach", "(Lkotlinx/io/Source;Lkotlin/jvm/functions/Function1;)V", "URL_ALPHABET", "Ljava/util/Set;", "URL_ALPHABET_CHARS", "HEX_ALPHABET", "", "URL_PROTOCOL_PART", "Ljava/util/List;", "VALID_PATH_PART", "ATTRIBUTE_CHARACTERS", "getATTRIBUTE_CHARACTERS", "()Ljava/util/Set;", "SPECIAL_SYMBOLS", "ktor-http"})
@SourceDebugExtension(value={"SMAP\nCodecs.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Codecs.kt\nio/ktor/http/CodecsKt\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,322:1\n1104#2,3:323\n13479#3,2:326\n1563#4:328\n1634#4,3:329\n1563#4:332\n1634#4,3:333\n1563#4:336\n1634#4,3:337\n*S KotlinDebug\n*F\n+ 1 Codecs.kt\nio/ktor/http/CodecsKt\n*L\n150#1:323,3\n161#1:326,2\n11#1:328\n11#1:329,3\n22#1:332\n22#1:333,3\n44#1:336\n44#1:337,3\n*E\n"})
public final class CodecsKt {
    @NotNull
    private static final Set<Byte> URL_ALPHABET;
    @NotNull
    private static final Set<Character> URL_ALPHABET_CHARS;
    @NotNull
    private static final Set<Character> HEX_ALPHABET;
    @NotNull
    private static final List<Byte> URL_PROTOCOL_PART;
    @NotNull
    private static final Set<Character> VALID_PATH_PART;
    @NotNull
    private static final Set<Character> ATTRIBUTE_CHARACTERS;
    @NotNull
    private static final List<Byte> SPECIAL_SYMBOLS;

    @NotNull
    public static final Set<Character> getATTRIBUTE_CHARACTERS() {
        return ATTRIBUTE_CHARACTERS;
    }

    @NotNull
    public static final String encodeURLQueryComponent(@NotNull String $this$encodeURLQueryComponent, boolean encodeFull, boolean spaceToPlus, @NotNull Charset charset) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter($this$encodeURLQueryComponent, "<this>");
        Intrinsics.checkNotNullParameter(charset, "charset");
        StringBuilder $this$encodeURLQueryComponent_u24lambda_u244 = stringBuilder = new StringBuilder();
        boolean bl = false;
        CharsetEncoder charsetEncoder = charset.newEncoder();
        Intrinsics.checkNotNullExpressionValue(charsetEncoder, "newEncoder(...)");
        Source content2 = EncodingKt.encode$default(charsetEncoder, $this$encodeURLQueryComponent, 0, 0, 6, null);
        CodecsKt.forEach(content2, arg_0 -> CodecsKt.encodeURLQueryComponent$lambda$4$lambda$3(spaceToPlus, $this$encodeURLQueryComponent_u24lambda_u244, encodeFull, arg_0));
        return stringBuilder.toString();
    }

    public static /* synthetic */ String encodeURLQueryComponent$default(String string2, boolean bl, boolean bl2, Charset charset, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        if ((n & 2) != 0) {
            bl2 = false;
        }
        if ((n & 4) != 0) {
            charset = Charsets.UTF_8;
        }
        return CodecsKt.encodeURLQueryComponent(string2, bl, bl2, charset);
    }

    @NotNull
    public static final String encodeURLPathPart(@NotNull String $this$encodeURLPathPart) {
        Intrinsics.checkNotNullParameter($this$encodeURLPathPart, "<this>");
        return CodecsKt.encodeURLPath$default($this$encodeURLPathPart, true, false, 2, null);
    }

    @NotNull
    public static final String encodeURLPath(@NotNull String $this$encodeURLPath, boolean encodeSlash, boolean encodeEncoded) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter($this$encodeURLPath, "<this>");
        StringBuilder $this$encodeURLPath_u24lambda_u246 = stringBuilder = new StringBuilder();
        boolean bl = false;
        Charset charset = Charsets.UTF_8;
        int index2 = 0;
        while (index2 < $this$encodeURLPath.length()) {
            char current = $this$encodeURLPath.charAt(index2);
            if (!encodeSlash && current == '/' || URL_ALPHABET_CHARS.contains(Character.valueOf(current)) || VALID_PATH_PART.contains(Character.valueOf(current))) {
                $this$encodeURLPath_u24lambda_u246.append(current);
                ++index2;
                continue;
            }
            if (!encodeEncoded && current == '%' && index2 + 2 < $this$encodeURLPath.length() && HEX_ALPHABET.contains(Character.valueOf($this$encodeURLPath.charAt(index2 + 1))) && HEX_ALPHABET.contains(Character.valueOf($this$encodeURLPath.charAt(index2 + 2)))) {
                $this$encodeURLPath_u24lambda_u246.append(current);
                $this$encodeURLPath_u24lambda_u246.append($this$encodeURLPath.charAt(index2 + 1));
                $this$encodeURLPath_u24lambda_u246.append($this$encodeURLPath.charAt(index2 + 2));
                index2 += 3;
                continue;
            }
            int symbolSize = CharsKt.isSurrogate(current) ? 2 : 1;
            CharsetEncoder charsetEncoder = charset.newEncoder();
            Intrinsics.checkNotNullExpressionValue(charsetEncoder, "newEncoder(...)");
            CodecsKt.forEach(EncodingKt.encode(charsetEncoder, $this$encodeURLPath, index2, index2 + symbolSize), arg_0 -> CodecsKt.encodeURLPath$lambda$6$lambda$5($this$encodeURLPath_u24lambda_u246, arg_0));
            index2 += symbolSize;
        }
        return stringBuilder.toString();
    }

    public static /* synthetic */ String encodeURLPath$default(String string2, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        if ((n & 2) != 0) {
            bl2 = true;
        }
        return CodecsKt.encodeURLPath(string2, bl, bl2);
    }

    @NotNull
    public static final String encodeOAuth(@NotNull String $this$encodeOAuth) {
        Intrinsics.checkNotNullParameter($this$encodeOAuth, "<this>");
        return CodecsKt.encodeURLParameter$default($this$encodeOAuth, false, 1, null);
    }

    @NotNull
    public static final String encodeURLParameter(@NotNull String $this$encodeURLParameter, boolean spaceToPlus) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter($this$encodeURLParameter, "<this>");
        StringBuilder $this$encodeURLParameter_u24lambda_u248 = stringBuilder = new StringBuilder();
        boolean bl = false;
        CharsetEncoder charsetEncoder = Charsets.UTF_8.newEncoder();
        Intrinsics.checkNotNullExpressionValue(charsetEncoder, "newEncoder(...)");
        Source content2 = EncodingKt.encode$default(charsetEncoder, $this$encodeURLParameter, 0, 0, 6, null);
        CodecsKt.forEach(content2, arg_0 -> CodecsKt.encodeURLParameter$lambda$8$lambda$7($this$encodeURLParameter_u24lambda_u248, spaceToPlus, arg_0));
        return stringBuilder.toString();
    }

    public static /* synthetic */ String encodeURLParameter$default(String string2, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        return CodecsKt.encodeURLParameter(string2, bl);
    }

    @NotNull
    public static final String percentEncode(@NotNull String $this$percentEncode, @NotNull Set<Character> allowedSet) {
        Intrinsics.checkNotNullParameter($this$percentEncode, "<this>");
        Intrinsics.checkNotNullParameter(allowedSet, "allowedSet");
        CharSequence $this$count$iv = $this$percentEncode;
        boolean $i$f$count = false;
        int count$iv = 0;
        for (int j = 0; j < $this$count$iv.length(); ++j) {
            char element$iv;
            char it = element$iv = $this$count$iv.charAt(j);
            boolean bl = false;
            if (!(!allowedSet.contains(Character.valueOf(it)))) continue;
            ++count$iv;
        }
        int encodedCount = count$iv;
        if (encodedCount == 0) {
            return $this$percentEncode;
        }
        byte[] content2 = io.ktor.utils.io.core.StringsKt.toByteArray($this$percentEncode, Charsets.UTF_8);
        int rawCount = $this$percentEncode.length() - encodedCount;
        int resultSize = rawCount + (content2.length - rawCount) * 3;
        char[] result2 = new char[resultSize];
        int writeIndex = 0;
        byte[] $this$forEach$iv = content2;
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int j = 0; j < n; ++j) {
            byte element$iv;
            byte it = element$iv = $this$forEach$iv[j];
            boolean bl = false;
            char c = (char)it;
            if (allowedSet.contains(Character.valueOf(c))) {
                int n2 = writeIndex;
                writeIndex = n2 + 1;
                result2[n2] = c;
                continue;
            }
            int code2 = it & 0xFF;
            int n3 = writeIndex;
            writeIndex = n3 + 1;
            result2[n3] = 37;
            n3 = writeIndex;
            writeIndex = n3 + 1;
            result2[n3] = CodecsKt.hexDigitToChar(code2 >> 4);
            n3 = writeIndex;
            writeIndex = n3 + 1;
            result2[n3] = CodecsKt.hexDigitToChar(code2 & 0xF);
        }
        return StringsKt.concatToString(result2);
    }

    @NotNull
    public static final String encodeURLParameterValue(@NotNull String $this$encodeURLParameterValue) {
        Intrinsics.checkNotNullParameter($this$encodeURLParameterValue, "<this>");
        return CodecsKt.encodeURLParameter($this$encodeURLParameterValue, true);
    }

    @NotNull
    public static final String decodeURLQueryComponent(@NotNull String $this$decodeURLQueryComponent, int start2, int end, boolean plusIsSpace, @NotNull Charset charset) {
        Intrinsics.checkNotNullParameter($this$decodeURLQueryComponent, "<this>");
        Intrinsics.checkNotNullParameter(charset, "charset");
        return CodecsKt.decodeScan($this$decodeURLQueryComponent, start2, end, plusIsSpace, charset);
    }

    public static /* synthetic */ String decodeURLQueryComponent$default(String string2, int n, int n2, boolean bl, Charset charset, int n3, Object object) {
        if ((n3 & 1) != 0) {
            n = 0;
        }
        if ((n3 & 2) != 0) {
            n2 = string2.length();
        }
        if ((n3 & 4) != 0) {
            bl = false;
        }
        if ((n3 & 8) != 0) {
            charset = Charsets.UTF_8;
        }
        return CodecsKt.decodeURLQueryComponent(string2, n, n2, bl, charset);
    }

    @NotNull
    public static final String decodeURLPart(@NotNull String $this$decodeURLPart, int start2, int end, @NotNull Charset charset) {
        Intrinsics.checkNotNullParameter($this$decodeURLPart, "<this>");
        Intrinsics.checkNotNullParameter(charset, "charset");
        return CodecsKt.decodeScan($this$decodeURLPart, start2, end, false, charset);
    }

    public static /* synthetic */ String decodeURLPart$default(String string2, int n, int n2, Charset charset, int n3, Object object) {
        if ((n3 & 1) != 0) {
            n = 0;
        }
        if ((n3 & 2) != 0) {
            n2 = string2.length();
        }
        if ((n3 & 4) != 0) {
            charset = Charsets.UTF_8;
        }
        return CodecsKt.decodeURLPart(string2, n, n2, charset);
    }

    private static final String decodeScan(String $this$decodeScan, int start2, int end, boolean plusIsSpace, Charset charset) {
        String string2;
        for (int index2 = start2; index2 < end; ++index2) {
            char ch = $this$decodeScan.charAt(index2);
            if (ch != '%' && (!plusIsSpace || ch != '+')) continue;
            return CodecsKt.decodeImpl($this$decodeScan, start2, end, index2, plusIsSpace, charset);
        }
        if (start2 == 0 && end == $this$decodeScan.length()) {
            string2 = $this$decodeScan.toString();
        } else {
            String string3 = $this$decodeScan.substring(start2, end);
            string2 = string3;
            Intrinsics.checkNotNullExpressionValue(string3, "substring(...)");
        }
        return string2;
    }

    private static final String decodeImpl(CharSequence $this$decodeImpl, int start2, int end, int prefixEnd, boolean plusIsSpace, Charset charset) {
        int length = end - start2;
        int sbSize = length > 255 ? length / 3 : length;
        StringBuilder sb = new StringBuilder(sbSize);
        if (prefixEnd > start2) {
            sb.append($this$decodeImpl, start2, prefixEnd);
        }
        int index2 = prefixEnd;
        byte[] bytes = null;
        while (index2 < end) {
            Serializable serializable;
            char c = $this$decodeImpl.charAt(index2);
            if (plusIsSpace && c == '+') {
                sb.append(' ');
                serializable = Integer.valueOf(index2++);
                continue;
            }
            if (c == '%') {
                if (bytes == null) {
                    bytes = new byte[(end - index2) / 3];
                }
                int count2 = 0;
                while (index2 < end && $this$decodeImpl.charAt(index2) == '%') {
                    if (index2 + 2 >= end) {
                        CharSequence charSequence = $this$decodeImpl;
                        int n = charSequence.length();
                        throw new URLDecodeException("Incomplete trailing HEX escape: " + ((Object)charSequence.subSequence(index2, n)).toString() + ", in " + $this$decodeImpl + " at " + index2);
                    }
                    int digit1 = CodecsKt.charToHexDigit($this$decodeImpl.charAt(index2 + 1));
                    int digit2 = CodecsKt.charToHexDigit($this$decodeImpl.charAt(index2 + 2));
                    if (digit1 == -1 || digit2 == -1) {
                        throw new URLDecodeException("Wrong HEX escape: %" + $this$decodeImpl.charAt(index2 + 1) + $this$decodeImpl.charAt(index2 + 2) + ", in " + $this$decodeImpl + ", at " + index2);
                    }
                    bytes[count2++] = (byte)(digit1 * 16 + digit2);
                    index2 += 3;
                }
                serializable = sb.append(StringsKt.decodeToString$default(bytes, 0, 0 + count2, false, 4, null));
                continue;
            }
            sb.append(c);
            serializable = Integer.valueOf(index2++);
        }
        String string2 = sb.toString();
        Intrinsics.checkNotNullExpressionValue(string2, "toString(...)");
        return string2;
    }

    private static final String percentEncode(byte $this$percentEncode) {
        int code2 = $this$percentEncode & 0xFF;
        char[] array2 = new char[]{'%', CodecsKt.hexDigitToChar(code2 >> 4), CodecsKt.hexDigitToChar(code2 & 0xF)};
        return StringsKt.concatToString(array2);
    }

    private static final int charToHexDigit(char c2) {
        int n;
        block1: {
            char c;
            block0: {
                c = c2;
                boolean bl = '0' <= c ? c < ':' : false;
                if (!bl) break block0;
                n = c2 - 48;
                break block1;
            }
            n = ('A' <= c ? c < 'G' : false) ? c2 - 65 + 10 : (('a' <= c ? c < 'g' : false) ? c2 - 97 + 10 : -1);
        }
        return n;
    }

    private static final char hexDigitToChar(int digit) {
        int n = digit;
        return (0 <= n ? n < 10 : false) ? (char)(48 + digit) : (char)((char)(65 + digit) - 10);
    }

    private static final void forEach(Source $this$forEach, Function1<? super Byte, Unit> block2) {
        ByteReadPacketKt.takeWhile($this$forEach, arg_0 -> CodecsKt.forEach$lambda$11(block2, arg_0));
    }

    private static final Unit encodeURLQueryComponent$lambda$4$lambda$3(boolean $spaceToPlus, StringBuilder $this_buildString, boolean $encodeFull, byte it) {
        StringBuilder stringBuilder = it == 32 ? ($spaceToPlus ? $this_buildString.append('+') : $this_buildString.append("%20")) : (URL_ALPHABET.contains(it) || !$encodeFull && URL_PROTOCOL_PART.contains(it) ? $this_buildString.append((char)it) : $this_buildString.append(CodecsKt.percentEncode(it)));
        return Unit.INSTANCE;
    }

    private static final Unit encodeURLPath$lambda$6$lambda$5(StringBuilder $this_buildString, byte it) {
        $this_buildString.append(CodecsKt.percentEncode(it));
        return Unit.INSTANCE;
    }

    private static final Unit encodeURLParameter$lambda$8$lambda$7(StringBuilder $this_buildString, boolean $spaceToPlus, byte it) {
        StringBuilder stringBuilder = URL_ALPHABET.contains(it) || SPECIAL_SYMBOLS.contains(it) ? $this_buildString.append((char)it) : ($spaceToPlus && it == 32 ? $this_buildString.append('+') : $this_buildString.append(CodecsKt.percentEncode(it)));
        return Unit.INSTANCE;
    }

    private static final boolean forEach$lambda$11(Function1 $block, Buffer buffer) {
        Intrinsics.checkNotNullParameter(buffer, "buffer");
        while (BufferKt.canRead(buffer)) {
            $block.invoke(buffer.readByte());
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var3_3;
        char it;
        Collection collection;
        Object item$iv$iv;
        Object $this$mapTo$iv$iv;
        Object $this$map$iv = (Character[])CollectionsKt.plus((Collection)CollectionsKt.plus((Iterable)new CharRange('a', 'z'), (Iterable)new CharRange('A', 'Z')), (Iterable)new CharRange('0', '9'));
        boolean $i$f$map = false;
        Character[] characterArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        Iterator iterator2 = $this$mapTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            item$iv$iv = iterator2.next();
            char c = ((Character)item$iv$iv).charValue();
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add((byte)it);
        }
        URL_ALPHABET = CollectionsKt.toSet((List)destination$iv$iv);
        URL_ALPHABET_CHARS = CollectionsKt.toSet(CollectionsKt.plus((Collection)CollectionsKt.plus((Iterable)new CharRange('a', 'z'), (Iterable)new CharRange('A', 'Z')), (Iterable)new CharRange('0', '9')));
        HEX_ALPHABET = CollectionsKt.toSet(CollectionsKt.plus((Collection)CollectionsKt.plus((Iterable)new CharRange('a', 'f'), (Iterable)new CharRange('A', 'F')), (Iterable)new CharRange('0', '9')));
        $this$map$iv = new Character[]{Character.valueOf(':'), Character.valueOf('/'), Character.valueOf('?'), Character.valueOf('#'), Character.valueOf('['), Character.valueOf(']'), Character.valueOf('@'), Character.valueOf('!'), Character.valueOf('$'), Character.valueOf('&'), Character.valueOf('\''), Character.valueOf('('), Character.valueOf(')'), Character.valueOf('*'), Character.valueOf(','), Character.valueOf(';'), Character.valueOf('='), Character.valueOf('-'), Character.valueOf('.'), Character.valueOf('_'), Character.valueOf('~'), Character.valueOf('+')};
        $this$map$iv = SetsKt.setOf($this$map$iv);
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        $i$f$mapTo = false;
        iterator2 = $this$mapTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            item$iv$iv = iterator2.next();
            it = ((Character)item$iv$iv).charValue();
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add((byte)it);
        }
        URL_PROTOCOL_PART = (List)destination$iv$iv;
        $this$map$iv = new Character[]{Character.valueOf(':'), Character.valueOf('@'), Character.valueOf('!'), Character.valueOf('$'), Character.valueOf('&'), Character.valueOf('\''), Character.valueOf('('), Character.valueOf(')'), Character.valueOf('*'), Character.valueOf('+'), Character.valueOf(','), Character.valueOf(';'), Character.valueOf('='), Character.valueOf('-'), Character.valueOf('.'), Character.valueOf('_'), Character.valueOf('~')};
        VALID_PATH_PART = SetsKt.setOf($this$map$iv);
        $this$map$iv = new Character[]{Character.valueOf('!'), Character.valueOf('#'), Character.valueOf('$'), Character.valueOf('&'), Character.valueOf('+'), Character.valueOf('-'), Character.valueOf('.'), Character.valueOf('^'), Character.valueOf('_'), Character.valueOf('`'), Character.valueOf('|'), Character.valueOf('~')};
        ATTRIBUTE_CHARACTERS = SetsKt.plus(URL_ALPHABET_CHARS, SetsKt.setOf($this$map$iv));
        $this$map$iv = new Character[]{Character.valueOf('-'), Character.valueOf('.'), Character.valueOf('_'), Character.valueOf('~')};
        $this$map$iv = CollectionsKt.listOf($this$map$iv);
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        $i$f$mapTo = false;
        iterator2 = $this$mapTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            item$iv$iv = iterator2.next();
            it = ((Character)item$iv$iv).charValue();
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add((byte)it);
        }
        SPECIAL_SYMBOLS = (List)var3_3;
    }
}

