/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.server.netty.http2;

import io.ktor.http.URLUtilsKt;
import io.ktor.http.Url;
import io.ktor.server.application.Application;
import io.ktor.server.engine.EnginePipeline;
import io.ktor.server.netty.NettyApplicationCallHandler;
import io.ktor.server.netty.NettyHttpHandlerState;
import io.ktor.server.netty.cio.NettyHttpResponsePipeline;
import io.ktor.server.netty.http2.NettyHttp2ApplicationCall;
import io.ktor.server.netty.http2.NettyHttp2ApplicationRequest;
import io.ktor.server.response.ResponsePushBuilder;
import io.ktor.server.response.UseHttp2Push;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http2.DefaultHttp2Headers;
import io.netty.handler.codec.http2.Http2Connection;
import io.netty.handler.codec.http2.Http2DataFrame;
import io.netty.handler.codec.http2.Http2FrameCodec;
import io.netty.handler.codec.http2.Http2FrameStream;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.Http2HeadersFrame;
import io.netty.handler.codec.http2.Http2MultiplexCodec;
import io.netty.handler.codec.http2.Http2ResetFrame;
import io.netty.handler.codec.http2.Http2Stream;
import io.netty.handler.codec.http2.Http2StreamChannel;
import io.netty.handler.codec.http2.Http2StreamChannelBootstrap;
import io.netty.util.AttributeKey;
import io.netty.util.concurrent.EventExecutorGroup;
import io.netty.util.concurrent.Future;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.channels.ClosedChannelException;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.coroutines.CoroutineContext;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CompletableJob;
import kotlinx.coroutines.CopyableThrowable;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.SupervisorKt;
import kotlinx.coroutines.channels.ChannelResult;
import kotlinx.coroutines.channels.SendChannel;
import org.jetbrains.annotations.NotNull;

@ChannelHandler.Sharable
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u009c\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\u0003\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0010\b\u0001\u0018\u0000 O2\u00020\u00012\u00020\u0002:\u0002POB/\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\n\u001a\u00020\t\u0012\u0006\u0010\f\u001a\u00020\u000b\u00a2\u0006\u0004\b\r\u0010\u000eJ\u001f\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0011H\u0016\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u0017\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u000fH\u0016\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u0017\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u000fH\u0016\u00a2\u0006\u0004\b\u0018\u0010\u0017J\u001f\u0010\u001c\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u001b\u001a\u00020\u001aH\u0016\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u001f\u0010 \u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u001f\u001a\u00020\u001eH\u0002\u00a2\u0006\u0004\b \u0010!J\u001f\u0010&\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010#\u001a\u00020\"H\u0001\u00a2\u0006\u0004\b$\u0010%J\u001b\u0010)\u001a\u00020\u0013*\u00020'2\u0006\u0010(\u001a\u00020\u000bH\u0002\u00a2\u0006\u0004\b)\u0010*J#\u00101\u001a\u000200*\u00020+2\u0006\u0010-\u001a\u00020,2\u0006\u0010/\u001a\u00020.H\u0002\u00a2\u0006\u0004\b1\u00102J\u0018\u00105\u001a\u000204*\u0006\u0012\u0002\b\u000303H\u0082\u0010\u00a2\u0006\u0004\b5\u00106R\u0014\u0010\u0004\u001a\u00020\u00038\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0004\u00107R\u0014\u0010\u0006\u001a\u00020\u00058\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0006\u00108R\u0014\u0010\b\u001a\u00020\u00078\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\b\u00109R\u0014\u0010\n\u001a\u00020\t8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\n\u0010:R\u0014\u0010<\u001a\u00020;8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b<\u0010=R\u0014\u0010?\u001a\u00020>8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b?\u0010@R\u0016\u0010B\u001a\u00020A8\u0002@\u0002X\u0082.\u00a2\u0006\u0006\n\u0004\bB\u0010CR\u0014\u0010F\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bD\u0010ER\u001d\u0010K\u001a\u0004\u0018\u0001048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\bG\u0010H\u001a\u0004\bI\u0010JR\u0018\u0010N\u001a\u000204*\u00020+8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\bL\u0010M\u00a8\u0006Q"}, d2={"Lio/ktor/server/netty/http2/NettyHttp2Handler;", "Lio/netty/channel/ChannelInboundHandlerAdapter;", "Lkotlinx/coroutines/CoroutineScope;", "Lio/ktor/server/engine/EnginePipeline;", "enginePipeline", "Lio/ktor/server/application/Application;", "application", "Lio/netty/util/concurrent/EventExecutorGroup;", "callEventGroup", "Lkotlin/coroutines/CoroutineContext;", "userCoroutineContext", "", "runningLimit", "<init>", "(Lio/ktor/server/engine/EnginePipeline;Lio/ktor/server/application/Application;Lio/netty/util/concurrent/EventExecutorGroup;Lkotlin/coroutines/CoroutineContext;I)V", "Lio/netty/channel/ChannelHandlerContext;", "context", "", "message", "", "channelRead", "(Lio/netty/channel/ChannelHandlerContext;Ljava/lang/Object;)V", "channelActive", "(Lio/netty/channel/ChannelHandlerContext;)V", "channelReadComplete", "ctx", "", "cause", "exceptionCaught", "(Lio/netty/channel/ChannelHandlerContext;Ljava/lang/Throwable;)V", "Lio/netty/handler/codec/http2/Http2Headers;", "headers", "startHttp2", "(Lio/netty/channel/ChannelHandlerContext;Lio/netty/handler/codec/http2/Http2Headers;)V", "Lio/ktor/server/response/ResponsePushBuilder;", "builder", "startHttp2PushPromise$ktor_server_netty", "(Lio/netty/channel/ChannelHandlerContext;Lio/ktor/server/response/ResponsePushBuilder;)V", "startHttp2PushPromise", "Lio/netty/handler/codec/http2/Http2StreamChannel;", "streamId", "setId", "(Lio/netty/handler/codec/http2/Http2StreamChannel;I)V", "Lio/netty/handler/codec/http2/Http2FrameStream;", "Lio/netty/handler/codec/http2/Http2FrameCodec;", "codec", "Lio/netty/handler/codec/http2/Http2Stream;", "childStream", "", "setStreamAndProperty", "(Lio/netty/handler/codec/http2/Http2FrameStream;Lio/netty/handler/codec/http2/Http2FrameCodec;Lio/netty/handler/codec/http2/Http2Stream;)Z", "Ljava/lang/Class;", "Ljava/lang/reflect/Field;", "findIdField", "(Ljava/lang/Class;)Ljava/lang/reflect/Field;", "Lio/ktor/server/engine/EnginePipeline;", "Lio/ktor/server/application/Application;", "Lio/netty/util/concurrent/EventExecutorGroup;", "Lkotlin/coroutines/CoroutineContext;", "Lkotlinx/coroutines/CompletableJob;", "handlerJob", "Lkotlinx/coroutines/CompletableJob;", "Lio/ktor/server/netty/NettyHttpHandlerState;", "state", "Lio/ktor/server/netty/NettyHttpHandlerState;", "Lio/ktor/server/netty/cio/NettyHttpResponsePipeline;", "responseWriter", "Lio/ktor/server/netty/cio/NettyHttpResponsePipeline;", "getCoroutineContext", "()Lkotlin/coroutines/CoroutineContext;", "coroutineContext", "streamKeyField$delegate", "Lkotlin/Lazy;", "getStreamKeyField", "()Ljava/lang/reflect/Field;", "streamKeyField", "getIdField", "(Lio/netty/handler/codec/http2/Http2FrameStream;)Ljava/lang/reflect/Field;", "idField", "Companion", "Http2ClosedChannelException", "ktor-server-netty"})
@SourceDebugExtension(value={"SMAP\nNettyHttp2Handler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NettyHttp2Handler.kt\nio/ktor/server/netty/http2/NettyHttp2Handler\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,224:1\n1310#2,2:225\n1#3:227\n*S KotlinDebug\n*F\n+ 1 NettyHttp2Handler.kt\nio/ktor/server/netty/http2/NettyHttp2Handler\n*L\n172#1:225,2\n*E\n"})
public final class NettyHttp2Handler
extends ChannelInboundHandlerAdapter
implements CoroutineScope {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final EnginePipeline enginePipeline;
    @NotNull
    private final Application application;
    @NotNull
    private final EventExecutorGroup callEventGroup;
    @NotNull
    private final CoroutineContext userCoroutineContext;
    @NotNull
    private final CompletableJob handlerJob;
    @NotNull
    private final NettyHttpHandlerState state;
    private NettyHttpResponsePipeline responseWriter;
    @NotNull
    private final Lazy streamKeyField$delegate;
    private static final AttributeKey<NettyHttp2ApplicationCall> ApplicationCallKey = AttributeKey.newInstance("ktor.ApplicationCall");

    public NettyHttp2Handler(@NotNull EnginePipeline enginePipeline, @NotNull Application application2, @NotNull EventExecutorGroup callEventGroup, @NotNull CoroutineContext userCoroutineContext, int runningLimit) {
        Intrinsics.checkNotNullParameter(enginePipeline, "enginePipeline");
        Intrinsics.checkNotNullParameter(application2, "application");
        Intrinsics.checkNotNullParameter(callEventGroup, "callEventGroup");
        Intrinsics.checkNotNullParameter(userCoroutineContext, "userCoroutineContext");
        this.enginePipeline = enginePipeline;
        this.application = application2;
        this.callEventGroup = callEventGroup;
        this.userCoroutineContext = userCoroutineContext;
        this.handlerJob = SupervisorKt.SupervisorJob((Job)this.userCoroutineContext.get(Job.Key));
        this.state = new NettyHttpHandlerState(runningLimit);
        this.streamKeyField$delegate = LazyKt.lazy(NettyHttp2Handler::streamKeyField_delegate$lambda$6);
    }

    @Override
    @NotNull
    public CoroutineContext getCoroutineContext() {
        return this.handlerJob;
    }

    @Override
    public void channelRead(@NotNull ChannelHandlerContext context2, @NotNull Object message) {
        Intrinsics.checkNotNullParameter(context2, "context");
        Intrinsics.checkNotNullParameter(message, "message");
        Object object = message;
        if (object instanceof Http2HeadersFrame) {
            NettyHttpHandlerState.isChannelReadCompleted$FU$internal.compareAndSet(this.state, 1, 0);
            NettyHttpHandlerState.activeRequests$FU$internal.incrementAndGet(this.state);
            Http2Headers http2Headers = ((Http2HeadersFrame)message).headers();
            Intrinsics.checkNotNullExpressionValue(http2Headers, "headers(...)");
            this.startHttp2(context2, http2Headers);
        } else if (object instanceof Http2DataFrame) {
            CoroutineScope coroutineScope = NettyHttp2Handler.Companion.getApplicationCall(context2);
            if (coroutineScope != null && (coroutineScope = ((NettyHttp2ApplicationCall)coroutineScope).getRequest()) != null) {
                boolean bl;
                CoroutineScope coroutineScope2;
                CoroutineScope $this$channelRead_u24lambda_u240 = coroutineScope2 = coroutineScope;
                boolean bl2 = false;
                boolean eof = ((Http2DataFrame)message).isEndStream();
                ChannelResult.isSuccess-impl(((NettyHttp2ApplicationRequest)$this$channelRead_u24lambda_u240).getContentActor().trySend-JP2dKIU((Http2DataFrame)message));
                if (eof) {
                    SendChannel.DefaultImpls.close$default(((NettyHttp2ApplicationRequest)$this$channelRead_u24lambda_u240).getContentActor(), null, 1, null);
                    bl = NettyHttpHandlerState.isCurrentRequestFullyRead$FU$internal.compareAndSet(this.state, 0, 1);
                } else {
                    bl = NettyHttpHandlerState.isCurrentRequestFullyRead$FU$internal.compareAndSet(this.state, 1, 0);
                }
            } else {
                ((Http2DataFrame)message).release();
            }
        } else if (object instanceof Http2ResetFrame) {
            CoroutineScope coroutineScope = NettyHttp2Handler.Companion.getApplicationCall(context2);
            if (coroutineScope != null && (coroutineScope = ((NettyHttp2ApplicationCall)coroutineScope).getRequest()) != null) {
                CoroutineScope r = coroutineScope;
                boolean bl = false;
                Http2ClosedChannelException e = ((Http2ResetFrame)message).errorCode() == 0L ? null : new Http2ClosedChannelException(((Http2ResetFrame)message).errorCode());
                ((NettyHttp2ApplicationRequest)r).getContentActor().close(e);
            }
        } else {
            context2.fireChannelRead(message);
        }
    }

    @Override
    public void channelActive(@NotNull ChannelHandlerContext context2) {
        Intrinsics.checkNotNullParameter(context2, "context");
        this.responseWriter = new NettyHttpResponsePipeline(context2, this.state, this.getCoroutineContext());
        ChannelPipeline channelPipeline = context2.pipeline();
        if (channelPipeline != null) {
            ChannelPipeline channelPipeline2;
            ChannelPipeline $this$channelActive_u24lambda_u242 = channelPipeline2 = channelPipeline;
            boolean bl = false;
            ChannelHandler[] channelHandlerArray = new ChannelHandler[]{new NettyApplicationCallHandler(this.userCoroutineContext, this.enginePipeline)};
            $this$channelActive_u24lambda_u242.addLast(this.callEventGroup, channelHandlerArray);
        }
        context2.fireChannelActive();
    }

    @Override
    public void channelReadComplete(@NotNull ChannelHandlerContext context2) {
        Intrinsics.checkNotNullParameter(context2, "context");
        NettyHttpHandlerState.isChannelReadCompleted$FU$internal.compareAndSet(this.state, 0, 1);
        NettyHttpResponsePipeline nettyHttpResponsePipeline = this.responseWriter;
        if (nettyHttpResponsePipeline == null) {
            Intrinsics.throwUninitializedPropertyAccessException("responseWriter");
            nettyHttpResponsePipeline = null;
        }
        nettyHttpResponsePipeline.flushIfNeeded$ktor_server_netty();
        context2.fireChannelReadComplete();
    }

    @Override
    public void exceptionCaught(@NotNull ChannelHandlerContext ctx, @NotNull Throwable cause) {
        Intrinsics.checkNotNullParameter(ctx, "ctx");
        Intrinsics.checkNotNullParameter(cause, "cause");
        ctx.close();
    }

    private final void startHttp2(ChannelHandlerContext context2, Http2Headers headers2) {
        NettyHttp2ApplicationCall call = new NettyHttp2ApplicationCall(this.application, context2, headers2, this, this.handlerJob.plus(Dispatchers.getUnconfined()), this.userCoroutineContext);
        NettyHttp2Handler.Companion.setApplicationCall(context2, call);
        context2.fireChannelRead(call);
        NettyHttpResponsePipeline nettyHttpResponsePipeline = this.responseWriter;
        if (nettyHttpResponsePipeline == null) {
            Intrinsics.throwUninitializedPropertyAccessException("responseWriter");
            nettyHttpResponsePipeline = null;
        }
        nettyHttpResponsePipeline.processResponse$ktor_server_netty(call);
    }

    @UseHttp2Push
    public final void startHttp2PushPromise$ktor_server_netty(@NotNull ChannelHandlerContext context2, @NotNull ResponsePushBuilder builder) {
        DefaultHttp2Headers defaultHttp2Headers;
        Intrinsics.checkNotNullParameter(context2, "context");
        Intrinsics.checkNotNullParameter(builder, "builder");
        Channel channel2 = context2.channel();
        Intrinsics.checkNotNull(channel2, "null cannot be cast to non-null type io.netty.handler.codec.http2.Http2StreamChannel");
        Http2StreamChannel channel3 = (Http2StreamChannel)channel2;
        int streamId = channel3.stream().id();
        Http2MultiplexCodec http2MultiplexCodec = channel3.parent().pipeline().get(Http2MultiplexCodec.class);
        Intrinsics.checkNotNull(http2MultiplexCodec);
        Http2MultiplexCodec codec = http2MultiplexCodec;
        Http2Connection connection = codec.connection();
        if (!connection.remote().allowPushTo()) {
            return;
        }
        ChannelHandlerContext rootContext = channel3.parent().pipeline().lastContext();
        int promisedStreamId = connection.local().incrementAndGetNextStreamId();
        DefaultHttp2Headers $this$startHttp2PushPromise_u24lambda_u243 = defaultHttp2Headers = new DefaultHttp2Headers();
        boolean bl = false;
        Url url2 = builder.getUrl().build();
        $this$startHttp2PushPromise_u24lambda_u243.method(builder.getMethod().getValue());
        $this$startHttp2PushPromise_u24lambda_u243.authority(URLUtilsKt.getHostWithPort(url2));
        $this$startHttp2PushPromise_u24lambda_u243.scheme(url2.getProtocol().getName());
        $this$startHttp2PushPromise_u24lambda_u243.path(url2.getEncodedPathAndQuery());
        DefaultHttp2Headers headers2 = defaultHttp2Headers;
        Http2StreamChannelBootstrap bs = new Http2StreamChannelBootstrap(channel3.parent()).handler(this);
        Http2StreamChannel child = (Http2StreamChannel)bs.open().get();
        Intrinsics.checkNotNull(child);
        this.setId(child, promisedStreamId);
        ChannelPromise promise = rootContext.newPromise();
        Http2Stream childStream = connection.local().createStream(promisedStreamId, false);
        Http2FrameStream http2FrameStream = child.stream();
        Intrinsics.checkNotNullExpressionValue(http2FrameStream, "stream(...)");
        Http2FrameCodec http2FrameCodec = codec;
        Intrinsics.checkNotNull(childStream);
        if (!this.setStreamAndProperty(http2FrameStream, http2FrameCodec, childStream)) {
            childStream.close();
            child.close();
            return;
        }
        codec.encoder().frameWriter().writePushPromise(rootContext, streamId, promisedStreamId, headers2, 0, promise);
        if (promise.isSuccess()) {
            ChannelHandlerContext channelHandlerContext = child.pipeline().firstContext();
            Intrinsics.checkNotNullExpressionValue(channelHandlerContext, "firstContext(...)");
            this.startHttp2(channelHandlerContext, headers2);
        } else {
            promise.addListener(arg_0 -> NettyHttp2Handler.startHttp2PushPromise$lambda$4(this, child, headers2, arg_0));
        }
    }

    private final void setId(Http2StreamChannel $this$setId, int streamId) {
        Http2FrameStream http2FrameStream = $this$setId.stream();
        Intrinsics.checkNotNull(http2FrameStream);
        Http2FrameStream stream = http2FrameStream;
        this.getIdField(stream).setInt(stream, streamId);
    }

    private final Field getStreamKeyField() {
        Lazy lazy = this.streamKeyField$delegate;
        return (Field)lazy.getValue();
    }

    /*
     * WARNING - void declaration
     */
    private final boolean setStreamAndProperty(Http2FrameStream $this$setStreamAndProperty, Http2FrameCodec codec, Http2Stream childStream) {
        Object[] objectArray;
        Object v3;
        Http2Connection.PropertyKey streamKey;
        Object[] objectArray2;
        block5: {
            void $this$firstOrNull$iv;
            Field field = this.getStreamKeyField();
            objectArray2 = field != null ? field.get(codec) : null;
            Http2Connection.PropertyKey propertyKey = objectArray2 instanceof Http2Connection.PropertyKey ? (Http2Connection.PropertyKey)objectArray2 : null;
            if (propertyKey == null) {
                return false;
            }
            streamKey = propertyKey;
            Method[] methodArray = $this$setStreamAndProperty.getClass().getDeclaredMethods();
            Intrinsics.checkNotNullExpressionValue(methodArray, "getDeclaredMethods(...)");
            Object[] objectArray3 = methodArray;
            boolean $i$f$firstOrNull = false;
            for (void element$iv : $this$firstOrNull$iv) {
                Method it = (Method)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual(it.getName(), "setStreamAndProperty")) continue;
                v3 = element$iv;
                break block5;
            }
            v3 = null;
        }
        objectArray2 = v3;
        if (objectArray2 == null) {
            return false;
        }
        Object[] it = objectArray = objectArray2;
        boolean bl = false;
        it.setAccessible(true);
        Object[] function = objectArray;
        try {
            objectArray2 = new Object[]{streamKey, childStream};
            function.invoke((Object)$this$setStreamAndProperty, objectArray2);
        }
        catch (Throwable cause) {
            return false;
        }
        return true;
    }

    private final Field getIdField(Http2FrameStream $this$idField) {
        return this.findIdField($this$idField.getClass());
    }

    private final Field findIdField(Class<?> $this$findIdField) {
        NettyHttp2Handler nettyHttp2Handler = this;
        while (true) {
            Class<?> superclass;
            Field field;
            try {
                field = $this$findIdField.getDeclaredField("id");
            }
            catch (NoSuchFieldException t) {
                field = null;
            }
            Field idField = field;
            if (idField != null) {
                idField.setAccessible(true);
                return idField;
            }
            if ($this$findIdField.getSuperclass() == null) {
                throw new NoSuchFieldException("id field not found");
            }
            $this$findIdField = superclass;
        }
    }

    private static final void startHttp2PushPromise$lambda$4(NettyHttp2Handler this$0, Http2StreamChannel $child, DefaultHttp2Headers $headers, Future future) {
        future.get();
        ChannelHandlerContext channelHandlerContext = $child.pipeline().firstContext();
        Intrinsics.checkNotNullExpressionValue(channelHandlerContext, "firstContext(...)");
        this$0.startHttp2(channelHandlerContext, $headers);
    }

    private static final Field streamKeyField_delegate$lambda$6() {
        Field field;
        try {
            Field it = field = Http2FrameCodec.class.getDeclaredField("streamKey");
            boolean bl = false;
            it.setAccessible(true);
        }
        catch (Throwable cause) {
            field = null;
        }
        return field;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R8\u0010\u0007\u001a&\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005 \u0006*\u0012\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005\u0018\u00010\u00040\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0007\u0010\bR,\u0010\u000f\u001a\u0004\u0018\u00010\u0005*\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u00058B@BX\u0082\u000e\u00a2\u0006\f\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000e\u00a8\u0006\u0010"}, d2={"Lio/ktor/server/netty/http2/NettyHttp2Handler$Companion;", "", "<init>", "()V", "Lio/netty/util/AttributeKey;", "Lio/ktor/server/netty/http2/NettyHttp2ApplicationCall;", "kotlin.jvm.PlatformType", "ApplicationCallKey", "Lio/netty/util/AttributeKey;", "Lio/netty/channel/ChannelHandlerContext;", "newValue", "getApplicationCall", "(Lio/netty/channel/ChannelHandlerContext;)Lio/ktor/server/netty/http2/NettyHttp2ApplicationCall;", "setApplicationCall", "(Lio/netty/channel/ChannelHandlerContext;Lio/ktor/server/netty/http2/NettyHttp2ApplicationCall;)V", "applicationCall", "ktor-server-netty"})
    public static final class Companion {
        private Companion() {
        }

        private final NettyHttp2ApplicationCall getApplicationCall(ChannelHandlerContext $this$applicationCall) {
            return (NettyHttp2ApplicationCall)$this$applicationCall.channel().attr(ApplicationCallKey).get();
        }

        private final void setApplicationCall(ChannelHandlerContext $this$applicationCall, NettyHttp2ApplicationCall newValue) {
            $this$applicationCall.channel().attr(ApplicationCallKey).set(newValue);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\b\b\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u00012\b\u0012\u0004\u0012\u00020\u00000\u0002B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000f\u0010\u0007\u001a\u00020\u0000H\u0016\u00a2\u0006\u0004\b\u0007\u0010\bR\u0017\u0010\u0004\u001a\u00020\u00038\u0006\u00a2\u0006\f\n\u0004\b\u0004\u0010\t\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\u000f\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0010"}, d2={"Lio/ktor/server/netty/http2/NettyHttp2Handler$Http2ClosedChannelException;", "Ljava/nio/channels/ClosedChannelException;", "Lkotlinx/coroutines/CopyableThrowable;", "", "errorCode", "<init>", "(J)V", "createCopy", "()Lio/ktor/server/netty/http2/NettyHttp2Handler$Http2ClosedChannelException;", "J", "getErrorCode", "()J", "", "getMessage", "()Ljava/lang/String;", "message", "ktor-server-netty"})
    private static final class Http2ClosedChannelException
    extends ClosedChannelException
    implements CopyableThrowable<Http2ClosedChannelException> {
        private final long errorCode;

        public Http2ClosedChannelException(long errorCode) {
            this.errorCode = errorCode;
        }

        public final long getErrorCode() {
            return this.errorCode;
        }

        @Override
        @NotNull
        public String getMessage() {
            return "Got close frame with code " + this.errorCode;
        }

        @Override
        @NotNull
        public Http2ClosedChannelException createCopy() {
            Http2ClosedChannelException http2ClosedChannelException;
            Http2ClosedChannelException it = http2ClosedChannelException = new Http2ClosedChannelException(this.errorCode);
            boolean bl = false;
            it.initCause(this);
            return http2ClosedChannelException;
        }
    }
}

