/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.server.routing;

import io.ktor.http.Parameters;
import io.ktor.http.ParametersBuilder;
import io.ktor.http.ParametersKt;
import io.ktor.server.routing.IgnoreTrailingSlashKt;
import io.ktor.server.routing.RouteSelector;
import io.ktor.server.routing.RouteSelectorEvaluation;
import io.ktor.server.routing.RoutingResolveContext;
import io.ktor.util.PlatformUtils;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.text.MatchGroup;
import kotlin.text.MatchGroupCollection;
import kotlin.text.MatchNamedGroupCollection;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\b\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u000b\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\bH\u0096@\u00a2\u0006\u0004\b\u000b\u0010\fJ'\u0010\u0012\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u0010H\u0002\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u000f\u0010\u0014\u001a\u00020\u0010H\u0016\u00a2\u0006\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u0016\u00a8\u0006\u0018"}, d2={"Lio/ktor/server/routing/PathSegmentRegexRouteSelector;", "Lio/ktor/server/routing/RouteSelector;", "Lkotlin/text/Regex;", "regex", "<init>", "(Lkotlin/text/Regex;)V", "Lio/ktor/server/routing/RoutingResolveContext;", "context", "", "segmentIndex", "Lio/ktor/server/routing/RouteSelectorEvaluation;", "evaluate", "(Lio/ktor/server/routing/RoutingResolveContext;ILkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Lkotlin/text/MatchResult;", "result", "lastSlashPosition", "", "prefix", "countSegments", "(Lkotlin/text/MatchResult;ILjava/lang/String;)I", "toString", "()Ljava/lang/String;", "Lkotlin/text/Regex;", "Companion", "ktor-server-core"})
@SourceDebugExtension(value={"SMAP\nRegexRouting.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RegexRouting.kt\nio/ktor/server/routing/PathSegmentRegexRouteSelector\n+ 2 Parameters.kt\nio/ktor/http/Parameters$Companion\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 4 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,315:1\n31#2:316\n1321#3,2:317\n1104#4,3:319\n*S KotlinDebug\n*F\n+ 1 RegexRouting.kt\nio/ktor/server/routing/PathSegmentRegexRouteSelector\n*L\n283#1:316\n284#1:317,2\n299#1:319,3\n*E\n"})
public final class PathSegmentRegexRouteSelector
extends RouteSelector {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Regex regex;
    @NotNull
    private static final Regex GROUP_NAME_MATCHER = PlatformUtils.INSTANCE.getIS_JS() ? new Regex("(^|[^\\\\])\\(\\?<(\\p{L}[\\p{L}\\p{N}]*)>(.*?[^\\\\])?\\)") : new Regex("(^|[^\\\\])\\(\\?<(\\p{Alpha}\\p{Alnum}*)>(.*?[^\\\\])?\\)");

    public PathSegmentRegexRouteSelector(@NotNull Regex regex) {
        Intrinsics.checkNotNullParameter(regex, "regex");
        this.regex = regex;
    }

    @Override
    @Nullable
    public Object evaluate(@NotNull RoutingResolveContext context2, int segmentIndex, @NotNull Continuation<? super RouteSelectorEvaluation> $completion) {
        ParametersBuilder parametersBuilder;
        int n;
        String prefix = StringsKt.startsWith$default((CharSequence)this.regex.getPattern(), '/', false, 2, null) || StringsKt.startsWith$default(this.regex.getPattern(), "\\/", false, 2, null) ? "/" : "";
        String postfix = StringsKt.endsWith$default((CharSequence)this.regex.getPattern(), '/', false, 2, null) && IgnoreTrailingSlashKt.getIgnoreTrailingSlash(context2.getCall()) ? "/" : "";
        String pathSegments = CollectionsKt.joinToString$default(CollectionsKt.drop((Iterable)context2.getSegments(), segmentIndex), "/", prefix, postfix, 0, null, null, 56, null);
        MatchResult matchResult = Regex.find$default(this.regex, pathSegments, 0, 2, null);
        if (matchResult == null) {
            return RouteSelectorEvaluation.Companion.getFailed();
        }
        MatchResult result2 = matchResult;
        int consumedLength = result2.getValue().length();
        boolean bl = false;
        if (pathSegments.length() == consumedLength) {
            n = context2.getSegments().size() - segmentIndex;
        } else if (pathSegments.charAt(consumedLength) == '/') {
            n = this.countSegments(result2, consumedLength, prefix);
        } else if (consumedLength >= 1 && pathSegments.charAt(consumedLength - 1) == '/') {
            n = this.countSegments(result2, consumedLength - 1, prefix);
        } else {
            return RouteSelectorEvaluation.Companion.getFailed();
        }
        int segmentIncrement = n;
        MatchGroupCollection matchGroupCollection = result2.getGroups();
        Intrinsics.checkNotNull(matchGroupCollection, "null cannot be cast to non-null type kotlin.text.MatchNamedGroupCollection");
        MatchNamedGroupCollection groups2 = (MatchNamedGroupCollection)matchGroupCollection;
        Parameters.Companion this_$iv = Parameters.Companion;
        boolean $i$f$build = false;
        ParametersBuilder $this$evaluate_u24lambda_u242 = parametersBuilder = ParametersKt.ParametersBuilder$default(0, 1, null);
        boolean bl2 = false;
        Sequence $this$forEach$iv = Regex.findAll$default(GROUP_NAME_MATCHER, this.regex.getPattern(), 0, 2, null);
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv.iterator();
        while (iterator2.hasNext()) {
            Object element$iv = iterator2.next();
            MatchResult matchResult2 = (MatchResult)element$iv;
            boolean bl3 = false;
            String name = matchResult2.getDestructured().getMatch().getGroupValues().get(2);
            Object object = groups2.get(name);
            if (object == null || (object = ((MatchGroup)object).getValue()) == null) {
                object = "";
            }
            Object value = object;
            $this$evaluate_u24lambda_u242.append(name, (String)value);
        }
        Parameters parameters = parametersBuilder.build();
        return new RouteSelectorEvaluation.Success(1.0, parameters, segmentIncrement);
    }

    private final int countSegments(MatchResult result2, int lastSlashPosition, String prefix) {
        String string2 = result2.getValue().substring(0, lastSlashPosition);
        Intrinsics.checkNotNullExpressionValue(string2, "substring(...)");
        String segments = string2;
        CharSequence $this$count$iv = segments;
        boolean $i$f$count = false;
        int count$iv = 0;
        for (int j = 0; j < $this$count$iv.length(); ++j) {
            char element$iv;
            char it = element$iv = $this$count$iv.charAt(j);
            boolean bl = false;
            if (!(it == '/')) continue;
            ++count$iv;
        }
        int count2 = count$iv;
        return Intrinsics.areEqual(prefix, "/") ? count2 : count2 + 1;
    }

    @NotNull
    public String toString() {
        return "Regex(" + this.regex.getPattern() + ')';
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lio/ktor/server/routing/PathSegmentRegexRouteSelector$Companion;", "", "<init>", "()V", "Lkotlin/text/Regex;", "GROUP_NAME_MATCHER", "Lkotlin/text/Regex;", "ktor-server-core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

