/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.util;

import java.io.File;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0019\u0010\u0002\u001a\u00020\u0000*\u00020\u00002\u0006\u0010\u0001\u001a\u00020\u0000\u00a2\u0006\u0004\b\u0002\u0010\u0003\u001a\u0011\u0010\u0004\u001a\u00020\u0000*\u00020\u0000\u00a2\u0006\u0004\b\u0004\u0010\u0005\u001a\u0013\u0010\u0006\u001a\u00020\u0000*\u00020\u0000H\u0002\u00a2\u0006\u0004\b\u0006\u0010\u0005\u001a\u0019\u0010\u0002\u001a\u00020\u0007*\u00020\u00072\u0006\u0010\u0001\u001a\u00020\u0000\u00a2\u0006\u0004\b\u0002\u0010\b\u00a8\u0006\t"}, d2={"Ljava/nio/file/Path;", "relativePath", "combineSafe", "(Ljava/nio/file/Path;Ljava/nio/file/Path;)Ljava/nio/file/Path;", "normalizeAndRelativize", "(Ljava/nio/file/Path;)Ljava/nio/file/Path;", "dropLeadingTopDirs", "Ljava/io/File;", "(Ljava/io/File;Ljava/nio/file/Path;)Ljava/io/File;", "ktor-utils"})
@SourceDebugExtension(value={"SMAP\nNioPath.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NioPath.kt\nio/ktor/util/NioPathKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,60:1\n1#2:61\n346#3,8:62\n*S KotlinDebug\n*F\n+ 1 NioPath.kt\nio/ktor/util/NioPathKt\n*L\n40#1:62,8\n*E\n"})
public final class NioPathKt {
    @NotNull
    public static final Path combineSafe(@NotNull Path $this$combineSafe, @NotNull Path relativePath) {
        Intrinsics.checkNotNullParameter($this$combineSafe, "<this>");
        Intrinsics.checkNotNullParameter(relativePath, "relativePath");
        Path normalized = NioPathKt.normalizeAndRelativize(relativePath);
        if (normalized.startsWith("..")) {
            throw new InvalidPathException(((Object)relativePath).toString(), "Relative path " + relativePath + " beginning with .. is invalid");
        }
        if (!(!normalized.isAbsolute())) {
            boolean bl = false;
            String string2 = "Bad relative path " + relativePath;
            throw new IllegalStateException(string2.toString());
        }
        if ($this$combineSafe.getNameCount() == 0) {
            return normalized;
        }
        Path path = $this$combineSafe.resolve(normalized);
        Intrinsics.checkNotNullExpressionValue(path, "resolve(...)");
        return path;
    }

    @NotNull
    public static final Path normalizeAndRelativize(@NotNull Path $this$normalizeAndRelativize) {
        Intrinsics.checkNotNullParameter($this$normalizeAndRelativize, "<this>");
        Path path = $this$normalizeAndRelativize.getRoot();
        if (path == null || (path = path.relativize($this$normalizeAndRelativize)) == null || (path = path.normalize()) == null || (path = NioPathKt.dropLeadingTopDirs(path)) == null) {
            Path path2 = $this$normalizeAndRelativize.normalize();
            Intrinsics.checkNotNullExpressionValue(path2, "normalize(...)");
            path = NioPathKt.dropLeadingTopDirs(path2);
        }
        return path;
    }

    private static final Path dropLeadingTopDirs(Path $this$dropLeadingTopDirs) {
        int startIndex;
        block4: {
            int n;
            Iterable $this$indexOfFirst$iv = $this$dropLeadingTopDirs;
            boolean $i$f$indexOfFirst = false;
            int index$iv = 0;
            for (Object item$iv : $this$indexOfFirst$iv) {
                if (index$iv < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                Path it = (Path)item$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual(((Object)it).toString(), "..")) {
                    n = index$iv;
                    break block4;
                }
                ++index$iv;
            }
            n = startIndex = -1;
        }
        if (startIndex <= 0) {
            return $this$dropLeadingTopDirs;
        }
        Path path = $this$dropLeadingTopDirs.subpath(startIndex, $this$dropLeadingTopDirs.getNameCount());
        Intrinsics.checkNotNullExpressionValue(path, "subpath(...)");
        return path;
    }

    @NotNull
    public static final File combineSafe(@NotNull File $this$combineSafe, @NotNull Path relativePath) {
        Intrinsics.checkNotNullParameter($this$combineSafe, "<this>");
        Intrinsics.checkNotNullParameter(relativePath, "relativePath");
        Path normalized = NioPathKt.normalizeAndRelativize(relativePath);
        if (normalized.startsWith("..")) {
            throw new InvalidPathException(((Object)relativePath).toString(), "Relative path " + relativePath + " beginning with .. is invalid");
        }
        if (!(!normalized.isAbsolute())) {
            boolean bl = false;
            String string2 = "Bad relative path " + relativePath;
            throw new IllegalStateException(string2.toString());
        }
        return new File($this$combineSafe, ((Object)normalized).toString());
    }
}

