/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util.concurrent;

import io.netty.util.concurrent.FastThreadLocal;
import io.netty.util.concurrent.FastThreadLocalRunnable;
import io.netty.util.internal.InternalThreadLocalMap;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicReference;

public class FastThreadLocalThread
extends Thread {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(FastThreadLocalThread.class);
    private static final AtomicReference<long[]> fallbackThreads = new AtomicReference<Object>(null);
    private final boolean cleanupFastThreadLocals;
    private InternalThreadLocalMap threadLocalMap;

    public FastThreadLocalThread() {
        this.cleanupFastThreadLocals = false;
    }

    public FastThreadLocalThread(Runnable target) {
        super(FastThreadLocalRunnable.wrap(target));
        this.cleanupFastThreadLocals = true;
    }

    public FastThreadLocalThread(ThreadGroup group, Runnable target) {
        super(group, FastThreadLocalRunnable.wrap(target));
        this.cleanupFastThreadLocals = true;
    }

    public FastThreadLocalThread(String name) {
        super(name);
        this.cleanupFastThreadLocals = false;
    }

    public FastThreadLocalThread(ThreadGroup group, String name) {
        super(group, name);
        this.cleanupFastThreadLocals = false;
    }

    public FastThreadLocalThread(Runnable target, String name) {
        super(FastThreadLocalRunnable.wrap(target), name);
        this.cleanupFastThreadLocals = true;
    }

    public FastThreadLocalThread(ThreadGroup group, Runnable target, String name) {
        super(group, FastThreadLocalRunnable.wrap(target), name);
        this.cleanupFastThreadLocals = true;
    }

    public FastThreadLocalThread(ThreadGroup group, Runnable target, String name, long stackSize) {
        super(group, FastThreadLocalRunnable.wrap(target), name, stackSize);
        this.cleanupFastThreadLocals = true;
    }

    public final InternalThreadLocalMap threadLocalMap() {
        if (this != Thread.currentThread() && logger.isWarnEnabled()) {
            logger.warn(new RuntimeException("It's not thread-safe to get 'threadLocalMap' which doesn't belong to the caller thread"));
        }
        return this.threadLocalMap;
    }

    public final void setThreadLocalMap(InternalThreadLocalMap threadLocalMap) {
        if (this != Thread.currentThread() && logger.isWarnEnabled()) {
            logger.warn(new RuntimeException("It's not thread-safe to set 'threadLocalMap' which doesn't belong to the caller thread"));
        }
        this.threadLocalMap = threadLocalMap;
    }

    @Deprecated
    public boolean willCleanupFastThreadLocals() {
        return this.cleanupFastThreadLocals;
    }

    @Deprecated
    public static boolean willCleanupFastThreadLocals(Thread thread2) {
        return thread2 instanceof FastThreadLocalThread && ((FastThreadLocalThread)thread2).willCleanupFastThreadLocals();
    }

    public static boolean currentThreadWillCleanupFastThreadLocals() {
        Thread currentThread = FastThreadLocalThread.currentThread();
        if (currentThread instanceof FastThreadLocalThread) {
            return ((FastThreadLocalThread)currentThread).willCleanupFastThreadLocals();
        }
        return FastThreadLocalThread.isFastThreadLocalVirtualThread();
    }

    public static boolean currentThreadHasFastThreadLocal() {
        return FastThreadLocalThread.currentThread() instanceof FastThreadLocalThread || FastThreadLocalThread.isFastThreadLocalVirtualThread();
    }

    private static boolean isFastThreadLocalVirtualThread() {
        long[] arr = fallbackThreads.get();
        if (arr == null) {
            return false;
        }
        return Arrays.binarySearch(arr, Thread.currentThread().getId()) >= 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void runWithFastThreadLocal(Runnable runnable2) {
        Thread current = FastThreadLocalThread.currentThread();
        if (current instanceof FastThreadLocalThread) {
            throw new IllegalStateException("Caller is a real FastThreadLocalThread");
        }
        long id = current.getId();
        fallbackThreads.updateAndGet(arr -> {
            if (arr == null) {
                return new long[]{id};
            }
            int index2 = Arrays.binarySearch(arr, id);
            if (index2 >= 0) {
                throw new IllegalStateException("Reentrant call to run()");
            }
            long[] next2 = new long[((long[])arr).length + 1];
            System.arraycopy(arr, 0, next2, 0, index2 ^= 0xFFFFFFFF);
            next2[index2] = id;
            System.arraycopy(arr, index2, next2, index2 + 1, ((long[])arr).length - index2);
            return next2;
        });
        try {
            runnable2.run();
        }
        finally {
            fallbackThreads.getAndUpdate(arr -> {
                if (arr == null || ((long[])arr).length == 1 && arr[0] == id) {
                    return null;
                }
                int index2 = Arrays.binarySearch(arr, id);
                if (index2 < 0) {
                    return arr;
                }
                long[] next2 = new long[((long[])arr).length - 1];
                System.arraycopy(arr, 0, next2, 0, index2);
                System.arraycopy(arr, index2 + 1, next2, index2, ((long[])arr).length - index2 - 1);
                return next2;
            });
            FastThreadLocal.removeAll();
        }
    }

    public boolean permitBlockingCalls() {
        return false;
    }
}

