/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.skia;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.skia.BlendMode;
import org.jetbrains.skia.ColorFilterKt;
import org.jetbrains.skia.ColorMatrix;
import org.jetbrains.skia.InversionMode;
import org.jetbrains.skia.impl.InteropScope;
import org.jetbrains.skia.impl.Library;
import org.jetbrains.skia.impl.NativeKt;
import org.jetbrains.skia.impl.Native_jvmKt;
import org.jetbrains.skia.impl.RefCnt;
import org.jetbrains.skia.impl.Stats;
import org.jetbrains.skia.impl.theScope;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u0000 \t2\u00020\u0001:\u0001\tB\u0013\b\u0010\u0012\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u00a2\u0006\u0002\u0010\u0005B\u001b\b\u0010\u0012\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\b\u00a8\u0006\n"}, d2={"Lorg/jetbrains/skia/ColorFilter;", "Lorg/jetbrains/skia/impl/RefCnt;", "ptr", "", "Lorg/jetbrains/skia/impl/NativePointer;", "(J)V", "allowClose", "", "(JZ)V", "Companion", "skiko"})
public final class ColorFilter
extends RefCnt {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final ColorFilter sRGBToLinearGamma;
    @NotNull
    private static final ColorFilter luma;

    public ColorFilter(long ptr) {
        super(ptr);
    }

    public ColorFilter(long ptr, boolean allowClose) {
        super(ptr, allowClose);
    }

    static {
        Library.Companion.staticLoad();
        sRGBToLinearGamma = new ColorFilter(ColorFilterKt.access$_nGetSRGBToLinearGamma(), false);
        luma = new ColorFilter(ColorFilterKt.access$_nGetLuma(), false);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\n\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\u001a\u0010\u000e\u001a\u00020\u00042\b\u0010\u000f\u001a\u0004\u0018\u00010\u00042\b\u0010\u0010\u001a\u0004\u0018\u00010\u0004J\u000e\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u0013J\u001e\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\f\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019J\"\u0010\u001a\u001a\u00020\u00042\b\u0010\u001b\u001a\u0004\u0018\u00010\u00042\b\u0010\u001c\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u001d\u001a\u00020\u0019J\u0016\u0010\u001e\u001a\u00020\u00042\u0006\u0010\u001f\u001a\u00020\u000b2\u0006\u0010 \u001a\u00020\u000bJ\u000e\u0010!\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u0013J\u000e\u0010\"\u001a\u00020\u00042\u0006\u0010#\u001a\u00020$J\u000e\u0010%\u001a\u00020\u00042\u0006\u0010&\u001a\u00020'J.\u0010(\u001a\u00020\u00042\b\u0010)\u001a\u0004\u0018\u00010'2\b\u0010*\u001a\u0004\u0018\u00010'2\b\u0010+\u001a\u0004\u0018\u00010'2\b\u0010,\u001a\u0004\u0018\u00010'R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006\u00a8\u0006-"}, d2={"Lorg/jetbrains/skia/ColorFilter$Companion;", "", "()V", "luma", "Lorg/jetbrains/skia/ColorFilter;", "getLuma", "()Lorg/jetbrains/skia/ColorFilter;", "sRGBToLinearGamma", "getSRGBToLinearGamma", "makeBlend", "color", "", "mode", "Lorg/jetbrains/skia/BlendMode;", "makeComposed", "outer", "inner", "makeHSLAMatrix", "matrix", "Lorg/jetbrains/skia/ColorMatrix;", "makeHighContrast", "grayscale", "", "Lorg/jetbrains/skia/InversionMode;", "contrast", "", "makeLerp", "dst", "src", "t", "makeLighting", "colorMul", "colorAdd", "makeMatrix", "makeOverdraw", "colors", "", "makeTable", "table", "", "makeTableARGB", "a", "r", "g", "b", "skiko"})
    @SourceDebugExtension(value={"SMAP\nColorFilter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ColorFilter.kt\norg/jetbrains/skia/ColorFilter$Companion\n+ 2 Native.jvm.kt\norg/jetbrains/skia/impl/Native_jvmKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,168:1\n56#2:169\n56#2:170\n56#2:172\n56#2:173\n1#3:171\n*S KotlinDebug\n*F\n+ 1 ColorFilter.kt\norg/jetbrains/skia/ColorFilter$Companion\n*L\n31#1:169\n40#1:170\n72#1:172\n83#1:173\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        public final ColorFilter makeComposed(@Nullable ColorFilter outer, @Nullable ColorFilter inner) {
            ColorFilter colorFilter;
            try {
                Stats.INSTANCE.onNativeCall();
                colorFilter = new ColorFilter(ColorFilterKt.access$_nMakeComposed(NativeKt.getPtr(outer), NativeKt.getPtr(inner)));
            }
            finally {
                Native_jvmKt.reachabilityBarrier(outer);
                Native_jvmKt.reachabilityBarrier(inner);
            }
            return colorFilter;
        }

        @NotNull
        public final ColorFilter makeBlend(int color, @NotNull BlendMode mode) {
            Intrinsics.checkNotNullParameter((Object)mode, "mode");
            Stats.INSTANCE.onNativeCall();
            return new ColorFilter(ColorFilterKt.access$_nMakeBlend(color, mode.ordinal()));
        }

        @NotNull
        public final ColorFilter makeMatrix(@NotNull ColorMatrix matrix) {
            Intrinsics.checkNotNullParameter(matrix, "matrix");
            Stats.INSTANCE.onNativeCall();
            boolean $i$f$interopScope = false;
            InteropScope $this$makeMatrix_u24lambda_u240 = theScope.INSTANCE;
            boolean bl = false;
            long l = ColorFilterKt.access$_nMakeMatrix($this$makeMatrix_u24lambda_u240.toInterop(matrix.getMat()));
            return new ColorFilter(l);
        }

        @NotNull
        public final ColorFilter makeHSLAMatrix(@NotNull ColorMatrix matrix) {
            Intrinsics.checkNotNullParameter(matrix, "matrix");
            Stats.INSTANCE.onNativeCall();
            boolean $i$f$interopScope = false;
            InteropScope $this$makeHSLAMatrix_u24lambda_u241 = theScope.INSTANCE;
            boolean bl = false;
            long l = ColorFilterKt.access$_nMakeHSLAMatrix($this$makeHSLAMatrix_u24lambda_u241.toInterop(matrix.getMat()));
            return new ColorFilter(l);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        public final ColorFilter makeLerp(@Nullable ColorFilter dst, @Nullable ColorFilter src, float t) {
            ColorFilter colorFilter;
            try {
                colorFilter = new ColorFilter(ColorFilterKt.access$_nMakeLerp(t, NativeKt.getPtr(dst), NativeKt.getPtr(src)));
            }
            finally {
                Native_jvmKt.reachabilityBarrier(dst);
                Native_jvmKt.reachabilityBarrier(src);
            }
            return colorFilter;
        }

        @NotNull
        public final ColorFilter makeLighting(int colorMul, int colorAdd) {
            return new ColorFilter(ColorFilterKt.access$_nMakeLighting(colorMul, colorAdd));
        }

        @NotNull
        public final ColorFilter makeHighContrast(boolean grayscale, @NotNull InversionMode mode, float contrast) {
            Intrinsics.checkNotNullParameter((Object)mode, "mode");
            return new ColorFilter(ColorFilterKt.access$_nMakeHighContrast(grayscale, mode.ordinal(), contrast));
        }

        @NotNull
        public final ColorFilter makeTable(@NotNull byte[] table2) {
            Intrinsics.checkNotNullParameter(table2, "table");
            if (!(table2.length == 256)) {
                boolean $i$a$-require-ColorFilter$Companion$makeTable$22 = false;
                String $i$a$-require-ColorFilter$Companion$makeTable$22 = "Expected 256 elements, got " + table2.length;
                throw new IllegalArgumentException($i$a$-require-ColorFilter$Companion$makeTable$22.toString());
            }
            boolean $i$f$interopScope = false;
            InteropScope $this$makeTable_u24lambda_u243 = theScope.INSTANCE;
            boolean bl = false;
            long l = ColorFilterKt.access$_nMakeTable($this$makeTable_u24lambda_u243.toInterop(table2));
            return new ColorFilter(l);
        }

        @NotNull
        public final ColorFilter makeTableARGB(@Nullable byte[] a2, @Nullable byte[] r, @Nullable byte[] g, @Nullable byte[] b2) {
            if (!(a2 == null || a2.length == 256)) {
                boolean $i$a$-require-ColorFilter$Companion$makeTableARGB$52 = false;
                StringBuilder stringBuilder = new StringBuilder().append("Expected 256 elements in a[], got ");
                Intrinsics.checkNotNull(a2);
                String $i$a$-require-ColorFilter$Companion$makeTableARGB$52 = stringBuilder.append(a2.length).toString();
                throw new IllegalArgumentException($i$a$-require-ColorFilter$Companion$makeTableARGB$52.toString());
            }
            if (!(r == null || r.length == 256)) {
                boolean $i$a$-require-ColorFilter$Companion$makeTableARGB$62 = false;
                StringBuilder stringBuilder = new StringBuilder().append("Expected 256 elements in r[], got ");
                Intrinsics.checkNotNull(r);
                String $i$a$-require-ColorFilter$Companion$makeTableARGB$62 = stringBuilder.append(r.length).toString();
                throw new IllegalArgumentException($i$a$-require-ColorFilter$Companion$makeTableARGB$62.toString());
            }
            if (!(g == null || g.length == 256)) {
                boolean $i$a$-require-ColorFilter$Companion$makeTableARGB$72 = false;
                StringBuilder stringBuilder = new StringBuilder().append("Expected 256 elements in g[], got ");
                Intrinsics.checkNotNull(g);
                String $i$a$-require-ColorFilter$Companion$makeTableARGB$72 = stringBuilder.append(g.length).toString();
                throw new IllegalArgumentException($i$a$-require-ColorFilter$Companion$makeTableARGB$72.toString());
            }
            if (!(b2 == null || b2.length == 256)) {
                boolean $i$a$-require-ColorFilter$Companion$makeTableARGB$82 = false;
                StringBuilder stringBuilder = new StringBuilder().append("Expected 256 elements in b[], got ");
                Intrinsics.checkNotNull(b2);
                String $i$a$-require-ColorFilter$Companion$makeTableARGB$82 = stringBuilder.append(b2.length).toString();
                throw new IllegalArgumentException($i$a$-require-ColorFilter$Companion$makeTableARGB$82.toString());
            }
            boolean $i$f$interopScope = false;
            InteropScope $this$makeTableARGB_u24lambda_u248 = theScope.INSTANCE;
            boolean bl = false;
            return new ColorFilter(ColorFilterKt.access$_nMakeTableARGB($this$makeTableARGB_u24lambda_u248.toInterop(a2), $this$makeTableARGB_u24lambda_u248.toInterop(r), $this$makeTableARGB_u24lambda_u248.toInterop(g), $this$makeTableARGB_u24lambda_u248.toInterop(b2)));
        }

        @NotNull
        public final ColorFilter makeOverdraw(@NotNull int[] colors) {
            Intrinsics.checkNotNullParameter(colors, "colors");
            if (!(colors.length == 6)) {
                boolean bl = false;
                String string2 = "Expected 6 elements, got " + colors.length;
                throw new IllegalArgumentException(string2.toString());
            }
            return new ColorFilter(ColorFilterKt.access$_nMakeOverdraw(colors[0], colors[1], colors[2], colors[3], colors[4], colors[5]));
        }

        @NotNull
        public final ColorFilter getSRGBToLinearGamma() {
            return sRGBToLinearGamma;
        }

        @NotNull
        public final ColorFilter getLuma() {
            return luma;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

