/*
 * Decompiled with CFR 0.152.
 */
package org.jsoup.parser;

import java.io.Reader;
import java.io.StringReader;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;
import org.jsoup.helper.Validate;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.parser.HtmlTreeBuilder;
import org.jsoup.parser.ParseErrorList;
import org.jsoup.parser.ParseSettings;
import org.jsoup.parser.TagSet;
import org.jsoup.parser.Tokeniser;
import org.jsoup.parser.TreeBuilder;
import org.jsoup.parser.XmlTreeBuilder;
import org.jspecify.annotations.Nullable;

public class Parser
implements Cloneable {
    public static final String NamespaceHtml = "http://www.w3.org/1999/xhtml";
    public static final String NamespaceXml = "http://www.w3.org/XML/1998/namespace";
    public static final String NamespaceMathml = "http://www.w3.org/1998/Math/MathML";
    public static final String NamespaceSvg = "http://www.w3.org/2000/svg";
    private final TreeBuilder treeBuilder;
    private ParseErrorList errors;
    private ParseSettings settings;
    private boolean trackPosition = false;
    private @Nullable TagSet tagSet;
    private final ReentrantLock lock = new ReentrantLock();

    public Parser(TreeBuilder treeBuilder) {
        this.treeBuilder = treeBuilder;
        this.settings = treeBuilder.defaultSettings();
        this.errors = ParseErrorList.noTracking();
    }

    public Parser newInstance() {
        return new Parser(this);
    }

    public Parser clone() {
        return new Parser(this);
    }

    private Parser(Parser copy2) {
        this.treeBuilder = copy2.treeBuilder.newInstance();
        this.errors = new ParseErrorList(copy2.errors);
        this.settings = new ParseSettings(copy2.settings);
        this.trackPosition = copy2.trackPosition;
    }

    public Document parseInput(String html2, String baseUri) {
        return this.parseInput(new StringReader(html2), baseUri);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Document parseInput(Reader inputHtml, String baseUri) {
        try {
            this.lock.lock();
            Document document = this.treeBuilder.parse(inputHtml, baseUri, this);
            return document;
        }
        finally {
            this.lock.unlock();
        }
    }

    public List<Node> parseFragmentInput(String fragment, @Nullable Element context2, String baseUri) {
        return this.parseFragmentInput(new StringReader(fragment), context2, baseUri);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Node> parseFragmentInput(Reader fragment, @Nullable Element context2, String baseUri) {
        try {
            this.lock.lock();
            List<Node> list2 = this.treeBuilder.parseFragment(fragment, context2, baseUri, this);
            return list2;
        }
        finally {
            this.lock.unlock();
        }
    }

    public TreeBuilder getTreeBuilder() {
        return this.treeBuilder;
    }

    public boolean isTrackErrors() {
        return this.errors.getMaxSize() > 0;
    }

    public Parser setTrackErrors(int maxErrors) {
        this.errors = maxErrors > 0 ? ParseErrorList.tracking(maxErrors) : ParseErrorList.noTracking();
        return this;
    }

    public ParseErrorList getErrors() {
        return this.errors;
    }

    public boolean isTrackPosition() {
        return this.trackPosition;
    }

    public Parser setTrackPosition(boolean trackPosition) {
        this.trackPosition = trackPosition;
        return this;
    }

    public Parser settings(ParseSettings settings) {
        this.settings = settings;
        return this;
    }

    public ParseSettings settings() {
        return this.settings;
    }

    public Parser tagSet(TagSet tagSet) {
        Validate.notNull(tagSet);
        this.tagSet = new TagSet(tagSet);
        return this;
    }

    public TagSet tagSet() {
        if (this.tagSet == null) {
            this.tagSet = this.treeBuilder.defaultTagSet();
        }
        return this.tagSet;
    }

    public String defaultNamespace() {
        return this.getTreeBuilder().defaultNamespace();
    }

    public static Document parse(String html2, String baseUri) {
        HtmlTreeBuilder treeBuilder = new HtmlTreeBuilder();
        return treeBuilder.parse(new StringReader(html2), baseUri, new Parser(treeBuilder));
    }

    public static List<Node> parseFragment(String fragmentHtml, Element context2, String baseUri) {
        HtmlTreeBuilder treeBuilder = new HtmlTreeBuilder();
        return treeBuilder.parseFragment(new StringReader(fragmentHtml), context2, baseUri, new Parser(treeBuilder));
    }

    public static List<Node> parseFragment(String fragmentHtml, Element context2, String baseUri, ParseErrorList errorList) {
        HtmlTreeBuilder treeBuilder = new HtmlTreeBuilder();
        Parser parser = new Parser(treeBuilder);
        parser.errors = errorList;
        return treeBuilder.parseFragment(new StringReader(fragmentHtml), context2, baseUri, parser);
    }

    public static List<Node> parseXmlFragment(String fragmentXml, String baseUri) {
        XmlTreeBuilder treeBuilder = new XmlTreeBuilder();
        return treeBuilder.parseFragment(new StringReader(fragmentXml), null, baseUri, new Parser(treeBuilder));
    }

    public static Document parseBodyFragment(String bodyHtml, String baseUri) {
        Document doc = Document.createShell(baseUri);
        Element body2 = doc.body();
        List<Node> nodeList = Parser.parseFragment(bodyHtml, body2, baseUri);
        Node[] nodes = nodeList.toArray(new Node[0]);
        for (int i2 = nodes.length - 1; i2 > 0; --i2) {
            nodes[i2].remove();
        }
        for (Node node2 : nodes) {
            body2.appendChild(node2);
        }
        return doc;
    }

    public static String unescapeEntities(String string2, boolean inAttribute) {
        Parser parser = Parser.htmlParser();
        parser.treeBuilder.initialiseParse(new StringReader(string2), "", parser);
        Tokeniser tokeniser = new Tokeniser(parser.treeBuilder);
        return tokeniser.unescapeEntities(inAttribute);
    }

    public static Parser htmlParser() {
        return new Parser(new HtmlTreeBuilder());
    }

    public static Parser xmlParser() {
        return new Parser(new XmlTreeBuilder());
    }
}

