/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.foundation.text.input;

import androidx.compose.foundation.ExperimentalFoundationApi;
import androidx.compose.foundation.internal.InlineClassHelperKt;
import androidx.compose.foundation.text.input.TextFieldBufferKt;
import androidx.compose.foundation.text.input.TextFieldCharSequence;
import androidx.compose.foundation.text.input.TextHighlightType;
import androidx.compose.foundation.text.input.internal.ChangeTracker;
import androidx.compose.foundation.text.input.internal.OffsetMappingCalculator;
import androidx.compose.foundation.text.input.internal.PartialGapBuffer;
import androidx.compose.runtime.collection.MutableVector;
import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.ui.text.AnnotatedString;
import androidx.compose.ui.text.TextRange;
import androidx.compose.ui.text.TextRangeKt;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0092\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\r\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0010\f\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0010\b\u0007\u0018\u00002\u00060\u0001j\u0002`\u0002:\u0001sB3\b\u0000\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0004\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\r\u0010;\u001a\u00020'H\u0000\u00a2\u0006\u0002\b<J\r\u0010=\u001a\u00020>H\u0000\u00a2\u0006\u0002\b?J9\u0010@\u001a\u00020>2\u0006\u0010A\u001a\u00020\u00152\u0006\u0010B\u001a\u00020\u00152\u001a\b\u0002\u0010C\u001a\u0014\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020706j\u0002`E\u0018\u00010DH\u0000\u00a2\u0006\u0002\bFJ'\u0010L\u001a\u00020>2\u0006\u0010M\u001a\u00020H2\u0006\u0010A\u001a\u00020\u00152\u0006\u0010B\u001a\u00020\u0015H\u0000\u00a2\u0006\u0004\bN\u0010OJ\r\u0010P\u001a\u00020>H\u0000\u00a2\u0006\u0002\bQJ\u001e\u0010R\u001a\u00020>2\u0006\u0010A\u001a\u00020\u00152\u0006\u0010B\u001a\u00020\u00152\u0006\u0010S\u001a\u00020\u0019J9\u0010R\u001a\u00020>2\u0006\u0010A\u001a\u00020\u00152\u0006\u0010B\u001a\u00020\u00152\u0006\u0010S\u001a\u00020\u00192\b\b\u0002\u0010T\u001a\u00020\u00152\b\b\u0002\u0010U\u001a\u00020\u0015H\u0000\u00a2\u0006\u0002\bVJ\u0015\u0010W\u001a\u00020>2\u0006\u0010X\u001a\u00020\u0019H\u0000\u00a2\u0006\u0002\bYJ\u0016\u0010Z\u001a\u00060\u0001j\u0002`\u00022\b\u0010S\u001a\u0004\u0018\u00010\u0019H\u0016J&\u0010Z\u001a\u00060\u0001j\u0002`\u00022\b\u0010S\u001a\u0004\u0018\u00010\u00192\u0006\u0010A\u001a\u00020\u00152\u0006\u0010B\u001a\u00020\u0015H\u0016J\u0014\u0010Z\u001a\u00060\u0001j\u0002`\u00022\u0006\u0010[\u001a\u00020\\H\u0016J \u0010]\u001a\u00020>2\u0006\u0010^\u001a\u00020\u00152\u0006\u0010_\u001a\u00020\u00152\u0006\u0010`\u001a\u00020\u0015H\u0002J\u000e\u0010a\u001a\u00020\\2\u0006\u0010b\u001a\u00020\u0015J\b\u0010c\u001a\u00020dH\u0016J\u0006\u0010e\u001a\u00020\u0019J\b\u0010f\u001a\u00020>H\u0002J\u0006\u0010g\u001a\u00020>J\u000e\u0010h\u001a\u00020>2\u0006\u0010b\u001a\u00020\u0015J\u000e\u0010i\u001a\u00020>2\u0006\u0010b\u001a\u00020\u0015JA\u0010j\u001a\u00020\u00042\b\b\u0002\u0010,\u001a\u00020\u001d2\n\b\u0002\u00100\u001a\u0004\u0018\u00010\u001d2\u001a\b\u0002\u00108\u001a\u0014\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020706j\u0002`E\u0018\u00010DH\u0000\u00a2\u0006\u0004\bk\u0010lJ \u0010m\u001a\u00020>2\u0006\u0010b\u001a\u00020\u00152\u0006\u0010n\u001a\u00020'2\u0006\u0010o\u001a\u00020'H\u0002J\u0017\u0010p\u001a\u00020>2\u0006\u0010q\u001a\u00020\u001dH\u0002\u00a2\u0006\u0004\br\u0010/R\u0014\u0010\u0007\u001a\u00020\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\u00020\u00068@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0014\u001a\u00020\u00158F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0018\u001a\u00020\u00198F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u0011\u0010\u001c\u001a\u00020\u001d8F\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001fR\u001a\u0010 \u001a\u00020!8FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\"\u0010#\u001a\u0004\b$\u0010%R\u0011\u0010&\u001a\u00020'8G\u00a2\u0006\u0006\u001a\u0004\b&\u0010(R\u0010\u0010)\u001a\u00020\u001dX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010*R$\u0010,\u001a\u00020\u001d2\u0006\u0010+\u001a\u00020\u001d8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b-\u0010\u001f\"\u0004\b.\u0010/R(\u00100\u001a\u0004\u0018\u00010\u001d2\b\u0010+\u001a\u0004\u0018\u00010\u001d@BX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b1\u00102\"\u0004\b3\u00104R:\u00108\u001a\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020706\u0018\u0001052\u0014\u0010+\u001a\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020706\u0018\u000105@BX\u0080\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b9\u0010:R:\u0010I\u001a\u0010\u0012\u0004\u0012\u00020H\u0012\u0004\u0012\u00020\u001d\u0018\u00010G2\u0014\u0010+\u001a\u0010\u0012\u0004\u0012\u00020H\u0012\u0004\u0012\u00020\u001d\u0018\u00010G@BX\u0080\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\bJ\u0010K\u00a8\u0006t"}, d2={"Landroidx/compose/foundation/text/input/TextFieldBuffer;", "Ljava/lang/Appendable;", "Lkotlin/text/Appendable;", "initialValue", "Landroidx/compose/foundation/text/input/TextFieldCharSequence;", "initialChanges", "Landroidx/compose/foundation/text/input/internal/ChangeTracker;", "originalValue", "offsetMappingCalculator", "Landroidx/compose/foundation/text/input/internal/OffsetMappingCalculator;", "<init>", "(Landroidx/compose/foundation/text/input/TextFieldCharSequence;Landroidx/compose/foundation/text/input/internal/ChangeTracker;Landroidx/compose/foundation/text/input/TextFieldCharSequence;Landroidx/compose/foundation/text/input/internal/OffsetMappingCalculator;)V", "getOriginalValue$foundation", "()Landroidx/compose/foundation/text/input/TextFieldCharSequence;", "buffer", "Landroidx/compose/foundation/text/input/internal/PartialGapBuffer;", "backingChangeTracker", "changeTracker", "getChangeTracker$foundation", "()Landroidx/compose/foundation/text/input/internal/ChangeTracker;", "length", "", "getLength", "()I", "originalText", "", "getOriginalText", "()Ljava/lang/CharSequence;", "originalSelection", "Landroidx/compose/ui/text/TextRange;", "getOriginalSelection-d9O1mEE", "()J", "changes", "Landroidx/compose/foundation/text/input/TextFieldBuffer$ChangeList;", "getChanges$annotations", "()V", "getChanges", "()Landroidx/compose/foundation/text/input/TextFieldBuffer$ChangeList;", "hasSelection", "", "()Z", "selectionInChars", "J", "value", "selection", "getSelection-d9O1mEE", "setSelection-5zc-tL8", "(J)V", "composition", "getComposition-MzsxiRA$foundation", "()Landroidx/compose/ui/text/TextRange;", "setComposition-OEnZFl4", "(Landroidx/compose/ui/text/TextRange;)V", "Landroidx/compose/runtime/collection/MutableVector;", "Landroidx/compose/ui/text/AnnotatedString$Range;", "Landroidx/compose/ui/text/AnnotatedString$Annotation;", "composingAnnotations", "getComposingAnnotations$foundation", "()Landroidx/compose/runtime/collection/MutableVector;", "hasComposition", "hasComposition$foundation", "commitComposition", "", "commitComposition$foundation", "setComposition", "start", "end", "annotations", "", "Landroidx/compose/foundation/text/input/PlacedAnnotation;", "setComposition$foundation", "Lkotlin/Pair;", "Landroidx/compose/foundation/text/input/TextHighlightType;", "highlight", "getHighlight$foundation", "()Lkotlin/Pair;", "setHighlight", "type", "setHighlight-K7f2yys$foundation", "(III)V", "clearHighlight", "clearHighlight$foundation", "replace", "text", "textStart", "textEnd", "replace$foundation", "setTextIfChanged", "newText", "setTextIfChanged$foundation", "append", "char", "", "onTextWillChange", "replaceStart", "replaceEnd", "newLength", "charAt", "index", "toString", "", "asCharSequence", "clearChangeList", "revertAllChanges", "placeCursorBeforeCharAt", "placeCursorAfterCharAt", "toTextFieldCharSequence", "toTextFieldCharSequence-I88jaVs$foundation", "(JLandroidx/compose/ui/text/TextRange;Ljava/util/List;)Landroidx/compose/foundation/text/input/TextFieldCharSequence;", "requireValidIndex", "startExclusive", "endExclusive", "requireValidRange", "range", "requireValidRange-5zc-tL8", "ChangeList", "foundation"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nTextFieldBuffer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TextFieldBuffer.kt\nandroidx/compose/foundation/text/input/TextFieldBuffer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 MutableVector.kt\nandroidx/compose/runtime/collection/MutableVectorKt\n+ 4 ListUtils.kt\nandroidx/compose/ui/util/ListUtilsKt\n+ 5 InlineClassHelper.kt\nandroidx/compose/foundation/internal/InlineClassHelperKt\n+ 6 TextFieldBuffer.kt\nandroidx/compose/foundation/text/input/TextFieldBufferKt\n*L\n1#1,721:1\n1#2:722\n1096#3,2:723\n1101#3:725\n1083#3,2:726\n35#4,5:728\n97#5,4:733\n97#5,4:737\n97#5,4:786\n97#5,4:790\n666#6,45:741\n*S KotlinDebug\n*F\n+ 1 TextFieldBuffer.kt\nandroidx/compose/foundation/text/input/TextFieldBuffer\n*L\n168#1:723,2\n220#1:725\n220#1:726,2\n222#1:728,5\n306#1:733,4\n307#1:737,4\n465#1:786,4\n470#1:790,4\n322#1:741,45\n*E\n"})
public final class TextFieldBuffer
implements Appendable {
    @NotNull
    private final TextFieldCharSequence originalValue;
    @Nullable
    private final OffsetMappingCalculator offsetMappingCalculator;
    @NotNull
    private final PartialGapBuffer buffer;
    @Nullable
    private ChangeTracker backingChangeTracker;
    private long selectionInChars;
    @Nullable
    private TextRange composition;
    @Nullable
    private MutableVector<AnnotatedString.Range<AnnotatedString.Annotation>> composingAnnotations;
    @Nullable
    private Pair<TextHighlightType, TextRange> highlight;
    public static final int $stable = 8;

    /*
     * WARNING - void declaration
     */
    public TextFieldBuffer(@NotNull TextFieldCharSequence initialValue, @Nullable ChangeTracker initialChanges, @NotNull TextFieldCharSequence originalValue, @Nullable OffsetMappingCalculator offsetMappingCalculator) {
        MutableVector<AnnotatedString.Range> mutableVector;
        ChangeTracker changeTracker;
        TextFieldBuffer textFieldBuffer;
        Intrinsics.checkNotNullParameter(initialValue, "initialValue");
        Intrinsics.checkNotNullParameter(originalValue, "originalValue");
        this.originalValue = originalValue;
        this.offsetMappingCalculator = offsetMappingCalculator;
        this.buffer = new PartialGapBuffer(initialValue);
        TextFieldBuffer textFieldBuffer2 = this;
        ChangeTracker changeTracker2 = initialChanges;
        if (changeTracker2 != null) {
            ChangeTracker changeTracker3 = changeTracker2;
            textFieldBuffer = textFieldBuffer2;
            boolean bl = false;
            changeTracker = new ChangeTracker(initialChanges);
            textFieldBuffer2 = textFieldBuffer;
        } else {
            changeTracker = null;
        }
        textFieldBuffer2.backingChangeTracker = changeTracker;
        this.selectionInChars = initialValue.getSelection-d9O1mEE();
        this.composition = initialValue.getComposition-MzsxiRA();
        TextFieldBuffer textFieldBuffer3 = this;
        Collection collection = initialValue.getComposingAnnotations();
        if (!(collection == null || collection.isEmpty())) {
            void size$iv;
            int n = initialValue.getComposingAnnotations().size();
            Function1<Integer, AnnotatedString.Range> it = arg_0 -> TextFieldBuffer.composingAnnotations$lambda$2(initialValue, arg_0);
            textFieldBuffer = textFieldBuffer3;
            boolean $i$f$MutableVector = false;
            int n2 = 0;
            AnnotatedString.Range[] rangeArray = new AnnotatedString.Range[size$iv];
            while (n2 < size$iv) {
                void init$iv;
                int n3 = n2++;
                rangeArray[n3] = init$iv.invoke(n3);
            }
            AnnotatedString.Range[] arr$iv = rangeArray;
            mutableVector = new MutableVector<AnnotatedString.Range>(arr$iv, (int)size$iv);
            textFieldBuffer3 = textFieldBuffer;
        } else {
            mutableVector = null;
        }
        textFieldBuffer3.composingAnnotations = mutableVector;
    }

    public /* synthetic */ TextFieldBuffer(TextFieldCharSequence textFieldCharSequence, ChangeTracker changeTracker, TextFieldCharSequence textFieldCharSequence2, OffsetMappingCalculator offsetMappingCalculator, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            changeTracker = null;
        }
        if ((n & 4) != 0) {
            textFieldCharSequence2 = textFieldCharSequence;
        }
        if ((n & 8) != 0) {
            offsetMappingCalculator = null;
        }
        this(textFieldCharSequence, changeTracker, textFieldCharSequence2, offsetMappingCalculator);
    }

    @NotNull
    public final TextFieldCharSequence getOriginalValue$foundation() {
        return this.originalValue;
    }

    @NotNull
    public final ChangeTracker getChangeTracker$foundation() {
        ChangeTracker changeTracker = this.backingChangeTracker;
        if (changeTracker == null) {
            ChangeTracker changeTracker2;
            ChangeTracker it = changeTracker2 = new ChangeTracker(null, 1, null);
            boolean bl = false;
            this.backingChangeTracker = it;
            changeTracker = changeTracker2;
        }
        return changeTracker;
    }

    public final int getLength() {
        return this.buffer.length();
    }

    @NotNull
    public final CharSequence getOriginalText() {
        return this.originalValue.getText();
    }

    public final long getOriginalSelection-d9O1mEE() {
        return this.originalValue.getSelection-d9O1mEE();
    }

    @NotNull
    public final ChangeList getChanges() {
        return this.getChangeTracker$foundation();
    }

    @ExperimentalFoundationApi
    public static /* synthetic */ void getChanges$annotations() {
    }

    @JvmName(name="hasSelection")
    public final boolean hasSelection() {
        return !TextRange.getCollapsed-impl(this.getSelection-d9O1mEE());
    }

    public final long getSelection-d9O1mEE() {
        return this.selectionInChars;
    }

    public final void setSelection-5zc-tL8(long value) {
        this.requireValidRange-5zc-tL8(value);
        this.selectionInChars = value;
        this.highlight = null;
    }

    @Nullable
    public final TextRange getComposition-MzsxiRA$foundation() {
        return this.composition;
    }

    private final void setComposition-OEnZFl4(TextRange value) {
        if (value == null || TextRange.getCollapsed-impl(value.unbox-impl())) {
            this.composition = null;
            MutableVector<AnnotatedString.Range<AnnotatedString.Annotation>> mutableVector = this.composingAnnotations;
            if (mutableVector != null) {
                mutableVector.clear();
            }
        } else {
            this.composition = value;
        }
    }

    @Nullable
    public final MutableVector<AnnotatedString.Range<AnnotatedString.Annotation>> getComposingAnnotations$foundation() {
        return this.composingAnnotations;
    }

    public final boolean hasComposition$foundation() {
        return this.composition != null;
    }

    public final void commitComposition$foundation() {
        this.setComposition-OEnZFl4(null);
    }

    public final void setComposition$foundation(int start2, int end, @Nullable List<AnnotatedString.Range<AnnotatedString.Annotation>> annotations) {
        if (start2 < 0 || start2 > this.buffer.length()) {
            throw new IndexOutOfBoundsException("start (" + start2 + ") offset is outside of text region " + this.buffer.length());
        }
        if (end < 0 || end > this.buffer.length()) {
            throw new IndexOutOfBoundsException("end (" + end + ") offset is outside of text region " + this.buffer.length());
        }
        if (start2 >= end) {
            throw new IllegalArgumentException("Do not set reversed or empty range: " + start2 + " > " + end);
        }
        this.setComposition-OEnZFl4(TextRange.box-impl(TextRangeKt.TextRange(start2, end)));
        MutableVector<AnnotatedString.Range<AnnotatedString.Annotation>> mutableVector = this.composingAnnotations;
        if (mutableVector != null) {
            mutableVector.clear();
        }
        Collection collection = annotations;
        if (!(collection == null || collection.isEmpty())) {
            if (this.composingAnnotations == null) {
                boolean $i$f$mutableVectorOf = false;
                int capacity$iv$iv = 16;
                boolean $i$f$MutableVector = false;
                this.composingAnnotations = new MutableVector<AnnotatedString.Range>(new AnnotatedString.Range[capacity$iv$iv], 0);
            }
            List<AnnotatedString.Range<AnnotatedString.Annotation>> $this$fastForEach$iv = annotations;
            boolean $i$f$fastForEach = false;
            int n = ((Collection)$this$fastForEach$iv).size();
            for (int index$iv = 0; index$iv < n; ++index$iv) {
                AnnotatedString.Range<AnnotatedString.Annotation> item$iv;
                AnnotatedString.Range<AnnotatedString.Annotation> it = item$iv = $this$fastForEach$iv.get(index$iv);
                boolean bl = false;
                MutableVector<AnnotatedString.Range<AnnotatedString.Annotation>> mutableVector2 = this.composingAnnotations;
                if (mutableVector2 != null) {
                    mutableVector2.add(AnnotatedString.Range.copy$default(it, null, it.getStart() + start2, it.getEnd() + start2, null, 9, null));
                }
            }
        }
    }

    public static /* synthetic */ void setComposition$foundation$default(TextFieldBuffer textFieldBuffer, int n, int n2, List list2, int n3, Object object) {
        if ((n3 & 4) != 0) {
            list2 = null;
        }
        textFieldBuffer.setComposition$foundation(n, n2, list2);
    }

    @Nullable
    public final Pair<TextHighlightType, TextRange> getHighlight$foundation() {
        return this.highlight;
    }

    public final void setHighlight-K7f2yys$foundation(int type2, int start2, int end) {
        if (start2 >= end) {
            throw new IllegalArgumentException("Do not set reversed or empty range: " + start2 + " > " + end);
        }
        int clampedStart = RangesKt.coerceIn(start2, 0, this.getLength());
        int clampedEnd = RangesKt.coerceIn(end, 0, this.getLength());
        this.highlight = new Pair<TextHighlightType, TextRange>(TextHighlightType.box-impl(type2), TextRange.box-impl(TextRangeKt.TextRange(clampedStart, clampedEnd)));
    }

    public final void clearHighlight$foundation() {
        this.highlight = null;
    }

    public final void replace(int start2, int end, @NotNull CharSequence text) {
        Intrinsics.checkNotNullParameter(text, "text");
        this.replace$foundation(start2, end, text, 0, text.length());
    }

    public final void replace$foundation(int start2, int end, @NotNull CharSequence text, int textStart, int textEnd) {
        Intrinsics.checkNotNullParameter(text, "text");
        boolean value$iv = start2 <= end;
        boolean $i$f$requirePrecondition = false;
        if (!value$iv) {
            boolean bl = false;
            InlineClassHelperKt.throwIllegalArgumentException("Expected start=" + start2 + " <= end=" + end);
        }
        value$iv = textStart <= textEnd;
        $i$f$requirePrecondition = false;
        if (!value$iv) {
            boolean bl = false;
            InlineClassHelperKt.throwIllegalArgumentException("Expected textStart=" + textStart + " <= textEnd=" + textEnd);
        }
        this.onTextWillChange(start2, end, textEnd - textStart);
        this.buffer.replace(start2, end, text, textStart, textEnd);
        this.commitComposition$foundation();
        this.clearHighlight$foundation();
    }

    public static /* synthetic */ void replace$foundation$default(TextFieldBuffer textFieldBuffer, int n, int n2, CharSequence charSequence, int n3, int n4, int n5, Object object) {
        if ((n5 & 8) != 0) {
            n3 = 0;
        }
        if ((n5 & 0x10) != 0) {
            n4 = charSequence.length();
        }
        textFieldBuffer.replace$foundation(n, n2, charSequence, n3, n4);
    }

    /*
     * WARNING - void declaration
     */
    public final void setTextIfChanged$foundation(@NotNull CharSequence newText) {
        Intrinsics.checkNotNullParameter(newText, "newText");
        CharSequence a$iv = this.buffer;
        boolean $i$f$findCommonPrefixAndSuffix = false;
        int aStart$iv = 0;
        int aEnd$iv = a$iv.length();
        int bStart$iv = 0;
        int bEnd$iv = newText.length();
        if (a$iv.length() > 0 && newText.length() > 0) {
            boolean prefixFound$iv = false;
            boolean suffixFound$iv = false;
            do {
                if (!prefixFound$iv) {
                    if (a$iv.charAt(aStart$iv) == newText.charAt(bStart$iv)) {
                        ++aStart$iv;
                        ++bStart$iv;
                    } else {
                        prefixFound$iv = true;
                    }
                }
                if (suffixFound$iv) continue;
                if (a$iv.charAt(aEnd$iv - 1) == newText.charAt(bEnd$iv - 1)) {
                    --aEnd$iv;
                    --bEnd$iv;
                    continue;
                }
                suffixFound$iv = true;
            } while (aStart$iv < aEnd$iv && bStart$iv < bEnd$iv && (!prefixFound$iv || !suffixFound$iv));
        }
        if (aStart$iv < aEnd$iv || bStart$iv < bEnd$iv) {
            void newEnd;
            void newStart;
            void thisEnd;
            int n = bEnd$iv;
            int n2 = bStart$iv;
            int n3 = aEnd$iv;
            int thisStart = aStart$iv;
            boolean bl = false;
            this.replace$foundation(thisStart, (int)thisEnd, newText, (int)newStart, (int)newEnd);
        }
    }

    @Override
    @NotNull
    public Appendable append(@Nullable CharSequence text) {
        TextFieldBuffer textFieldBuffer;
        TextFieldBuffer $this$append_u24lambda_u247 = textFieldBuffer = this;
        boolean bl = false;
        if (text != null) {
            $this$append_u24lambda_u247.onTextWillChange($this$append_u24lambda_u247.getLength(), $this$append_u24lambda_u247.getLength(), text.length());
            PartialGapBuffer.replace$default($this$append_u24lambda_u247.buffer, $this$append_u24lambda_u247.buffer.length(), $this$append_u24lambda_u247.buffer.length(), text, 0, 0, 24, null);
        }
        return textFieldBuffer;
    }

    @Override
    @NotNull
    public Appendable append(@Nullable CharSequence text, int start2, int end) {
        TextFieldBuffer textFieldBuffer;
        TextFieldBuffer $this$append_u24lambda_u248 = textFieldBuffer = this;
        boolean bl = false;
        if (text != null) {
            $this$append_u24lambda_u248.onTextWillChange($this$append_u24lambda_u248.getLength(), $this$append_u24lambda_u248.getLength(), end - start2);
            PartialGapBuffer.replace$default($this$append_u24lambda_u248.buffer, $this$append_u24lambda_u248.buffer.length(), $this$append_u24lambda_u248.buffer.length(), text.subSequence(start2, end), 0, 0, 24, null);
        }
        return textFieldBuffer;
    }

    @Override
    @NotNull
    public Appendable append(char c) {
        TextFieldBuffer textFieldBuffer;
        TextFieldBuffer $this$append_u24lambda_u249 = textFieldBuffer = this;
        boolean bl = false;
        $this$append_u24lambda_u249.onTextWillChange($this$append_u24lambda_u249.getLength(), $this$append_u24lambda_u249.getLength(), 1);
        PartialGapBuffer.replace$default($this$append_u24lambda_u249.buffer, $this$append_u24lambda_u249.buffer.length(), $this$append_u24lambda_u249.buffer.length(), String.valueOf(c), 0, 0, 24, null);
        return textFieldBuffer;
    }

    private final void onTextWillChange(int replaceStart, int replaceEnd, int newLength) {
        this.getChangeTracker$foundation().trackChange(replaceStart, replaceEnd, newLength);
        OffsetMappingCalculator offsetMappingCalculator = this.offsetMappingCalculator;
        if (offsetMappingCalculator != null) {
            offsetMappingCalculator.recordEditOperation(replaceStart, replaceEnd, newLength);
        }
        this.selectionInChars = TextFieldBufferKt.adjustTextRange-vJH6DeI(this.getSelection-d9O1mEE(), replaceStart, replaceEnd, newLength);
    }

    public final char charAt(int index2) {
        return this.buffer.charAt(index2);
    }

    @NotNull
    public String toString() {
        return this.buffer.toString();
    }

    @NotNull
    public final CharSequence asCharSequence() {
        return this.buffer;
    }

    private final void clearChangeList() {
        this.getChangeTracker$foundation().clearChanges();
    }

    public final void revertAllChanges() {
        this.replace(0, this.getLength(), this.originalValue.toString());
        this.setSelection-5zc-tL8(this.originalValue.getSelection-d9O1mEE());
        this.clearChangeList();
    }

    public final void placeCursorBeforeCharAt(int index2) {
        this.requireValidIndex(index2, true, false);
        this.selectionInChars = TextRangeKt.TextRange(index2);
    }

    public final void placeCursorAfterCharAt(int index2) {
        this.requireValidIndex(index2, false, true);
        this.selectionInChars = TextRangeKt.TextRange(RangesKt.coerceAtMost(index2 + 1, this.getLength()));
    }

    @NotNull
    public final TextFieldCharSequence toTextFieldCharSequence-I88jaVs$foundation(long selection, @Nullable TextRange composition2, @Nullable List<AnnotatedString.Range<AnnotatedString.Annotation>> composingAnnotations) {
        return new TextFieldCharSequence(this.buffer.toString(), selection, composition2, null, composingAnnotations, 8, null);
    }

    public static /* synthetic */ TextFieldCharSequence toTextFieldCharSequence-I88jaVs$foundation$default(TextFieldBuffer textFieldBuffer, long l, TextRange textRange, List list2, int n, Object object) {
        if ((n & 1) != 0) {
            l = textFieldBuffer.getSelection-d9O1mEE();
        }
        if ((n & 2) != 0) {
            textRange = textFieldBuffer.composition;
        }
        if ((n & 4) != 0) {
            MutableVector<AnnotatedString.Range<AnnotatedString.Annotation>> mutableVector;
            MutableVector<AnnotatedString.Range<AnnotatedString.Annotation>> mutableVector2 = textFieldBuffer.composingAnnotations;
            if (mutableVector2 != null && (mutableVector2 = mutableVector2.asMutableList()) != null) {
                MutableVector<AnnotatedString.Range<AnnotatedString.Annotation>> mutableVector3;
                MutableVector<AnnotatedString.Range<AnnotatedString.Annotation>> it = mutableVector3 = mutableVector2;
                boolean bl = false;
                mutableVector = !((Collection)((Object)it)).isEmpty() ? mutableVector3 : null;
            } else {
                mutableVector = null;
            }
            list2 = mutableVector;
        }
        return textFieldBuffer.toTextFieldCharSequence-I88jaVs$foundation(l, textRange, list2);
    }

    private final void requireValidIndex(int index2, boolean startExclusive, boolean endExclusive) {
        int end;
        int start2 = startExclusive ? 0 : -1;
        int n = end = endExclusive ? this.getLength() : this.getLength() + 1;
        boolean value$iv = start2 <= index2 ? index2 < end : false;
        boolean $i$f$requirePrecondition = false;
        if (!value$iv) {
            boolean bl = false;
            InlineClassHelperKt.throwIllegalArgumentException("Expected " + index2 + " to be in [" + start2 + ", " + end + ")");
        }
    }

    private final void requireValidRange-5zc-tL8(long range) {
        long validRange = TextRangeKt.TextRange(0, this.getLength());
        boolean value$iv = TextRange.contains-5zc-tL8(validRange, range);
        boolean $i$f$requirePrecondition = false;
        if (!value$iv) {
            boolean bl = false;
            InlineClassHelperKt.throwIllegalArgumentException("Expected " + TextRange.toString-impl(range) + " to be in " + TextRange.toString-impl(validRange));
        }
    }

    private static final AnnotatedString.Range composingAnnotations$lambda$2(TextFieldCharSequence $initialValue, int it) {
        return $initialValue.getComposingAnnotations().get(it);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\bf\u0018\u00002\u00020\u0001J\u0017\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0003H&\u00a2\u0006\u0004\b\t\u0010\nJ\u0017\u0010\u000b\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0003H&\u00a2\u0006\u0004\b\f\u0010\nR\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\r\u00c0\u0006\u0001"}, d2={"Landroidx/compose/foundation/text/input/TextFieldBuffer$ChangeList;", "", "changeCount", "", "getChangeCount", "()I", "getRange", "Landroidx/compose/ui/text/TextRange;", "changeIndex", "getRange--jx7JFs", "(I)J", "getOriginalRange", "getOriginalRange--jx7JFs", "foundation"})
    public static interface ChangeList {
        public int getChangeCount();

        public long getRange--jx7JFs(int var1);

        public long getOriginalRange--jx7JFs(int var1);
    }
}

