/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.runtime.snapshots;

import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.runtime.internal.Utils_jvmKt;
import androidx.compose.runtime.internal.WeakReference;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0015\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\b\u0001\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0013\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u001cJ \u0010\u001d\u001a\u00020\u001e2\u0012\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u001a0 H\u0086\b\u00f8\u0001\u0000J\u001d\u0010!\u001a\u00020\u00062\u0006\u0010\u001b\u001a\u00028\u00002\u0006\u0010\"\u001a\u00020\u0006H\u0002\u00a2\u0006\u0002\u0010#J%\u0010$\u001a\u00020\u00062\u0006\u0010%\u001a\u00020\u00062\u0006\u0010\u001b\u001a\u00028\u00002\u0006\u0010&\u001a\u00020\u0006H\u0002\u00a2\u0006\u0002\u0010'J\r\u0010(\u001a\u00020\u001aH\u0001\u00a2\u0006\u0002\b)R\u001a\u0010\u0005\u001a\u00020\u0006X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\u00020\fX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R*\u0010\u0011\u001a\u0010\u0012\f\u0012\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u00130\u0012X\u0080\u000e\u00a2\u0006\u0010\n\u0002\u0010\u0018\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006*"}, d2={"Landroidx/compose/runtime/snapshots/SnapshotWeakSet;", "T", "", "<init>", "()V", "size", "", "getSize$runtime", "()I", "setSize$runtime", "(I)V", "hashes", "", "getHashes$runtime", "()[I", "setHashes$runtime", "([I)V", "values", "", "Landroidx/compose/runtime/internal/WeakReference;", "getValues$runtime", "()[Landroidx/compose/runtime/internal/WeakReference;", "setValues$runtime", "([Landroidx/compose/runtime/internal/WeakReference;)V", "[Landroidx/compose/runtime/internal/WeakReference;", "add", "", "value", "(Ljava/lang/Object;)Z", "removeIf", "", "block", "Lkotlin/Function1;", "find", "hash", "(Ljava/lang/Object;I)I", "findExactIndex", "midIndex", "valueHash", "(ILjava/lang/Object;I)I", "isValid", "isValid$runtime", "runtime"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nSnapshotWeakSet.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SnapshotWeakSet.kt\nandroidx/compose/runtime/snapshots/SnapshotWeakSet\n+ 2 ArrayUtils.nonAndroid.kt\nandroidx/compose/runtime/collection/ArrayUtils_nonAndroidKt\n*L\n1#1,243:1\n23#2:244\n23#2:245\n23#2:246\n*S KotlinDebug\n*F\n+ 1 SnapshotWeakSet.kt\nandroidx/compose/runtime/snapshots/SnapshotWeakSet\n*L\n74#1:244\n80#1:245\n96#1:246\n*E\n"})
public final class SnapshotWeakSet<T> {
    private int size;
    @NotNull
    private int[] hashes = new int[16];
    @NotNull
    private WeakReference<T>[] values = new WeakReference[16];
    public static final int $stable = 8;

    public final int getSize$runtime() {
        return this.size;
    }

    public final void setSize$runtime(int n) {
        this.size = n;
    }

    @NotNull
    public final int[] getHashes$runtime() {
        return this.hashes;
    }

    public final void setHashes$runtime(@NotNull int[] nArray) {
        Intrinsics.checkNotNullParameter(nArray, "<set-?>");
        this.hashes = nArray;
    }

    @NotNull
    public final WeakReference<T>[] getValues$runtime() {
        return this.values;
    }

    public final void setValues$runtime(@NotNull WeakReference<T>[] weakReferenceArray) {
        Intrinsics.checkNotNullParameter(weakReferenceArray, "<set-?>");
        this.values = weakReferenceArray;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean add(@NotNull T value) {
        Intrinsics.checkNotNullParameter(value, "value");
        int index2 = 0;
        int size2 = this.size;
        int hash = Utils_jvmKt.identityHashCode(value);
        if (size2 > 0) {
            index2 = this.find(value, hash);
            if (index2 >= 0) {
                return false;
            }
        } else {
            index2 = -1;
        }
        int insertIndex = -(index2 + 1);
        int capacity = this.values.length;
        if (size2 == capacity) {
            void startIndex$iv;
            int destinationOffset$iv;
            WeakReference<T>[] $this$fastCopyInto$iv;
            int newCapacity = capacity * 2;
            WeakReference[] newValues = new WeakReference[newCapacity];
            int[] newHashes = new int[newCapacity];
            WeakReference<T>[] weakReferenceArray = this.values;
            int n = insertIndex + 1;
            boolean $i$f$fastCopyInto = false;
            ArraysKt.copyInto($this$fastCopyInto$iv, newValues, destinationOffset$iv, insertIndex, size2);
            $this$fastCopyInto$iv = this.values;
            destinationOffset$iv = 0;
            $i$f$fastCopyInto = false;
            boolean $i$f$fastCopyInto2 = false;
            ArraysKt.copyInto($this$fastCopyInto$iv, newValues, destinationOffset$iv, (int)startIndex$iv, insertIndex);
            ArraysKt.copyInto(this.hashes, newHashes, insertIndex + 1, insertIndex, size2);
            ArraysKt.copyInto$default(this.hashes, newHashes, 0, 0, insertIndex, 6, null);
            this.values = newValues;
            this.hashes = newHashes;
        } else {
            void destinationOffset$iv;
            void destination$iv;
            void $this$fastCopyInto$iv;
            WeakReference<T>[] newCapacity = this.values;
            WeakReference<T>[] newValues = this.values;
            int newHashes = insertIndex + 1;
            boolean $i$f$fastCopyInto = false;
            ArraysKt.copyInto($this$fastCopyInto$iv, destination$iv, (int)destinationOffset$iv, insertIndex, size2);
            ArraysKt.copyInto(this.hashes, this.hashes, insertIndex + 1, insertIndex, size2);
        }
        this.values[insertIndex] = new WeakReference<T>(value);
        this.hashes[insertIndex] = hash;
        int n = this.size;
        this.size = n + 1;
        return true;
    }

    public final void removeIf(@NotNull Function1<? super T, Boolean> block2) {
        int i2;
        Intrinsics.checkNotNullParameter(block2, "block");
        boolean $i$f$removeIf = false;
        int size2 = this.getSize$runtime();
        int currentUsed = 0;
        for (i2 = 0; i2 < size2; ++i2) {
            Object value;
            WeakReference<T> entry;
            WeakReference<T> weakReference = entry = this.getValues$runtime()[i2];
            Object object = value = weakReference != null ? weakReference.get() : null;
            if (value == null || block2.invoke(value).booleanValue()) continue;
            if (currentUsed != i2) {
                this.getValues$runtime()[currentUsed] = entry;
                this.getHashes$runtime()[currentUsed] = this.getHashes$runtime()[i2];
            }
            ++currentUsed;
        }
        for (i2 = currentUsed; i2 < size2; ++i2) {
            this.getValues$runtime()[i2] = null;
            this.getHashes$runtime()[i2] = 0;
        }
        if (currentUsed != size2) {
            this.setSize$runtime(currentUsed);
        }
    }

    private final int find(T value, int hash) {
        int low = 0;
        int high = this.size - 1;
        while (low <= high) {
            Object midVal;
            int mid = low + high >>> 1;
            int midHash = this.hashes[mid];
            if (midHash < hash) {
                low = mid + 1;
                continue;
            }
            if (midHash > hash) {
                high = mid - 1;
                continue;
            }
            WeakReference<T> weakReference = this.values[mid];
            Object object = midVal = weakReference != null ? weakReference.get() : null;
            if (value == midVal) {
                return mid;
            }
            return this.findExactIndex(mid, value, hash);
        }
        return -(low + 1);
    }

    private final int findExactIndex(int midIndex, T value, int valueHash) {
        int i2;
        for (i2 = midIndex - 1; -1 < i2 && this.hashes[i2] == valueHash; --i2) {
            Object v;
            WeakReference<T> weakReference = this.values[i2];
            Object object = v = weakReference != null ? weakReference.get() : null;
            if (v != value) continue;
            return i2;
        }
        int n = this.size;
        for (i2 = midIndex + 1; i2 < n; ++i2) {
            Object v;
            if (this.hashes[i2] != valueHash) {
                return -(i2 + 1);
            }
            WeakReference<T> weakReference = this.values[i2];
            Object object = v = weakReference != null ? weakReference.get() : null;
            if (v != value) continue;
            return i2;
        }
        return -(this.size + 1);
    }

    @TestOnly
    public final boolean isValid$runtime() {
        int i2;
        int size2 = this.size;
        WeakReference<T>[] values2 = this.values;
        int[] hashes = this.hashes;
        int capacity = values2.length;
        if (size2 > capacity) {
            return false;
        }
        int previous2 = Integer.MIN_VALUE;
        for (i2 = 0; i2 < size2; ++i2) {
            WeakReference<T> entry;
            int hash = hashes[i2];
            if (hash < previous2) {
                return false;
            }
            if (values2[i2] == null) {
                return false;
            }
            Object value = entry.get();
            if (value != null && hash != Utils_jvmKt.identityHashCode(value)) {
                return false;
            }
            previous2 = hash;
        }
        for (i2 = size2; i2 < capacity; ++i2) {
            if (hashes[i2] != 0) {
                return false;
            }
            if (values2[i2] == null) continue;
            return false;
        }
        return true;
    }
}

