/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.platform.a11y;

import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.ui.geometry.Offset;
import androidx.compose.ui.geometry.Rect;
import androidx.compose.ui.node.DelegatableNodeKt;
import androidx.compose.ui.node.NodeKind;
import androidx.compose.ui.platform.a11y.AccessibilityController;
import androidx.compose.ui.platform.a11y.ComposeAccessibleKt;
import androidx.compose.ui.platform.a11y.ProgressBarAccessibleValue;
import androidx.compose.ui.platform.a11y.RadioButtonAccessibleValue;
import androidx.compose.ui.platform.a11y.ToggleableAccessibleValue;
import androidx.compose.ui.semantics.AccessibilityAction;
import androidx.compose.ui.semantics.ProgressBarRangeInfo;
import androidx.compose.ui.semantics.Role;
import androidx.compose.ui.semantics.ScrollAxisRange;
import androidx.compose.ui.semantics.SemanticsActions;
import androidx.compose.ui.semantics.SemanticsConfiguration;
import androidx.compose.ui.semantics.SemanticsConfigurationKt;
import androidx.compose.ui.semantics.SemanticsNode;
import androidx.compose.ui.semantics.SemanticsProperties;
import androidx.compose.ui.semantics.SemanticsPropertyKey;
import androidx.compose.ui.state.ToggleableState;
import androidx.compose.ui.text.AnnotatedString;
import androidx.compose.ui.text.TextLayoutResult;
import androidx.compose.ui.text.TextRange;
import androidx.compose.ui.unit.Density;
import androidx.compose.ui.unit.Dp;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.FocusListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleAction;
import javax.accessibility.AccessibleComponent;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleEditableText;
import javax.accessibility.AccessibleExtendedText;
import javax.accessibility.AccessibleRelation;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;
import javax.accessibility.AccessibleText;
import javax.accessibility.AccessibleTextSequence;
import javax.accessibility.AccessibleValue;
import javax.swing.text.AttributeSet;
import javax.swing.text.SimpleAttributeSet;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.NotImplementedError;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.skia.BreakIterator;
import org.jetbrains.skiko.HardwareLayerKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0001\u0018\u00002\u00020\u00012\u00020\u0002:\u0001#B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\n\u0010!\u001a\u0004\u0018\u00010\"H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u0003\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u0004@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\u00020\u000f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\t\u0010\u0013\u001a\u00020\u0014X\u0082\u0004R\u001f\u0010\u0015\u001a\u00060\u0016R\u00020\u00008FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0019\u0010\u001a\u001a\u0004\b\u0017\u0010\u0018R\u001a\u0010\u001b\u001a\u00020\u001cX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 \u00a8\u0006$"}, d2={"Landroidx/compose/ui/platform/a11y/ComposeAccessible;", "Ljavax/accessibility/Accessible;", "Ljava/awt/Component;", "semanticsNode", "Landroidx/compose/ui/semantics/SemanticsNode;", "controller", "Landroidx/compose/ui/platform/a11y/AccessibilityController;", "<init>", "(Landroidx/compose/ui/semantics/SemanticsNode;Landroidx/compose/ui/platform/a11y/AccessibilityController;)V", "value", "getSemanticsNode", "()Landroidx/compose/ui/semantics/SemanticsNode;", "setSemanticsNode", "(Landroidx/compose/ui/semantics/SemanticsNode;)V", "cachedSemanticsConfig", "Landroidx/compose/ui/semantics/SemanticsConfiguration;", "semanticsConfig", "getSemanticsConfig", "()Landroidx/compose/ui/semantics/SemanticsConfiguration;", "isNativelyInitialized", "Lkotlinx/atomicfu/AtomicBoolean;", "composeAccessibleContext", "Landroidx/compose/ui/platform/a11y/ComposeAccessible$ComposeAccessibleComponent;", "getComposeAccessibleContext", "()Landroidx/compose/ui/platform/a11y/ComposeAccessible$ComposeAccessibleComponent;", "composeAccessibleContext$delegate", "Lkotlin/Lazy;", "removed", "", "getRemoved", "()Z", "setRemoved", "(Z)V", "getAccessibleContext", "Ljavax/accessibility/AccessibleContext;", "ComposeAccessibleComponent", "ui"})
@StabilityInferred(parameters=0)
public final class ComposeAccessible
extends Component
implements Accessible {
    @NotNull
    private final AccessibilityController controller;
    @NotNull
    private SemanticsNode semanticsNode;
    @Nullable
    private SemanticsConfiguration cachedSemanticsConfig;
    private volatile /* synthetic */ int isNativelyInitialized$volatile;
    @NotNull
    private final Lazy composeAccessibleContext$delegate;
    private boolean removed;
    private static final /* synthetic */ AtomicIntegerFieldUpdater isNativelyInitialized$volatile$FU;
    public static final int $stable;

    public ComposeAccessible(@NotNull SemanticsNode semanticsNode, @NotNull AccessibilityController controller) {
        Intrinsics.checkNotNullParameter(semanticsNode, "semanticsNode");
        Intrinsics.checkNotNullParameter(controller, "controller");
        this.controller = controller;
        this.semanticsNode = semanticsNode;
        this.composeAccessibleContext$delegate = LazyKt.lazy(() -> ComposeAccessible.composeAccessibleContext_delegate$lambda$1(this));
    }

    @NotNull
    public final SemanticsNode getSemanticsNode() {
        return this.semanticsNode;
    }

    public final void setSemanticsNode(@NotNull SemanticsNode value) {
        Intrinsics.checkNotNullParameter(value, "value");
        this.semanticsNode = value;
        this.cachedSemanticsConfig = null;
    }

    private final SemanticsConfiguration getSemanticsConfig() {
        SemanticsConfiguration semanticsConfiguration = this.cachedSemanticsConfig;
        if (semanticsConfiguration == null) {
            SemanticsConfiguration semanticsConfiguration2;
            SemanticsConfiguration it = semanticsConfiguration2 = this.semanticsNode.getConfig();
            boolean bl = false;
            this.cachedSemanticsConfig = it;
            semanticsConfiguration = semanticsConfiguration2;
        }
        return semanticsConfiguration;
    }

    private final /* synthetic */ int isNativelyInitialized$volatile() {
        return this.isNativelyInitialized$volatile;
    }

    private final /* synthetic */ void setNativelyInitialized$volatile(int value) {
        this.isNativelyInitialized$volatile = value;
    }

    @NotNull
    public final ComposeAccessibleComponent getComposeAccessibleContext() {
        Lazy lazy = this.composeAccessibleContext$delegate;
        return (ComposeAccessibleComponent)lazy.getValue();
    }

    public final boolean getRemoved() {
        return this.removed;
    }

    public final void setRemoved(boolean bl) {
        this.removed = bl;
    }

    @Override
    @Nullable
    public AccessibleContext getAccessibleContext() {
        if (this.removed) {
            return null;
        }
        if (ComposeAccessible.isNativelyInitialized$volatile$FU.compareAndSet(this, 0, 1)) {
            HardwareLayerKt.nativeInitializeAccessible(this);
        }
        return this.getComposeAccessibleContext();
    }

    private static final ComposeAccessibleComponent composeAccessibleContext_delegate$lambda$1(ComposeAccessible this$0) {
        return this$0.new ComposeAccessibleComponent();
    }

    static {
        isNativelyInitialized$volatile$FU = AtomicIntegerFieldUpdater.newUpdater(ComposeAccessible.class, "isNativelyInitialized$volatile");
        $stable = 8;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     * Duplicate member names - consider using --renamedupmembers true
     */
    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u009c\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\b\u0096\u0004\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003:\u0006\u00a6\u0001\u00a7\u0001\u00a8\u0001B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010D\u001a\u00020;2\u0006\u0010E\u001a\u00020\u000eH\u0002J\u0013\u0010F\u001a\u00020G*\u00020HH\u0002\u00a2\u0006\u0004\bI\u0010JJ\u0013\u0010K\u001a\u00020\u0013*\u00020LH\u0002\u00a2\u0006\u0004\bM\u0010NJ\f\u0010O\u001a\u00020P*\u00020QH\u0002J\u0013\u0010R\u001a\u00020H*\u00020GH\u0002\u00a2\u0006\u0004\bS\u0010TJ\u0013\u0010U\u001a\u00020V*\u00020WH\u0002\u00a2\u0006\u0004\bX\u0010YJ\n\u0010Z\u001a\u0004\u0018\u00010[H\u0016J\n\u0010\\\u001a\u0004\u0018\u00010[H\u0016J\n\u0010]\u001a\u0004\u0018\u00010;H\u0016J\n\u0010^\u001a\u0004\u0018\u00010\u0002H\u0016J\n\u0010`\u001a\u0004\u0018\u00010\u0003H\u0016J\n\u0010a\u001a\u0004\u0018\u00010bH\u0016J\b\u0010c\u001a\u00020\u0013H\u0016J\b\u0010d\u001a\u00020\u0013H\u0016J\u0012\u0010e\u001a\u0004\u0018\u00010;2\u0006\u0010f\u001a\u00020\u0013H\u0016J\b\u0010g\u001a\u00020hH\u0016J\b\u0010i\u001a\u00020HH\u0016J\b\u0010j\u001a\u00020HH\u0016J\b\u0010k\u001a\u00020PH\u0016J\b\u0010l\u001a\u00020VH\u0016J\b\u0010m\u001a\u00020\u000eH\u0016J\b\u0010n\u001a\u00020\u000eH\u0016J\b\u0010o\u001a\u00020\u000eH\u0016J\u0011\u0010p\u001a\u00020\u000e2\u0006\u0010q\u001a\u00020HH\u0096\u0002J\u0012\u0010r\u001a\u0004\u0018\u00010;2\u0006\u0010q\u001a\u00020HH\u0016J\b\u0010s\u001a\u00020\u000eH\u0016J\b\u0010t\u001a\u00020uH\u0016J\u0012\u0010v\u001a\u00020u2\b\u0010w\u001a\u0004\u0018\u00010xH\u0016J\u0012\u0010y\u001a\u00020u2\b\u0010w\u001a\u0004\u0018\u00010xH\u0016J\b\u0010z\u001a\u00020{H\u0016J\b\u0010|\u001a\u00020}H\u0016J\f\u0010~\u001a\u00020u*\u00020}H\u0002J\f\u0010\u007f\u001a\u00020u*\u00020}H\u0002J\r\u0010\u0080\u0001\u001a\u00020u*\u00020}H\u0002J\f\u0010\u0084\u0001\u001a\u0005\u0018\u00010\u0088\u0001H\u0016J\f\u0010\u0089\u0001\u001a\u0005\u0018\u00010\u008a\u0001H\u0016J\u0014\u0010\u008b\u0001\u001a\u00020u2\t\u0010\u008c\u0001\u001a\u0004\u0018\u00010PH\u0016J\u0014\u0010\u008d\u0001\u001a\u00020u2\t\u0010\u008e\u0001\u001a\u0004\u0018\u00010VH\u0016J\u0013\u0010\u008f\u0001\u001a\u00020u2\b\u0010q\u001a\u0004\u0018\u00010HH\u0016J\n\u0010\u0090\u0001\u001a\u00030\u0091\u0001H\u0016J\u0015\u0010\u0092\u0001\u001a\u00020u2\n\u0010\u0093\u0001\u001a\u0005\u0018\u00010\u0091\u0001H\u0016J\n\u0010\u0094\u0001\u001a\u00030\u0091\u0001H\u0016J\u0015\u0010\u0095\u0001\u001a\u00020u2\n\u0010\u0093\u0001\u001a\u0005\u0018\u00010\u0091\u0001H\u0016J\n\u0010\u0096\u0001\u001a\u00030\u0097\u0001H\u0016J\u0015\u0010\u0098\u0001\u001a\u00020u2\n\u0010\u0099\u0001\u001a\u0005\u0018\u00010\u0097\u0001H\u0016J\n\u0010\u009a\u0001\u001a\u00030\u009b\u0001H\u0016J\u0015\u0010\u009c\u0001\u001a\u00020u2\n\u0010\u009d\u0001\u001a\u0005\u0018\u00010\u009b\u0001H\u0016J\u0016\u0010\u009e\u0001\u001a\u00030\u009f\u00012\n\u0010\u009d\u0001\u001a\u0005\u0018\u00010\u009b\u0001H\u0016J\u0012\u0010\u00a0\u0001\u001a\u00020u2\u0007\u0010\u00a1\u0001\u001a\u00020\u000eH\u0016J\u0012\u0010\u00a2\u0001\u001a\u00020u2\u0007\u0010\u00a1\u0001\u001a\u00020\u000eH\u0016J\t\u0010\u00a3\u0001\u001a\u00020\u0013H\u0016J\u0011\u0010\u00a4\u0001\u001a\u00020[2\u0006\u0010f\u001a\u00020\u0013H\u0016J\u0011\u0010\u00a5\u0001\u001a\u00020\u000e2\u0006\u0010f\u001a\u00020\u0013H\u0016R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u00078F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR%\u0010\n\u001a\u0016\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\f\u0018\u00010\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R1\u0010\u0011\u001a\"\u0012\u001c\u0012\u001a\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000e0\u0012\u0018\u00010\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0010R\u0013\u0010\u0015\u001a\u0004\u0018\u00010\r8F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0013\u0010\u0018\u001a\u0004\u0018\u00010\u00198F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u0013\u0010\u001c\u001a\u0004\u0018\u00010\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001eR\u0013\u0010\u001f\u001a\u0004\u0018\u00010\u000e8F\u00a2\u0006\u0006\u001a\u0004\b \u0010\u001eR\u0014\u0010!\u001a\u00020\"8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b#\u0010$R\u0013\u0010%\u001a\u0004\u0018\u00010&8F\u00a2\u0006\u0006\u001a\u0004\b'\u0010(R\u0013\u0010)\u001a\u0004\u0018\u00010&8F\u00a2\u0006\u0006\u001a\u0004\b*\u0010(RI\u0010+\u001a:\u00124\u00122\u0012\u0013\u0012\u00110-\u00a2\u0006\f\b.\u0012\b\b/\u0012\u0004\b\b(0\u0012\u0013\u0012\u00110-\u00a2\u0006\f\b.\u0012\b\b/\u0012\u0004\b\b(1\u0012\u0004\u0012\u00020\u000e0,\u0018\u00010\u000b8F\u00a2\u0006\u0006\u001a\u0004\b2\u0010\u0010R\u0011\u00103\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b3\u00104R\u0013\u00105\u001a\u0004\u0018\u0001068F\u00a2\u0006\u0006\u001a\u0004\b7\u00108R\u0017\u00109\u001a\b\u0012\u0004\u0012\u00020;0:8F\u00a2\u0006\u0006\u001a\u0004\b<\u0010=R\u0013\u0010>\u001a\u0004\u0018\u00010?8F\u00a2\u0006\u0006\u001a\u0004\b@\u0010AR\u0013\u0010B\u001a\u0004\u0018\u00010\u000e8F\u00a2\u0006\u0006\u001a\u0004\bB\u0010\u001eR\u0013\u0010C\u001a\u0004\u0018\u00010\u000e8F\u00a2\u0006\u0006\u001a\u0004\bC\u0010\u001eR\u0010\u0010_\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R,\u0010\u0081\u0001\u001a\u000e\u0018\u00010\u0082\u0001R\u00070\u0000R\u00030\u0083\u00018BX\u0082\u0084\u0002\u00a2\u0006\u0010\n\u0006\b\u0086\u0001\u0010\u0087\u0001\u001a\u0006\b\u0084\u0001\u0010\u0085\u0001\u00a8\u0006\u00a9\u0001"}, d2={"Landroidx/compose/ui/platform/a11y/ComposeAccessible$ComposeAccessibleComponent;", "Ljavax/accessibility/AccessibleContext;", "Ljavax/accessibility/AccessibleComponent;", "Ljavax/accessibility/AccessibleAction;", "<init>", "(Landroidx/compose/ui/platform/a11y/ComposeAccessible;)V", "textSelectionRange", "Landroidx/compose/ui/text/TextRange;", "getTextSelectionRange-MzsxiRA", "()Landroidx/compose/ui/text/TextRange;", "setText", "Landroidx/compose/ui/semantics/AccessibilityAction;", "Lkotlin/Function1;", "Landroidx/compose/ui/text/AnnotatedString;", "", "getSetText", "()Landroidx/compose/ui/semantics/AccessibilityAction;", "setSelection", "Lkotlin/Function3;", "", "getSetSelection", "text", "getText", "()Landroidx/compose/ui/text/AnnotatedString;", "textLayoutResult", "Landroidx/compose/ui/text/TextLayoutResult;", "getTextLayoutResult", "()Landroidx/compose/ui/text/TextLayoutResult;", "focused", "getFocused", "()Ljava/lang/Boolean;", "selected", "getSelected", "density", "Landroidx/compose/ui/unit/Density;", "getDensity", "()Landroidx/compose/ui/unit/Density;", "horizontalScroll", "Landroidx/compose/ui/semantics/ScrollAxisRange;", "getHorizontalScroll", "()Landroidx/compose/ui/semantics/ScrollAxisRange;", "verticalScroll", "getVerticalScroll", "scrollBy", "Lkotlin/Function2;", "", "Lkotlin/ParameterName;", "name", "x", "y", "getScrollBy", "isPassword", "()Z", "toggleableState", "Landroidx/compose/ui/state/ToggleableState;", "getToggleableState", "()Landroidx/compose/ui/state/ToggleableState;", "auxiliaryChildren", "", "Ljavax/accessibility/Accessible;", "getAuxiliaryChildren", "()Ljava/util/List;", "progressBarRangeInfo", "Landroidx/compose/ui/semantics/ProgressBarRangeInfo;", "getProgressBarRangeInfo", "()Landroidx/compose/ui/semantics/ProgressBarRangeInfo;", "isContainer", "isTraversalGroup", "makeScrollbarChild", "vertical", "toComposeOffset", "Landroidx/compose/ui/geometry/Offset;", "Ljava/awt/Point;", "toComposeOffset-tuRUvjQ", "(Ljava/awt/Point;)J", "toAwtPx", "Landroidx/compose/ui/unit/Dp;", "toAwtPx-0680j_4", "(F)I", "toAwtRectangle", "Ljava/awt/Rectangle;", "Landroidx/compose/ui/geometry/Rect;", "toAwtPoint", "toAwtPoint-k-4lQ0M", "(J)Ljava/awt/Point;", "toAwtDimension", "Ljava/awt/Dimension;", "Landroidx/compose/ui/unit/IntSize;", "toAwtDimension-ozmzZPI", "(J)Ljava/awt/Dimension;", "getAccessibleName", "", "getAccessibleDescription", "getAccessibleParent", "getAccessibleComponent", "accessibleAction", "getAccessibleAction", "getAccessibleValue", "Ljavax/accessibility/AccessibleValue;", "getAccessibleIndexInParent", "getAccessibleChildrenCount", "getAccessibleChild", "i", "getLocale", "Ljava/util/Locale;", "getLocationOnScreen", "getLocation", "getBounds", "getSize", "isVisible", "isEnabled", "isShowing", "contains", "p", "getAccessibleAt", "isFocusTraversable", "requestFocus", "", "addFocusListener", "l", "Ljava/awt/event/FocusListener;", "removeFocusListener", "getAccessibleRole", "Ljavax/accessibility/AccessibleRole;", "getAccessibleStateSet", "Ljavax/accessibility/AccessibleStateSet;", "addCheckedStateForCheckbox", "addCheckedStateForRadioButton", "addDefaultStateForToggleableState", "accessibleText", "Landroidx/compose/ui/platform/a11y/ComposeAccessible$ComposeAccessibleComponent$ComposeAccessibleText;", "Landroidx/compose/ui/platform/a11y/ComposeAccessible;", "getAccessibleText", "()Landroidx/compose/ui/platform/a11y/ComposeAccessible$ComposeAccessibleComponent$ComposeAccessibleText;", "accessibleText$delegate", "Lkotlin/Lazy;", "Ljavax/accessibility/AccessibleText;", "getAccessibleEditableText", "Ljavax/accessibility/AccessibleEditableText;", "setBounds", "r", "setSize", "d", "setLocation", "getBackground", "Ljava/awt/Color;", "setBackground", "c", "getForeground", "setForeground", "getCursor", "Ljava/awt/Cursor;", "setCursor", "cursor", "getFont", "Ljava/awt/Font;", "setFont", "f", "getFontMetrics", "Ljava/awt/FontMetrics;", "setEnabled", "b", "setVisible", "getAccessibleActionCount", "getAccessibleActionDescription", "doAccessibleAction", "ComposeAccessibleText", "ScrollBarAccessible", "ComposeAccessibleEditableText", "ui"})
    @SourceDebugExtension(value={"SMAP\nComposeAccessible.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ComposeAccessible.kt\nandroidx/compose/ui/platform/a11y/ComposeAccessible$ComposeAccessibleComponent\n+ 2 Dp.kt\nandroidx/compose/ui/unit/DpKt\n+ 3 Offset.kt\nandroidx/compose/ui/geometry/OffsetKt\n+ 4 InlineClassHelper.kt\nandroidx/compose/ui/util/InlineClassHelperKt\n+ 5 Rect.kt\nandroidx/compose/ui/geometry/Rect\n+ 6 Offset.kt\nandroidx/compose/ui/geometry/Offset\n+ 7 InlineClassHelper.jvm.kt\nandroidx/compose/ui/util/InlineClassHelper_jvmKt\n+ 8 IntSize.kt\nandroidx/compose/ui/unit/IntSize\n+ 9 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 10 NodeKind.kt\nandroidx/compose/ui/node/Nodes\n*L\n1#1,935:1\n113#2:936\n30#3:937\n53#4,3:938\n60#4:944\n70#4:947\n85#4:950\n90#4:952\n56#5:941\n61#5:942\n65#6:943\n69#6:946\n22#7:945\n22#7:948\n54#8:949\n59#8:951\n360#9,7:953\n91#10:960\n*S KotlinDebug\n*F\n+ 1 ComposeAccessible.kt\nandroidx/compose/ui/platform/a11y/ComposeAccessible$ComposeAccessibleComponent\n*L\n224#1:936\n224#1:937\n224#1:938,3\n241#1:944\n242#1:947\n248#1:950\n249#1:952\n234#1:941\n235#1:942\n241#1:943\n242#1:946\n241#1:945\n242#1:948\n248#1:949\n249#1:951\n330#1:953,7\n367#1:960\n*E\n"})
    public class ComposeAccessibleComponent
    extends AccessibleContext
    implements AccessibleComponent,
    AccessibleAction {
        @Nullable
        private AccessibleAction accessibleAction;
        @NotNull
        private final Lazy accessibleText$delegate = LazyKt.lazy(() -> ComposeAccessibleComponent.accessibleText_delegate$lambda$13(this));

        @Nullable
        public final TextRange getTextSelectionRange-MzsxiRA() {
            return SemanticsConfigurationKt.getOrNull(ComposeAccessible.this.getSemanticsConfig(), SemanticsProperties.INSTANCE.getTextSelectionRange());
        }

        @Nullable
        public final AccessibilityAction<Function1<AnnotatedString, Boolean>> getSetText() {
            return SemanticsConfigurationKt.getOrNull(ComposeAccessible.this.getSemanticsConfig(), SemanticsActions.INSTANCE.getSetText());
        }

        @Nullable
        public final AccessibilityAction<Function3<Integer, Integer, Boolean, Boolean>> getSetSelection() {
            return SemanticsConfigurationKt.getOrNull(ComposeAccessible.this.getSemanticsConfig(), SemanticsActions.INSTANCE.getSetSelection());
        }

        @Nullable
        public final AnnotatedString getText() {
            AnnotatedString annotatedString = SemanticsConfigurationKt.getOrNull(ComposeAccessible.this.getSemanticsConfig(), SemanticsProperties.INSTANCE.getEditableText());
            if (annotatedString == null) {
                annotatedString = (AnnotatedString)ComposeAccessibleKt.access$getFirstOrNull(ComposeAccessible.this.getSemanticsConfig(), SemanticsProperties.INSTANCE.getText());
            }
            return annotatedString;
        }

        @Nullable
        public final TextLayoutResult getTextLayoutResult() {
            Function1<List<TextLayoutResult>, Boolean> function1;
            List textLayoutResults = new ArrayList();
            AccessibilityAction<Function1<List<TextLayoutResult>, Boolean>> accessibilityAction = SemanticsConfigurationKt.getOrNull(ComposeAccessible.this.getSemanticsConfig(), SemanticsActions.INSTANCE.getGetTextLayoutResult());
            Boolean getLayoutResult = accessibilityAction != null && (function1 = accessibilityAction.getAction()) != null ? function1.invoke(textLayoutResults) : null;
            return Intrinsics.areEqual(getLayoutResult, true) ? (TextLayoutResult)textLayoutResults.get(0) : null;
        }

        @Nullable
        public final Boolean getFocused() {
            return SemanticsConfigurationKt.getOrNull(ComposeAccessible.this.getSemanticsConfig(), SemanticsProperties.INSTANCE.getFocused());
        }

        @Nullable
        public final Boolean getSelected() {
            return SemanticsConfigurationKt.getOrNull(ComposeAccessible.this.getSemanticsConfig(), SemanticsProperties.INSTANCE.getSelected());
        }

        private final Density getDensity() {
            return ComposeAccessible.this.controller.getDesktopComponent().getDensity();
        }

        @Nullable
        public final ScrollAxisRange getHorizontalScroll() {
            return SemanticsConfigurationKt.getOrNull(ComposeAccessible.this.getSemanticsConfig(), SemanticsProperties.INSTANCE.getHorizontalScrollAxisRange());
        }

        @Nullable
        public final ScrollAxisRange getVerticalScroll() {
            return SemanticsConfigurationKt.getOrNull(ComposeAccessible.this.getSemanticsConfig(), SemanticsProperties.INSTANCE.getVerticalScrollAxisRange());
        }

        @Nullable
        public final AccessibilityAction<Function2<Float, Float, Boolean>> getScrollBy() {
            return SemanticsConfigurationKt.getOrNull(ComposeAccessible.this.getSemanticsConfig(), SemanticsActions.INSTANCE.getScrollBy());
        }

        public final boolean isPassword() {
            return SemanticsConfigurationKt.getOrNull(ComposeAccessible.this.getSemanticsConfig(), SemanticsProperties.INSTANCE.getPassword()) != null;
        }

        @Nullable
        public final ToggleableState getToggleableState() {
            return SemanticsConfigurationKt.getOrNull(ComposeAccessible.this.getSemanticsConfig(), SemanticsProperties.INSTANCE.getToggleableState());
        }

        @NotNull
        public final List<Accessible> getAuxiliaryChildren() {
            List<Accessible> list2;
            block1: {
                ScrollAxisRange it;
                List<Accessible> $this$_get_auxiliaryChildren__u24lambda_u242 = list2 = CollectionsKt.createListBuilder();
                boolean bl = false;
                ScrollAxisRange scrollAxisRange = this.getHorizontalScroll();
                if (scrollAxisRange != null) {
                    it = scrollAxisRange;
                    boolean bl2 = false;
                    $this$_get_auxiliaryChildren__u24lambda_u242.add(this.makeScrollbarChild(false));
                }
                ScrollAxisRange scrollAxisRange2 = this.getVerticalScroll();
                if (scrollAxisRange2 == null) break block1;
                it = scrollAxisRange2;
                boolean bl3 = false;
                $this$_get_auxiliaryChildren__u24lambda_u242.add(this.makeScrollbarChild(true));
            }
            return CollectionsKt.build(list2);
        }

        @Nullable
        public final ProgressBarRangeInfo getProgressBarRangeInfo() {
            return SemanticsConfigurationKt.getOrNull(ComposeAccessible.this.getSemanticsConfig(), SemanticsProperties.INSTANCE.getProgressBarRangeInfo());
        }

        @Nullable
        public final Boolean isContainer() {
            return SemanticsConfigurationKt.getOrNull(ComposeAccessible.this.getSemanticsConfig(), SemanticsProperties.INSTANCE.getIsContainer());
        }

        @Nullable
        public final Boolean isTraversalGroup() {
            return SemanticsConfigurationKt.getOrNull(ComposeAccessible.this.getSemanticsConfig(), SemanticsProperties.INSTANCE.getIsTraversalGroup());
        }

        private final Accessible makeScrollbarChild(boolean vertical) {
            ScrollBarAccessible bar = new ScrollBarAccessible(vertical);
            AccessibleRelation controlledBy = new AccessibleRelation(AccessibleRelation.CONTROLLED_BY, bar);
            AccessibleRelation controllerFor = new AccessibleRelation(AccessibleRelation.CONTROLLER_FOR, ComposeAccessible.this);
            bar.getContext().getAccessibleRelationSet().add(controllerFor);
            this.getAccessibleRelationSet().add(controlledBy);
            return bar;
        }

        /*
         * WARNING - void declaration
         */
        private final long toComposeOffset-tuRUvjQ(Point $this$toComposeOffset_u2dtuRUvjQ) {
            void x$iv;
            Density $this$toComposeOffset_tuRUvjQ_u24lambda_u243 = this.getDensity();
            boolean bl = false;
            int $this$dp$iv22 = $this$toComposeOffset_u2dtuRUvjQ.x;
            boolean $i$f$getDp = false;
            float $this$dp$iv22 = $this$toComposeOffset_tuRUvjQ_u24lambda_u243.toPx-0680j_4(Dp.constructor-impl($this$dp$iv22));
            int $this$dp$iv = $this$toComposeOffset_u2dtuRUvjQ.y;
            boolean $i$f$getDp2 = false;
            float y$iv = $this$toComposeOffset_tuRUvjQ_u24lambda_u243.toPx-0680j_4(Dp.constructor-impl($this$dp$iv));
            boolean $i$f$Offset = false;
            boolean $i$f$packFloats = false;
            long v1$iv$iv = Float.floatToRawIntBits((float)x$iv);
            long v2$iv$iv = Float.floatToRawIntBits(y$iv);
            return Offset.constructor-impl(v1$iv$iv << 32 | v2$iv$iv & 0xFFFFFFFFL);
        }

        private final int toAwtPx-0680j_4(float $this$toAwtPx_u2d0680j_4) {
            return Float.isInfinite($this$toAwtPx_u2d0680j_4) ? Integer.MAX_VALUE : MathKt.roundToInt($this$toAwtPx_u2d0680j_4);
        }

        private final Rectangle toAwtRectangle(Rect $this$toAwtRectangle) {
            Density $this$toAwtRectangle_u24lambda_u244 = this.getDensity();
            boolean bl = false;
            Rect this_$iv = $this$toAwtRectangle;
            boolean $i$f$getWidth = false;
            int n = this.toAwtPx-0680j_4($this$toAwtRectangle_u24lambda_u244.toDp-u2uoSUM(this_$iv.getRight() - this_$iv.getLeft()));
            this_$iv = $this$toAwtRectangle;
            boolean $i$f$getHeight = false;
            return new Rectangle(this.toAwtPx-0680j_4($this$toAwtRectangle_u24lambda_u244.toDp-u2uoSUM($this$toAwtRectangle.getLeft())), this.toAwtPx-0680j_4($this$toAwtRectangle_u24lambda_u244.toDp-u2uoSUM($this$toAwtRectangle.getTop())), n, this.toAwtPx-0680j_4($this$toAwtRectangle_u24lambda_u244.toDp-u2uoSUM(this_$iv.getBottom() - this_$iv.getTop())));
        }

        private final Point toAwtPoint-k-4lQ0M(long $this$toAwtPoint_u2dk_u2d4lQ0M) {
            Density $this$toAwtPoint_k_4lQ0M_u24lambda_u245 = this.getDensity();
            boolean bl = false;
            boolean bl2 = false;
            long value$iv$iv = $this$toAwtPoint_u2dk_u2d4lQ0M;
            boolean $i$f$unpackFloat1 = false;
            int bits$iv$iv$iv = (int)(value$iv$iv >> 32);
            boolean $i$f$floatFromBits = false;
            int n = this.toAwtPx-0680j_4($this$toAwtPoint_k_4lQ0M_u24lambda_u245.toDp-u2uoSUM(Float.intBitsToFloat(bits$iv$iv$iv)));
            boolean bl3 = false;
            value$iv$iv = $this$toAwtPoint_u2dk_u2d4lQ0M;
            boolean $i$f$unpackFloat2 = false;
            bits$iv$iv$iv = (int)(value$iv$iv & 0xFFFFFFFFL);
            $i$f$floatFromBits = false;
            return new Point(n, this.toAwtPx-0680j_4($this$toAwtPoint_k_4lQ0M_u24lambda_u245.toDp-u2uoSUM(Float.intBitsToFloat(bits$iv$iv$iv))));
        }

        private final Dimension toAwtDimension-ozmzZPI(long $this$toAwtDimension_u2dozmzZPI) {
            Density $this$toAwtDimension_ozmzZPI_u24lambda_u246 = this.getDensity();
            boolean bl = false;
            boolean bl2 = false;
            long value$iv$iv = $this$toAwtDimension_u2dozmzZPI;
            boolean $i$f$unpackInt1 = false;
            int n = this.toAwtPx-0680j_4($this$toAwtDimension_ozmzZPI_u24lambda_u246.toDp-u2uoSUM((int)(value$iv$iv >> 32)));
            boolean bl3 = false;
            value$iv$iv = $this$toAwtDimension_u2dozmzZPI;
            boolean $i$f$unpackInt2 = false;
            return new Dimension(n, this.toAwtPx-0680j_4($this$toAwtDimension_ozmzZPI_u24lambda_u246.toDp-u2uoSUM((int)(value$iv$iv & 0xFFFFFFFFL))));
        }

        @Override
        @Nullable
        public String getAccessibleName() {
            AnnotatedString annotatedString = this.getText();
            return annotatedString != null ? annotatedString.toString() : null;
        }

        @Override
        @Nullable
        public String getAccessibleDescription() {
            return (String)ComposeAccessibleKt.access$getFirstOrNull(ComposeAccessible.this.getSemanticsConfig(), SemanticsProperties.INSTANCE.getContentDescription());
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        @Nullable
        public Accessible getAccessibleParent() {
            Accessible accessible;
            Object object = ComposeAccessible.this.getSemanticsNode().getParent();
            if (object != null) {
                int n = ((SemanticsNode)object).getId();
                ComposeAccessible composeAccessible = ComposeAccessible.this;
                int id = n;
                boolean bl = false;
                ComposeAccessible composeAccessible2 = composeAccessible.controller.accessibleByNodeId(id);
                Intrinsics.checkNotNull(composeAccessible2);
                object = composeAccessible2;
                if (composeAccessible2 != null) {
                    accessible = (Accessible)object;
                    return accessible;
                }
            }
            accessible = this.accessibleParent;
            return accessible;
        }

        @Override
        @Nullable
        public AccessibleComponent getAccessibleComponent() {
            return this;
        }

        @Override
        @Nullable
        public AccessibleAction getAccessibleAction() {
            List actions = new ArrayList();
            AccessibilityAction<Function0<Boolean>> accessibilityAction = SemanticsConfigurationKt.getOrNull(ComposeAccessible.this.getSemanticsConfig(), SemanticsActions.INSTANCE.getOnClick());
            if (accessibilityAction != null) {
                AccessibilityAction<Function0<Boolean>> it = accessibilityAction;
                boolean bl = false;
                actions.add(new Pair<String, SemanticsPropertyKey<AccessibilityAction<Function0<Boolean>>>>("click", SemanticsActions.INSTANCE.getOnClick()));
            }
            ComposeAccessibleComponent.getAccessibleAction$addActionIfExist(ComposeAccessible.this, actions, SemanticsActions.INSTANCE.getOnLongClick());
            ComposeAccessibleComponent.getAccessibleAction$addActionIfExist(ComposeAccessible.this, actions, SemanticsActions.INSTANCE.getExpand());
            ComposeAccessibleComponent.getAccessibleAction$addActionIfExist(ComposeAccessible.this, actions, SemanticsActions.INSTANCE.getCollapse());
            ComposeAccessibleComponent.getAccessibleAction$addActionIfExist(ComposeAccessible.this, actions, SemanticsActions.INSTANCE.getDismiss());
            if (actions.isEmpty()) {
                return null;
            }
            this.accessibleAction = new AccessibleAction(actions, ComposeAccessible.this){
                final /* synthetic */ List<Pair<String, SemanticsPropertyKey<AccessibilityAction<Function0<Boolean>>>>> $actions;
                final /* synthetic */ ComposeAccessible this$0;
                {
                    this.$actions = $actions;
                    this.this$0 = $receiver;
                }

                public int getAccessibleActionCount() {
                    return this.$actions.size();
                }

                public String getAccessibleActionDescription(int i2) {
                    String label2 = this.$actions.get(i2).component1();
                    return label2;
                }

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public boolean doAccessibleAction(int i2) {
                    SemanticsPropertyKey<AccessibilityAction<Function0<Boolean>>> actionKey = this.$actions.get(i2).component2();
                    AccessibilityAction<Function0<Boolean>> accessibilityAction = SemanticsConfigurationKt.getOrNull(ComposeAccessible.access$getSemanticsConfig(this.this$0), actionKey);
                    Object object = accessibilityAction;
                    if (accessibilityAction == null) return false;
                    AccessibilityAction<Function0<Boolean>> it = object;
                    boolean bl = false;
                    Function0<Boolean> function0 = it.getAction();
                    if (function0 == null) return false;
                    Boolean bl2 = function0.invoke();
                    object = bl2;
                    if (bl2 == null) return false;
                    boolean bl3 = (Boolean)object;
                    return bl3;
                }
            };
            return this.accessibleAction;
        }

        @Override
        @Nullable
        public AccessibleValue getAccessibleValue() {
            AccessibleValue accessibleValue;
            Role role = SemanticsConfigurationKt.getOrNull(ComposeAccessible.this.getSemanticsConfig(), SemanticsProperties.INSTANCE.getRole());
            if (this.getToggleableState() != null) {
                accessibleValue = new ToggleableAccessibleValue(this);
            } else {
                int n = Role.Companion.getRadioButton-o7Vup1c();
                Role role2 = role;
                accessibleValue = (role2 == null ? false : Role.equals-impl0(role2.unbox-impl(), n)) ? (AccessibleValue)new RadioButtonAccessibleValue(this) : (this.getProgressBarRangeInfo() != null ? (AccessibleValue)new ProgressBarAccessibleValue(this) : null);
            }
            return accessibleValue;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public int getAccessibleIndexInParent() {
            int n;
            block4: {
                List<SemanticsNode> parentChildren;
                SemanticsNode semanticsNode = ComposeAccessible.this.getSemanticsNode().getParent();
                List<SemanticsNode> list2 = parentChildren = semanticsNode != null ? semanticsNode.getReplacedChildren$ui() : null;
                if (list2 != null) {
                    void $this$indexOfFirst$iv;
                    List<SemanticsNode> list3 = list2;
                    ComposeAccessible composeAccessible = ComposeAccessible.this;
                    boolean $i$f$indexOfFirst = false;
                    int index$iv = 0;
                    for (Object item$iv : $this$indexOfFirst$iv) {
                        SemanticsNode it = (SemanticsNode)item$iv;
                        boolean bl = false;
                        if (it.getId() == composeAccessible.getSemanticsNode().getId()) {
                            n = index$iv;
                            break block4;
                        }
                        ++index$iv;
                    }
                    n = -1;
                } else {
                    n = -1;
                }
            }
            return n;
        }

        @Override
        public int getAccessibleChildrenCount() {
            return ComposeAccessible.this.getSemanticsNode().getReplacedChildren$ui().size() + this.getAuxiliaryChildren().size();
        }

        @Override
        @Nullable
        public Accessible getAccessibleChild(int i2) {
            List<SemanticsNode> replacedChildren = ComposeAccessible.this.getSemanticsNode().getReplacedChildren$ui();
            int replacedChildrenSize = replacedChildren.size();
            return i2 < replacedChildrenSize ? (Accessible)ComposeAccessible.this.controller.accessibleByNodeId(replacedChildren.get(i2).getId()) : this.getAuxiliaryChildren().get(i2 - replacedChildrenSize);
        }

        @Override
        @NotNull
        public Locale getLocale() {
            Locale locale = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue(locale, "getDefault(...)");
            return locale;
        }

        @Override
        @NotNull
        public Point getLocationOnScreen() {
            return this.toAwtPoint-k-4lQ0M(ComposeAccessible.this.getSemanticsNode().getPositionOnScreen-F1C5BW0());
        }

        @Override
        @NotNull
        public Point getLocation() {
            return this.toAwtPoint-k-4lQ0M(ComposeAccessible.this.getSemanticsNode().getPositionInRoot-F1C5BW0());
        }

        @Override
        @NotNull
        public Rectangle getBounds() {
            return this.toAwtRectangle(ComposeAccessible.this.getSemanticsNode().getBoundsInRoot());
        }

        @Override
        @NotNull
        public Dimension getSize() {
            return this.toAwtDimension-ozmzZPI(ComposeAccessible.this.getSemanticsNode().getSize-YbymL2g());
        }

        @Override
        public boolean isVisible() {
            boolean bl = false;
            return !DelegatableNodeKt.requireCoordinator-64DMado(ComposeAccessible.this.getSemanticsNode().getOuterSemanticsNode$ui(), NodeKind.constructor-impl(8)).isTransparent() && !ComposeAccessible.this.getSemanticsConfig().contains(SemanticsProperties.INSTANCE.getInvisibleToUser()) && !ComposeAccessible.this.getSemanticsConfig().contains(SemanticsProperties.INSTANCE.getHideFromAccessibility());
        }

        @Override
        public boolean isEnabled() {
            return SemanticsConfigurationKt.getOrNull(ComposeAccessible.this.getSemanticsConfig(), SemanticsProperties.INSTANCE.getDisabled()) == null;
        }

        @Override
        public boolean isShowing() {
            return true;
        }

        @Override
        public boolean contains(@NotNull Point p2) {
            Intrinsics.checkNotNullParameter(p2, "p");
            return this.getBounds().contains(p2);
        }

        @Override
        @Nullable
        public Accessible getAccessibleAt(@NotNull Point p2) {
            Intrinsics.checkNotNullParameter(p2, "p");
            int n = this.getAccessibleChildrenCount();
            for (int i2 = 0; i2 < n; ++i2) {
                AccessibleComponent child;
                Accessible accessible = this.getAccessibleChild(i2);
                Object object = accessible != null ? accessible.getAccessibleContext() : null;
                AccessibleComponent accessibleComponent = child = object instanceof AccessibleComponent ? (AccessibleComponent)object : null;
                if (child == null || (object = child.getAccessibleAt(p2)) == null) continue;
                Object it = object;
                boolean bl = false;
                return it;
            }
            if (this.contains(p2)) {
                return ComposeAccessible.this;
            }
            return null;
        }

        @Override
        public boolean isFocusTraversable() {
            return this.getFocused() != null;
        }

        @Override
        public void requestFocus() {
            Function0<Boolean> function0;
            AccessibilityAction<Function0<Boolean>> accessibilityAction;
            if (Intrinsics.areEqual(this.getFocused(), false) && (accessibilityAction = SemanticsConfigurationKt.getOrNull(ComposeAccessible.this.getSemanticsNode().getUnmergedConfig$ui(), SemanticsActions.INSTANCE.getRequestFocus())) != null && (function0 = accessibilityAction.getAction()) != null) {
                function0.invoke();
            }
        }

        @Override
        public void addFocusListener(@Nullable FocusListener l) {
            System.out.println((Object)"Not implemented: addFocusListener");
            String string2 = "Not yet implemented";
            throw new NotImplementedError("An operation is not implemented: " + string2);
        }

        @Override
        public void removeFocusListener(@Nullable FocusListener l) {
            System.out.println((Object)"Not implemented: removeFocusListener");
            String string2 = "Not yet implemented";
            throw new NotImplementedError("An operation is not implemented: " + string2);
        }

        @Override
        @NotNull
        public AccessibleRole getAccessibleRole() {
            AccessibleRole accessibleRole;
            AccessibilityController.AccessibilityUsage.INSTANCE.notifyInUse();
            Role role = SemanticsConfigurationKt.getOrNull(ComposeAccessible.this.getSemanticsConfig(), SemanticsProperties.INSTANCE.getRole());
            int n = Role.Companion.getButton-o7Vup1c();
            Role role2 = role;
            if (role2 == null ? false : Role.equals-impl0(role2.unbox-impl(), n)) {
                accessibleRole = AccessibleRole.PUSH_BUTTON;
            } else {
                n = Role.Companion.getCheckbox-o7Vup1c();
                Role role3 = role;
                if (role3 == null ? false : Role.equals-impl0(role3.unbox-impl(), n)) {
                    accessibleRole = AccessibleRole.CHECK_BOX;
                } else {
                    n = Role.Companion.getRadioButton-o7Vup1c();
                    Role role4 = role;
                    if (role4 == null ? false : Role.equals-impl0(role4.unbox-impl(), n)) {
                        accessibleRole = AccessibleRole.RADIO_BUTTON;
                    } else {
                        n = Role.Companion.getTab-o7Vup1c();
                        Role role5 = role;
                        if (role5 == null ? false : Role.equals-impl0(role5.unbox-impl(), n)) {
                            accessibleRole = AccessibleRole.PAGE_TAB;
                        } else {
                            n = Role.Companion.getDropdownList-o7Vup1c();
                            Role role6 = role;
                            accessibleRole = (role6 == null ? false : Role.equals-impl0(role6.unbox-impl(), n)) ? AccessibleRole.COMBO_BOX : null;
                        }
                    }
                }
            }
            AccessibleRole fromSemanticRole = accessibleRole;
            AccessibleRole accessibleRole2 = fromSemanticRole;
            if (accessibleRole2 == null) {
                if (this.isPassword()) {
                    AccessibleRole accessibleRole3 = AccessibleRole.PASSWORD_TEXT;
                    accessibleRole2 = accessibleRole3;
                    Intrinsics.checkNotNullExpressionValue(accessibleRole3, "PASSWORD_TEXT");
                } else if (this.getScrollBy() != null) {
                    AccessibleRole accessibleRole4 = AccessibleRole.SCROLL_PANE;
                    accessibleRole2 = accessibleRole4;
                    Intrinsics.checkNotNullExpressionValue(accessibleRole4, "SCROLL_PANE");
                } else if (this.getSetText() != null) {
                    AccessibleRole accessibleRole5 = AccessibleRole.TEXT;
                    accessibleRole2 = accessibleRole5;
                    Intrinsics.checkNotNullExpressionValue(accessibleRole5, "TEXT");
                } else if (this.getText() != null) {
                    AccessibleRole accessibleRole6 = AccessibleRole.LABEL;
                    accessibleRole2 = accessibleRole6;
                    Intrinsics.checkNotNullExpressionValue(accessibleRole6, "LABEL");
                } else if (this.getProgressBarRangeInfo() != null) {
                    AccessibleRole accessibleRole7 = AccessibleRole.PROGRESS_BAR;
                    accessibleRole2 = accessibleRole7;
                    Intrinsics.checkNotNullExpressionValue(accessibleRole7, "PROGRESS_BAR");
                } else if (this.isContainer() != null) {
                    AccessibleRole accessibleRole8 = AccessibleRole.GROUP_BOX;
                    accessibleRole2 = accessibleRole8;
                    Intrinsics.checkNotNullExpressionValue(accessibleRole8, "GROUP_BOX");
                } else if (this.isTraversalGroup() != null) {
                    AccessibleRole accessibleRole9 = AccessibleRole.GROUP_BOX;
                    accessibleRole2 = accessibleRole9;
                    Intrinsics.checkNotNullExpressionValue(accessibleRole9, "GROUP_BOX");
                } else {
                    AccessibleRole accessibleRole10 = AccessibleRole.UNKNOWN;
                    accessibleRole2 = accessibleRole10;
                    Intrinsics.checkNotNullExpressionValue(accessibleRole10, "UNKNOWN");
                }
            }
            return accessibleRole2;
        }

        @Override
        @NotNull
        public AccessibleStateSet getAccessibleStateSet() {
            boolean canCollapse;
            AccessibleStateSet accessibleStateSet = new AccessibleStateSet();
            ComposeAccessible composeAccessible = ComposeAccessible.this;
            AccessibleStateSet $this$getAccessibleStateSet_u24lambda_u2412 = accessibleStateSet;
            boolean bl = false;
            if (this.isEnabled()) {
                $this$getAccessibleStateSet_u24lambda_u2412.add(AccessibleState.ENABLED);
            }
            if (this.isShowing()) {
                $this$getAccessibleStateSet_u24lambda_u2412.add(AccessibleState.SHOWING);
            }
            if (this.isVisible()) {
                $this$getAccessibleStateSet_u24lambda_u2412.add(AccessibleState.VISIBLE);
            }
            if (this.isFocusTraversable()) {
                $this$getAccessibleStateSet_u24lambda_u2412.add(AccessibleState.FOCUSABLE);
            }
            if (Intrinsics.areEqual(this.getFocused(), true)) {
                $this$getAccessibleStateSet_u24lambda_u2412.add(AccessibleState.FOCUSED);
            }
            boolean canExpand = SemanticsConfigurationKt.getOrNull(composeAccessible.getSemanticsConfig(), SemanticsActions.INSTANCE.getExpand()) != null;
            boolean bl2 = canCollapse = SemanticsConfigurationKt.getOrNull(composeAccessible.getSemanticsConfig(), SemanticsActions.INSTANCE.getCollapse()) != null;
            if (canExpand || canCollapse) {
                $this$getAccessibleStateSet_u24lambda_u2412.add(AccessibleState.EXPANDABLE);
            }
            if (canExpand) {
                $this$getAccessibleStateSet_u24lambda_u2412.add(AccessibleState.COLLAPSED);
            }
            if (canCollapse) {
                $this$getAccessibleStateSet_u24lambda_u2412.add(AccessibleState.EXPANDED);
            }
            Role role = SemanticsConfigurationKt.getOrNull(composeAccessible.getSemanticsConfig(), SemanticsProperties.INSTANCE.getRole());
            int n = Role.Companion.getCheckbox-o7Vup1c();
            Role role2 = role;
            if (role2 == null ? false : Role.equals-impl0(role2.unbox-impl(), n)) {
                this.addCheckedStateForCheckbox($this$getAccessibleStateSet_u24lambda_u2412);
            } else {
                n = Role.Companion.getRadioButton-o7Vup1c();
                Role role3 = role;
                if (role3 == null ? false : Role.equals-impl0(role3.unbox-impl(), n)) {
                    this.addCheckedStateForRadioButton($this$getAccessibleStateSet_u24lambda_u2412);
                } else {
                    this.addDefaultStateForToggleableState($this$getAccessibleStateSet_u24lambda_u2412);
                    if (this.getSelected() != null) {
                        $this$getAccessibleStateSet_u24lambda_u2412.add(AccessibleState.SELECTABLE);
                    }
                    if (Intrinsics.areEqual(this.getSelected(), true)) {
                        $this$getAccessibleStateSet_u24lambda_u2412.add(AccessibleState.SELECTED);
                    }
                }
            }
            return accessibleStateSet;
        }

        private final void addCheckedStateForCheckbox(AccessibleStateSet $this$addCheckedStateForCheckbox) {
            this.addDefaultStateForToggleableState($this$addCheckedStateForCheckbox);
        }

        private final void addCheckedStateForRadioButton(AccessibleStateSet $this$addCheckedStateForRadioButton) {
            if (Intrinsics.areEqual(this.getSelected(), true)) {
                $this$addCheckedStateForRadioButton.add(AccessibleState.CHECKED);
            }
        }

        private final void addDefaultStateForToggleableState(AccessibleStateSet $this$addDefaultStateForToggleableState) {
            AccessibleState accessibleState;
            ToggleableState toggleableState = this.getToggleableState();
            switch (toggleableState == null ? -1 : WhenMappings.$EnumSwitchMapping$0[toggleableState.ordinal()]) {
                case 1: {
                    accessibleState = AccessibleState.CHECKED;
                    break;
                }
                case 2: {
                    accessibleState = AccessibleState.INDETERMINATE;
                    break;
                }
                case -1: 
                case 3: {
                    accessibleState = null;
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            AccessibleState state2 = accessibleState;
            if (state2 != null) {
                $this$addDefaultStateForToggleableState.add(state2);
            }
        }

        @Override
        private final ComposeAccessibleText getAccessibleText() {
            Lazy lazy = this.accessibleText$delegate;
            return (ComposeAccessibleText)lazy.getValue();
        }

        @Override
        @Nullable
        public AccessibleText getAccessibleText() {
            return this.getAccessibleText();
        }

        @Override
        @Nullable
        public AccessibleEditableText getAccessibleEditableText() {
            ComposeAccessibleText accessibleText = this.getAccessibleText();
            return accessibleText instanceof AccessibleEditableText ? (AccessibleEditableText)((Object)accessibleText) : null;
        }

        @Override
        public void setBounds(@Nullable Rectangle r) {
            System.out.println((Object)"Not implemented: setBounds");
            String string2 = "Not yet implemented";
            throw new NotImplementedError("An operation is not implemented: " + string2);
        }

        @Override
        public void setSize(@Nullable Dimension d) {
            System.out.println((Object)"Not implemented: setSize");
            String string2 = "Not yet implemented";
            throw new NotImplementedError("An operation is not implemented: " + string2);
        }

        @Override
        public void setLocation(@Nullable Point p2) {
            System.out.println((Object)"Not implemented: setLocation");
            String string2 = "Not yet implemented";
            throw new NotImplementedError("An operation is not implemented: " + string2);
        }

        @Override
        @NotNull
        public Color getBackground() {
            System.out.println((Object)"Not implemented: getBackground");
            String string2 = "Not yet implemented";
            throw new NotImplementedError("An operation is not implemented: " + string2);
        }

        @Override
        public void setBackground(@Nullable Color c) {
            System.out.println((Object)"Not implemented: setBackground");
            String string2 = "Not yet implemented";
            throw new NotImplementedError("An operation is not implemented: " + string2);
        }

        @Override
        @NotNull
        public Color getForeground() {
            System.out.println((Object)"Not implemented: getForeground");
            String string2 = "Not yet implemented";
            throw new NotImplementedError("An operation is not implemented: " + string2);
        }

        @Override
        public void setForeground(@Nullable Color c) {
            System.out.println((Object)"Not implemented: setForeground");
            String string2 = "Not yet implemented";
            throw new NotImplementedError("An operation is not implemented: " + string2);
        }

        @Override
        @NotNull
        public Cursor getCursor() {
            System.out.println((Object)"Not implemented: getCursor");
            String string2 = "Not yet implemented";
            throw new NotImplementedError("An operation is not implemented: " + string2);
        }

        @Override
        public void setCursor(@Nullable Cursor cursor2) {
            System.out.println((Object)"Not implemented: setCursor");
            String string2 = "Not yet implemented";
            throw new NotImplementedError("An operation is not implemented: " + string2);
        }

        @Override
        @NotNull
        public Font getFont() {
            System.out.println((Object)"Not implemented: getFont");
            String string2 = "Not yet implemented";
            throw new NotImplementedError("An operation is not implemented: " + string2);
        }

        @Override
        public void setFont(@Nullable Font f) {
            System.out.println((Object)"Not implemented: setFont");
            String string2 = "Not yet implemented";
            throw new NotImplementedError("An operation is not implemented: " + string2);
        }

        @Override
        @NotNull
        public FontMetrics getFontMetrics(@Nullable Font f) {
            System.out.println((Object)"Not implemented: getFontMetrics");
            String string2 = "Not yet implemented";
            throw new NotImplementedError("An operation is not implemented: " + string2);
        }

        @Override
        public void setEnabled(boolean b2) {
            System.out.println((Object)"Not implemented: setEnabled");
            String string2 = "Not yet implemented";
            throw new NotImplementedError("An operation is not implemented: " + string2);
        }

        @Override
        public void setVisible(boolean b2) {
            System.out.println((Object)"Not implemented: setVisible");
            String string2 = "Not yet implemented";
            throw new NotImplementedError("An operation is not implemented: " + string2);
        }

        @Override
        public int getAccessibleActionCount() {
            AccessibleAction accessibleAction = this.accessibleAction;
            return accessibleAction != null ? accessibleAction.getAccessibleActionCount() : 0;
        }

        @Override
        @NotNull
        public String getAccessibleActionDescription(int i2) {
            Object object = this.accessibleAction;
            if (object == null || (object = object.getAccessibleActionDescription(i2)) == null) {
                object = "";
            }
            return object;
        }

        @Override
        public boolean doAccessibleAction(int i2) {
            AccessibleAction accessibleAction = this.accessibleAction;
            return accessibleAction != null ? accessibleAction.doAccessibleAction(i2) : false;
        }

        private static final void getAccessibleAction$addActionIfExist(ComposeAccessible this$0, List<Pair<String, SemanticsPropertyKey<AccessibilityAction<Function0<Boolean>>>>> actions, SemanticsPropertyKey<AccessibilityAction<Function0<Boolean>>> key) {
            block0: {
                AccessibilityAction<Function0<Boolean>> accessibilityAction = SemanticsConfigurationKt.getOrNull(this$0.getSemanticsConfig(), key);
                if (accessibilityAction == null) break block0;
                AccessibilityAction<Function0<Boolean>> it = accessibilityAction;
                boolean bl = false;
                actions.add(new Pair<String, SemanticsPropertyKey<AccessibilityAction<Function0<Boolean>>>>(it.getLabel(), key));
            }
        }

        private static final ComposeAccessibleText accessibleText_delegate$lambda$13(ComposeAccessibleComponent this$0) {
            return this$0.getSetText() != null ? (ComposeAccessibleText)this$0.new ComposeAccessibleEditableText() : (this$0.getText() != null ? this$0.new ComposeAccessibleText() : null);
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\n0\u0001R\u00060\u0002R\u00020\u00032\u00020\u0004B\u0007\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\rH\u0016J\u0018\u0010\u0011\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\rH\u0016J\u0018\u0010\u0012\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\rH\u0016J\u0010\u0010\u0013\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\rH\u0016J \u0010\u0014\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\u0015\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\rH\u0016J\"\u0010\u0016\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\r2\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0016\u00a8\u0006\u0019"}, d2={"Landroidx/compose/ui/platform/a11y/ComposeAccessible$ComposeAccessibleComponent$ComposeAccessibleEditableText;", "Landroidx/compose/ui/platform/a11y/ComposeAccessible$ComposeAccessibleComponent$ComposeAccessibleText;", "Landroidx/compose/ui/platform/a11y/ComposeAccessible$ComposeAccessibleComponent;", "Landroidx/compose/ui/platform/a11y/ComposeAccessible;", "Ljavax/accessibility/AccessibleEditableText;", "<init>", "(Landroidx/compose/ui/platform/a11y/ComposeAccessible$ComposeAccessibleComponent;)V", "setTextContents", "", "s", "", "insertTextAtIndex", "index", "", "getTextRange", "startIndex", "endIndex", "delete", "cut", "paste", "replaceText", "selectText", "setAttributes", "as", "Ljavax/swing/text/AttributeSet;", "ui"})
        @SourceDebugExtension(value={"SMAP\nComposeAccessible.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ComposeAccessible.kt\nandroidx/compose/ui/platform/a11y/ComposeAccessible$ComposeAccessibleComponent$ComposeAccessibleEditableText\n+ 2 AnnotatedString.kt\nandroidx/compose/ui/text/AnnotatedStringKt\n*L\n1#1,935:1\n1565#2:936\n1565#2:937\n1565#2:938\n*S KotlinDebug\n*F\n+ 1 ComposeAccessible.kt\nandroidx/compose/ui/platform/a11y/ComposeAccessible$ComposeAccessibleComponent$ComposeAccessibleEditableText\n*L\n718#1:936\n733#1:937\n751#1:938\n*E\n"})
        public final class ComposeAccessibleEditableText
        extends ComposeAccessibleText
        implements AccessibleEditableText {
            @Override
            public void setTextContents(@NotNull String s2) {
                Intrinsics.checkNotNullParameter(s2, "s");
                AccessibilityAction<Function1<AnnotatedString, Boolean>> accessibilityAction = ComposeAccessibleComponent.this.getSetText();
                Intrinsics.checkNotNull(accessibilityAction);
                Function1<AnnotatedString, Boolean> function1 = accessibilityAction.getAction();
                Intrinsics.checkNotNull(function1);
                function1.invoke(new AnnotatedString(s2, null, 2, null));
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public void insertTextAtIndex(int index2, @NotNull String s2) {
                void $this$insertTextAtIndex_u24lambda_u240;
                AnnotatedString.Builder builder;
                Intrinsics.checkNotNullParameter(s2, "s");
                AnnotatedString annotatedString = ComposeAccessibleComponent.this.getText();
                Intrinsics.checkNotNull(annotatedString);
                AnnotatedString text = annotatedString;
                AccessibilityAction<Function1<AnnotatedString, Boolean>> accessibilityAction = ComposeAccessibleComponent.this.getSetText();
                Intrinsics.checkNotNull(accessibilityAction);
                Function1<AnnotatedString, Boolean> function1 = accessibilityAction.getAction();
                Intrinsics.checkNotNull(function1);
                boolean $i$f$buildAnnotatedString = false;
                AnnotatedString.Builder builder2 = builder = new AnnotatedString.Builder(0, 1, null);
                Function1<AnnotatedString, Boolean> function12 = function1;
                boolean bl = false;
                $this$insertTextAtIndex_u24lambda_u240.append(text.subSequence(0, index2));
                $this$insertTextAtIndex_u24lambda_u240.append(s2);
                $this$insertTextAtIndex_u24lambda_u240.append(text.subSequence(index2, text.length() - 1));
                function12.invoke(builder.toAnnotatedString());
            }

            @Override
            @NotNull
            public String getTextRange(int startIndex, int endIndex) {
                AnnotatedString annotatedString = ComposeAccessibleComponent.this.getText();
                Intrinsics.checkNotNull(annotatedString);
                return ((Object)((CharSequence)annotatedString).subSequence(startIndex, endIndex)).toString();
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public void delete(int startIndex, int endIndex) {
                void $this$delete_u24lambda_u241;
                AnnotatedString.Builder builder;
                AnnotatedString annotatedString = ComposeAccessibleComponent.this.getText();
                Intrinsics.checkNotNull(annotatedString);
                AnnotatedString text = annotatedString;
                AccessibilityAction<Function1<AnnotatedString, Boolean>> accessibilityAction = ComposeAccessibleComponent.this.getSetText();
                Intrinsics.checkNotNull(accessibilityAction);
                Function1<AnnotatedString, Boolean> function1 = accessibilityAction.getAction();
                Intrinsics.checkNotNull(function1);
                boolean $i$f$buildAnnotatedString = false;
                AnnotatedString.Builder builder2 = builder = new AnnotatedString.Builder(0, 1, null);
                Function1<AnnotatedString, Boolean> function12 = function1;
                boolean bl = false;
                $this$delete_u24lambda_u241.append(text.subSequence(0, startIndex));
                $this$delete_u24lambda_u241.append(text.subSequence(endIndex, text.length() - 1));
                function12.invoke(builder.toAnnotatedString());
            }

            @Override
            public void cut(int startIndex, int endIndex) {
                String string2 = "Not yet implemented";
                throw new NotImplementedError("An operation is not implemented: " + string2);
            }

            @Override
            public void paste(int startIndex) {
                String string2 = "Not yet implemented";
                throw new NotImplementedError("An operation is not implemented: " + string2);
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public void replaceText(int startIndex, int endIndex, @NotNull String s2) {
                void $this$replaceText_u24lambda_u242;
                AnnotatedString.Builder builder;
                Intrinsics.checkNotNullParameter(s2, "s");
                AnnotatedString annotatedString = ComposeAccessibleComponent.this.getText();
                Intrinsics.checkNotNull(annotatedString);
                AnnotatedString text = annotatedString;
                AccessibilityAction<Function1<AnnotatedString, Boolean>> accessibilityAction = ComposeAccessibleComponent.this.getSetText();
                Intrinsics.checkNotNull(accessibilityAction);
                Function1<AnnotatedString, Boolean> function1 = accessibilityAction.getAction();
                Intrinsics.checkNotNull(function1);
                boolean $i$f$buildAnnotatedString = false;
                AnnotatedString.Builder builder2 = builder = new AnnotatedString.Builder(0, 1, null);
                Function1<AnnotatedString, Boolean> function12 = function1;
                boolean bl = false;
                $this$replaceText_u24lambda_u242.append(text.subSequence(0, startIndex));
                $this$replaceText_u24lambda_u242.append(s2);
                $this$replaceText_u24lambda_u242.append(text.subSequence(endIndex, text.length() - 1));
                function12.invoke(builder.toAnnotatedString());
            }

            @Override
            public void selectText(int startIndex, int endIndex) {
                AccessibilityAction<Function3<Integer, Integer, Boolean, Boolean>> accessibilityAction = ComposeAccessibleComponent.this.getSetSelection();
                Intrinsics.checkNotNull(accessibilityAction);
                Function3<Integer, Integer, Boolean, Boolean> function3 = accessibilityAction.getAction();
                Intrinsics.checkNotNull(function3);
                function3.invoke(startIndex, endIndex, false);
            }

            @Override
            public void setAttributes(int startIndex, int endIndex, @Nullable AttributeSet as) {
                System.out.println((Object)"Not implemented: setAttributes");
                String string2 = "Not yet implemented";
                throw new NotImplementedError("An operation is not implemented: " + string2);
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0096\u0004\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0006H\u0016J\b\u0010\f\u001a\u00020\u0006H\u0016J\b\u0010\r\u001a\u00020\u0006H\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0006H\u0002J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u0006H\u0016J\u0018\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u0006H\u0016J\u0018\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u0006H\u0016J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u000b\u001a\u00020\u0006H\u0016J\b\u0010\u0018\u001a\u00020\u0006H\u0016J\b\u0010\u0019\u001a\u00020\u0006H\u0016J\b\u0010\u001a\u001a\u00020\u0012H\u0016J\u0018\u0010\u001b\u001a\u00020\u00122\u0006\u0010\u001c\u001a\u00020\u00062\u0006\u0010\u001d\u001a\u00020\u0006H\u0016J\u0018\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u0006H\u0016J\u0018\u0010 \u001a\u00020\u001f2\u0006\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u0006H\u0016J\u0018\u0010!\u001a\u00020\u001f2\u0006\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u0006H\u0016J\u0018\u0010\"\u001a\u00020\n2\u0006\u0010\u001c\u001a\u00020\u00062\u0006\u0010\u001d\u001a\u00020\u0006H\u0016\u00a8\u0006#"}, d2={"Landroidx/compose/ui/platform/a11y/ComposeAccessible$ComposeAccessibleComponent$ComposeAccessibleText;", "Ljavax/accessibility/AccessibleText;", "Ljavax/accessibility/AccessibleExtendedText;", "<init>", "(Landroidx/compose/ui/platform/a11y/ComposeAccessible$ComposeAccessibleComponent;)V", "getIndexAtPoint", "", "p", "Ljava/awt/Point;", "getCharacterBounds", "Ljava/awt/Rectangle;", "i", "getCharCount", "getCaretPosition", "partToBreakIterator", "Lorg/jetbrains/skia/BreakIterator;", "part", "getAtIndex", "", "index", "getAfterIndex", "getBeforeIndex", "getCharacterAttribute", "Ljavax/swing/text/AttributeSet;", "getSelectionStart", "getSelectionEnd", "getSelectedText", "getTextRange", "startIndex", "endIndex", "getTextSequenceAt", "Ljavax/accessibility/AccessibleTextSequence;", "getTextSequenceAfter", "getTextSequenceBefore", "getTextBounds", "ui"})
        public class ComposeAccessibleText
        implements AccessibleText,
        AccessibleExtendedText {
            @Override
            public int getIndexAtPoint(@NotNull Point p2) {
                Intrinsics.checkNotNullParameter(p2, "p");
                TextLayoutResult textLayoutResult = ComposeAccessibleComponent.this.getTextLayoutResult();
                Intrinsics.checkNotNull(textLayoutResult);
                return textLayoutResult.getOffsetForPosition-k-4lQ0M(ComposeAccessibleComponent.this.toComposeOffset-tuRUvjQ(p2));
            }

            @Override
            @NotNull
            public Rectangle getCharacterBounds(int i2) {
                block3: {
                    block2: {
                        if (i2 < 0) break block2;
                        AnnotatedString annotatedString = ComposeAccessibleComponent.this.getText();
                        Intrinsics.checkNotNull(annotatedString);
                        if (i2 < annotatedString.length()) break block3;
                    }
                    return new Rectangle((int)((float)ComposeAccessibleComponent.this.getLocation().x / ComposeAccessibleComponent.this.getDensity().getDensity()), (int)((float)ComposeAccessibleComponent.this.getLocation().y / ComposeAccessibleComponent.this.getDensity().getDensity()), 0, 0);
                }
                TextLayoutResult textLayoutResult = ComposeAccessibleComponent.this.getTextLayoutResult();
                Intrinsics.checkNotNull(textLayoutResult);
                return ComposeAccessibleComponent.this.toAwtRectangle(textLayoutResult.getBoundingBox(i2));
            }

            @Override
            public int getCharCount() {
                AnnotatedString annotatedString = ComposeAccessibleComponent.this.getText();
                Intrinsics.checkNotNull(annotatedString);
                return annotatedString.length();
            }

            @Override
            public int getCaretPosition() {
                TextRange textRange = ComposeAccessibleComponent.this.getTextSelectionRange-MzsxiRA();
                return textRange != null ? TextRange.getStart-impl(textRange.unbox-impl()) : -1;
            }

            private final BreakIterator partToBreakIterator(int part) {
                BreakIterator breakIterator;
                switch (part) {
                    case 3: {
                        breakIterator = BreakIterator.Companion.makeSentenceInstance$default(BreakIterator.Companion, null, 1, null);
                        break;
                    }
                    case 2: {
                        breakIterator = BreakIterator.Companion.makeWordInstance$default(BreakIterator.Companion, null, 1, null);
                        break;
                    }
                    case 1: {
                        breakIterator = BreakIterator.Companion.makeCharacterInstance$default(BreakIterator.Companion, null, 1, null);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException();
                    }
                }
                BreakIterator iter = breakIterator;
                AnnotatedString annotatedString = ComposeAccessibleComponent.this.getText();
                Intrinsics.checkNotNull(annotatedString);
                iter.setText(annotatedString.toString());
                return iter;
            }

            @Override
            @NotNull
            public String getAtIndex(int part, int index2) {
                String string2;
                int end = this.partToBreakIterator(part).following(index2);
                if (end == -1) {
                    string2 = "";
                } else {
                    AnnotatedString annotatedString = ComposeAccessibleComponent.this.getText();
                    Intrinsics.checkNotNull(annotatedString);
                    string2 = annotatedString.subSequence(index2, end).toString();
                }
                return string2;
            }

            @Override
            @NotNull
            public String getAfterIndex(int part, int index2) {
                BreakIterator iterator2 = this.partToBreakIterator(part);
                int start2 = index2;
                while (true) {
                    if ((start2 = iterator2.following(start2)) == -1) {
                        return "";
                    }
                    AnnotatedString annotatedString = ComposeAccessibleComponent.this.getText();
                    Intrinsics.checkNotNull(annotatedString);
                    if (annotatedString.charAt(start2) == ' ') continue;
                    AnnotatedString annotatedString2 = ComposeAccessibleComponent.this.getText();
                    Intrinsics.checkNotNull(annotatedString2);
                    if (annotatedString2.charAt(start2) != '\n') break;
                }
                int end = iterator2.next();
                int end2 = end == -1 ? iterator2.last() : end;
                AnnotatedString annotatedString = ComposeAccessibleComponent.this.getText();
                Intrinsics.checkNotNull(annotatedString);
                return annotatedString.subSequence(start2, end2).toString();
            }

            @Override
            @NotNull
            public String getBeforeIndex(int part, int index2) {
                String string2;
                int start2 = this.partToBreakIterator(part).preceding(index2);
                if (start2 == -1) {
                    string2 = "";
                } else {
                    AnnotatedString annotatedString = ComposeAccessibleComponent.this.getText();
                    Intrinsics.checkNotNull(annotatedString);
                    string2 = annotatedString.subSequence(start2, index2).toString();
                }
                return string2;
            }

            @Override
            @NotNull
            public AttributeSet getCharacterAttribute(int i2) {
                System.out.println((Object)"Not implemented: getCharacterAttribute");
                return new SimpleAttributeSet();
            }

            @Override
            public int getSelectionStart() {
                TextRange textRange = ComposeAccessibleComponent.this.getTextSelectionRange-MzsxiRA();
                return textRange != null ? TextRange.getStart-impl(textRange.unbox-impl()) : 0;
            }

            @Override
            public int getSelectionEnd() {
                TextRange textRange = ComposeAccessibleComponent.this.getTextSelectionRange-MzsxiRA();
                return textRange != null ? TextRange.getEnd-impl(textRange.unbox-impl()) : 0;
            }

            @Override
            @NotNull
            public String getSelectedText() {
                Object object;
                block3: {
                    block2: {
                        object = ComposeAccessibleComponent.this.getTextSelectionRange-MzsxiRA();
                        if (object == null) break block2;
                        TextRange textRange = object;
                        ComposeAccessibleComponent composeAccessibleComponent = ComposeAccessibleComponent.this;
                        long selection = textRange.unbox-impl();
                        boolean bl = false;
                        AnnotatedString annotatedString = composeAccessibleComponent.getText();
                        Intrinsics.checkNotNull(annotatedString);
                        String string2 = annotatedString.subSequence(TextRange.getStart-impl(selection), TextRange.getEnd-impl(selection)).toString();
                        object = string2;
                        if (string2 != null) break block3;
                    }
                    object = "";
                }
                return object;
            }

            @Override
            @NotNull
            public String getTextRange(int startIndex, int endIndex) {
                AnnotatedString annotatedString = ComposeAccessibleComponent.this.getText();
                Intrinsics.checkNotNull(annotatedString);
                return annotatedString.subSequence(startIndex, endIndex).toString();
            }

            @Override
            @NotNull
            public AccessibleTextSequence getTextSequenceAt(int part, int index2) {
                System.out.println((Object)"Not implemented: getBeforeIndex");
                String string2 = "Not yet implemented";
                throw new NotImplementedError("An operation is not implemented: " + string2);
            }

            @Override
            @NotNull
            public AccessibleTextSequence getTextSequenceAfter(int part, int index2) {
                System.out.println((Object)"Not implemented: getTextSequenceAfter");
                String string2 = "Not yet implemented";
                throw new NotImplementedError("An operation is not implemented: " + string2);
            }

            @Override
            @NotNull
            public AccessibleTextSequence getTextSequenceBefore(int part, int index2) {
                System.out.println((Object)"Not implemented: getTextSequenceBefore");
                String string2 = "Not yet implemented";
                throw new NotImplementedError("An operation is not implemented: " + string2);
            }

            @Override
            @NotNull
            public Rectangle getTextBounds(int startIndex, int endIndex) {
                System.out.println((Object)"Not implemented: getTextBounds");
                String string2 = "Not yet implemented";
                throw new NotImplementedError("An operation is not implemented: " + string2);
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\f\u001a\u00020\tH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\r"}, d2={"Landroidx/compose/ui/platform/a11y/ComposeAccessible$ComposeAccessibleComponent$ScrollBarAccessible;", "Ljavax/accessibility/Accessible;", "vertical", "", "<init>", "(Landroidx/compose/ui/platform/a11y/ComposeAccessible$ComposeAccessibleComponent;Z)V", "getVertical", "()Z", "context", "Ljavax/accessibility/AccessibleContext;", "getContext", "()Ljavax/accessibility/AccessibleContext;", "getAccessibleContext", "ui"})
        public final class ScrollBarAccessible
        implements Accessible {
            private final boolean vertical;
            @NotNull
            private final AccessibleContext context;

            public ScrollBarAccessible(boolean vertical) {
                this.vertical = vertical;
                this.context = (AccessibleContext)((Object)new AccessibleValue(this, ComposeAccessibleComponent.this, ComposeAccessible.this){
                    private final ScrollAxisRange range;
                    final /* synthetic */ ScrollBarAccessible this$0;
                    final /* synthetic */ ComposeAccessibleComponent this$1;
                    final /* synthetic */ ComposeAccessible this$2;
                    {
                        ScrollAxisRange scrollAxisRange;
                        this.this$0 = $receiver;
                        this.this$1 = $receiver2;
                        this.this$2 = $receiver3;
                        if ($receiver.getVertical()) {
                            ScrollAxisRange scrollAxisRange2 = $receiver2.getVerticalScroll();
                            scrollAxisRange = scrollAxisRange2;
                            Intrinsics.checkNotNull(scrollAxisRange2);
                        } else {
                            ScrollAxisRange scrollAxisRange3 = $receiver2.getHorizontalScroll();
                            scrollAxisRange = scrollAxisRange3;
                            Intrinsics.checkNotNull(scrollAxisRange3);
                        }
                        this.range = scrollAxisRange;
                    }

                    public AccessibleValue getAccessibleValue() {
                        return this;
                    }

                    public AccessibleRole getAccessibleRole() {
                        AccessibleRole accessibleRole = AccessibleRole.SCROLL_BAR;
                        Intrinsics.checkNotNullExpressionValue(accessibleRole, "SCROLL_BAR");
                        return accessibleRole;
                    }

                    public AccessibleStateSet getAccessibleStateSet() {
                        AccessibleStateSet accessibleStateSet = new AccessibleStateSet();
                        ScrollBarAccessible scrollBarAccessible = this.this$0;
                        AccessibleStateSet $this$getAccessibleStateSet_u24lambda_u240 = accessibleStateSet;
                        boolean bl = false;
                        $this$getAccessibleStateSet_u24lambda_u240.add(AccessibleState.ENABLED);
                        boolean bl2 = scrollBarAccessible.getVertical() ? $this$getAccessibleStateSet_u24lambda_u240.add(AccessibleState.VERTICAL) : $this$getAccessibleStateSet_u24lambda_u240.add(AccessibleState.HORIZONTAL);
                        return accessibleStateSet;
                    }

                    public Accessible getAccessibleParent() {
                        return this.this$2;
                    }

                    public int getAccessibleIndexInParent() {
                        return this.this$1.getAuxiliaryChildren().indexOf(this.this$0);
                    }

                    public int getAccessibleChildrenCount() {
                        return 0;
                    }

                    public Accessible getAccessibleChild(int i2) {
                        return null;
                    }

                    public Locale getLocale() {
                        Locale locale = Locale.getDefault();
                        Intrinsics.checkNotNullExpressionValue(locale, "getDefault(...)");
                        return locale;
                    }

                    public Number getCurrentAccessibleValue() {
                        return this.range.getValue().invoke();
                    }

                    public boolean setCurrentAccessibleValue(Number n) {
                        boolean bl;
                        if (this.this$0.getVertical()) {
                            AccessibilityAction<Function2<Float, Float, Boolean>> accessibilityAction = this.this$1.getScrollBy();
                            Intrinsics.checkNotNull(accessibilityAction);
                            Function2<Float, Float, Boolean> function2 = accessibilityAction.getAction();
                            Intrinsics.checkNotNull(function2);
                            Float f = Float.valueOf(0.0f);
                            Number number = n;
                            Intrinsics.checkNotNull(number);
                            bl = function2.invoke(f, Float.valueOf(number.floatValue() - ((Number)this.range.getValue().invoke()).floatValue()));
                        } else {
                            AccessibilityAction<Function2<Float, Float, Boolean>> accessibilityAction = this.this$1.getScrollBy();
                            Intrinsics.checkNotNull(accessibilityAction);
                            Function2<Float, Float, Boolean> function2 = accessibilityAction.getAction();
                            Intrinsics.checkNotNull(function2);
                            Number number = n;
                            Intrinsics.checkNotNull(number);
                            bl = function2.invoke(Float.valueOf(number.floatValue() - ((Number)this.range.getValue().invoke()).floatValue()), Float.valueOf(0.0f));
                        }
                        return bl;
                    }

                    public Number getMinimumAccessibleValue() {
                        return 0;
                    }

                    public Number getMaximumAccessibleValue() {
                        return this.range.getMaxValue().invoke();
                    }
                });
            }

            public final boolean getVertical() {
                return this.vertical;
            }

            @NotNull
            public final AccessibleContext getContext() {
                return this.context;
            }

            @Override
            @NotNull
            public AccessibleContext getAccessibleContext() {
                return this.context;
            }
        }

        @Metadata(mv={2, 0, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[ToggleableState.values().length];
                try {
                    nArray[ToggleableState.On.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ToggleableState.Indeterminate.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ToggleableState.Off.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

