/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.semantics;

import androidx.collection.IntObjectMap;
import androidx.collection.IntObjectMapKt;
import androidx.collection.MutableIntObjectMap;
import androidx.compose.ui.geometry.Rect;
import androidx.compose.ui.semantics.SemanticsNode;
import androidx.compose.ui.semantics.SemanticsNodeWithAdjustedBounds;
import androidx.compose.ui.semantics.SemanticsOwner;
import androidx.compose.ui.semantics.SemanticsProperties;
import androidx.compose.ui.semantics.SemanticsRegion;
import androidx.compose.ui.semantics.SemanticsRegion_skikoKt;
import androidx.compose.ui.unit.IntRect;
import androidx.compose.ui.unit.IntRectKt;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000(\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\u001a\f\u0010\u0000\u001a\u00020\u0001*\u00020\u0002H\u0000\u001a\u001a\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n*\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0000\"\u001e\u0010\u0003\u001a\u00020\u0001*\u00020\u00028@X\u0080\u0004\u00a2\u0006\f\u0012\u0004\b\u0004\u0010\u0005\u001a\u0004\b\u0003\u0010\u0006\"\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"isImportantForAccessibility", "", "Landroidx/compose/ui/semantics/SemanticsNode;", "isHidden", "isHidden$annotations", "(Landroidx/compose/ui/semantics/SemanticsNode;)V", "(Landroidx/compose/ui/semantics/SemanticsNode;)Z", "DefaultFakeNodeBounds", "Landroidx/compose/ui/geometry/Rect;", "getAllUncoveredSemanticsNodesToIntObjectMap", "Landroidx/collection/IntObjectMap;", "Landroidx/compose/ui/semantics/SemanticsNodeWithAdjustedBounds;", "Landroidx/compose/ui/semantics/SemanticsOwner;", "customRootNodeId", "", "ui"})
public final class SemanticsOwner_skikoKt {
    @NotNull
    private static final Rect DefaultFakeNodeBounds = new Rect(0.0f, 0.0f, 10.0f, 10.0f);

    public static final boolean isImportantForAccessibility(@NotNull SemanticsNode $this$isImportantForAccessibility) {
        Intrinsics.checkNotNullParameter($this$isImportantForAccessibility, "<this>");
        return !SemanticsOwner_skikoKt.isHidden($this$isImportantForAccessibility) && ($this$isImportantForAccessibility.getUnmergedConfig$ui().isMergingSemanticsOfDescendants() || $this$isImportantForAccessibility.getUnmergedConfig$ui().contains(SemanticsProperties.INSTANCE.getTestTag()) || $this$isImportantForAccessibility.getUnmergedConfig$ui().containsImportantForAccessibility$ui());
    }

    public static final boolean isHidden(@NotNull SemanticsNode $this$isHidden) {
        Intrinsics.checkNotNullParameter($this$isHidden, "<this>");
        return $this$isHidden.isTransparent$ui() || $this$isHidden.getUnmergedConfig$ui().contains(SemanticsProperties.INSTANCE.getHideFromAccessibility()) || $this$isHidden.getUnmergedConfig$ui().contains(SemanticsProperties.INSTANCE.getInvisibleToUser());
    }

    public static /* synthetic */ void isHidden$annotations(SemanticsNode semanticsNode) {
    }

    @NotNull
    public static final IntObjectMap<SemanticsNodeWithAdjustedBounds> getAllUncoveredSemanticsNodesToIntObjectMap(@NotNull SemanticsOwner $this$getAllUncoveredSemanticsNodesToIntObjectMap, int customRootNodeId) {
        Intrinsics.checkNotNullParameter($this$getAllUncoveredSemanticsNodesToIntObjectMap, "<this>");
        SemanticsNode root = $this$getAllUncoveredSemanticsNodesToIntObjectMap.getUnmergedRootSemanticsNode();
        if (!root.getLayoutNode$ui().isPlaced() || !root.getLayoutNode$ui().isAttached()) {
            return IntObjectMapKt.emptyIntObjectMap();
        }
        MutableIntObjectMap<SemanticsNodeWithAdjustedBounds> nodes = new MutableIntObjectMap<SemanticsNodeWithAdjustedBounds>(48);
        SemanticsRegion unaccountedSpace = SemanticsRegion_skikoKt.SemanticsRegion();
        unaccountedSpace.set(IntRectKt.roundToIntRect(root.getBoundsInRoot()));
        SemanticsOwner_skikoKt.getAllUncoveredSemanticsNodesToIntObjectMap$findAllSemanticNodesRecursive(unaccountedSpace, root, customRootNodeId, nodes, root, SemanticsRegion_skikoKt.SemanticsRegion());
        return nodes;
    }

    private static final void getAllUncoveredSemanticsNodesToIntObjectMap$findAllSemanticNodesRecursive(SemanticsRegion unaccountedSpace, SemanticsNode root, int $customRootNodeId, MutableIntObjectMap<SemanticsNodeWithAdjustedBounds> nodes, SemanticsNode currentNode, SemanticsRegion region) {
        int virtualViewId;
        boolean notAttachedOrPlaced;
        boolean bl = notAttachedOrPlaced = !currentNode.getLayoutNode$ui().isPlaced() || !currentNode.getLayoutNode$ui().isAttached();
        if (unaccountedSpace.isEmpty() && currentNode.getId() != root.getId() || notAttachedOrPlaced && !currentNode.isFake$ui()) {
            return;
        }
        IntRect touchBoundsInRoot = IntRectKt.roundToIntRect(currentNode.getTouchBoundsInRoot());
        region.set(touchBoundsInRoot);
        int n = virtualViewId = currentNode.getId() == root.getId() ? $customRootNodeId : currentNode.getId();
        if (region.intersect(unaccountedSpace)) {
            nodes.set(virtualViewId, new SemanticsNodeWithAdjustedBounds(currentNode, region.getBounds()));
            List<SemanticsNode> children2 = currentNode.getReplacedChildren$ui();
            for (int i2 = children2.size() - 1; -1 < i2; --i2) {
                if (children2.get(i2).getConfig().contains(SemanticsProperties.INSTANCE.getLinkTestMarker())) continue;
                SemanticsOwner_skikoKt.getAllUncoveredSemanticsNodesToIntObjectMap$findAllSemanticNodesRecursive(unaccountedSpace, root, $customRootNodeId, nodes, children2.get(i2), region);
            }
            if (SemanticsOwner_skikoKt.isImportantForAccessibility(currentNode)) {
                unaccountedSpace.difference(touchBoundsInRoot);
            }
        } else if (currentNode.isFake$ui()) {
            SemanticsNode parentNode = currentNode.getParent();
            Object object = parentNode;
            Rect boundsForFakeNode = (object != null && (object = ((SemanticsNode)object).getLayoutInfo()) != null ? object.isPlaced() : false) ? parentNode.getBoundsInRoot() : DefaultFakeNodeBounds;
            nodes.set(virtualViewId, new SemanticsNodeWithAdjustedBounds(currentNode, IntRectKt.roundToIntRect(boundsForFakeNode)));
        } else if (virtualViewId == $customRootNodeId) {
            nodes.set(virtualViewId, new SemanticsNodeWithAdjustedBounds(currentNode, region.getBounds()));
        }
    }
}

