/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.text.platform;

import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.ui.text.Cache;
import androidx.compose.ui.text.ExpireAfterAccessCache;
import androidx.compose.ui.text.font.DefaultFontFamily;
import androidx.compose.ui.text.font.FontFamily;
import androidx.compose.ui.text.font.FontListFontFamily;
import androidx.compose.ui.text.font.FontStyle;
import androidx.compose.ui.text.font.FontWeight;
import androidx.compose.ui.text.font.GenericFontFamily;
import androidx.compose.ui.text.font.LoadedFontFamily;
import androidx.compose.ui.text.platform.DesktopFont_desktopKt;
import androidx.compose.ui.text.platform.FontLoadResult;
import androidx.compose.ui.text.platform.PlatformFont;
import androidx.compose.ui.text.platform.PlatformFont_skikoKt;
import androidx.compose.ui.text.platform.SkiaBackedTypeface;
import androidx.compose.ui.text.platform.SkiaParagraph_skikoKt;
import androidx.compose.ui.text.platform.SystemFont;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.skia.FontMgrWithFallback;
import org.jetbrains.skia.Typeface;
import org.jetbrains.skia.paragraph.FontCollection;
import org.jetbrains.skia.paragraph.TypefaceFontProviderWithFallback;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\b\u0001\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0000\u00a2\u0006\u0002\b\u0014J+\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u00172\b\b\u0002\u0010\u0018\u001a\u00020\u00192\b\b\u0002\u0010\u001a\u001a\u00020\u001bH\u0000\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u0018\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u000f2\u0006\u0010!\u001a\u00020\fH\u0002J\u0016\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\f0\"2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002R\u0014\u0010\u0004\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Landroidx/compose/ui/text/platform/FontCache;", "", "<init>", "()V", "fonts", "Lorg/jetbrains/skia/paragraph/FontCollection;", "getFonts$ui_text", "()Lorg/jetbrains/skia/paragraph/FontCollection;", "fontProvider", "Lorg/jetbrains/skia/paragraph/TypefaceFontProviderWithFallback;", "registered", "", "", "typefacesCache", "Landroidx/compose/ui/text/Cache;", "Lorg/jetbrains/skia/Typeface;", "load", "Landroidx/compose/ui/text/platform/FontLoadResult;", "font", "Landroidx/compose/ui/text/platform/PlatformFont;", "load$ui_text", "loadPlatformTypes", "fontFamily", "Landroidx/compose/ui/text/font/FontFamily;", "fontWeight", "Landroidx/compose/ui/text/font/FontWeight;", "fontStyle", "Landroidx/compose/ui/text/font/FontStyle;", "loadPlatformTypes-RetOiIg$ui_text", "(Landroidx/compose/ui/text/font/FontFamily;Landroidx/compose/ui/text/font/FontWeight;I)Landroidx/compose/ui/text/platform/FontLoadResult;", "ensureRegistered", "", "typeface", "key", "", "ui-text"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nPlatformFont.skiko.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PlatformFont.skiko.kt\nandroidx/compose/ui/text/platform/FontCache\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,432:1\n37#2:433\n36#2,3:434\n808#3,11:437\n1563#3:448\n1634#3,3:449\n*S KotlinDebug\n*F\n+ 1 PlatformFont.skiko.kt\nandroidx/compose/ui/text/platform/FontCache\n*L\n319#1:433\n319#1:434,3\n332#1:437,11\n334#1:448\n334#1:449,3\n*E\n"})
public final class FontCache {
    @NotNull
    private final FontCollection fonts = new FontCollection();
    @NotNull
    private final TypefaceFontProviderWithFallback fontProvider = new TypefaceFontProviderWithFallback();
    @NotNull
    private final Set<String> registered = new HashSet();
    @NotNull
    private final Cache<String, Typeface> typefacesCache = new ExpireAfterAccessCache(60000000000L, null, 2, null);
    public static final int $stable = 8;

    public FontCache() {
        this.fonts.setDefaultFontManager(new FontMgrWithFallback(this.fontProvider));
        this.fonts.setAssetFontManager(this.fontProvider);
    }

    @NotNull
    public final FontCollection getFonts$ui_text() {
        return this.fonts;
    }

    @NotNull
    public final FontLoadResult load$ui_text(@NotNull PlatformFont font2) {
        Intrinsics.checkNotNullParameter(font2, "font");
        Typeface typeface2 = this.typefacesCache.get(font2.getCacheKey$ui_text(), arg_0 -> FontCache.load$lambda$0(font2, arg_0));
        this.ensureRegistered(typeface2, font2.getCacheKey$ui_text());
        return new FontLoadResult(typeface2, CollectionsKt.listOf(font2.getCacheKey$ui_text()));
    }

    @NotNull
    public final FontLoadResult loadPlatformTypes-RetOiIg$ui_text(@NotNull FontFamily fontFamily, @NotNull FontWeight fontWeight, int fontStyle) {
        Intrinsics.checkNotNullParameter(fontFamily, "fontFamily");
        Intrinsics.checkNotNullParameter(fontWeight, "fontWeight");
        List<String> aliases = this.ensureRegistered(fontFamily);
        org.jetbrains.skia.FontStyle style2 = SkiaParagraph_skikoKt.toSkFontStyle-nzbMABs(fontStyle).withWeight(fontWeight.getWeight());
        Collection $this$toTypedArray$iv = aliases;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return new FontLoadResult(ArraysKt.first(this.fonts.findTypefaces(thisCollection$iv.toArray(new String[0]), style2)), aliases);
    }

    public static /* synthetic */ FontLoadResult loadPlatformTypes-RetOiIg$ui_text$default(FontCache fontCache, FontFamily fontFamily, FontWeight fontWeight, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            fontWeight = FontWeight.Companion.getNormal();
        }
        if ((n2 & 4) != 0) {
            n = FontStyle.Companion.getNormal-_-LCdwA();
        }
        return fontCache.loadPlatformTypes-RetOiIg$ui_text(fontFamily, fontWeight, n);
    }

    private final void ensureRegistered(Typeface typeface2, String key) {
        if (!this.registered.contains(key)) {
            this.fontProvider.registerTypeface(typeface2, key);
            this.registered.add(key);
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final List<String> ensureRegistered(FontFamily fontFamily) {
        List list2;
        FontFamily fontFamily2 = fontFamily;
        if (fontFamily2 instanceof FontListFontFamily) {
            void $this$mapTo$iv$iv;
            Iterable $this$filterIsInstanceTo$iv$iv;
            Iterable $this$filterIsInstance$iv = ((FontListFontFamily)fontFamily).getFonts();
            boolean $i$f$filterIsInstance = false;
            Iterable iterable = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof SystemFont)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List fonts = (List)destination$iv$iv;
            if (fonts.size() != ((FontListFontFamily)fontFamily).getFonts().size()) throw new IllegalArgumentException("Don't load FontListFontFamily through ensureRegistered: " + fontFamily);
            Iterable $this$map$iv = fonts;
            boolean $i$f$map = false;
            $this$filterIsInstanceTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                SystemFont systemFont = (SystemFont)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getIdentity());
            }
            list2 = (List)destination$iv$iv;
            return list2;
        } else if (fontFamily2 instanceof LoadedFontFamily) {
            androidx.compose.ui.text.font.Typeface typeface2 = ((LoadedFontFamily)fontFamily).getTypeface();
            Intrinsics.checkNotNull(typeface2, "null cannot be cast to non-null type androidx.compose.ui.text.platform.SkiaBackedTypeface");
            SkiaBackedTypeface typeface3 = (SkiaBackedTypeface)typeface2;
            this.ensureRegistered(typeface3.getNativeTypeface(), typeface3.getAlias());
            list2 = CollectionsKt.listOf(typeface3.getAlias());
            return list2;
        } else if (fontFamily2 instanceof GenericFontFamily) {
            list2 = PlatformFont_skikoKt.getAliases((GenericFontFamily)fontFamily);
            return list2;
        } else {
            if (!(fontFamily2 instanceof DefaultFontFamily)) throw new IllegalArgumentException("Unknown font family type: " + fontFamily);
            list2 = PlatformFont_skikoKt.getAliases(FontFamily.Companion.getSansSerif());
        }
        return list2;
    }

    private static final Typeface load$lambda$0(PlatformFont $font, String it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return DesktopFont_desktopKt.loadTypeface($font);
    }
}

