/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.schema;

import com.fasterxml.jackson.databind.JsonNode;
import com.networknt.schema.BaseJsonValidator;
import com.networknt.schema.CachedSupplier;
import com.networknt.schema.ExecutionContext;
import com.networknt.schema.InvalidSchemaRefException;
import com.networknt.schema.JsonNodePath;
import com.networknt.schema.JsonSchema;
import com.networknt.schema.JsonSchemaException;
import com.networknt.schema.JsonSchemaFactory;
import com.networknt.schema.JsonSchemaRef;
import com.networknt.schema.MessageSourceValidationMessage;
import com.networknt.schema.SchemaLocation;
import com.networknt.schema.ValidationContext;
import com.networknt.schema.ValidationMessage;
import com.networknt.schema.ValidatorTypeCode;
import java.util.Collections;
import java.util.Set;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RefValidator
extends BaseJsonValidator {
    private static final Logger logger = LoggerFactory.getLogger(RefValidator.class);
    protected final JsonSchemaRef schema;
    private static final String REF_CURRENT = "#";

    public RefValidator(SchemaLocation schemaLocation, JsonNodePath evaluationPath, JsonNode schemaNode, JsonSchema parentSchema, ValidationContext validationContext) {
        super(schemaLocation, evaluationPath, schemaNode, parentSchema, ValidatorTypeCode.REF, validationContext);
        String refValue = schemaNode.asText();
        this.schema = RefValidator.getRefSchema(parentSchema, validationContext, refValue, evaluationPath);
    }

    static JsonSchemaRef getRefSchema(JsonSchema parentSchema, ValidationContext validationContext, String refValue, JsonNodePath evaluationPath) {
        String refValueOriginal = refValue;
        if (!refValue.startsWith(REF_CURRENT)) {
            int index2 = refValue.indexOf(REF_CURRENT);
            String refUri = index2 > 0 ? refValue.substring(0, index2) : refValue;
            String schemaUriFinal = RefValidator.resolve(parentSchema, refUri);
            SchemaLocation schemaLocation = SchemaLocation.of(schemaUriFinal);
            return new JsonSchemaRef(RefValidator.getSupplier(() -> {
                JsonSchema schemaResource = (JsonSchema)validationContext.getSchemaResources().get(schemaUriFinal);
                if (schemaResource == null && (schemaResource = validationContext.getJsonSchemaFactory().loadSchema(schemaLocation, validationContext.getConfig())) != null) {
                    RefValidator.copySchemaResources(validationContext, schemaResource);
                }
                if (index2 < 0) {
                    if (schemaResource == null) {
                        return null;
                    }
                    return schemaResource.fromRef(parentSchema, evaluationPath);
                }
                String newRefValue = refValue.substring(index2);
                String find2 = schemaLocation.getAbsoluteIri() + newRefValue;
                JsonSchema findSchemaResource = (JsonSchema)validationContext.getSchemaResources().get(find2);
                if (findSchemaResource == null) {
                    findSchemaResource = (JsonSchema)validationContext.getDynamicAnchors().get(find2);
                }
                if ((schemaResource = findSchemaResource != null ? findSchemaResource : RefValidator.getJsonSchema(schemaResource, validationContext, newRefValue, refValueOriginal, evaluationPath)) == null) {
                    return null;
                }
                return schemaResource.fromRef(parentSchema, evaluationPath);
            }, validationContext.getConfig().isCacheRefs()));
        }
        if (SchemaLocation.Fragment.isAnchorFragment(refValue)) {
            String absoluteIri = RefValidator.resolve(parentSchema, refValue);
            return new JsonSchemaRef(RefValidator.getSupplier(() -> {
                JsonSchema schemaResource = (JsonSchema)validationContext.getSchemaResources().get(absoluteIri);
                if (schemaResource == null) {
                    schemaResource = (JsonSchema)validationContext.getDynamicAnchors().get(absoluteIri);
                }
                if (schemaResource == null) {
                    schemaResource = RefValidator.getJsonSchema(parentSchema, validationContext, refValue, refValueOriginal, evaluationPath);
                }
                if (schemaResource == null) {
                    return null;
                }
                return schemaResource.fromRef(parentSchema, evaluationPath);
            }, validationContext.getConfig().isCacheRefs()));
        }
        if (refValue.equals(REF_CURRENT)) {
            return new JsonSchemaRef(RefValidator.getSupplier(() -> parentSchema.findSchemaResourceRoot().fromRef(parentSchema, evaluationPath), validationContext.getConfig().isCacheRefs()));
        }
        return new JsonSchemaRef(RefValidator.getSupplier(() -> RefValidator.getJsonSchema(parentSchema, validationContext, refValue, refValueOriginal, evaluationPath).fromRef(parentSchema, evaluationPath), validationContext.getConfig().isCacheRefs()));
    }

    static <T> Supplier<T> getSupplier(Supplier<T> supplier, boolean cache2) {
        return cache2 ? new CachedSupplier(supplier) : supplier;
    }

    private static void copySchemaResources(ValidationContext validationContext, JsonSchema schemaResource) {
        if (!schemaResource.getValidationContext().getSchemaResources().isEmpty()) {
            validationContext.getSchemaResources().putAll(schemaResource.getValidationContext().getSchemaResources());
        }
        if (!schemaResource.getValidationContext().getSchemaReferences().isEmpty()) {
            validationContext.getSchemaReferences().putAll(schemaResource.getValidationContext().getSchemaReferences());
        }
        if (!schemaResource.getValidationContext().getDynamicAnchors().isEmpty()) {
            validationContext.getDynamicAnchors().putAll(schemaResource.getValidationContext().getDynamicAnchors());
        }
    }

    private static String resolve(JsonSchema parentSchema, String refValue) {
        JsonSchema base2 = parentSchema;
        if (parentSchema.getId() != null && parentSchema.parentSchema != null) {
            base2 = parentSchema.parentSchema;
        }
        return SchemaLocation.resolve(base2.getSchemaLocation(), refValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static JsonSchema getJsonSchema(JsonSchema parent, ValidationContext validationContext, String refValue, String refValueOriginal, JsonNodePath evaluationPath) {
        JsonNodePath fragment = SchemaLocation.Fragment.of(refValue);
        String schemaReference = RefValidator.resolve(parent, refValueOriginal);
        JsonSchema result2 = (JsonSchema)validationContext.getSchemaReferences().get(schemaReference);
        if (result2 == null) {
            JsonSchemaFactory jsonSchemaFactory = validationContext.getJsonSchemaFactory();
            synchronized (jsonSchemaFactory) {
                result2 = (JsonSchema)validationContext.getSchemaReferences().get(schemaReference);
                if (result2 == null && (result2 = parent.getSubSchema(fragment)) != null) {
                    validationContext.getSchemaReferences().put(schemaReference, result2);
                }
            }
        }
        return result2;
    }

    @Override
    public Set<ValidationMessage> validate(ExecutionContext executionContext, JsonNode node2, JsonNode rootNode, JsonNodePath instanceLocation) {
        RefValidator.debug(logger, executionContext, node2, rootNode, instanceLocation);
        JsonSchema refSchema = this.schema.getSchema();
        if (refSchema == null) {
            ValidationMessage validationMessage = ((MessageSourceValidationMessage.Builder)((MessageSourceValidationMessage.Builder)((MessageSourceValidationMessage.Builder)((MessageSourceValidationMessage.Builder)((MessageSourceValidationMessage.Builder)((MessageSourceValidationMessage.Builder)this.message().type(ValidatorTypeCode.REF.getValue())).code("internal.unresolvedRef")).message("{0}: Reference {1} cannot be resolved")).instanceLocation(instanceLocation)).evaluationPath(this.getEvaluationPath())).arguments(this.schemaNode.asText())).build();
            throw new InvalidSchemaRefException(validationMessage);
        }
        return refSchema.validate(executionContext, node2, rootNode, instanceLocation);
    }

    @Override
    public Set<ValidationMessage> walk(ExecutionContext executionContext, JsonNode node2, JsonNode rootNode, JsonNodePath instanceLocation, boolean shouldValidateSchema) {
        RefValidator.debug(logger, executionContext, node2, rootNode, instanceLocation);
        JsonSchema refSchema = this.schema.getSchema();
        if (refSchema == null) {
            ValidationMessage validationMessage = ((MessageSourceValidationMessage.Builder)((MessageSourceValidationMessage.Builder)((MessageSourceValidationMessage.Builder)((MessageSourceValidationMessage.Builder)((MessageSourceValidationMessage.Builder)((MessageSourceValidationMessage.Builder)this.message().type(ValidatorTypeCode.REF.getValue())).code("internal.unresolvedRef")).message("{0}: Reference {1} cannot be resolved")).instanceLocation(instanceLocation)).evaluationPath(this.getEvaluationPath())).arguments(this.schemaNode.asText())).build();
            throw new InvalidSchemaRefException(validationMessage);
        }
        if (node2 == null) {
            SchemaLocation schemaLocation = refSchema.getSchemaLocation();
            JsonSchema check2 = refSchema;
            boolean circularDependency = false;
            while (check2.getEvaluationParentSchema() != null) {
                if (!(check2 = check2.getEvaluationParentSchema()).getSchemaLocation().equals(schemaLocation)) continue;
                circularDependency = true;
                break;
            }
            if (circularDependency) {
                return Collections.emptySet();
            }
        }
        return refSchema.walk(executionContext, node2, rootNode, instanceLocation, shouldValidateSchema);
    }

    public JsonSchemaRef getSchemaRef() {
        return this.schema;
    }

    @Override
    public void preloadJsonSchema() {
        JsonSchema jsonSchema = null;
        try {
            jsonSchema = this.schema.getSchema();
        }
        catch (JsonSchemaException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw new JsonSchemaException(e);
        }
        SchemaLocation schemaLocation = jsonSchema.getSchemaLocation();
        JsonSchema check2 = jsonSchema;
        boolean circularDependency = false;
        int depth = 0;
        while (check2.getEvaluationParentSchema() != null) {
            ++depth;
            if (!(check2 = check2.getEvaluationParentSchema()).getSchemaLocation().equals(schemaLocation)) continue;
            circularDependency = true;
            break;
        }
        if (this.validationContext.getConfig().isCacheRefs() && !circularDependency && depth < this.validationContext.getConfig().getPreloadJsonSchemaRefMaxNestingDepth()) {
            jsonSchema.initializeValidators();
        }
    }
}

