/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.libcache;

import androidx.room.RoomDatabaseKt;
import androidx.room.TransactionScope;
import androidx.room.Transactor;
import com.ustadmobile.libcache.db.UstadCacheDb;
import com.ustadmobile.libcache.db.entities.CacheEntry;
import com.ustadmobile.libcache.logging.UstadCacheLogger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.channels.BufferOverflow;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.MutableSharedFlow;
import kotlinx.coroutines.flow.SharedFlowKt;
import kotlinx.io.files.FileSystem;
import kotlinx.io.files.Path;
import kotlinx.io.files.PathsJvmKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B1\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u0006\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\u0004\b\u000b\u0010\fJ\r\u0010\u000e\u001a\u00020\r\u00a2\u0006\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u0010R\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0011R\u0016\u0010\u0007\u001a\u0004\u0018\u00010\u00068\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0007\u0010\u0012R\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\b8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\n\u0010\u0013R\u0014\u0010\u0015\u001a\u00020\u00148\u0002X\u0082D\u00a2\u0006\u0006\n\u0004\b\u0015\u0010\u0016R \u0010\u0019\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00140\u00180\u00178\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0019\u0010\u001aR#\u0010\u001c\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00140\u00180\u001b8\u0006\u00a2\u0006\f\n\u0004\b\u001c\u0010\u001d\u001a\u0004\b\u001e\u0010\u001f\u00a8\u0006 "}, d2={"Lcom/ustadmobile/libcache/UstadCacheTrimmer;", "", "Lcom/ustadmobile/libcache/db/UstadCacheDb;", "db", "Lkotlinx/io/files/FileSystem;", "fileSystem", "Lcom/ustadmobile/libcache/logging/UstadCacheLogger;", "logger", "Lkotlin/Function0;", "", "sizeLimit", "<init>", "(Lcom/ustadmobile/libcache/db/UstadCacheDb;Lkotlinx/io/files/FileSystem;Lcom/ustadmobile/libcache/logging/UstadCacheLogger;Lkotlin/jvm/functions/Function0;)V", "", "trim", "()V", "Lcom/ustadmobile/libcache/db/UstadCacheDb;", "Lkotlinx/io/files/FileSystem;", "Lcom/ustadmobile/libcache/logging/UstadCacheLogger;", "Lkotlin/jvm/functions/Function0;", "", "logPrefix", "Ljava/lang/String;", "Lkotlinx/coroutines/flow/MutableSharedFlow;", "", "_evictedEntriesFlow", "Lkotlinx/coroutines/flow/MutableSharedFlow;", "Lkotlinx/coroutines/flow/Flow;", "evictedEntriesFlow", "Lkotlinx/coroutines/flow/Flow;", "getEvictedEntriesFlow", "()Lkotlinx/coroutines/flow/Flow;", "respect-lib-cache"})
@SourceDebugExtension(value={"SMAP\nUstadCacheTrimmer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UstadCacheTrimmer.kt\ncom/ustadmobile/libcache/UstadCacheTrimmer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,79:1\n1869#2:80\n1870#2:82\n1#3:81\n*S KotlinDebug\n*F\n+ 1 UstadCacheTrimmer.kt\ncom/ustadmobile/libcache/UstadCacheTrimmer\n*L\n73#1:80\n73#1:82\n*E\n"})
public final class UstadCacheTrimmer {
    @NotNull
    private final UstadCacheDb db;
    @NotNull
    private final FileSystem fileSystem;
    @Nullable
    private final UstadCacheLogger logger;
    @NotNull
    private final Function0<Long> sizeLimit;
    @NotNull
    private final String logPrefix;
    @NotNull
    private final MutableSharedFlow<List<String>> _evictedEntriesFlow;
    @NotNull
    private final Flow<List<String>> evictedEntriesFlow;

    public UstadCacheTrimmer(@NotNull UstadCacheDb db, @NotNull FileSystem fileSystem, @Nullable UstadCacheLogger logger, @NotNull Function0<Long> sizeLimit) {
        Intrinsics.checkNotNullParameter(db, "db");
        Intrinsics.checkNotNullParameter(fileSystem, "fileSystem");
        Intrinsics.checkNotNullParameter(sizeLimit, "sizeLimit");
        this.db = db;
        this.fileSystem = fileSystem;
        this.logger = logger;
        this.sizeLimit = sizeLimit;
        this.logPrefix = "CacheTrimmer: ";
        this._evictedEntriesFlow = SharedFlowKt.MutableSharedFlow(1, 0, BufferOverflow.DROP_OLDEST);
        this.evictedEntriesFlow = FlowKt.asSharedFlow(this._evictedEntriesFlow);
    }

    public /* synthetic */ UstadCacheTrimmer(UstadCacheDb ustadCacheDb, FileSystem fileSystem, UstadCacheLogger ustadCacheLogger, Function0 function0, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            ustadCacheLogger = null;
        }
        this(ustadCacheDb, fileSystem, ustadCacheLogger, function0);
    }

    @NotNull
    public final Flow<List<String>> getEvictedEntriesFlow() {
        return this.evictedEntriesFlow;
    }

    public final void trim() {
        long currentLimit = ((Number)this.sizeLimit.invoke()).longValue();
        if (currentLimit <= 0L) {
            throw new IllegalArgumentException("Size limit must be greater than 0");
        }
        UstadCacheLogger ustadCacheLogger = this.logger;
        if (ustadCacheLogger != null) {
            UstadCacheLogger.d$default(ustadCacheLogger, "UstadCache", this.logPrefix + " Trim cache run: max (evictable) size = " + currentLimit + " bytes", null, 4, null);
        }
        List pathsToDelete = new ArrayList();
        BuildersKt.runBlocking$default(null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, currentLimit, (List<String>)pathsToDelete, null){
            int label;
            final /* synthetic */ UstadCacheTrimmer this$0;
            final /* synthetic */ long $currentLimit;
            final /* synthetic */ List<String> $pathsToDelete;
            {
                this.this$0 = $receiver;
                this.$currentLimit = $currentLimit;
                this.$pathsToDelete = $pathsToDelete;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure($result);
                        this.label = 1;
                        Object object2 = RoomDatabaseKt.useWriterConnection(UstadCacheTrimmer.access$getDb$p(this.this$0), (Function2)new Function2<Transactor, Continuation<? super Unit>, Object>(this.this$0, this.$currentLimit, this.$pathsToDelete, null){
                            int label;
                            /* synthetic */ Object L$0;
                            final /* synthetic */ UstadCacheTrimmer this$0;
                            final /* synthetic */ long $currentLimit;
                            final /* synthetic */ List<String> $pathsToDelete;
                            {
                                this.this$0 = $receiver;
                                this.$currentLimit = $currentLimit;
                                this.$pathsToDelete = $pathsToDelete;
                                super(2, $completion);
                            }

                            /*
                             * WARNING - void declaration
                             * Enabled force condition propagation
                             * Lifted jumps to return sites
                             */
                            public final Object invokeSuspend(Object $result) {
                                Transactor transactor = (Transactor)this.L$0;
                                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        void con;
                                        ResultKt.throwOnFailure($result);
                                        this.L$0 = SpillingKt.nullOutSpilledVariable(con);
                                        this.label = 1;
                                        Object object2 = con.withTransaction(Transactor.SQLiteTransactionType.IMMEDIATE, (Function2)new Function2<TransactionScope<Unit>, Continuation<? super Unit>, Object>(this.this$0, this.$currentLimit, this.$pathsToDelete, null){
                                            Object L$0;
                                            Object L$1;
                                            Object L$2;
                                            long J$0;
                                            long J$1;
                                            int label;
                                            final /* synthetic */ UstadCacheTrimmer this$0;
                                            final /* synthetic */ long $currentLimit;
                                            final /* synthetic */ List<String> $pathsToDelete;
                                            {
                                                this.this$0 = $receiver;
                                                this.$currentLimit = $currentLimit;
                                                this.$pathsToDelete = $pathsToDelete;
                                                super(2, $completion);
                                            }

                                            /*
                                             * Unable to fully structure code
                                             */
                                            public final Object invokeSuspend(Object $result) {
                                                var23_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                                switch (this.label) {
                                                    case 0: {
                                                        ResultKt.throwOnFailure($result);
                                                        currentSize = new Ref.LongRef();
lbl6:
                                                        // 2 sources

                                                        while (true) {
                                                            this.L$0 = currentSize;
                                                            this.L$1 = null;
                                                            this.L$2 = null;
                                                            this.label = 1;
                                                            v0 = UstadCacheTrimmer.access$getDb$p(this.this$0).getCacheEntryDao().totalEvictableSize(this);
                                                            if (v0 == var23_2) {
                                                                return var23_2;
                                                            }
                                                            ** GOTO lbl19
                                                            break;
                                                        }
                                                    }
                                                    case 1: {
                                                        currentSize = (Ref.LongRef)this.L$0;
                                                        ResultKt.throwOnFailure($result);
                                                        v0 = $result;
lbl19:
                                                        // 2 sources

                                                        var3_5 = v0;
                                                        it = ((Number)var3_5).longValue();
                                                        $i$a$-also-UstadCacheTrimmer$trim$1$1$1$1 = false;
                                                        currentSize.element = it;
                                                        if (((Number)var3_5).longValue() <= this.$currentLimit) break;
                                                        deleteTarget = currentSize.element - this.$currentLimit;
                                                        this.L$0 = currentSize;
                                                        this.J$0 = deleteTarget;
                                                        this.label = 2;
                                                        v1 = UstadCacheTrimmer.access$getDb$p(this.this$0).getCacheEntryDao().findEvictableEntries(100, this);
                                                        if (v1 == var23_2) {
                                                            return var23_2;
                                                        }
                                                        ** GOTO lbl37
                                                    }
                                                    case 2: {
                                                        deleteTarget = this.J$0;
                                                        currentSize = (Ref.LongRef)this.L$0;
                                                        ResultKt.throwOnFailure($result);
                                                        v1 = $result;
lbl37:
                                                        // 2 sources

                                                        evictableEntries = (List)v1;
                                                        entriesToEvict = new ArrayList<E>();
                                                        entriesToEvictSize = 0L;
                                                        for (CacheEntry entry : evictableEntries) {
                                                            ((Collection)entriesToEvict).add(entry);
                                                            if ((entriesToEvictSize += entry.getStorageSize()) < deleteTarget) continue;
                                                        }
                                                        var9_11 = evictableEntries;
                                                        var19_32 = UstadCacheTrimmer.access$get_evictedEntriesFlow$p(this.this$0);
                                                        $i$f$map = false;
                                                        var11_17 = $this$map$iv;
                                                        destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                                                        $i$f$mapTo = false;
                                                        for (T item$iv$iv : $this$mapTo$iv$iv) {
                                                            var16_27 = (CacheEntry)item$iv$iv;
                                                            var20_33 = destination$iv$iv;
                                                            $i$a$-map-UstadCacheTrimmer$trim$1$1$1$2 = false;
                                                            var20_33.add(it.getKey());
                                                        }
                                                        var19_32.tryEmit((List)destination$iv$iv);
                                                        this.L$0 = currentSize;
                                                        this.L$1 = SpillingKt.nullOutSpilledVariable(evictableEntries);
                                                        this.L$2 = entriesToEvict;
                                                        this.J$0 = deleteTarget;
                                                        this.J$1 = entriesToEvictSize;
                                                        this.label = 3;
                                                        v2 = UstadCacheTrimmer.access$getDb$p(this.this$0).getCacheEntryDao().delete(entriesToEvict, this);
                                                        if (v2 == var23_2) {
                                                            return var23_2;
                                                        }
                                                        ** GOTO lbl77
                                                    }
                                                    case 3: {
                                                        entriesToEvictSize = this.J$1;
                                                        deleteTarget = this.J$0;
                                                        entriesToEvict = (List)this.L$2;
                                                        evictableEntries = (List)this.L$1;
                                                        currentSize = (Ref.LongRef)this.L$0;
                                                        ResultKt.throwOnFailure($result);
                                                        v2 = $result;
lbl77:
                                                        // 2 sources

                                                        v3 = UstadCacheTrimmer.access$getLogger$p(this.this$0);
                                                        if (v3 != null) {
                                                            $i$f$map = entriesToEvict;
                                                            var21_34 = UstadCacheTrimmer.access$getLogPrefix$p(this.this$0);
                                                            var20_33 = "UstadCache";
                                                            var19_32 = v3;
                                                            $i$f$map = false;
                                                            destination$iv$iv = $this$map$iv;
                                                            destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                                                            $i$f$mapTo = false;
                                                            for (T item$iv$iv : $this$mapTo$iv$iv) {
                                                                $i$a$-map-UstadCacheTrimmer$trim$1$1$1$2 = (CacheEntry)item$iv$iv;
                                                                var22_35 = destination$iv$iv;
                                                                $i$a$-map-UstadCacheTrimmer$trim$1$1$1$3 = false;
                                                                var22_35.add(it.getUrl());
                                                            }
                                                            var22_35 = (List)destination$iv$iv;
                                                            UstadCacheLogger.v$default((UstadCacheLogger)var19_32, (String)var20_33, var21_34 + " evicting " + (List)var22_35, null, 4, null);
                                                        }
                                                        var9_11 = this.$pathsToDelete;
                                                        $this$map$iv = entriesToEvict;
                                                        $i$f$map = false;
                                                        $this$mapTo$iv$iv = $this$map$iv;
                                                        destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                                                        $i$f$mapTo = false;
                                                        for (T item$iv$iv : $this$mapTo$iv$iv) {
                                                            it = (CacheEntry)item$iv$iv;
                                                            var19_32 = destination$iv$iv;
                                                            $i$a$-map-UstadCacheTrimmer$trim$1$1$1$4 = false;
                                                            var19_32.add(it.getStorageUri());
                                                        }
                                                        var10_12 = (List)destination$iv$iv;
                                                        CollectionsKt.addAll(var9_11, var10_12);
                                                        ** continue;
                                                    }
                                                }
                                                return Unit.INSTANCE;
                                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                            }

                                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                                return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
                                            }

                                            public final Object invoke(TransactionScope<Unit> p1, Continuation<? super Unit> p2) {
                                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                            }
                                        }, this);
                                        if (object2 != object) return Unit.INSTANCE;
                                        return object;
                                    }
                                    case 1: {
                                        ResultKt.throwOnFailure($result);
                                        Object object2 = $result;
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                                var3_3.L$0 = value;
                                return var3_3;
                            }

                            public final Object invoke(Transactor p1, Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }, this);
                        if (object2 != object) return Unit.INSTANCE;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure($result);
                        Object object2 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, 1, null);
        UstadCacheLogger ustadCacheLogger2 = this.logger;
        if (ustadCacheLogger2 != null) {
            UstadCacheLogger.v$default(ustadCacheLogger2, "UstadCache", this.logPrefix + " deleting " + CollectionsKt.joinToString$default(pathsToDelete, null, null, null, 0, null, null, 63, null), null, 4, null);
        }
        Iterable $this$forEach$iv = pathsToDelete;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            FileSystem fileSystem;
            String pathToDelete = (String)element$iv;
            boolean bl = false;
            Path path = PathsJvmKt.Path(pathToDelete);
            FileSystem it = fileSystem = this.fileSystem;
            boolean bl2 = false;
            FileSystem fileSystem2 = it.exists(path) ? fileSystem : null;
            if (fileSystem2 == null) continue;
            FileSystem.delete$default(fileSystem2, path, false, 2, null);
        }
    }

    public static final /* synthetic */ UstadCacheDb access$getDb$p(UstadCacheTrimmer $this) {
        return $this.db;
    }

    public static final /* synthetic */ MutableSharedFlow access$get_evictedEntriesFlow$p(UstadCacheTrimmer $this) {
        return $this._evictedEntriesFlow;
    }

    public static final /* synthetic */ UstadCacheLogger access$getLogger$p(UstadCacheTrimmer $this) {
        return $this.logger;
    }

    public static final /* synthetic */ String access$getLogPrefix$p(UstadCacheTrimmer $this) {
        return $this.logPrefix;
    }
}

