/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.server.plugins.cors;

import io.ktor.http.ContentType;
import io.ktor.http.HttpHeaders;
import io.ktor.http.HttpMethod;
import io.ktor.util.CaseInsensitiveSet;
import io.ktor.util.CollectionsJvmKt;
import io.ktor.utils.io.KtorDsl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@KtorDsl
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010#\n\u0002\b\u0012\n\u0002\u0010!\n\u0002\b\u0006\n\u0002\u0010\t\n\u0002\b\u000f\b\u0007\u0018\u0000 M2\u00020\u0001:\u0001MB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\r\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0003J5\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u000e\b\u0002\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\b2\u000e\b\u0002\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00060\b\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0017\u0010\r\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0017\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\u000f\u0010\u000eJ\u0017\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0007\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0015\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0014\u0010\u000eJ\r\u0010\u0015\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0015\u0010\u0003J!\u0010\u0018\u001a\u00020\u00042\u0012\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00100\u0016\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u0015\u0010\u001b\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\u0006\u00a2\u0006\u0004\b\u001b\u0010\u000eJ!\u0010\u001c\u001a\u00020\u00042\u0012\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00100\u0016\u00a2\u0006\u0004\b\u001c\u0010\u0019J\u0015\u0010\u001d\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u0006\u00a2\u0006\u0004\b\u001d\u0010\u000eJ\u0015\u0010 \u001a\u00020\u00042\u0006\u0010\u001f\u001a\u00020\u001e\u00a2\u0006\u0004\b \u0010!J\r\u0010\"\u001a\u00020\u0004\u00a2\u0006\u0004\b\"\u0010\u0003R\u0014\u0010#\u001a\u00020\u00068\u0002X\u0082D\u00a2\u0006\u0006\n\u0004\b#\u0010$R\u001d\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00060%8\u0006\u00a2\u0006\f\n\u0004\b&\u0010'\u001a\u0004\b(\u0010)R#\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00060%8\u0006\u00a2\u0006\u0012\n\u0004\b*\u0010'\u0012\u0004\b,\u0010\u0003\u001a\u0004\b+\u0010)R\u001d\u0010-\u001a\b\u0012\u0004\u0012\u00020\u001e0%8\u0006\u00a2\u0006\f\n\u0004\b-\u0010'\u001a\u0004\b.\u0010)R#\u0010/\u001a\b\u0012\u0004\u0012\u00020\u00060%8\u0006\u00a2\u0006\u0012\n\u0004\b/\u0010'\u0012\u0004\b1\u0010\u0003\u001a\u0004\b0\u0010)R\"\u00102\u001a\u00020\u00108\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b2\u00103\u001a\u0004\b4\u00105\"\u0004\b6\u00107R,\u00109\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00100\u0016088\u0000X\u0080\u0004\u00a2\u0006\f\n\u0004\b9\u0010:\u001a\u0004\b;\u0010<R)\u0010=\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00100\u0016088\u0006\u00a2\u0006\f\n\u0004\b=\u0010:\u001a\u0004\b>\u0010<R*\u0010A\u001a\u00020?2\u0006\u0010@\u001a\u00020?8\u0006@FX\u0086\u000e\u00a2\u0006\u0012\n\u0004\bA\u0010B\u001a\u0004\bC\u0010D\"\u0004\bE\u0010FR\"\u0010G\u001a\u00020\u00108\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bG\u00103\u001a\u0004\bH\u00105\"\u0004\bI\u00107R\"\u0010J\u001a\u00020\u00108\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bJ\u00103\u001a\u0004\bK\u00105\"\u0004\bL\u00107\u00a8\u0006N"}, d2={"Lio/ktor/server/plugins/cors/CORSConfig;", "", "<init>", "()V", "", "anyHost", "", "host", "", "schemes", "subDomains", "allowHost", "(Ljava/lang/String;Ljava/util/List;Ljava/util/List;)V", "addHost", "(Ljava/lang/String;)V", "validateWildcardRequirements", "", "wildcardInFrontOfDomain", "(Ljava/lang/String;)Z", "header", "exposeHeader", "allowXHttpMethodOverride", "Lkotlin/Function1;", "predicate", "allowOrigins", "(Lkotlin/jvm/functions/Function1;)V", "headerPrefix", "allowHeadersPrefixed", "allowHeaders", "allowHeader", "Lio/ktor/http/HttpMethod;", "method", "allowMethod", "(Lio/ktor/http/HttpMethod;)V", "anyMethod", "wildcardWithDot", "Ljava/lang/String;", "", "hosts", "Ljava/util/Set;", "getHosts", "()Ljava/util/Set;", "headers", "getHeaders", "getHeaders$annotations", "methods", "getMethods", "exposedHeaders", "getExposedHeaders", "getExposedHeaders$annotations", "allowCredentials", "Z", "getAllowCredentials", "()Z", "setAllowCredentials", "(Z)V", "", "originPredicates", "Ljava/util/List;", "getOriginPredicates$ktor_server_cors", "()Ljava/util/List;", "headerPredicates", "getHeaderPredicates", "", "newMaxAge", "maxAgeInSeconds", "J", "getMaxAgeInSeconds", "()J", "setMaxAgeInSeconds", "(J)V", "allowSameOrigin", "getAllowSameOrigin", "setAllowSameOrigin", "allowNonSimpleContentTypes", "getAllowNonSimpleContentTypes", "setAllowNonSimpleContentTypes", "Companion", "ktor-server-cors"})
@SourceDebugExtension(value={"SMAP\nCORSConfig.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CORSConfig.kt\nio/ktor/server/plugins/cors/CORSConfig\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,318:1\n1#2:319\n*E\n"})
public final class CORSConfig {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String wildcardWithDot;
    @NotNull
    private final Set<String> hosts = new HashSet();
    @NotNull
    private final Set<String> headers = new CaseInsensitiveSet();
    @NotNull
    private final Set<HttpMethod> methods = new HashSet();
    @NotNull
    private final Set<String> exposedHeaders = new CaseInsensitiveSet();
    private boolean allowCredentials;
    @NotNull
    private final List<Function1<String, Boolean>> originPredicates = new ArrayList();
    @NotNull
    private final List<Function1<String, Boolean>> headerPredicates = new ArrayList();
    private long maxAgeInSeconds = 86400L;
    private boolean allowSameOrigin = true;
    private boolean allowNonSimpleContentTypes;
    public static final long CORS_DEFAULT_MAX_AGE = 86400L;
    @NotNull
    private static final Set<HttpMethod> CorsDefaultMethods;
    @NotNull
    private static final Set<String> CorsSimpleRequestHeaders;
    @NotNull
    private static final Set<String> CorsSimpleResponseHeaders;
    @NotNull
    private static final Set<ContentType> CorsSimpleContentTypes;

    public CORSConfig() {
        this.wildcardWithDot = "*.";
    }

    @NotNull
    public final Set<String> getHosts() {
        return this.hosts;
    }

    @NotNull
    public final Set<String> getHeaders() {
        return this.headers;
    }

    public static /* synthetic */ void getHeaders$annotations() {
    }

    @NotNull
    public final Set<HttpMethod> getMethods() {
        return this.methods;
    }

    @NotNull
    public final Set<String> getExposedHeaders() {
        return this.exposedHeaders;
    }

    public static /* synthetic */ void getExposedHeaders$annotations() {
    }

    public final boolean getAllowCredentials() {
        return this.allowCredentials;
    }

    public final void setAllowCredentials(boolean bl) {
        this.allowCredentials = bl;
    }

    @NotNull
    public final List<Function1<String, Boolean>> getOriginPredicates$ktor_server_cors() {
        return this.originPredicates;
    }

    @NotNull
    public final List<Function1<String, Boolean>> getHeaderPredicates() {
        return this.headerPredicates;
    }

    public final long getMaxAgeInSeconds() {
        return this.maxAgeInSeconds;
    }

    public final void setMaxAgeInSeconds(long newMaxAge) {
        if (!(newMaxAge >= 0L)) {
            boolean bl = false;
            String string2 = "maxAgeInSeconds shouldn't be negative: " + newMaxAge;
            throw new IllegalStateException(string2.toString());
        }
        this.maxAgeInSeconds = newMaxAge;
    }

    public final boolean getAllowSameOrigin() {
        return this.allowSameOrigin;
    }

    public final void setAllowSameOrigin(boolean bl) {
        this.allowSameOrigin = bl;
    }

    public final boolean getAllowNonSimpleContentTypes() {
        return this.allowNonSimpleContentTypes;
    }

    public final void setAllowNonSimpleContentTypes(boolean bl) {
        this.allowNonSimpleContentTypes = bl;
    }

    public final void anyHost() {
        this.hosts.add("*");
    }

    public final void allowHost(@NotNull String host, @NotNull List<String> schemes, @NotNull List<String> subDomains) {
        Intrinsics.checkNotNullParameter(host, "host");
        Intrinsics.checkNotNullParameter(schemes, "schemes");
        Intrinsics.checkNotNullParameter(subDomains, "subDomains");
        if (Intrinsics.areEqual(host, "*")) {
            this.anyHost();
            return;
        }
        if (!(!StringsKt.contains$default((CharSequence)host, "://", false, 2, null))) {
            boolean $i$a$-require-CORSConfig$allowHost$22 = false;
            String $i$a$-require-CORSConfig$allowHost$22 = "scheme should be specified as a separate parameter schemes";
            throw new IllegalArgumentException($i$a$-require-CORSConfig$allowHost$22.toString());
        }
        for (String schema : schemes) {
            this.addHost(schema + "://" + host);
            for (String subDomain : subDomains) {
                this.validateWildcardRequirements(subDomain);
                this.addHost(schema + "://" + subDomain + '.' + host);
            }
        }
    }

    public static /* synthetic */ void allowHost$default(CORSConfig cORSConfig, String string2, List list2, List list3, int n, Object object) {
        if ((n & 2) != 0) {
            String[] stringArray = new String[]{"http", "https"};
            list2 = CollectionsKt.listOf(stringArray);
        }
        if ((n & 4) != 0) {
            list3 = CollectionsKt.emptyList();
        }
        cORSConfig.allowHost(string2, list2, list3);
    }

    private final void addHost(String host) {
        this.validateWildcardRequirements(host);
        this.hosts.add(host);
    }

    private final void validateWildcardRequirements(String host) {
        if (!StringsKt.contains$default((CharSequence)host, '*', false, 2, null)) {
            return;
        }
        if (!this.wildcardInFrontOfDomain(host)) {
            boolean $i$a$-require-CORSConfig$validateWildcardRequirements$32 = false;
            String $i$a$-require-CORSConfig$validateWildcardRequirements$32 = "wildcard must appear in front of the domain, e.g. *.domain.com";
            throw new IllegalArgumentException($i$a$-require-CORSConfig$validateWildcardRequirements$32.toString());
        }
        if (!(CORSConfig.validateWildcardRequirements$countMatches(host, this.wildcardWithDot) == 1)) {
            boolean bl = false;
            String string2 = "wildcard cannot appear more than once";
            throw new IllegalArgumentException(string2.toString());
        }
    }

    private final boolean wildcardInFrontOfDomain(String host) {
        int indexOfWildcard = StringsKt.indexOf$default((CharSequence)host, this.wildcardWithDot, 0, false, 6, null);
        return StringsKt.contains$default((CharSequence)host, this.wildcardWithDot, false, 2, null) && !StringsKt.endsWith$default(host, this.wildcardWithDot, false, 2, null) && (indexOfWildcard <= 0 || StringsKt.endsWith$default(StringsKt.substringBefore$default(host, this.wildcardWithDot, null, 2, null), "://", false, 2, null));
    }

    public final void exposeHeader(@NotNull String header2) {
        Intrinsics.checkNotNullParameter(header2, "header");
        if (!CorsSimpleResponseHeaders.contains(header2)) {
            this.exposedHeaders.add(header2);
        }
    }

    public final void allowXHttpMethodOverride() {
        this.allowHeader(HttpHeaders.INSTANCE.getXHttpMethodOverride());
    }

    public final void allowOrigins(@NotNull Function1<? super String, Boolean> predicate) {
        Intrinsics.checkNotNullParameter(predicate, "predicate");
        this.originPredicates.add(predicate);
    }

    public final void allowHeadersPrefixed(@NotNull String headerPrefix) {
        Intrinsics.checkNotNullParameter(headerPrefix, "headerPrefix");
        String string2 = headerPrefix.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue(string2, "toLowerCase(...)");
        String prefix = string2;
        this.headerPredicates.add(arg_0 -> CORSConfig.allowHeadersPrefixed$lambda$5(prefix, arg_0));
    }

    public final void allowHeaders(@NotNull Function1<? super String, Boolean> predicate) {
        Intrinsics.checkNotNullParameter(predicate, "predicate");
        this.headerPredicates.add(predicate);
    }

    public final void allowHeader(@NotNull String header2) {
        Intrinsics.checkNotNullParameter(header2, "header");
        if (StringsKt.equals(header2, HttpHeaders.INSTANCE.getContentType(), true)) {
            this.allowNonSimpleContentTypes = true;
            return;
        }
        if (!CorsSimpleRequestHeaders.contains(header2)) {
            this.headers.add(header2);
        }
    }

    public final void allowMethod(@NotNull HttpMethod method) {
        Intrinsics.checkNotNullParameter(method, "method");
        if (!CorsDefaultMethods.contains(method)) {
            this.methods.add(method);
        }
    }

    public final void anyMethod() {
        this.methods.addAll((Collection<HttpMethod>)HttpMethod.Companion.getDefaultMethods());
    }

    private static final int validateWildcardRequirements$countMatches$lambda$2(String $subString, CharSequence it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return Intrinsics.areEqual(it, $subString) ? 1 : 0;
    }

    private static final int validateWildcardRequirements$countMatches(String $this$validateWildcardRequirements_u24countMatches, String subString) {
        return CollectionsKt.sumOfInt(StringsKt.windowed$default($this$validateWildcardRequirements_u24countMatches, subString.length(), 0, false, arg_0 -> CORSConfig.validateWildcardRequirements$countMatches$lambda$2(subString, arg_0), 6, null));
    }

    private static final boolean allowHeadersPrefixed$lambda$5(String $prefix, String name) {
        Intrinsics.checkNotNullParameter(name, "name");
        return StringsKt.startsWith$default(name, $prefix, false, 2, null);
    }

    static {
        Object[] objectArray = new HttpMethod[]{HttpMethod.Companion.getGet(), HttpMethod.Companion.getPost(), HttpMethod.Companion.getHead()};
        CorsDefaultMethods = SetsKt.setOf(objectArray);
        objectArray = new String[]{HttpHeaders.INSTANCE.getAccept(), HttpHeaders.INSTANCE.getAcceptLanguage(), HttpHeaders.INSTANCE.getContentLanguage(), HttpHeaders.INSTANCE.getContentType()};
        CorsSimpleRequestHeaders = CORSConfig.Companion.caseInsensitiveSet((String[])objectArray);
        objectArray = new String[]{HttpHeaders.INSTANCE.getCacheControl(), HttpHeaders.INSTANCE.getContentLanguage(), HttpHeaders.INSTANCE.getContentType(), HttpHeaders.INSTANCE.getExpires(), HttpHeaders.INSTANCE.getLastModified(), HttpHeaders.INSTANCE.getPragma()};
        CorsSimpleResponseHeaders = CORSConfig.Companion.caseInsensitiveSet((String[])objectArray);
        objectArray = new ContentType[]{ContentType.Application.INSTANCE.getFormUrlEncoded(), ContentType.MultiPart.INSTANCE.getFormData(), ContentType.Text.INSTANCE.getPlain()};
        CorsSimpleContentTypes = CollectionsJvmKt.unmodifiable(SetsKt.setOf(objectArray));
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J)\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\u00072\u0012\u0010\u0006\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00050\u0004\"\u00020\u0005H\u0002\u00a2\u0006\u0004\b\b\u0010\tR\u0014\u0010\u000b\u001a\u00020\n8\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u000b\u0010\fR\u001d\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\r0\u00078\u0006\u00a2\u0006\f\n\u0004\b\u000e\u0010\u000f\u001a\u0004\b\u0010\u0010\u0011R\u001d\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00050\u00078\u0006\u00a2\u0006\f\n\u0004\b\u0012\u0010\u000f\u001a\u0004\b\u0013\u0010\u0011R\u001d\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00050\u00078\u0006\u00a2\u0006\f\n\u0004\b\u0014\u0010\u000f\u001a\u0004\b\u0015\u0010\u0011R#\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00160\u00078\u0006\u00a2\u0006\u0012\n\u0004\b\u0017\u0010\u000f\u0012\u0004\b\u0019\u0010\u0003\u001a\u0004\b\u0018\u0010\u0011\u00a8\u0006\u001a"}, d2={"Lio/ktor/server/plugins/cors/CORSConfig$Companion;", "", "<init>", "()V", "", "", "elements", "", "caseInsensitiveSet", "([Ljava/lang/String;)Ljava/util/Set;", "", "CORS_DEFAULT_MAX_AGE", "J", "Lio/ktor/http/HttpMethod;", "CorsDefaultMethods", "Ljava/util/Set;", "getCorsDefaultMethods", "()Ljava/util/Set;", "CorsSimpleRequestHeaders", "getCorsSimpleRequestHeaders", "CorsSimpleResponseHeaders", "getCorsSimpleResponseHeaders", "Lio/ktor/http/ContentType;", "CorsSimpleContentTypes", "getCorsSimpleContentTypes", "getCorsSimpleContentTypes$annotations", "ktor-server-cors"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Set<HttpMethod> getCorsDefaultMethods() {
            return CorsDefaultMethods;
        }

        @NotNull
        public final Set<String> getCorsSimpleRequestHeaders() {
            return CorsSimpleRequestHeaders;
        }

        @NotNull
        public final Set<String> getCorsSimpleResponseHeaders() {
            return CorsSimpleResponseHeaders;
        }

        @NotNull
        public final Set<ContentType> getCorsSimpleContentTypes() {
            return CorsSimpleContentTypes;
        }

        public static /* synthetic */ void getCorsSimpleContentTypes$annotations() {
        }

        private final Set<String> caseInsensitiveSet(String ... elements) {
            return new CaseInsensitiveSet((Iterable<String>)ArraysKt.asList(elements));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

