/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.server.sessions;

import io.ktor.server.sessions.SessionTransportTransformer;
import io.ktor.util.CryptoKt;
import java.security.MessageDigest;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u000f\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007B\u001b\b\u0016\u0012\u0006\u0010\t\u001a\u00020\b\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\nJ\u0019\u0010\f\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u000b\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\f\u0010\rJ\u0017\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u000e\u0010\rJ\u0017\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0010\u0010\rR\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0011\u001a\u0004\b\u0012\u0010\u0013R\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0014\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006\u0017"}, d2={"Lio/ktor/server/sessions/SessionTransportTransformerMessageAuthentication;", "Lio/ktor/server/sessions/SessionTransportTransformer;", "Ljavax/crypto/spec/SecretKeySpec;", "keySpec", "", "algorithm", "<init>", "(Ljavax/crypto/spec/SecretKeySpec;Ljava/lang/String;)V", "", "key", "([BLjava/lang/String;)V", "transportValue", "transformRead", "(Ljava/lang/String;)Ljava/lang/String;", "transformWrite", "value", "mac", "Ljavax/crypto/spec/SecretKeySpec;", "getKeySpec", "()Ljavax/crypto/spec/SecretKeySpec;", "Ljava/lang/String;", "getAlgorithm", "()Ljava/lang/String;", "ktor-server-sessions"})
public final class SessionTransportTransformerMessageAuthentication
implements SessionTransportTransformer {
    @NotNull
    private final SecretKeySpec keySpec;
    @NotNull
    private final String algorithm;

    public SessionTransportTransformerMessageAuthentication(@NotNull SecretKeySpec keySpec, @NotNull String algorithm) {
        Intrinsics.checkNotNullParameter(keySpec, "keySpec");
        Intrinsics.checkNotNullParameter(algorithm, "algorithm");
        this.keySpec = keySpec;
        this.algorithm = algorithm;
    }

    public /* synthetic */ SessionTransportTransformerMessageAuthentication(SecretKeySpec secretKeySpec, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            string2 = "HmacSHA256";
        }
        this(secretKeySpec, string2);
    }

    @NotNull
    public final SecretKeySpec getKeySpec() {
        return this.keySpec;
    }

    @NotNull
    public final String getAlgorithm() {
        return this.algorithm;
    }

    public SessionTransportTransformerMessageAuthentication(@NotNull byte[] key, @NotNull String algorithm) {
        Intrinsics.checkNotNullParameter(key, "key");
        Intrinsics.checkNotNullParameter(algorithm, "algorithm");
        this(new SecretKeySpec(key, algorithm), algorithm);
    }

    public /* synthetic */ SessionTransportTransformerMessageAuthentication(byte[] byArray, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            string2 = "HmacSHA256";
        }
        this(byArray, string2);
    }

    @Override
    @Nullable
    public String transformRead(@NotNull String transportValue) {
        Intrinsics.checkNotNullParameter(transportValue, "transportValue");
        String expectedSignature = StringsKt.substringAfterLast(transportValue, '/', "");
        String value = StringsKt.substringBeforeLast$default(transportValue, '/', null, 2, null);
        String string2 = this.mac(value);
        byte[] byArray = string2.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue(byArray, "getBytes(...)");
        string2 = expectedSignature;
        byte[] byArray2 = string2.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue(byArray2, "getBytes(...)");
        if (MessageDigest.isEqual(byArray, byArray2)) {
            return value;
        }
        return null;
    }

    @Override
    @NotNull
    public String transformWrite(@NotNull String transportValue) {
        Intrinsics.checkNotNullParameter(transportValue, "transportValue");
        return transportValue + '/' + this.mac(transportValue);
    }

    private final String mac(String value) {
        Mac mac = Mac.getInstance(this.algorithm);
        mac.init(this.keySpec);
        String string2 = value;
        byte[] byArray = string2.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue(byArray, "getBytes(...)");
        byte[] byArray2 = mac.doFinal(byArray);
        Intrinsics.checkNotNullExpressionValue(byArray2, "doFinal(...)");
        return CryptoKt.hex(byArray2);
    }
}

