/*
 * Decompiled with CFR 0.152.
 */
package io.netty.buffer;

import io.netty.buffer.AbstractByteBuf;
import io.netty.buffer.AbstractReferenceCountedByteBuf;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufUtil;
import io.netty.util.ByteProcessor;
import io.netty.util.IllegalReferenceCountException;
import io.netty.util.NettyRuntime;
import io.netty.util.Recycler;
import io.netty.util.ReferenceCounted;
import io.netty.util.concurrent.FastThreadLocal;
import io.netty.util.concurrent.FastThreadLocalThread;
import io.netty.util.internal.ObjectPool;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.PlatformDependent;
import io.netty.util.internal.ReferenceCountUpdater;
import io.netty.util.internal.SystemPropertyUtil;
import io.netty.util.internal.ThreadExecutorMap;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.ScatteringByteChannel;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.concurrent.locks.StampedLock;

final class AdaptivePoolingAllocator {
    private static final int MIN_CHUNK_SIZE = 131072;
    private static final int EXPANSION_ATTEMPTS = 3;
    private static final int INITIAL_MAGAZINES = 4;
    private static final int RETIRE_CAPACITY = 256;
    private static final int MAX_STRIPES = NettyRuntime.availableProcessors() * 2;
    private static final int BUFS_PER_CHUNK = 8;
    private static final int MAX_CHUNK_SIZE = 0x800000;
    private static final int MAX_POOLED_BUF_SIZE = 0x100000;
    private static final int CENTRAL_QUEUE_CAPACITY = Math.max(2, SystemPropertyUtil.getInt("io.netty.allocator.centralQueueCapacity", NettyRuntime.availableProcessors()));
    private static final int MAGAZINE_BUFFER_QUEUE_CAPACITY = SystemPropertyUtil.getInt("io.netty.allocator.magazineBufferQueueCapacity", 1024);
    private static final Object NO_MAGAZINE = Boolean.TRUE;
    private final ChunkAllocator chunkAllocator;
    private final Queue<Chunk> centralQueue;
    private final StampedLock magazineExpandLock;
    private volatile Magazine[] magazines;
    private final FastThreadLocal<Object> threadLocalMagazine;
    private final Set<Magazine> liveCachedMagazines;
    private volatile boolean freed;

    AdaptivePoolingAllocator(ChunkAllocator chunkAllocator, MagazineCaching magazineCaching) {
        ObjectUtil.checkNotNull(chunkAllocator, "chunkAllocator");
        ObjectUtil.checkNotNull(magazineCaching, "magazineCaching");
        this.chunkAllocator = chunkAllocator;
        this.centralQueue = ObjectUtil.checkNotNull(AdaptivePoolingAllocator.createSharedChunkQueue(), "centralQueue");
        this.magazineExpandLock = new StampedLock();
        if (magazineCaching != MagazineCaching.None) {
            assert (magazineCaching == MagazineCaching.EventLoopThreads || magazineCaching == MagazineCaching.FastThreadLocalThreads);
            final boolean cachedMagazinesNonEventLoopThreads = magazineCaching == MagazineCaching.FastThreadLocalThreads;
            final CopyOnWriteArraySet<Magazine> liveMagazines = new CopyOnWriteArraySet<Magazine>();
            this.threadLocalMagazine = new FastThreadLocal<Object>(){

                @Override
                protected Object initialValue() {
                    if (cachedMagazinesNonEventLoopThreads || ThreadExecutorMap.currentExecutor() != null) {
                        if (!FastThreadLocalThread.currentThreadWillCleanupFastThreadLocals()) {
                            return NO_MAGAZINE;
                        }
                        Magazine mag = new Magazine(AdaptivePoolingAllocator.this, false);
                        liveMagazines.add(mag);
                        return mag;
                    }
                    return NO_MAGAZINE;
                }

                @Override
                protected void onRemoval(Object value) throws Exception {
                    if (value != NO_MAGAZINE) {
                        liveMagazines.remove(value);
                    }
                }
            };
            this.liveCachedMagazines = liveMagazines;
        } else {
            this.threadLocalMagazine = null;
            this.liveCachedMagazines = null;
        }
        Magazine[] mags = new Magazine[4];
        for (int i2 = 0; i2 < mags.length; ++i2) {
            mags[i2] = new Magazine(this);
        }
        this.magazines = mags;
    }

    private static Queue<Chunk> createSharedChunkQueue() {
        return PlatformDependent.newFixedMpmcQueue(CENTRAL_QUEUE_CAPACITY);
    }

    ByteBuf allocate(int size2, int maxCapacity) {
        return this.allocate(size2, maxCapacity, Thread.currentThread(), null);
    }

    private AdaptiveByteBuf allocate(int size2, int maxCapacity, Thread currentThread, AdaptiveByteBuf buf) {
        if (size2 <= 0x100000) {
            Magazine[] mags;
            Object mag;
            FastThreadLocal<Object> threadLocalMagazine = this.threadLocalMagazine;
            if (threadLocalMagazine != null && FastThreadLocalThread.currentThreadHasFastThreadLocal() && (mag = threadLocalMagazine.get()) != NO_MAGAZINE) {
                Magazine magazine = (Magazine)mag;
                if (buf == null) {
                    buf = magazine.newBuffer();
                }
                boolean allocated = magazine.tryAllocate(size2, maxCapacity, buf);
                assert (allocated) : "Allocation of threadLocalMagazine must always succeed";
                return buf;
            }
            long threadId = currentThread.getId();
            int expansions = 0;
            do {
                mags = this.magazines;
                int mask = mags.length - 1;
                int index2 = (int)(threadId & (long)mask);
                int m = Integer.numberOfTrailingZeros(~mask);
                for (int i2 = 0; i2 < m; ++i2) {
                    Magazine mag2 = mags[index2 + i2 & mask];
                    if (buf == null) {
                        buf = mag2.newBuffer();
                    }
                    if (!mag2.tryAllocate(size2, maxCapacity, buf)) continue;
                    return buf;
                }
            } while (++expansions <= 3 && this.tryExpandMagazines(mags.length));
        }
        return this.allocateFallback(size2, maxCapacity, currentThread, buf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AdaptiveByteBuf allocateFallback(int size2, int maxCapacity, Thread currentThread, AdaptiveByteBuf buf) {
        Magazine magazine;
        if (buf != null) {
            Chunk chunk = buf.chunk;
            if (chunk == null || chunk == Magazine.MAGAZINE_FREED || (magazine = chunk.currentMagazine()) == null) {
                magazine = this.getFallbackMagazine(currentThread);
            }
        } else {
            magazine = this.getFallbackMagazine(currentThread);
            buf = magazine.newBuffer();
        }
        AbstractByteBuf innerChunk = this.chunkAllocator.allocate(size2, maxCapacity);
        Chunk chunk = new Chunk(innerChunk, magazine, false);
        try {
            chunk.readInitInto(buf, size2, size2, maxCapacity);
        }
        finally {
            chunk.release();
        }
        return buf;
    }

    private Magazine getFallbackMagazine(Thread currentThread) {
        Object tlMag;
        FastThreadLocal<Object> threadLocalMagazine = this.threadLocalMagazine;
        if (threadLocalMagazine != null && FastThreadLocalThread.currentThreadHasFastThreadLocal() && (tlMag = threadLocalMagazine.get()) != NO_MAGAZINE) {
            return (Magazine)tlMag;
        }
        Magazine[] mags = this.magazines;
        return mags[(int)currentThread.getId() & mags.length - 1];
    }

    void allocate(int size2, int maxCapacity, AdaptiveByteBuf into) {
        AdaptiveByteBuf result2 = this.allocate(size2, maxCapacity, Thread.currentThread(), into);
        assert (result2 == into) : "Re-allocation created separate buffer instance";
    }

    long usedMemory() {
        long sum = 0L;
        for (Chunk chunk : this.centralQueue) {
            sum += (long)chunk.capacity();
        }
        for (Magazine magazine : this.magazines) {
            sum += magazine.usedMemory.get();
        }
        if (this.liveCachedMagazines != null) {
            for (Magazine magazine : this.liveCachedMagazines) {
                sum += magazine.usedMemory.get();
            }
        }
        return sum;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean tryExpandMagazines(int currentLength) {
        if (currentLength >= MAX_STRIPES) {
            return true;
        }
        long writeLock = this.magazineExpandLock.tryWriteLock();
        if (writeLock != 0L) {
            Magazine[] mags;
            try {
                mags = this.magazines;
                if (mags.length >= MAX_STRIPES || mags.length > currentLength || this.freed) {
                    boolean bl = true;
                    return bl;
                }
                int preferredChunkSize = mags[0].sharedPrefChunkSize;
                Magazine[] expanded = new Magazine[mags.length * 2];
                int l = expanded.length;
                for (int i2 = 0; i2 < l; ++i2) {
                    Magazine m = new Magazine(this);
                    m.localPrefChunkSize = preferredChunkSize;
                    m.sharedPrefChunkSize = preferredChunkSize;
                    expanded[i2] = m;
                }
                this.magazines = expanded;
            }
            finally {
                this.magazineExpandLock.unlockWrite(writeLock);
            }
            for (Magazine magazine : mags) {
                magazine.free();
            }
        }
        return true;
    }

    boolean offerToQueue(Chunk buffer) {
        if (this.freed) {
            return false;
        }
        assert (buffer.allocatedBytes == 0);
        assert (buffer.magazine == null);
        boolean isAdded = this.centralQueue.offer(buffer);
        if (this.freed && isAdded) {
            this.freeCentralQueue();
        }
        return isAdded;
    }

    protected void finalize() throws Throwable {
        try {
            super.finalize();
        }
        finally {
            this.free();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void free() {
        this.freed = true;
        long stamp = this.magazineExpandLock.writeLock();
        try {
            Magazine[] mags;
            for (Magazine magazine : mags = this.magazines) {
                magazine.free();
            }
        }
        finally {
            this.magazineExpandLock.unlockWrite(stamp);
        }
        this.freeCentralQueue();
    }

    private void freeCentralQueue() {
        Chunk chunk;
        while ((chunk = this.centralQueue.poll()) != null) {
            chunk.release();
        }
    }

    static int sizeBucket(int size2) {
        return AllocationStatistics.sizeBucket(size2);
    }

    static {
        if (MAGAZINE_BUFFER_QUEUE_CAPACITY < 2) {
            throw new IllegalArgumentException("MAGAZINE_BUFFER_QUEUE_CAPACITY: " + MAGAZINE_BUFFER_QUEUE_CAPACITY + " (expected: >= " + 2 + ')');
        }
    }

    static interface ChunkAllocator {
        public AbstractByteBuf allocate(int var1, int var2);
    }

    static final class AdaptiveByteBuf
    extends AbstractReferenceCountedByteBuf {
        private final ObjectPool.Handle<AdaptiveByteBuf> handle;
        private int adjustment;
        private AbstractByteBuf rootParent;
        Chunk chunk;
        private int length;
        private int maxFastCapacity;
        private ByteBuffer tmpNioBuf;
        private boolean hasArray;
        private boolean hasMemoryAddress;

        AdaptiveByteBuf(ObjectPool.Handle<AdaptiveByteBuf> recyclerHandle) {
            super(0);
            this.handle = ObjectUtil.checkNotNull(recyclerHandle, "recyclerHandle");
        }

        void init(AbstractByteBuf unwrapped, Chunk wrapped, int readerIndex, int writerIndex, int adjustment, int size2, int capacity, int maxCapacity) {
            this.adjustment = adjustment;
            this.chunk = wrapped;
            this.length = size2;
            this.maxFastCapacity = capacity;
            this.maxCapacity(maxCapacity);
            this.setIndex0(readerIndex, writerIndex);
            this.hasArray = unwrapped.hasArray();
            this.hasMemoryAddress = unwrapped.hasMemoryAddress();
            this.rootParent = unwrapped;
            this.tmpNioBuf = null;
        }

        private AbstractByteBuf rootParent() {
            AbstractByteBuf rootParent = this.rootParent;
            if (rootParent != null) {
                return rootParent;
            }
            throw new IllegalReferenceCountException();
        }

        @Override
        public int capacity() {
            return this.length;
        }

        @Override
        public int maxFastWritableBytes() {
            return this.maxFastCapacity;
        }

        @Override
        public ByteBuf capacity(int newCapacity) {
            if (this.length <= newCapacity && newCapacity <= this.maxFastCapacity) {
                this.ensureAccessible();
                this.length = newCapacity;
                return this;
            }
            this.checkNewCapacity(newCapacity);
            if (newCapacity < this.capacity()) {
                this.length = newCapacity;
                this.setIndex0(Math.min(this.readerIndex(), newCapacity), Math.min(this.writerIndex(), newCapacity));
                return this;
            }
            Chunk chunk = this.chunk;
            AdaptivePoolingAllocator allocator = chunk.allocator;
            int readerIndex = this.readerIndex;
            int writerIndex = this.writerIndex;
            int baseOldRootIndex = this.adjustment;
            int oldCapacity = this.length;
            AbstractByteBuf oldRoot = this.rootParent();
            this.length = 0;
            allocator.allocate(newCapacity, this.maxCapacity(), this);
            oldRoot.getBytes(baseOldRootIndex, this, 0, oldCapacity);
            chunk.release();
            this.readerIndex = readerIndex;
            this.writerIndex = writerIndex;
            return this;
        }

        @Override
        public ByteBufAllocator alloc() {
            return this.rootParent().alloc();
        }

        @Override
        public ByteOrder order() {
            return this.rootParent().order();
        }

        @Override
        public ByteBuf unwrap() {
            return null;
        }

        @Override
        public boolean isDirect() {
            return this.rootParent().isDirect();
        }

        @Override
        public int arrayOffset() {
            return this.idx(this.rootParent().arrayOffset());
        }

        @Override
        public boolean hasMemoryAddress() {
            return this.hasMemoryAddress;
        }

        @Override
        public long memoryAddress() {
            this.ensureAccessible();
            return this.rootParent().memoryAddress() + (long)this.adjustment;
        }

        @Override
        public ByteBuffer nioBuffer(int index2, int length) {
            this.checkIndex(index2, length);
            return this.rootParent().nioBuffer(this.idx(index2), length);
        }

        @Override
        public ByteBuffer internalNioBuffer(int index2, int length) {
            this.checkIndex(index2, length);
            return (ByteBuffer)this.internalNioBuffer().position(index2).limit(index2 + length);
        }

        private ByteBuffer internalNioBuffer() {
            if (this.tmpNioBuf == null) {
                this.tmpNioBuf = this.rootParent().nioBuffer(this.adjustment, this.maxFastCapacity);
            }
            return (ByteBuffer)this.tmpNioBuf.clear();
        }

        @Override
        public ByteBuffer[] nioBuffers(int index2, int length) {
            this.checkIndex(index2, length);
            return this.rootParent().nioBuffers(this.idx(index2), length);
        }

        @Override
        public boolean hasArray() {
            return this.hasArray;
        }

        @Override
        public byte[] array() {
            this.ensureAccessible();
            return this.rootParent().array();
        }

        @Override
        public ByteBuf copy(int index2, int length) {
            this.checkIndex(index2, length);
            return this.rootParent().copy(this.idx(index2), length);
        }

        @Override
        public int nioBufferCount() {
            return this.rootParent().nioBufferCount();
        }

        @Override
        protected byte _getByte(int index2) {
            return this.rootParent()._getByte(this.idx(index2));
        }

        @Override
        protected short _getShort(int index2) {
            return this.rootParent()._getShort(this.idx(index2));
        }

        @Override
        protected short _getShortLE(int index2) {
            return this.rootParent()._getShortLE(this.idx(index2));
        }

        @Override
        protected int _getUnsignedMedium(int index2) {
            return this.rootParent()._getUnsignedMedium(this.idx(index2));
        }

        @Override
        protected int _getUnsignedMediumLE(int index2) {
            return this.rootParent()._getUnsignedMediumLE(this.idx(index2));
        }

        @Override
        protected int _getInt(int index2) {
            return this.rootParent()._getInt(this.idx(index2));
        }

        @Override
        protected int _getIntLE(int index2) {
            return this.rootParent()._getIntLE(this.idx(index2));
        }

        @Override
        protected long _getLong(int index2) {
            return this.rootParent()._getLong(this.idx(index2));
        }

        @Override
        protected long _getLongLE(int index2) {
            return this.rootParent()._getLongLE(this.idx(index2));
        }

        @Override
        public ByteBuf getBytes(int index2, ByteBuf dst, int dstIndex, int length) {
            this.checkIndex(index2, length);
            this.rootParent().getBytes(this.idx(index2), dst, dstIndex, length);
            return this;
        }

        @Override
        public ByteBuf getBytes(int index2, byte[] dst, int dstIndex, int length) {
            this.checkIndex(index2, length);
            this.rootParent().getBytes(this.idx(index2), dst, dstIndex, length);
            return this;
        }

        @Override
        public ByteBuf getBytes(int index2, ByteBuffer dst) {
            this.checkIndex(index2, dst.remaining());
            this.rootParent().getBytes(this.idx(index2), dst);
            return this;
        }

        @Override
        protected void _setByte(int index2, int value) {
            this.rootParent()._setByte(this.idx(index2), value);
        }

        @Override
        protected void _setShort(int index2, int value) {
            this.rootParent()._setShort(this.idx(index2), value);
        }

        @Override
        protected void _setShortLE(int index2, int value) {
            this.rootParent()._setShortLE(this.idx(index2), value);
        }

        @Override
        protected void _setMedium(int index2, int value) {
            this.rootParent()._setMedium(this.idx(index2), value);
        }

        @Override
        protected void _setMediumLE(int index2, int value) {
            this.rootParent()._setMediumLE(this.idx(index2), value);
        }

        @Override
        protected void _setInt(int index2, int value) {
            this.rootParent()._setInt(this.idx(index2), value);
        }

        @Override
        protected void _setIntLE(int index2, int value) {
            this.rootParent()._setIntLE(this.idx(index2), value);
        }

        @Override
        protected void _setLong(int index2, long value) {
            this.rootParent()._setLong(this.idx(index2), value);
        }

        @Override
        protected void _setLongLE(int index2, long value) {
            this.rootParent().setLongLE(this.idx(index2), value);
        }

        @Override
        public ByteBuf setBytes(int index2, byte[] src, int srcIndex, int length) {
            this.checkIndex(index2, length);
            ByteBuffer tmp = (ByteBuffer)this.internalNioBuffer().clear().position(index2);
            tmp.put(src, srcIndex, length);
            return this;
        }

        @Override
        public ByteBuf setBytes(int index2, ByteBuf src, int srcIndex, int length) {
            this.checkIndex(index2, length);
            ByteBuffer tmp = (ByteBuffer)this.internalNioBuffer().clear().position(index2);
            tmp.put(src.nioBuffer(srcIndex, length));
            return this;
        }

        @Override
        public ByteBuf setBytes(int index2, ByteBuffer src) {
            this.checkIndex(index2, src.remaining());
            ByteBuffer tmp = (ByteBuffer)this.internalNioBuffer().clear().position(index2);
            tmp.put(src);
            return this;
        }

        @Override
        public ByteBuf getBytes(int index2, OutputStream out, int length) throws IOException {
            this.checkIndex(index2, length);
            if (length != 0) {
                ByteBufUtil.readBytes(this.alloc(), this.internalNioBuffer().duplicate(), index2, length, out);
            }
            return this;
        }

        @Override
        public int getBytes(int index2, GatheringByteChannel out, int length) throws IOException {
            return out.write(this.internalNioBuffer(index2, length).duplicate());
        }

        @Override
        public int getBytes(int index2, FileChannel out, long position, int length) throws IOException {
            return out.write(this.internalNioBuffer(index2, length).duplicate(), position);
        }

        @Override
        public int setBytes(int index2, InputStream in, int length) throws IOException {
            this.checkIndex(index2, length);
            AbstractByteBuf rootParent = this.rootParent();
            if (rootParent.hasArray()) {
                return rootParent.setBytes(this.idx(index2), in, length);
            }
            byte[] tmp = ByteBufUtil.threadLocalTempArray(length);
            int readBytes2 = in.read(tmp, 0, length);
            if (readBytes2 <= 0) {
                return readBytes2;
            }
            this.setBytes(index2, tmp, 0, readBytes2);
            return readBytes2;
        }

        @Override
        public int setBytes(int index2, ScatteringByteChannel in, int length) throws IOException {
            try {
                return in.read(this.internalNioBuffer(index2, length).duplicate());
            }
            catch (ClosedChannelException ignored) {
                return -1;
            }
        }

        @Override
        public int setBytes(int index2, FileChannel in, long position, int length) throws IOException {
            try {
                return in.read(this.internalNioBuffer(index2, length).duplicate(), position);
            }
            catch (ClosedChannelException ignored) {
                return -1;
            }
        }

        @Override
        public int setCharSequence(int index2, CharSequence sequence2, Charset charset) {
            this.checkIndex(index2, sequence2.length());
            return this.rootParent().setCharSequence(this.idx(index2), sequence2, charset);
        }

        @Override
        public int forEachByte(int index2, int length, ByteProcessor processor) {
            this.checkIndex(index2, length);
            int ret = this.rootParent().forEachByte(this.idx(index2), length, processor);
            return this.forEachResult(ret);
        }

        @Override
        public int forEachByteDesc(int index2, int length, ByteProcessor processor) {
            this.checkIndex(index2, length);
            int ret = this.rootParent().forEachByteDesc(this.idx(index2), length, processor);
            return this.forEachResult(ret);
        }

        private int forEachResult(int ret) {
            if (ret < this.adjustment) {
                return -1;
            }
            return ret - this.adjustment;
        }

        @Override
        public boolean isContiguous() {
            return this.rootParent().isContiguous();
        }

        private int idx(int index2) {
            return index2 + this.adjustment;
        }

        @Override
        protected void deallocate() {
            if (this.chunk != null) {
                this.chunk.release();
            }
            this.tmpNioBuf = null;
            this.chunk = null;
            this.rootParent = null;
            if (this.handle instanceof Recycler.EnhancedHandle) {
                Recycler.EnhancedHandle enhancedHandle = (Recycler.EnhancedHandle)this.handle;
                enhancedHandle.unguardedRecycle(this);
            } else {
                this.handle.recycle(this);
            }
        }
    }

    private static final class Chunk
    implements ReferenceCounted {
        private final AbstractByteBuf delegate;
        private Magazine magazine;
        private final AdaptivePoolingAllocator allocator;
        private final int capacity;
        private final boolean pooled;
        private int allocatedBytes;
        private static final long REFCNT_FIELD_OFFSET = ReferenceCountUpdater.getUnsafeOffset(Chunk.class, "refCnt");
        private static final AtomicIntegerFieldUpdater<Chunk> AIF_UPDATER = AtomicIntegerFieldUpdater.newUpdater(Chunk.class, "refCnt");
        private static final ReferenceCountUpdater<Chunk> updater = new ReferenceCountUpdater<Chunk>(){

            @Override
            protected AtomicIntegerFieldUpdater<Chunk> updater() {
                return AIF_UPDATER;
            }

            @Override
            protected long unsafeOffset() {
                return REFCNT_FIELD_OFFSET;
            }
        };
        private volatile int refCnt;

        Chunk() {
            this.delegate = null;
            this.magazine = null;
            this.allocator = null;
            this.capacity = 0;
            this.pooled = false;
        }

        Chunk(AbstractByteBuf delegate, Magazine magazine, boolean pooled) {
            this.delegate = delegate;
            this.pooled = pooled;
            this.capacity = delegate.capacity();
            updater.setInitialValue(this);
            this.allocator = magazine.parent;
            this.attachToMagazine(magazine);
        }

        Magazine currentMagazine() {
            return this.magazine;
        }

        void detachFromMagazine() {
            if (this.magazine != null) {
                this.magazine.usedMemory.getAndAdd(-this.capacity);
                this.magazine = null;
            }
        }

        void attachToMagazine(Magazine magazine) {
            assert (this.magazine == null);
            this.magazine = magazine;
            magazine.usedMemory.getAndAdd(this.capacity);
        }

        @Override
        public Chunk touch(Object hint) {
            return this;
        }

        @Override
        public int refCnt() {
            return updater.refCnt(this);
        }

        @Override
        public Chunk retain() {
            return updater.retain(this);
        }

        @Override
        public Chunk retain(int increment) {
            return updater.retain(this, increment);
        }

        @Override
        public Chunk touch() {
            return this;
        }

        @Override
        public boolean release() {
            if (updater.release(this)) {
                this.deallocate();
                return true;
            }
            return false;
        }

        @Override
        public boolean release(int decrement) {
            if (updater.release(this, decrement)) {
                this.deallocate();
                return true;
            }
            return false;
        }

        private void deallocate() {
            Magazine mag = this.magazine;
            AdaptivePoolingAllocator parent = mag.parent;
            int chunkSize = mag.preferredChunkSize();
            int memSize = this.delegate.capacity();
            if (!this.pooled || Chunk.shouldReleaseSuboptimalChunkSize(memSize, chunkSize)) {
                this.detachFromMagazine();
                this.delegate.release();
            } else {
                updater.resetRefCnt(this);
                this.delegate.setIndex(0, 0);
                this.allocatedBytes = 0;
                if (!mag.trySetNextInLine(this)) {
                    this.detachFromMagazine();
                    if (!parent.offerToQueue(this)) {
                        boolean released = updater.release(this);
                        this.delegate.release();
                        assert (released);
                    }
                }
            }
        }

        private static boolean shouldReleaseSuboptimalChunkSize(int givenSize, int preferredSize) {
            int givenChunks = givenSize / 131072;
            int preferredChunks = preferredSize / 131072;
            int deviation = Math.abs(givenChunks - preferredChunks);
            return deviation != 0 && ThreadLocalRandom.current().nextDouble() * 20.0 < (double)deviation;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void readInitInto(AdaptiveByteBuf buf, int size2, int startingCapacity, int maxCapacity) {
            int startIndex = this.allocatedBytes;
            this.allocatedBytes = startIndex + startingCapacity;
            Chunk chunk = this;
            chunk.retain();
            try {
                buf.init(this.delegate, chunk, 0, 0, startIndex, size2, startingCapacity, maxCapacity);
                chunk = null;
            }
            finally {
                if (chunk != null) {
                    this.allocatedBytes = startIndex;
                    chunk.release();
                }
            }
        }

        public int remainingCapacity() {
            return this.capacity - this.allocatedBytes;
        }

        public int capacity() {
            return this.capacity;
        }
    }

    private static final class Magazine
    extends AllocationStatistics {
        private static final AtomicReferenceFieldUpdater<Magazine, Chunk> NEXT_IN_LINE = AtomicReferenceFieldUpdater.newUpdater(Magazine.class, Chunk.class, "nextInLine");
        private static final Chunk MAGAZINE_FREED = new Chunk();
        private static final ObjectPool<AdaptiveByteBuf> EVENT_LOOP_LOCAL_BUFFER_POOL = ObjectPool.newPool(new ObjectPool.ObjectCreator<AdaptiveByteBuf>(){

            @Override
            public AdaptiveByteBuf newObject(ObjectPool.Handle<AdaptiveByteBuf> handle) {
                return new AdaptiveByteBuf(handle);
            }
        });
        private Chunk current;
        private volatile Chunk nextInLine;
        private final AtomicLong usedMemory;
        private final StampedLock allocationLock;
        private final Queue<AdaptiveByteBuf> bufferQueue;
        private final ObjectPool.Handle<AdaptiveByteBuf> handle;

        Magazine(AdaptivePoolingAllocator parent) {
            this(parent, true);
        }

        Magazine(AdaptivePoolingAllocator parent, boolean shareable) {
            super(parent, shareable);
            if (shareable) {
                this.allocationLock = new StampedLock();
                this.bufferQueue = PlatformDependent.newFixedMpmcQueue(MAGAZINE_BUFFER_QUEUE_CAPACITY);
                this.handle = new ObjectPool.Handle<AdaptiveByteBuf>(){

                    @Override
                    public void recycle(AdaptiveByteBuf self) {
                        bufferQueue.offer(self);
                    }
                };
            } else {
                this.allocationLock = null;
                this.bufferQueue = null;
                this.handle = null;
            }
            this.usedMemory = new AtomicLong();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean tryAllocate(int size2, int maxCapacity, AdaptiveByteBuf buf) {
            if (this.allocationLock == null) {
                return this.allocate(size2, maxCapacity, buf);
            }
            long writeLock = this.allocationLock.tryWriteLock();
            if (writeLock != 0L) {
                try {
                    boolean bl = this.allocate(size2, maxCapacity, buf);
                    return bl;
                }
                finally {
                    this.allocationLock.unlockWrite(writeLock);
                }
            }
            return this.allocateWithoutLock(size2, maxCapacity, buf);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean allocateWithoutLock(int size2, int maxCapacity, AdaptiveByteBuf buf) {
            Chunk curr = NEXT_IN_LINE.getAndSet(this, null);
            if (curr == MAGAZINE_FREED) {
                this.restoreMagazineFreed();
                return false;
            }
            if (curr == null) {
                curr = (Chunk)this.parent.centralQueue.poll();
                if (curr == null) {
                    return false;
                }
                curr.attachToMagazine(this);
            }
            boolean allocated = false;
            int remainingCapacity = curr.remainingCapacity();
            int startingCapacity = this.getStartingCapacity(size2, maxCapacity);
            if (remainingCapacity >= size2) {
                curr.readInitInto(buf, size2, Math.min(remainingCapacity, startingCapacity), maxCapacity);
                allocated = true;
            }
            try {
                if (remainingCapacity >= 256) {
                    this.transferToNextInLineOrRelease(curr);
                    curr = null;
                }
            }
            finally {
                if (curr != null) {
                    curr.release();
                }
            }
            return allocated;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean allocate(int size2, int maxCapacity, AdaptiveByteBuf buf) {
            int remainingCapacity;
            this.recordAllocationSize(buf.length);
            int startingCapacity = this.getStartingCapacity(size2, maxCapacity);
            Chunk curr = this.current;
            if (curr != null) {
                remainingCapacity = curr.remainingCapacity();
                if (remainingCapacity > startingCapacity) {
                    curr.readInitInto(buf, size2, startingCapacity, maxCapacity);
                    return true;
                }
                this.current = null;
                if (remainingCapacity >= size2) {
                    try {
                        curr.readInitInto(buf, size2, remainingCapacity, maxCapacity);
                        boolean bl = true;
                        return bl;
                    }
                    finally {
                        curr.release();
                    }
                }
                if (remainingCapacity < 256) {
                    curr.release();
                } else {
                    this.transferToNextInLineOrRelease(curr);
                }
            }
            assert (this.current == null);
            curr = NEXT_IN_LINE.getAndSet(this, null);
            if (curr != null) {
                if (curr == MAGAZINE_FREED) {
                    this.restoreMagazineFreed();
                    return false;
                }
                remainingCapacity = curr.remainingCapacity();
                if (remainingCapacity > startingCapacity) {
                    curr.readInitInto(buf, size2, startingCapacity, maxCapacity);
                    this.current = curr;
                    return true;
                }
                if (remainingCapacity >= size2) {
                    try {
                        curr.readInitInto(buf, size2, remainingCapacity, maxCapacity);
                        boolean bl = true;
                        return bl;
                    }
                    finally {
                        curr.release();
                    }
                }
                curr.release();
            }
            if ((curr = (Chunk)this.parent.centralQueue.poll()) == null) {
                curr = this.newChunkAllocation(size2);
            } else {
                curr.attachToMagazine(this);
                remainingCapacity = curr.remainingCapacity();
                if (remainingCapacity < size2) {
                    if (remainingCapacity < 256) {
                        curr.release();
                    } else {
                        this.transferToNextInLineOrRelease(curr);
                    }
                    curr = this.newChunkAllocation(size2);
                }
            }
            this.current = curr;
            try {
                remainingCapacity = curr.remainingCapacity();
                assert (remainingCapacity >= size2);
                if (remainingCapacity > startingCapacity) {
                    curr.readInitInto(buf, size2, startingCapacity, maxCapacity);
                    curr = null;
                } else {
                    curr.readInitInto(buf, size2, remainingCapacity, maxCapacity);
                }
            }
            finally {
                if (curr != null) {
                    curr.release();
                    this.current = null;
                }
            }
            return true;
        }

        private int getStartingCapacity(int size2, int maxCapacity) {
            int startCapLimits = size2 <= 2048 ? 16384 : (size2 <= 32768 ? 65536 : size2 * 2);
            int startingCapacity = Math.min(startCapLimits, this.localUpperBufSize);
            startingCapacity = Math.max(size2, Math.min(maxCapacity, startingCapacity));
            return startingCapacity;
        }

        private void restoreMagazineFreed() {
            Chunk next2 = NEXT_IN_LINE.getAndSet(this, MAGAZINE_FREED);
            if (next2 != null && next2 != MAGAZINE_FREED) {
                next2.release();
            }
        }

        private void transferToNextInLineOrRelease(Chunk chunk) {
            if (NEXT_IN_LINE.compareAndSet(this, null, chunk)) {
                return;
            }
            Chunk nextChunk = NEXT_IN_LINE.get(this);
            if (nextChunk != null && nextChunk != MAGAZINE_FREED && chunk.remainingCapacity() > nextChunk.remainingCapacity() && NEXT_IN_LINE.compareAndSet(this, nextChunk, chunk)) {
                nextChunk.release();
                return;
            }
            chunk.release();
        }

        private Chunk newChunkAllocation(int promptingSize) {
            int size2 = Math.max(promptingSize * 8, this.preferredChunkSize());
            int minChunks = size2 / 131072;
            if (131072 * minChunks < size2) {
                size2 = 131072 * (1 + minChunks);
            }
            size2 = Math.min(size2, 0x800000);
            if (!this.hasHadRotation && this.sharedPrefChunkSize == 131072) {
                this.sharedPrefChunkSize = size2;
            }
            ChunkAllocator chunkAllocator = this.parent.chunkAllocator;
            return new Chunk(chunkAllocator.allocate(size2, size2), this, true);
        }

        boolean trySetNextInLine(Chunk chunk) {
            return NEXT_IN_LINE.compareAndSet(this, null, chunk);
        }

        void free() {
            this.restoreMagazineFreed();
            long stamp = this.allocationLock.writeLock();
            try {
                if (this.current != null) {
                    this.current.release();
                    this.current = null;
                }
            }
            finally {
                this.allocationLock.unlockWrite(stamp);
            }
        }

        public AdaptiveByteBuf newBuffer() {
            AdaptiveByteBuf buf;
            if (this.handle == null) {
                buf = EVENT_LOOP_LOCAL_BUFFER_POOL.get();
            } else {
                buf = this.bufferQueue.poll();
                if (buf == null) {
                    buf = new AdaptiveByteBuf(this.handle);
                }
            }
            buf.resetRefCnt();
            buf.discardMarks();
            return buf;
        }
    }

    private static class AllocationStatistics {
        private static final int MIN_DATUM_TARGET = 1024;
        private static final int MAX_DATUM_TARGET = 65534;
        private static final int INIT_DATUM_TARGET = 9;
        private static final int HISTO_MIN_BUCKET_SHIFT = 8;
        private static final int HISTO_MAX_BUCKET_SHIFT = 23;
        private static final int HISTO_BUCKET_COUNT = 16;
        private static final int HISTO_MAX_BUCKET_MASK = 15;
        private static final int SIZE_MAX_MASK = 0x7FFFFF;
        protected final AdaptivePoolingAllocator parent;
        private final boolean shareable;
        private final short[][] histos = new short[][]{new short[16], new short[16], new short[16], new short[16]};
        private short[] histo = this.histos[0];
        private final int[] sums = new int[16];
        private int histoIndex;
        private int datumCount;
        private int datumTarget = 9;
        protected boolean hasHadRotation;
        protected volatile int sharedPrefChunkSize = 131072;
        protected volatile int localPrefChunkSize = 131072;
        protected volatile int localUpperBufSize;

        private AllocationStatistics(AdaptivePoolingAllocator parent, boolean shareable) {
            this.parent = parent;
            this.shareable = shareable;
        }

        protected void recordAllocationSize(int bufferSizeToRecord) {
            int bucket;
            if (bufferSizeToRecord == 0) {
                return;
            }
            int n = bucket = AllocationStatistics.sizeBucket(bufferSizeToRecord);
            this.histo[n] = (short)(this.histo[n] + 1);
            if (this.datumCount++ == this.datumTarget) {
                this.rotateHistograms();
            }
        }

        static int sizeBucket(int size2) {
            if (size2 == 0) {
                return 0;
            }
            int normalizedSize = size2 - 1 >> 8 & 0x7FFFFF;
            return Math.min(32 - Integer.numberOfLeadingZeros(normalizedSize), 15);
        }

        private void rotateHistograms() {
            int sizeBucket;
            short[][] hs = this.histos;
            for (int i2 = 0; i2 < 16; ++i2) {
                this.sums[i2] = (hs[0][i2] & 0xFFFF) + (hs[1][i2] & 0xFFFF) + (hs[2][i2] & 0xFFFF) + (hs[3][i2] & 0xFFFF);
            }
            int sum = 0;
            for (int count2 : this.sums) {
                sum += count2;
            }
            int targetPercentile = (int)((double)sum * 0.99);
            for (sizeBucket = 0; sizeBucket < this.sums.length && this.sums[sizeBucket] <= targetPercentile; targetPercentile -= this.sums[sizeBucket], ++sizeBucket) {
            }
            this.hasHadRotation = true;
            int percentileSize = 1 << sizeBucket + 8;
            int prefChunkSize = Math.max(percentileSize * 8, 131072);
            this.localUpperBufSize = percentileSize;
            this.localPrefChunkSize = prefChunkSize;
            if (this.shareable) {
                for (Magazine mag : this.parent.magazines) {
                    prefChunkSize = Math.max(prefChunkSize, mag.localPrefChunkSize);
                }
            }
            if (this.sharedPrefChunkSize != prefChunkSize) {
                this.datumTarget = Math.max(this.datumTarget >> 1, 1024);
                this.sharedPrefChunkSize = prefChunkSize;
            } else {
                this.datumTarget = Math.min(this.datumTarget << 1, 65534);
            }
            this.histoIndex = this.histoIndex + 1 & 3;
            this.histo = this.histos[this.histoIndex];
            this.datumCount = 0;
            Arrays.fill(this.histo, (short)0);
        }

        protected int preferredChunkSize() {
            return this.sharedPrefChunkSize;
        }
    }

    static enum MagazineCaching {
        EventLoopThreads,
        FastThreadLocalThreads,
        None;

    }
}

