/*
 * Decompiled with CFR 0.152.
 */
package io.netty.buffer;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.PooledHeapByteBuf;
import io.netty.buffer.SwappedByteBuf;
import io.netty.buffer.UnsafeByteBufUtil;
import io.netty.buffer.UnsafeHeapSwappedByteBuf;
import io.netty.util.internal.ObjectPool;
import io.netty.util.internal.PlatformDependent;

final class PooledUnsafeHeapByteBuf
extends PooledHeapByteBuf {
    private static final ObjectPool<PooledUnsafeHeapByteBuf> RECYCLER = ObjectPool.newPool(new ObjectPool.ObjectCreator<PooledUnsafeHeapByteBuf>(){

        @Override
        public PooledUnsafeHeapByteBuf newObject(ObjectPool.Handle<PooledUnsafeHeapByteBuf> handle) {
            return new PooledUnsafeHeapByteBuf(handle, 0);
        }
    });

    static PooledUnsafeHeapByteBuf newUnsafeInstance(int maxCapacity) {
        PooledUnsafeHeapByteBuf buf = RECYCLER.get();
        buf.reuse(maxCapacity);
        return buf;
    }

    private PooledUnsafeHeapByteBuf(ObjectPool.Handle<PooledUnsafeHeapByteBuf> recyclerHandle, int maxCapacity) {
        super((ObjectPool.Handle<? extends PooledHeapByteBuf>)recyclerHandle, maxCapacity);
    }

    @Override
    protected byte _getByte(int index2) {
        return UnsafeByteBufUtil.getByte((byte[])this.memory, this.idx(index2));
    }

    @Override
    protected short _getShort(int index2) {
        return UnsafeByteBufUtil.getShort((byte[])this.memory, this.idx(index2));
    }

    @Override
    protected short _getShortLE(int index2) {
        return UnsafeByteBufUtil.getShortLE((byte[])this.memory, this.idx(index2));
    }

    @Override
    protected int _getUnsignedMedium(int index2) {
        return UnsafeByteBufUtil.getUnsignedMedium((byte[])this.memory, this.idx(index2));
    }

    @Override
    protected int _getUnsignedMediumLE(int index2) {
        return UnsafeByteBufUtil.getUnsignedMediumLE((byte[])this.memory, this.idx(index2));
    }

    @Override
    protected int _getInt(int index2) {
        return UnsafeByteBufUtil.getInt((byte[])this.memory, this.idx(index2));
    }

    @Override
    protected int _getIntLE(int index2) {
        return UnsafeByteBufUtil.getIntLE((byte[])this.memory, this.idx(index2));
    }

    @Override
    protected long _getLong(int index2) {
        return UnsafeByteBufUtil.getLong((byte[])this.memory, this.idx(index2));
    }

    @Override
    protected long _getLongLE(int index2) {
        return UnsafeByteBufUtil.getLongLE((byte[])this.memory, this.idx(index2));
    }

    @Override
    protected void _setByte(int index2, int value) {
        UnsafeByteBufUtil.setByte((byte[])this.memory, this.idx(index2), value);
    }

    @Override
    protected void _setShort(int index2, int value) {
        UnsafeByteBufUtil.setShort((byte[])this.memory, this.idx(index2), value);
    }

    @Override
    protected void _setShortLE(int index2, int value) {
        UnsafeByteBufUtil.setShortLE((byte[])this.memory, this.idx(index2), value);
    }

    @Override
    protected void _setMedium(int index2, int value) {
        UnsafeByteBufUtil.setMedium((byte[])this.memory, this.idx(index2), value);
    }

    @Override
    protected void _setMediumLE(int index2, int value) {
        UnsafeByteBufUtil.setMediumLE((byte[])this.memory, this.idx(index2), value);
    }

    @Override
    protected void _setInt(int index2, int value) {
        UnsafeByteBufUtil.setInt((byte[])this.memory, this.idx(index2), value);
    }

    @Override
    protected void _setIntLE(int index2, int value) {
        UnsafeByteBufUtil.setIntLE((byte[])this.memory, this.idx(index2), value);
    }

    @Override
    protected void _setLong(int index2, long value) {
        UnsafeByteBufUtil.setLong((byte[])this.memory, this.idx(index2), value);
    }

    @Override
    protected void _setLongLE(int index2, long value) {
        UnsafeByteBufUtil.setLongLE((byte[])this.memory, this.idx(index2), value);
    }

    @Override
    public ByteBuf setZero(int index2, int length) {
        this.checkIndex(index2, length);
        UnsafeByteBufUtil.setZero((byte[])this.memory, this.idx(index2), length);
        return this;
    }

    @Override
    public ByteBuf writeZero(int length) {
        this.ensureWritable(length);
        int wIndex = this.writerIndex;
        UnsafeByteBufUtil.setZero((byte[])this.memory, this.idx(wIndex), length);
        this.writerIndex = wIndex + length;
        return this;
    }

    @Override
    @Deprecated
    protected SwappedByteBuf newSwappedByteBuf() {
        if (PlatformDependent.isUnaligned()) {
            return new UnsafeHeapSwappedByteBuf(this);
        }
        return super.newSwappedByteBuf();
    }
}

