/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.skiko.swing;

import java.awt.Graphics2D;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.skia.BackendRenderTarget;
import org.jetbrains.skia.Bitmap;
import org.jetbrains.skia.Canvas;
import org.jetbrains.skia.ColorAlphaType;
import org.jetbrains.skia.ColorSpace;
import org.jetbrains.skia.DirectContext;
import org.jetbrains.skia.ImageInfo;
import org.jetbrains.skia.PixelGeometry;
import org.jetbrains.skia.Surface;
import org.jetbrains.skia.SurfaceColorFormat;
import org.jetbrains.skia.SurfaceOrigin;
import org.jetbrains.skia.SurfaceProps;
import org.jetbrains.skiko.CloseScope;
import org.jetbrains.skiko.GraphicsApi;
import org.jetbrains.skiko.Library;
import org.jetbrains.skiko.MetalAdapter;
import org.jetbrains.skiko.MetalApiKt;
import org.jetbrains.skiko.RenderException;
import org.jetbrains.skiko.ResourceUtilsKt;
import org.jetbrains.skiko.SkiaLayerAnalytics;
import org.jetbrains.skiko.SkikoRenderDelegate;
import org.jetbrains.skiko.swing.SwingLayerProperties;
import org.jetbrains.skiko.swing.SwingOffscreenDrawer;
import org.jetbrains.skiko.swing.SwingRedrawerBase;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0000\u0018\u0000 +2\u00020\u0001:\u0001+B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u0015\u001a\u00020\u0016H\u0016J\u0011\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u0014H\u0082 J\u0018\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\b\u0010\u001e\u001a\u00020\u000eH\u0002J\u0011\u0010\u001e\u001a\u00020\u00142\u0006\u0010\t\u001a\u00020\u0014H\u0082 J\u0011\u0010\u001f\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u0014H\u0082 J)\u0010 \u001a\u00020\u00142\u0006\u0010\t\u001a\u00020\u00142\u0006\u0010!\u001a\u00020\u00142\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020#H\u0082 J\b\u0010%\u001a\u00020&H\u0002J(\u0010'\u001a\u00020\u00162\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020#2\u0006\u0010(\u001a\u00020\u0014H\u0014J\b\u0010)\u001a\u00020*H\u0014R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lorg/jetbrains/skiko/swing/MetalSwingRedrawer;", "Lorg/jetbrains/skiko/swing/SwingRedrawerBase;", "swingLayerProperties", "Lorg/jetbrains/skiko/swing/SwingLayerProperties;", "renderDelegate", "Lorg/jetbrains/skiko/SkikoRenderDelegate;", "analytics", "Lorg/jetbrains/skiko/SkiaLayerAnalytics;", "(Lorg/jetbrains/skiko/swing/SwingLayerProperties;Lorg/jetbrains/skiko/SkikoRenderDelegate;Lorg/jetbrains/skiko/SkiaLayerAnalytics;)V", "adapter", "Lorg/jetbrains/skiko/MetalAdapter;", "bytesToDraw", "", "context", "Lorg/jetbrains/skia/DirectContext;", "storage", "Lorg/jetbrains/skia/Bitmap;", "swingOffscreenDrawer", "Lorg/jetbrains/skiko/swing/SwingOffscreenDrawer;", "texturePtr", "", "dispose", "", "disposeMetalTexture", "texture", "flush", "surface", "Lorg/jetbrains/skia/Surface;", "g", "Ljava/awt/Graphics2D;", "makeMetalContext", "makeMetalRenderTargetOffScreen", "makeMetalTexture", "oldTexture", "width", "", "height", "makeRenderTarget", "Lorg/jetbrains/skia/BackendRenderTarget;", "onRender", "nanoTime", "rendererInfo", "", "Companion", "skiko"})
@SourceDebugExtension(value={"SMAP\nMetalSwingRedrawer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MetalSwingRedrawer.kt\norg/jetbrains/skiko/swing/MetalSwingRedrawer\n+ 2 MetalApi.kt\norg/jetbrains/skiko/MetalApiKt\n*L\n1#1,124:1\n40#2,6:125\n*S KotlinDebug\n*F\n+ 1 MetalSwingRedrawer.kt\norg/jetbrains/skiko/swing/MetalSwingRedrawer\n*L\n58#1:125,6\n*E\n"})
public final class MetalSwingRedrawer
extends SwingRedrawerBase {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SkikoRenderDelegate renderDelegate;
    @NotNull
    private final MetalAdapter adapter;
    @NotNull
    private final DirectContext context;
    private long texturePtr;
    @NotNull
    private final Bitmap storage;
    @NotNull
    private byte[] bytesToDraw;
    @NotNull
    private final SwingOffscreenDrawer swingOffscreenDrawer;

    /*
     * WARNING - void declaration
     */
    public MetalSwingRedrawer(@NotNull SwingLayerProperties swingLayerProperties2, @NotNull SkikoRenderDelegate renderDelegate2, @NotNull SkiaLayerAnalytics analytics) {
        void it;
        MetalAdapter metalAdapter;
        Intrinsics.checkNotNullParameter(swingLayerProperties2, "swingLayerProperties");
        Intrinsics.checkNotNullParameter(renderDelegate2, "renderDelegate");
        Intrinsics.checkNotNullParameter(analytics, "analytics");
        super(swingLayerProperties2, analytics, GraphicsApi.METAL);
        this.renderDelegate = renderDelegate2;
        MetalAdapter metalAdapter2 = metalAdapter = MetalApiKt.chooseMetalAdapter(swingLayerProperties2.getAdapterPriority());
        MetalSwingRedrawer metalSwingRedrawer = this;
        boolean bl = false;
        this.onDeviceChosen(it.getName());
        metalSwingRedrawer.adapter = metalAdapter;
        this.context = this.makeMetalContext();
        this.storage = new Bitmap();
        this.bytesToDraw = new byte[0];
        this.onContextInit();
        this.swingOffscreenDrawer = new SwingOffscreenDrawer(swingLayerProperties2);
    }

    @Override
    public void dispose() {
        this.bytesToDraw = new byte[0];
        this.storage.close();
        this.disposeMetalTexture(this.texturePtr);
        this.context.close();
        MetalApiKt.dispose(this.adapter);
        super.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void onRender(@NotNull Graphics2D g, int width2, int height2, long nanoTime) {
        Intrinsics.checkNotNullParameter(g, "g");
        boolean $i$f$autoreleasepool = false;
        long handle$iv = MetalApiKt.access$openAutoreleasepool();
        try {
            boolean bl = false;
            ResourceUtilsKt.autoCloseScope((Function1<? super CloseScope, Unit>)new Function1<CloseScope, Unit>(this, width2, height2, nanoTime, g){
                final /* synthetic */ MetalSwingRedrawer this$0;
                final /* synthetic */ int $width;
                final /* synthetic */ int $height;
                final /* synthetic */ long $nanoTime;
                final /* synthetic */ Graphics2D $g;
                {
                    this.this$0 = $receiver;
                    this.$width = $width;
                    this.$height = $height;
                    this.$nanoTime = $nanoTime;
                    this.$g = $g;
                    super(1);
                }

                public final void invoke(@NotNull CloseScope $this$autoCloseScope) {
                    Surface surface;
                    Intrinsics.checkNotNullParameter($this$autoCloseScope, "$this$autoCloseScope");
                    MetalSwingRedrawer.access$setTexturePtr$p(this.this$0, MetalSwingRedrawer.access$makeMetalTexture(this.this$0, MetalSwingRedrawer.access$getAdapter$p(this.this$0).getPtr(), MetalSwingRedrawer.access$getTexturePtr$p(this.this$0), this.$width, this.$height));
                    BackendRenderTarget renderTarget = (BackendRenderTarget)$this$autoCloseScope.autoClose((AutoCloseable)MetalSwingRedrawer.access$makeRenderTarget(this.this$0));
                    Surface surface2 = Surface.Companion.makeFromBackendRenderTarget(MetalSwingRedrawer.access$getContext$p(this.this$0), renderTarget, SurfaceOrigin.TOP_LEFT, SurfaceColorFormat.BGRA_8888, ColorSpace.Companion.getSRGB(), new SurfaceProps(false, PixelGeometry.UNKNOWN, 1, null));
                    if (surface2 == null || (surface = (Surface)$this$autoCloseScope.autoClose((AutoCloseable)surface2)) == null) {
                        throw new RenderException("Cannot create surface", null, 2, null);
                    }
                    Surface surface3 = surface;
                    Canvas canvas2 = surface3.getCanvas();
                    canvas2.clear(0);
                    MetalSwingRedrawer.access$getRenderDelegate$p(this.this$0).onRender(canvas2, this.$width, this.$height, this.$nanoTime);
                    MetalSwingRedrawer.access$flush(this.this$0, surface3, this.$g);
                }
            });
            Unit unit = Unit.INSTANCE;
        }
        finally {
            MetalApiKt.access$closeAutoreleasepool(handle$iv);
        }
    }

    private final void flush(Surface surface, Graphics2D g) {
        surface.flushAndSubmit(true);
        int width2 = surface.getWidth();
        int height2 = surface.getHeight();
        int dstRowBytes = width2 * 4;
        if (this.storage.getWidth() != width2 || this.storage.getHeight() != height2) {
            this.storage.allocPixelsFlags(ImageInfo.Companion.makeS32(width2, height2, ColorAlphaType.PREMUL), false);
            this.bytesToDraw = new byte[Bitmap.getReadPixelsArraySize$skiko$default(this.storage, null, dstRowBytes, 0, 5, null)];
        }
        surface.readPixels(this.storage, 0, 0);
        boolean successfulRead = Bitmap.readPixels$skiko$default(this.storage, this.bytesToDraw, null, dstRowBytes, 0, 0, 26, null);
        if (successfulRead) {
            this.swingOffscreenDrawer.draw(g, this.bytesToDraw, width2, height2);
        }
    }

    @Override
    @NotNull
    protected String rendererInfo() {
        return super.rendererInfo() + "Video card: " + this.adapter.getName() + "\nTotal VRAM: " + this.adapter.getMemorySize() / (long)1024 / (long)1024 + " MB\n";
    }

    private final BackendRenderTarget makeRenderTarget() {
        return new BackendRenderTarget(this.makeMetalRenderTargetOffScreen(this.texturePtr));
    }

    private final DirectContext makeMetalContext() {
        return new DirectContext(this.makeMetalContext(this.adapter.getPtr()));
    }

    private final native long makeMetalContext(long var1);

    private final native long makeMetalRenderTargetOffScreen(long var1);

    private final native long makeMetalTexture(long var1, long var3, int var5, int var6);

    private final native long disposeMetalTexture(long var1);

    public static final /* synthetic */ void access$setTexturePtr$p(MetalSwingRedrawer $this, long l) {
        $this.texturePtr = l;
    }

    public static final /* synthetic */ long access$makeMetalTexture(MetalSwingRedrawer $this, long adapter2, long oldTexture, int width2, int height2) {
        return $this.makeMetalTexture(adapter2, oldTexture, width2, height2);
    }

    public static final /* synthetic */ MetalAdapter access$getAdapter$p(MetalSwingRedrawer $this) {
        return $this.adapter;
    }

    public static final /* synthetic */ long access$getTexturePtr$p(MetalSwingRedrawer $this) {
        return $this.texturePtr;
    }

    public static final /* synthetic */ BackendRenderTarget access$makeRenderTarget(MetalSwingRedrawer $this) {
        return $this.makeRenderTarget();
    }

    public static final /* synthetic */ DirectContext access$getContext$p(MetalSwingRedrawer $this) {
        return $this.context;
    }

    public static final /* synthetic */ SkikoRenderDelegate access$getRenderDelegate$p(MetalSwingRedrawer $this) {
        return $this.renderDelegate;
    }

    public static final /* synthetic */ void access$flush(MetalSwingRedrawer $this, Surface surface, Graphics2D g) {
        $this.flush(surface, g);
    }

    static {
        Library.INSTANCE.load();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lorg/jetbrains/skiko/swing/MetalSwingRedrawer$Companion;", "", "()V", "skiko"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

