/*
 * Decompiled with CFR 0.152.
 */
package com.ethlo.time.internal.fixed;

import com.ethlo.time.Field;
import com.ethlo.time.TimezoneOffset;
import com.ethlo.time.internal.DateTimeFormatException;
import com.ethlo.time.internal.util.LimitedCharArrayIntegerUtil;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;

public class ITUFormatter {
    private static final int[] widths = new int[]{100000000, 10000000, 1000000, 100000, 10000, 1000, 100, 10, 1};

    public static String finish(char[] buf, int length, TimezoneOffset tz) {
        int tzLen = 0;
        if (tz != null) {
            tzLen = ITUFormatter.writeTz(buf, length, tz);
        }
        return new String(buf, 0, length + tzLen);
    }

    private static int writeTz(char[] buf, int start2, TimezoneOffset tz) {
        if (tz.equals(TimezoneOffset.UTC)) {
            buf[start2] = 90;
            return 1;
        }
        buf[start2] = tz.getTotalSeconds() < 0 ? 45 : 43;
        LimitedCharArrayIntegerUtil.toString(Math.abs(tz.getHours()), buf, start2 + 1, 2);
        buf[start2 + 3] = 58;
        LimitedCharArrayIntegerUtil.toString(Math.abs(tz.getMinutes()), buf, start2 + 4, 2);
        return 6;
    }

    public static String formatUtc(OffsetDateTime date, int fractionDigits) {
        return ITUFormatter.doFormat(date, ZoneOffset.UTC, Field.SECOND, fractionDigits);
    }

    public static String formatUtc(OffsetDateTime date, Field lastIncluded) {
        return ITUFormatter.doFormat(date, ZoneOffset.UTC, lastIncluded, 0);
    }

    public static String format(OffsetDateTime date, ZoneOffset adjustTo, int fractionDigits) {
        return ITUFormatter.doFormat(date, adjustTo, Field.NANO, fractionDigits);
    }

    private static String doFormat(OffsetDateTime date, ZoneOffset adjustTo, Field lastIncluded, int fractionDigits) {
        boolean hasFractionDigits;
        if (fractionDigits > 9) {
            throw new DateTimeFormatException("Maximum supported number of fraction digits in second is 9, got " + fractionDigits);
        }
        OffsetDateTime adjusted = date;
        if (!date.getOffset().equals(adjustTo)) {
            adjusted = date.atZoneSameInstant(adjustTo).toOffsetDateTime();
        }
        TimezoneOffset tz = TimezoneOffset.of(adjustTo);
        char[] buffer = new char[26 + fractionDigits];
        if (ITUFormatter.handleDatePart(lastIncluded, buffer, adjusted.getYear(), 0, 4, Field.YEAR)) {
            return ITUFormatter.finish(buffer, Field.YEAR.getRequiredLength(), null);
        }
        buffer[4] = 45;
        if (ITUFormatter.handleDatePart(lastIncluded, buffer, adjusted.getMonthValue(), 5, 2, Field.MONTH)) {
            return ITUFormatter.finish(buffer, Field.MONTH.getRequiredLength(), null);
        }
        buffer[7] = 45;
        if (ITUFormatter.handleDatePart(lastIncluded, buffer, adjusted.getDayOfMonth(), 8, 2, Field.DAY)) {
            return ITUFormatter.finish(buffer, Field.DAY.getRequiredLength(), null);
        }
        buffer[10] = 84;
        LimitedCharArrayIntegerUtil.toString(adjusted.getHour(), buffer, 11, 2);
        buffer[13] = 58;
        if (ITUFormatter.handleDatePart(lastIncluded, buffer, adjusted.getMinute(), 14, 2, Field.MINUTE)) {
            return ITUFormatter.finish(buffer, Field.MINUTE.getRequiredLength(), tz);
        }
        buffer[16] = 58;
        LimitedCharArrayIntegerUtil.toString(adjusted.getSecond(), buffer, 17, 2);
        boolean bl = hasFractionDigits = fractionDigits > 0;
        if (hasFractionDigits) {
            buffer[19] = 46;
            ITUFormatter.addFractions(buffer, fractionDigits, adjusted.getNano());
            return ITUFormatter.finish(buffer, 20 + fractionDigits, tz);
        }
        return ITUFormatter.finish(buffer, 19, tz);
    }

    private static boolean handleDatePart(Field lastIncluded, char[] buffer, int value, int offset, int length, Field field) {
        LimitedCharArrayIntegerUtil.toString(value, buffer, offset, length);
        return lastIncluded == field;
    }

    private static void addFractions(char[] buf, int fractionDigits, int nano) {
        double d = widths[fractionDigits - 1];
        LimitedCharArrayIntegerUtil.toString((int)((double)nano / d), buf, 20, fractionDigits);
    }
}

