/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.util;

import io.ktor.util.StringValues;
import io.ktor.util.StringValuesKt;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0010\"\n\u0002\u0010&\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0011\b\u0016\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\u001f\u0010\n\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\n\u0010\u000bJ'\u0010\u000e\u001a\u001a\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00060\r0\fH\u0016\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u000f\u0010\u0010\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0015\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00040\fH\u0016\u00a2\u0006\u0004\b\u0012\u0010\u000fJ\u000f\u0010\u0013\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u000f\u0010\u0016\u001a\u00020\u0015H\u0016\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u001a\u0010\u001a\u001a\u00020\u00022\b\u0010\u0019\u001a\u0004\u0018\u00010\u0018H\u0096\u0002\u00a2\u0006\u0004\b\u001a\u0010\u001bJ/\u0010\u001f\u001a\u00020\u001d2\u001e\u0010\u001e\u001a\u001a\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u0006\u0012\u0004\u0012\u00020\u001d0\u001cH\u0016\u00a2\u0006\u0004\b\u001f\u0010 J\u001a\u0010!\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0096\u0002\u00a2\u0006\u0004\b!\u0010\"J\u0018\u0010#\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0004H\u0096\u0002\u00a2\u0006\u0004\b#\u0010$J\u001f\u0010#\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010%\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b#\u0010&R\u001a\u0010\u0003\u001a\u00020\u00028\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u0003\u0010'\u001a\u0004\b(\u0010\u0011R\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010)\u001a\u0004\b*\u0010\u0014R\u001d\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\u00068\u0006\u00a2\u0006\f\n\u0004\b\u0007\u0010+\u001a\u0004\b,\u0010-\u00a8\u0006."}, d2={"Lio/ktor/util/StringValuesSingleImpl;", "Lio/ktor/util/StringValues;", "", "caseInsensitiveName", "", "name", "", "values", "<init>", "(ZLjava/lang/String;Ljava/util/List;)V", "getAll", "(Ljava/lang/String;)Ljava/util/List;", "", "", "entries", "()Ljava/util/Set;", "isEmpty", "()Z", "names", "toString", "()Ljava/lang/String;", "", "hashCode", "()I", "", "other", "equals", "(Ljava/lang/Object;)Z", "Lkotlin/Function2;", "", "body", "forEach", "(Lkotlin/jvm/functions/Function2;)V", "get", "(Ljava/lang/String;)Ljava/lang/String;", "contains", "(Ljava/lang/String;)Z", "value", "(Ljava/lang/String;Ljava/lang/String;)Z", "Z", "getCaseInsensitiveName", "Ljava/lang/String;", "getName", "Ljava/util/List;", "getValues", "()Ljava/util/List;", "ktor-utils"})
public class StringValuesSingleImpl
implements StringValues {
    private final boolean caseInsensitiveName;
    @NotNull
    private final String name;
    @NotNull
    private final List<String> values;

    public StringValuesSingleImpl(boolean caseInsensitiveName, @NotNull String name, @NotNull List<String> values) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(values, (String)"values");
        this.caseInsensitiveName = caseInsensitiveName;
        this.name = name;
        this.values = values;
    }

    @Override
    public boolean getCaseInsensitiveName() {
        return this.caseInsensitiveName;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @NotNull
    public final List<String> getValues() {
        return this.values;
    }

    @Override
    @Nullable
    public List<String> getAll(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return StringsKt.equals((String)this.name, (String)name, (boolean)this.getCaseInsensitiveName()) ? this.values : null;
    }

    @Override
    @NotNull
    public Set<Map.Entry<String, List<String>>> entries() {
        return SetsKt.setOf((Object)new Map.Entry<String, List<? extends String>>(this){
            private final String key;
            private final List<String> value;
            {
                this.key = $receiver.getName();
                this.value = $receiver.getValues();
            }

            public String getKey() {
                return this.key;
            }

            public List<String> getValue() {
                return this.value;
            }

            public String toString() {
                return this.getKey() + '=' + this.getValue();
            }

            public boolean equals(Object other) {
                return other instanceof Map.Entry && Intrinsics.areEqual(((Map.Entry)other).getKey(), (Object)this.getKey()) && Intrinsics.areEqual(((Map.Entry)other).getValue(), (Object)this.getValue());
            }

            public int hashCode() {
                return this.getKey().hashCode() ^ this.getValue().hashCode();
            }

            public List<String> setValue(List<String> newValue) {
                throw new UnsupportedOperationException("Operation is not supported for read-only collection");
            }
        });
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    @NotNull
    public Set<String> names() {
        return SetsKt.setOf((Object)this.name);
    }

    @NotNull
    public String toString() {
        return "StringValues(case=" + !this.getCaseInsensitiveName() + ") " + this.entries();
    }

    public int hashCode() {
        return StringValuesKt.access$entriesHashCode(this.entries(), 31 * Boolean.hashCode(this.getCaseInsensitiveName()));
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof StringValues)) {
            return false;
        }
        if (this.getCaseInsensitiveName() != ((StringValues)other).getCaseInsensitiveName()) {
            return false;
        }
        return StringValuesKt.access$entriesEquals(this.entries(), ((StringValues)other).entries());
    }

    @Override
    public void forEach(@NotNull Function2<? super String, ? super List<String>, Unit> body) {
        Intrinsics.checkNotNullParameter(body, (String)"body");
        body.invoke((Object)this.name, this.values);
    }

    @Override
    @Nullable
    public String get(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return StringsKt.equals((String)name, (String)this.name, (boolean)this.getCaseInsensitiveName()) ? (String)CollectionsKt.firstOrNull(this.values) : null;
    }

    @Override
    public boolean contains(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return StringsKt.equals((String)name, (String)this.name, (boolean)this.getCaseInsensitiveName());
    }

    @Override
    public boolean contains(@NotNull String name, @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return StringsKt.equals((String)name, (String)this.name, (boolean)this.getCaseInsensitiveName()) && this.values.contains(value);
    }
}

