/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util.concurrent;

import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.GenericProgressiveFutureListener;
import java.util.Arrays;

final class DefaultFutureListeners {
    private GenericFutureListener<? extends Future<?>>[] listeners = new GenericFutureListener[2];
    private int size;
    private int progressiveSize;

    DefaultFutureListeners(GenericFutureListener<? extends Future<?>> first2, GenericFutureListener<? extends Future<?>> second2) {
        this.listeners[0] = first2;
        this.listeners[1] = second2;
        this.size = 2;
        if (first2 instanceof GenericProgressiveFutureListener) {
            ++this.progressiveSize;
        }
        if (second2 instanceof GenericProgressiveFutureListener) {
            ++this.progressiveSize;
        }
    }

    public void add(GenericFutureListener<? extends Future<?>> l) {
        int size2 = this.size;
        GenericFutureListener<? extends Future<?>>[] listeners2 = this.listeners;
        if (size2 == listeners2.length) {
            this.listeners = listeners2 = Arrays.copyOf(listeners2, size2 << 1);
        }
        listeners2[size2] = l;
        this.size = size2 + 1;
        if (l instanceof GenericProgressiveFutureListener) {
            ++this.progressiveSize;
        }
    }

    public void remove(GenericFutureListener<? extends Future<?>> l) {
        GenericFutureListener<? extends Future<?>>[] listeners2 = this.listeners;
        int size2 = this.size;
        for (int i2 = 0; i2 < size2; ++i2) {
            if (listeners2[i2] != l) continue;
            int listenersToMove = size2 - i2 - 1;
            if (listenersToMove > 0) {
                System.arraycopy(listeners2, i2 + 1, listeners2, i2, listenersToMove);
            }
            listeners2[--size2] = null;
            this.size = size2;
            if (l instanceof GenericProgressiveFutureListener) {
                --this.progressiveSize;
            }
            return;
        }
    }

    public GenericFutureListener<? extends Future<?>>[] listeners() {
        return this.listeners;
    }

    public int size() {
        return this.size;
    }

    public int progressiveSize() {
        return this.progressiveSize;
    }
}

