/*
 * Decompiled with CFR 0.152.
 */
package io.github.alexzhirkevich.qrose;

import androidx.compose.runtime.Immutable;
import androidx.compose.ui.geometry.Offset;
import androidx.compose.ui.geometry.OffsetKt;
import androidx.compose.ui.geometry.Size;
import androidx.compose.ui.geometry.SizeKt;
import androidx.compose.ui.graphics.BlendMode;
import androidx.compose.ui.graphics.Brush;
import androidx.compose.ui.graphics.Color;
import androidx.compose.ui.graphics.Path;
import androidx.compose.ui.graphics.PathFillType;
import androidx.compose.ui.graphics.SkiaBackedPath_skikoKt;
import androidx.compose.ui.graphics.drawscope.DrawScope;
import androidx.compose.ui.graphics.painter.Painter;
import io.github.alexzhirkevich.qrose.CachedPainter;
import io.github.alexzhirkevich.qrose.NeighborsBasedFactory;
import io.github.alexzhirkevich.qrose.QrCodePainterKt;
import io.github.alexzhirkevich.qrose.Recreating;
import io.github.alexzhirkevich.qrose.options.Neighbors;
import io.github.alexzhirkevich.qrose.options.QrBrush;
import io.github.alexzhirkevich.qrose.options.QrBrushKt;
import io.github.alexzhirkevich.qrose.options.QrBrushMode;
import io.github.alexzhirkevich.qrose.options.QrCodeMatrix;
import io.github.alexzhirkevich.qrose.options.QrCodeMatrixKt;
import io.github.alexzhirkevich.qrose.options.QrCodeShape;
import io.github.alexzhirkevich.qrose.options.QrErrorCorrectionLevel;
import io.github.alexzhirkevich.qrose.options.QrLogoPadding;
import io.github.alexzhirkevich.qrose.options.QrOptions;
import io.github.alexzhirkevich.qrose.options.QrShapeModifier;
import io.github.alexzhirkevich.qrose.options.QrShapeModifierKt;
import io.github.alexzhirkevich.qrose.qrcode.QRCode;
import java.util.Collection;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010\u0007\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\r\b\u0007\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0016\u0010.\u001a\b\u0012\u0004\u0012\u0002000/2\u0006\u0010,\u001a\u00020%H\u0002J\u0016\u00101\u001a\b\u0012\u0004\u0012\u0002020/2\u0006\u0010,\u001a\u00020%H\u0002J\u001c\u00103\u001a\u000e\u0012\u0004\u0012\u000202\u0012\u0004\u0012\u0002020\u000b2\u0006\u0010,\u001a\u00020%H\u0002J\u0016\u00104\u001a\b\u0012\u0004\u0012\u000200052\u0006\u0010,\u001a\u00020%H\u0002J\u0016\u00106\u001a\b\u0012\u0004\u0012\u000202052\u0006\u0010,\u001a\u00020%H\u0002J\u0013\u00107\u001a\u00020\u001b2\b\u00108\u001a\u0004\u0018\u000109H\u0096\u0002J\u001e\u0010:\u001a\b\u0012\u0004\u0012\u0002000/2\u0006\u0010;\u001a\u00020<2\u0006\u0010,\u001a\u00020%H\u0002J\u0016\u0010=\u001a\b\u0012\u0004\u0012\u0002000/2\u0006\u0010,\u001a\u00020%H\u0002J\u0016\u0010>\u001a\b\u0012\u0004\u0012\u0002020/2\u0006\u0010,\u001a\u00020%H\u0002J\b\u0010?\u001a\u00020\fH\u0016J\u0018\u0010@\u001a\u00020\u001b2\u0006\u0010A\u001a\u00020\f2\u0006\u0010B\u001a\u00020\fH\u0002J\u0018\u0010C\u001a\u00020\u001b2\u0006\u0010A\u001a\u00020\f2\u0006\u0010B\u001a\u00020\fH\u0002J\u0018\u0010D\u001a\u00020\u001b2\u0006\u0010A\u001a\u00020\f2\u0006\u0010B\u001a\u00020\fH\u0002J\u0016\u0010E\u001a\b\u0012\u0004\u0012\u000200052\u0006\u0010,\u001a\u00020%H\u0002J\u0016\u0010F\u001a\b\u0012\u0004\u0012\u000202052\u0006\u0010,\u001a\u00020%H\u0002J&\u0010G\u001a\b\u0012\u0004\u0012\u000200052\u0006\u0010;\u001a\u00020<2\u0006\u0010H\u001a\u00020\u001b2\u0006\u0010,\u001a\u00020%H\u0002J\u001e\u0010I\u001a\b\u0012\u0004\u0012\u000202052\u0006\u0010J\u001a\u00020K2\u0006\u0010,\u001a\u00020%H\u0002J\u001e\u0010L\u001a\b\u0012\u0004\u0012\u0002020/2\u0006\u0010J\u001a\u00020K2\u0006\u0010M\u001a\u00020%H\u0002J\b\u0010N\u001a\u00020\u0003H\u0016J\f\u0010O\u001a\u00020P*\u00020&H\u0002J\u0014\u0010Q\u001a\u00020P*\u00020&2\u0006\u0010,\u001a\u00020%H\u0002J\u0014\u0010R\u001a\u00020P*\u00020&2\u0006\u0010,\u001a\u00020%H\u0002J\f\u0010S\u001a\u00020P*\u00020&H\u0002J\u0014\u0010T\u001a\u00020P*\u00020&2\u0006\u0010,\u001a\u00020%H\u0002J\f\u0010U\u001a\u00020P*\u00020&H\u0016J\u0014\u0010V\u001a\u00020P*\u00020&2\u0006\u0010,\u001a\u00020%H\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\t\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f0\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR \u0010\u0010\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f0\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0012\u001a\u00020\u0013X\u0096\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\n\n\u0002\u0010\u0016\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u000e\u0010\u0019\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001a\u001a\u00020\u001b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001dR\u0014\u0010\u001e\u001a\u00020\u001b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\u001dR\u0014\u0010 \u001a\u00020\u001b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\u001dR\u0014\u0010\"\u001a\u00020\u001b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b#\u0010\u001dR\u0018\u0010$\u001a\u00020%*\u00020&8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b'\u0010(R\u001e\u0010)\u001a\u00020\u0013*\u00020&8BX\u0082\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0006\u001a\u0004\b*\u0010+R\u0018\u0010,\u001a\u00020%*\u00020&8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b-\u0010(\u0082\u0002\u000b\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006W\u00b2\u0006\n\u0010;\u001a\u000200X\u008a\u0084\u0002\u00b2\u0006\n\u0010X\u001a\u000202X\u008a\u0084\u0002\u00b2\u0006\n\u0010Y\u001a\u000200X\u008a\u0084\u0002\u00b2\u0006\n\u0010Z\u001a\u000202X\u008a\u0084\u0002\u00b2\u0006\n\u0010[\u001a\u000202X\u008a\u0084\u0002\u00b2\u0006\n\u0010\\\u001a\u000202X\u008a\u0084\u0002\u00b2\u0006\n\u0010]\u001a\u000200X\u008a\u0084\u0002"}, d2={"Lio/github/alexzhirkevich/qrose/QrCodePainter;", "Lio/github/alexzhirkevich/qrose/CachedPainter;", "data", "", "options", "Lio/github/alexzhirkevich/qrose/options/QrOptions;", "(Ljava/lang/String;Lio/github/alexzhirkevich/qrose/options/QrOptions;)V", "actualCodeMatrix", "Lio/github/alexzhirkevich/qrose/options/QrCodeMatrix;", "balls", "", "Lkotlin/Pair;", "", "codeMatrix", "getData", "()Ljava/lang/String;", "frames", "initialMatrixSize", "intrinsicSize", "Landroidx/compose/ui/geometry/Size;", "getIntrinsicSize-NH-jbRc", "()J", "J", "getOptions", "()Lio/github/alexzhirkevich/qrose/options/QrOptions;", "shapeIncrease", "shouldSeparateBalls", "", "getShouldSeparateBalls", "()Z", "shouldSeparateDarkPixels", "getShouldSeparateDarkPixels", "shouldSeparateFrames", "getShouldSeparateFrames", "shouldSeparateLightPixels", "getShouldSeparateLightPixels", "logoPaddingSize", "", "Landroidx/compose/ui/graphics/drawscope/DrawScope;", "getLogoPaddingSize", "(Landroidx/compose/ui/graphics/drawscope/DrawScope;)F", "logoSize", "getLogoSize-7Ah8Wj8", "(Landroidx/compose/ui/graphics/drawscope/DrawScope;)J", "pixelSize", "getPixelSize", "ballBrushFactory", "Lkotlin/Lazy;", "Landroidx/compose/ui/graphics/Brush;", "ballShapeFactory", "Landroidx/compose/ui/graphics/Path;", "createMainElements", "darkPaintFactory", "Lio/github/alexzhirkevich/qrose/NeighborsBasedFactory;", "darkPixelPathFactory", "equals", "other", "", "eyeBrushFactory", "brush", "Lio/github/alexzhirkevich/qrose/options/QrBrush;", "frameBrushFactory", "frameShapeFactory", "hashCode", "isBallStart", "x", "y", "isFrameStart", "isInsideFrameOrBall", "lightPaintFactory", "lightPixelPathFactory", "pixelBrushFactory", "separate", "pixelPathFactory", "shape", "Lio/github/alexzhirkevich/qrose/options/QrShapeModifier;", "rotatedPathFactory", "shapeSize", "toString", "draw", "", "drawBalls", "drawFrames", "drawLogo", "drawSeparatePixels", "onCache", "prepareLogo", "qrose", "path", "ballBrush", "ballPath", "rotatedFramePath", "rotatedBallPath", "joinBrush"})
@Immutable
@SourceDebugExtension(value={"SMAP\nQrCodePainter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 QrCodePainter.kt\nio/github/alexzhirkevich/qrose/QrCodePainter\n+ 2 DrawScope.kt\nandroidx/compose/ui/graphics/drawscope/DrawScopeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,673:1\n121#2,4:674\n121#2,4:678\n121#2,4:682\n121#2,4:687\n121#2,4:693\n1855#3:686\n1856#3:691\n1855#3:692\n1856#3:697\n1#4:698\n*S KotlinDebug\n*F\n+ 1 QrCodePainter.kt\nio/github/alexzhirkevich/qrose/QrCodePainter\n*L\n229#1:674,4\n318#1:678,4\n328#1:682,4\n347#1:687,4\n368#1:693,4\n345#1:686\n345#1:691\n366#1:692\n366#1:697\n*E\n"})
public final class QrCodePainter
extends CachedPainter {
    @NotNull
    private final String data;
    @NotNull
    private final QrOptions options;
    private final int initialMatrixSize;
    @NotNull
    private final QrCodeMatrix actualCodeMatrix;
    @NotNull
    private QrCodeMatrix codeMatrix;
    private final long intrinsicSize;
    private final int shapeIncrease;
    @NotNull
    private final List<Pair<Integer, Integer>> balls;
    @NotNull
    private final List<Pair<Integer, Integer>> frames;
    public static final int $stable;

    /*
     * WARNING - void declaration
     */
    public QrCodePainter(@NotNull String data2, @NotNull QrOptions options2) {
        Object $this$balls_u24lambda_u241;
        Object $this$actualCodeMatrix_u24lambda_u240;
        Intrinsics.checkNotNullParameter(data2, "data");
        Intrinsics.checkNotNullParameter(options2, "options");
        this.data = data2;
        this.options = options2;
        QrCodeShape qrCodeShape = this.options.getShapes().getCode();
        QrCodePainter qrCodePainter = this;
        boolean bl = false;
        QrCodeMatrix initialMatrix = QRCode.encode$default(new QRCode(this.data, this.options.getErrorCorrectionLevel() == QrErrorCorrectionLevel.Auto ? QrCodePainterKt.access$fit(this.options.getErrorCorrectionLevel(), this.options).getLvl$qrose() : this.options.getErrorCorrectionLevel().getLvl$qrose(), null, 4, null), 0, null, 3, null);
        this.initialMatrixSize = initialMatrix.getSize();
        qrCodePainter.actualCodeMatrix = $this$actualCodeMatrix_u24lambda_u240.transform(initialMatrix);
        this.codeMatrix = this.actualCodeMatrix;
        this.intrinsicSize = SizeKt.Size((float)this.codeMatrix.getSize() * 10.0f, (float)this.codeMatrix.getSize() * 10.0f);
        this.shapeIncrease = (this.codeMatrix.getSize() - this.initialMatrixSize) / 2;
        Object object = new Pair[]{TuplesKt.to(2 + this.shapeIncrease, 2 + this.shapeIncrease), TuplesKt.to(2 + this.shapeIncrease, this.initialMatrixSize - 5 + this.shapeIncrease), TuplesKt.to(this.initialMatrixSize - 5 + this.shapeIncrease, 2 + this.shapeIncrease)};
        $this$actualCodeMatrix_u24lambda_u240 = object = CollectionsKt.mutableListOf(object);
        qrCodePainter = this;
        boolean bl2 = false;
        if (this.options.getFourEyed()) {
            ((Collection)$this$balls_u24lambda_u241).add(TuplesKt.to(this.initialMatrixSize - 5 + this.shapeIncrease, this.initialMatrixSize - 5 + this.shapeIncrease));
        }
        qrCodePainter.balls = CollectionsKt.toList((Iterable)object);
        object = new Pair[]{TuplesKt.to(this.shapeIncrease, this.shapeIncrease), TuplesKt.to(this.shapeIncrease, this.initialMatrixSize - 7 + this.shapeIncrease), TuplesKt.to(this.initialMatrixSize - 7 + this.shapeIncrease, this.shapeIncrease)};
        $this$balls_u24lambda_u241 = object = CollectionsKt.mutableListOf(object);
        qrCodePainter = this;
        boolean bl3 = false;
        if (this.options.getFourEyed()) {
            void $this$frames_u24lambda_u242;
            ((Collection)$this$frames_u24lambda_u242).add(TuplesKt.to(this.initialMatrixSize - 7 + this.shapeIncrease, this.initialMatrixSize - 7 + this.shapeIncrease));
        }
        qrCodePainter.frames = CollectionsKt.toList((Iterable)object);
    }

    public /* synthetic */ QrCodePainter(String string2, QrOptions qrOptions, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            qrOptions = new QrOptions(null, null, null, null, false, 31, null);
        }
        this(string2, qrOptions);
    }

    @NotNull
    public final String getData() {
        return this.data;
    }

    @NotNull
    public final QrOptions getOptions() {
        return this.options;
    }

    @Override
    public long getIntrinsicSize-NH-jbRc() {
        return this.intrinsicSize;
    }

    private final boolean getShouldSeparateDarkPixels() {
        return this.options.getColors().getDark().getMode() == QrBrushMode.Separate;
    }

    private final boolean getShouldSeparateLightPixels() {
        return this.options.getColors().getLight().getMode() == QrBrushMode.Separate;
    }

    private final boolean getShouldSeparateFrames() {
        return QrBrushKt.isSpecified(this.options.getColors().getFrame()) || this.getShouldSeparateDarkPixels();
    }

    private final boolean getShouldSeparateBalls() {
        return QrBrushKt.isSpecified(this.options.getColors().getBall()) || this.getShouldSeparateDarkPixels();
    }

    @NotNull
    public String toString() {
        return "QrCodePainter(data = " + this.data + ")";
    }

    public int hashCode() {
        return this.data.hashCode() * 31 + this.options.hashCode();
    }

    private final long getLogoSize-7Ah8Wj8(DrawScope $this$logoSize) {
        return Size.times-7Ah8Wj8($this$logoSize.getSize-NH-jbRc(), this.options.getLogo().getSize());
    }

    private final float getLogoPaddingSize(DrawScope $this$logoPaddingSize) {
        return Size.getWidth-impl(this.getLogoSize-7Ah8Wj8($this$logoPaddingSize)) * (1.0f + this.options.getLogo().getPadding().getSize());
    }

    private final float getPixelSize(DrawScope $this$pixelSize) {
        return Math.min(Size.getWidth-impl($this$pixelSize.getSize-NH-jbRc()), Size.getHeight-impl($this$pixelSize.getSize-NH-jbRc())) / (float)this.codeMatrix.getSize();
    }

    @Override
    public void onCache(@NotNull DrawScope $this$onCache) {
        Intrinsics.checkNotNullParameter($this$onCache, "<this>");
        this.draw($this$onCache);
    }

    private final void draw(DrawScope $this$draw) {
        float pixelSize = this.getPixelSize($this$draw);
        this.prepareLogo($this$draw, pixelSize);
        Pair<Path, Path> pair = this.createMainElements(pixelSize);
        Path dark = pair.component1();
        Path light = pair.component2();
        if (this.getShouldSeparateDarkPixels() || this.getShouldSeparateLightPixels()) {
            this.drawSeparatePixels($this$draw, pixelSize);
        }
        if (!this.getShouldSeparateLightPixels()) {
            DrawScope.drawPath-GBMwjPU$default($this$draw, light, this.options.getColors().getLight().brush(pixelSize * (float)this.codeMatrix.getSize(), Neighbors.Companion.getEmpty()), 0.0f, null, null, 0, 60, null);
        }
        if (!this.getShouldSeparateDarkPixels()) {
            DrawScope.drawPath-GBMwjPU$default($this$draw, dark, this.options.getColors().getDark().brush(pixelSize * (float)this.codeMatrix.getSize(), Neighbors.Companion.getEmpty()), 0.0f, null, null, 0, 60, null);
        }
        if (this.getShouldSeparateFrames()) {
            this.drawFrames($this$draw, pixelSize);
        }
        if (this.getShouldSeparateBalls()) {
            this.drawBalls($this$draw, pixelSize);
        }
        this.drawLogo($this$draw);
    }

    /*
     * WARNING - void declaration
     */
    private final void drawSeparatePixels(DrawScope $this$drawSeparatePixels, float pixelSize) {
        NeighborsBasedFactory<Brush> darkPaint = this.darkPaintFactory(pixelSize);
        NeighborsBasedFactory<Brush> lightPaint = this.lightPaintFactory(pixelSize);
        NeighborsBasedFactory<Path> darkPixelPath = this.darkPixelPathFactory(pixelSize);
        NeighborsBasedFactory<Path> lightPixelPath = this.lightPixelPathFactory(pixelSize);
        int n = this.codeMatrix.getSize();
        for (int j = 0; j < n; ++j) {
            int i2 = j;
            boolean bl = false;
            int n2 = this.codeMatrix.getSize();
            for (int k = 0; k < n2; ++k) {
                Neighbors n3;
                void top$iv;
                void left$iv;
                void $this$translate$iv;
                int j2 = k;
                boolean bl2 = false;
                if (this.isInsideFrameOrBall(i2, j2)) continue;
                DrawScope drawScope = $this$drawSeparatePixels;
                float f = (float)i2 * pixelSize;
                float f2 = (float)j2 * pixelSize;
                boolean $i$f$translate = false;
                $this$translate$iv.getDrawContext().getTransform().translate((float)left$iv, (float)top$iv);
                void $this$drawSeparatePixels_u24lambda_u245_u24lambda_u244_u24lambda_u243 = $this$translate$iv;
                boolean bl3 = false;
                if (this.getShouldSeparateDarkPixels() && this.codeMatrix.get(i2, j2) == QrCodeMatrix.PixelType.DarkPixel) {
                    n3 = QrCodeMatrixKt.neighbors(this.codeMatrix, i2, j2);
                    DrawScope.drawPath-GBMwjPU$default((DrawScope)$this$drawSeparatePixels_u24lambda_u245_u24lambda_u244_u24lambda_u243, darkPixelPath.next(n3), darkPaint.next(n3), 0.0f, null, null, 0, 60, null);
                }
                if (this.getShouldSeparateLightPixels() && this.codeMatrix.get(i2, j2) == QrCodeMatrix.PixelType.LightPixel) {
                    n3 = QrCodeMatrixKt.neighbors(this.codeMatrix, i2, j2);
                    DrawScope.drawPath-GBMwjPU$default((DrawScope)$this$drawSeparatePixels_u24lambda_u245_u24lambda_u244_u24lambda_u243, lightPixelPath.next(n3), lightPaint.next(n3), 0.0f, null, null, 0, 60, null);
                }
                $this$translate$iv.getDrawContext().getTransform().translate((float)(-left$iv), (float)(-top$iv));
            }
        }
    }

    private final void prepareLogo(DrawScope $this$prepareLogo, float pixelSize) {
        float ps = this.getLogoPaddingSize($this$prepareLogo);
        if (this.options.getLogo().getPadding() instanceof QrLogoPadding.Natural) {
            Path path;
            Path $this$prepareLogo_u24lambda_u246 = path = QrShapeModifierKt.newPath(this.options.getLogo().getShape(), ps, Neighbors.Companion.getEmpty());
            boolean bl = false;
            $this$prepareLogo_u24lambda_u246.translate-k-4lQ0M(OffsetKt.Offset((Size.getWidth-impl($this$prepareLogo.getSize-NH-jbRc()) - ps) / 2.0f, (Size.getHeight-impl($this$prepareLogo.getSize-NH-jbRc()) - ps) / 2.0f));
            Path logoPath = path;
            NeighborsBasedFactory<Path> darkPathF = this.darkPixelPathFactory(pixelSize);
            NeighborsBasedFactory<Path> lightPathF = this.lightPixelPathFactory(pixelSize);
            int logoPixels = MathKt.roundToInt((float)this.codeMatrix.getSize() * RangesKt.coerceIn(this.options.getLogo().getSize(), 0.0f, 1.0f) * (1.0f + RangesKt.coerceIn(this.options.getLogo().getPadding().getSize(), 0.0f, 1.0f))) + 1;
            IntRange xRange = RangesKt.until((this.codeMatrix.getSize() - logoPixels) / 2, (this.codeMatrix.getSize() + logoPixels) / 2);
            IntRange yRange = RangesKt.until((this.codeMatrix.getSize() - logoPixels) / 2, (this.codeMatrix.getSize() + logoPixels) / 2);
            int x2 = xRange.getFirst();
            int n = xRange.getLast();
            if (x2 <= n) {
                while (true) {
                    int n2;
                    int y2;
                    if ((y2 = yRange.getFirst()) <= (n2 = yRange.getLast())) {
                        while (true) {
                            Path path2;
                            Path path3;
                            Neighbors neighbors = QrCodeMatrixKt.neighbors(this.codeMatrix, x2, y2);
                            long offset = OffsetKt.Offset((float)x2 * pixelSize, (float)y2 * pixelSize);
                            Path $this$prepareLogo_u24lambda_u247 = path3 = darkPathF.next(neighbors);
                            boolean bl2 = false;
                            $this$prepareLogo_u24lambda_u247.translate-k-4lQ0M(offset);
                            Path darkPath = path3;
                            Path $this$prepareLogo_u24lambda_u248 = path2 = lightPathF.next(neighbors);
                            boolean bl3 = false;
                            $this$prepareLogo_u24lambda_u248.translate-k-4lQ0M(offset);
                            Path lightPath = path2;
                            if (this.codeMatrix.get(x2, y2) == QrCodeMatrix.PixelType.DarkPixel && QrCodePainterKt.access$intersects(logoPath, darkPath) || this.codeMatrix.get(x2, y2) == QrCodeMatrix.PixelType.LightPixel && QrCodePainterKt.access$intersects(logoPath, lightPath)) {
                                this.codeMatrix.set(x2, y2, QrCodeMatrix.PixelType.Logo);
                            }
                            if (y2 == n2) break;
                            ++y2;
                        }
                    }
                    if (x2 == n) break;
                    ++x2;
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void drawLogo(DrawScope $this$drawLogo) {
        block1: {
            void top$iv;
            void left$iv;
            void $this$translate$iv;
            float ps = this.getLogoPaddingSize($this$drawLogo);
            if (this.options.getLogo().getPadding() instanceof QrLogoPadding.Accurate) {
                void top$iv2;
                void left$iv2;
                void $this$translate$iv2;
                Path path = QrShapeModifierKt.newPath(this.options.getLogo().getShape(), ps, Neighbors.Companion.getEmpty());
                DrawScope drawScope = $this$drawLogo;
                float f = Offset.getX-impl($this$drawLogo.getCenter-F1C5BW0()) - ps / (float)2;
                float f2 = Offset.getY-impl($this$drawLogo.getCenter-F1C5BW0()) - ps / (float)2;
                boolean $i$f$translate = false;
                $this$translate$iv2.getDrawContext().getTransform().translate((float)left$iv2, (float)top$iv2);
                void $this$drawLogo_u24lambda_u249 = $this$translate$iv2;
                boolean bl3 = false;
                DrawScope.drawPath-LG529CI$default((DrawScope)$this$drawLogo_u24lambda_u249, path, Color.Companion.getBlack-0d7_KjU(), 0.0f, null, null, BlendMode.Companion.getClear-0nO6VwU(), 28, null);
                $this$translate$iv2.getDrawContext().getTransform().translate((float)(-left$iv2), (float)(-top$iv2));
            }
            Painter painter = this.options.getLogo().getPainter();
            if (painter == null) break block1;
            Painter it = painter;
            boolean bl = false;
            Painter $this$drawLogo_u24lambda_u2412_u24lambda_u2411 = it;
            boolean bl2 = false;
            DrawScope bl3 = $this$drawLogo;
            float f = Offset.getX-impl($this$drawLogo.getCenter-F1C5BW0()) - Size.getWidth-impl(this.getLogoSize-7Ah8Wj8($this$drawLogo)) / (float)2;
            float f3 = Offset.getY-impl($this$drawLogo.getCenter-F1C5BW0()) - Size.getHeight-impl(this.getLogoSize-7Ah8Wj8($this$drawLogo)) / (float)2;
            boolean $i$f$translate = false;
            $this$translate$iv.getDrawContext().getTransform().translate((float)left$iv, (float)top$iv);
            void $this$drawLogo_u24lambda_u2412_u24lambda_u2411_u24lambda_u2410 = $this$translate$iv;
            boolean bl4 = false;
            Painter.draw-x_KDEd0$default($this$drawLogo_u24lambda_u2412_u24lambda_u2411, (DrawScope)$this$drawLogo_u24lambda_u2412_u24lambda_u2411_u24lambda_u2410, this.getLogoSize-7Ah8Wj8((DrawScope)$this$drawLogo_u24lambda_u2412_u24lambda_u2411_u24lambda_u2410), 0.0f, null, 6, null);
            $this$translate$iv.getDrawContext().getTransform().translate((float)(-left$iv), (float)(-top$iv));
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void drawBalls(DrawScope $this$drawBalls, float pixelSize) {
        Lazy<Brush> brush$delegate = this.ballBrushFactory(pixelSize);
        Lazy<Path> path$delegate = this.ballShapeFactory(pixelSize);
        Iterable $this$forEach$iv = this.balls;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            void top$iv;
            void left$iv;
            void $this$translate$iv;
            Pair it = (Pair)element$iv;
            boolean bl = false;
            DrawScope drawScope = $this$drawBalls;
            float f = ((Number)it.getFirst()).floatValue() * pixelSize;
            float f2 = ((Number)it.getSecond()).floatValue() * pixelSize;
            boolean $i$f$translate = false;
            $this$translate$iv.getDrawContext().getTransform().translate((float)left$iv, (float)top$iv);
            void $this$drawBalls_u24lambda_u2416_u24lambda_u2415 = $this$translate$iv;
            boolean bl2 = false;
            DrawScope.drawPath-GBMwjPU$default((DrawScope)$this$drawBalls_u24lambda_u2416_u24lambda_u2415, QrCodePainter.drawBalls$lambda$14(path$delegate), QrCodePainter.drawBalls$lambda$13(brush$delegate), 0.0f, null, null, 0, 60, null);
            $this$translate$iv.getDrawContext().getTransform().translate((float)(-left$iv), (float)(-top$iv));
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void drawFrames(DrawScope $this$drawFrames, float pixelSize) {
        Lazy<Brush> ballBrush$delegate = this.frameBrushFactory(pixelSize);
        Lazy<Path> ballPath$delegate = this.frameShapeFactory(pixelSize);
        Iterable $this$forEach$iv = this.frames;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            void top$iv;
            void left$iv;
            void $this$translate$iv;
            Pair it = (Pair)element$iv;
            boolean bl = false;
            DrawScope drawScope = $this$drawFrames;
            float f = ((Number)it.getFirst()).floatValue() * pixelSize;
            float f2 = ((Number)it.getSecond()).floatValue() * pixelSize;
            boolean $i$f$translate = false;
            $this$translate$iv.getDrawContext().getTransform().translate((float)left$iv, (float)top$iv);
            void $this$drawFrames_u24lambda_u2420_u24lambda_u2419 = $this$translate$iv;
            boolean bl2 = false;
            DrawScope.drawPath-GBMwjPU$default((DrawScope)$this$drawFrames_u24lambda_u2420_u24lambda_u2419, QrCodePainter.drawFrames$lambda$18(ballPath$delegate), QrCodePainter.drawFrames$lambda$17(ballBrush$delegate), 0.0f, null, null, 0, 60, null);
            $this$translate$iv.getDrawContext().getTransform().translate((float)(-left$iv), (float)(-top$iv));
        }
    }

    private final Pair<Path, Path> createMainElements(float pixelSize) {
        Path path;
        Path $this$createMainElements_u24lambda_u2421 = path = SkiaBackedPath_skikoKt.Path();
        boolean bl = false;
        $this$createMainElements_u24lambda_u2421.setFillType-oQ8Xj4U(PathFillType.Companion.getEvenOdd-Rg-k1Os());
        Path darkPath = path;
        Path $this$createMainElements_u24lambda_u2422 = $this$createMainElements_u24lambda_u2421 = SkiaBackedPath_skikoKt.Path();
        boolean bl2 = false;
        $this$createMainElements_u24lambda_u2422.setFillType-oQ8Xj4U(PathFillType.Companion.getEvenOdd-Rg-k1Os());
        Path lightPath = $this$createMainElements_u24lambda_u2421;
        Lazy<Path> rotatedFramePath$delegate = this.frameShapeFactory(pixelSize);
        Lazy<Path> rotatedBallPath$delegate = this.ballShapeFactory(pixelSize);
        NeighborsBasedFactory<Path> darkPixelPathFactory = this.darkPixelPathFactory(pixelSize);
        NeighborsBasedFactory<Path> lightPixelPathFactory = this.lightPixelPathFactory(pixelSize);
        int n = this.codeMatrix.getSize();
        for (int x2 = 0; x2 < n; ++x2) {
            int n2 = this.codeMatrix.getSize();
            for (int y2 = 0; y2 < n2; ++y2) {
                Neighbors neighbors = QrCodeMatrixKt.neighbors(this.codeMatrix, x2, y2);
                if (!this.getShouldSeparateFrames() && this.isFrameStart(x2, y2)) {
                    darkPath.addPath-Uv8p0NA(QrCodePainter.createMainElements$lambda$23(rotatedFramePath$delegate), OffsetKt.Offset((float)x2 * pixelSize, (float)y2 * pixelSize));
                    continue;
                }
                if (!this.getShouldSeparateBalls() && this.isBallStart(x2, y2)) {
                    darkPath.addPath-Uv8p0NA(QrCodePainter.createMainElements$lambda$24(rotatedBallPath$delegate), OffsetKt.Offset((float)x2 * pixelSize, (float)y2 * pixelSize));
                    continue;
                }
                if (this.isInsideFrameOrBall(x2, y2)) continue;
                if (!this.getShouldSeparateDarkPixels() && this.codeMatrix.get(x2, y2) == QrCodeMatrix.PixelType.DarkPixel) {
                    darkPath.addPath-Uv8p0NA(darkPixelPathFactory.next(neighbors), OffsetKt.Offset((float)x2 * pixelSize, (float)y2 * pixelSize));
                    continue;
                }
                if (this.getShouldSeparateLightPixels() || this.codeMatrix.get(x2, y2) != QrCodeMatrix.PixelType.LightPixel) continue;
                lightPath.addPath-Uv8p0NA(lightPixelPathFactory.next(neighbors), OffsetKt.Offset((float)x2 * pixelSize, (float)y2 * pixelSize));
            }
        }
        return TuplesKt.to(darkPath, lightPath);
    }

    private final boolean isFrameStart(int x2, int y2) {
        return x2 - this.shapeIncrease == 0 && y2 - this.shapeIncrease == 0 || x2 - this.shapeIncrease == 0 && y2 - this.shapeIncrease == this.initialMatrixSize - 7 || x2 - this.shapeIncrease == this.initialMatrixSize - 7 && y2 - this.shapeIncrease == 0 || this.options.getFourEyed() && x2 - this.shapeIncrease == this.initialMatrixSize - 7 && y2 - this.shapeIncrease == this.initialMatrixSize - 7;
    }

    private final boolean isBallStart(int x2, int y2) {
        return x2 - this.shapeIncrease == 2 && y2 - this.shapeIncrease == this.initialMatrixSize - 5 || x2 - this.shapeIncrease == this.initialMatrixSize - 5 && y2 - this.shapeIncrease == 2 || x2 - this.shapeIncrease == 2 && y2 - this.shapeIncrease == 2 || this.options.getFourEyed() && x2 - this.shapeIncrease == this.initialMatrixSize - 5 && y2 - this.shapeIncrease == this.initialMatrixSize - 5;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isInsideFrameOrBall(int x2, int y2) {
        int n;
        int n2;
        int n3 = x2 - this.shapeIncrease;
        boolean bl = -1 <= n3 ? n3 < 8 : false;
        if (bl) {
            boolean bl2;
            n3 = y2 - this.shapeIncrease;
            if (-1 <= n3) {
                if (n3 < 8) {
                    return true;
                }
                bl2 = false;
            } else {
                bl2 = false;
            }
            if (bl2) return true;
        }
        boolean bl3 = -1 <= (n3 = x2 - this.shapeIncrease) ? n3 < 8 : false;
        if (bl3) {
            boolean bl4;
            n3 = this.initialMatrixSize - 8;
            n2 = this.initialMatrixSize + 1;
            n = y2 - this.shapeIncrease;
            if (n3 <= n) {
                if (n < n2) {
                    return true;
                }
                bl4 = false;
            } else {
                bl4 = false;
            }
            if (bl4) return true;
        }
        n3 = this.initialMatrixSize - 8;
        n2 = this.initialMatrixSize + 1;
        n = x2 - this.shapeIncrease;
        boolean bl5 = n3 <= n ? n < n2 : false;
        if (bl5) {
            boolean bl6;
            n3 = y2 - this.shapeIncrease;
            if (-1 <= n3) {
                if (n3 < 8) {
                    return true;
                }
                bl6 = false;
            } else {
                bl6 = false;
            }
            if (bl6) return true;
        }
        if (!this.options.getFourEyed()) return false;
        n3 = this.initialMatrixSize - 8;
        n2 = this.initialMatrixSize + 1;
        n = x2 - this.shapeIncrease;
        if (n3 > n) return false;
        if (n >= n2) return false;
        boolean bl7 = true;
        if (!bl7) return false;
        n3 = this.initialMatrixSize - 8;
        n2 = this.initialMatrixSize + 1;
        n = y2 - this.shapeIncrease;
        if (n3 > n) return false;
        if (n >= n2) return false;
        return true;
    }

    private final NeighborsBasedFactory<Brush> darkPaintFactory(float pixelSize) {
        return this.pixelBrushFactory(this.options.getColors().getDark(), this.getShouldSeparateDarkPixels(), pixelSize);
    }

    private final NeighborsBasedFactory<Brush> lightPaintFactory(float pixelSize) {
        return this.pixelBrushFactory(this.options.getColors().getLight(), this.getShouldSeparateLightPixels(), pixelSize);
    }

    private final Lazy<Brush> ballBrushFactory(float pixelSize) {
        return this.eyeBrushFactory(this.options.getColors().getBall(), pixelSize);
    }

    private final Lazy<Brush> frameBrushFactory(float pixelSize) {
        return this.eyeBrushFactory(this.options.getColors().getFrame(), pixelSize);
    }

    private final Lazy<Path> ballShapeFactory(float pixelSize) {
        return this.rotatedPathFactory(this.options.getShapes().getBall(), pixelSize * (float)3);
    }

    private final Lazy<Path> frameShapeFactory(float pixelSize) {
        return this.rotatedPathFactory(this.options.getShapes().getFrame(), pixelSize * (float)7);
    }

    private final NeighborsBasedFactory<Path> darkPixelPathFactory(float pixelSize) {
        return this.pixelPathFactory(this.options.getShapes().getDarkPixel(), pixelSize);
    }

    private final NeighborsBasedFactory<Path> lightPixelPathFactory(float pixelSize) {
        return this.pixelPathFactory(this.options.getShapes().getLightPixel(), pixelSize);
    }

    private final NeighborsBasedFactory<Path> pixelPathFactory(QrShapeModifier shape, float pixelSize) {
        Path path = SkiaBackedPath_skikoKt.Path();
        return arg_0 -> QrCodePainter.pixelPathFactory$lambda$27(path, shape, pixelSize, arg_0);
    }

    private final Lazy<Path> rotatedPathFactory(QrShapeModifier shape, float shapeSize) {
        Ref.IntRef number = new Ref.IntRef();
        Path path = SkiaBackedPath_skikoKt.Path();
        NeighborsBasedFactory<Path> factory2 = arg_0 -> QrCodePainter.rotatedPathFactory$lambda$30(path, shape, shapeSize, arg_0);
        return new Recreating((Function0)new Function0<Path>(factory2, number, this, shapeSize){
            final /* synthetic */ NeighborsBasedFactory<Path> $factory;
            final /* synthetic */ Ref.IntRef $number;
            final /* synthetic */ QrCodePainter this$0;
            final /* synthetic */ float $shapeSize;
            {
                this.$factory = $factory;
                this.$number = $number;
                this.this$0 = $receiver;
                this.$shapeSize = $shapeSize;
                super(0);
            }

            @NotNull
            public final Path invoke() {
                Path path = this.$factory.next(QrCodePainterKt.access$forEyeWithNumber(Neighbors.Companion, this.$number.element, this.this$0.getOptions().getFourEyed()));
                Object object = this.this$0;
                Object object2 = this.$number;
                float f = this.$shapeSize;
                Path $this$invoke_u24lambda_u240 = path;
                boolean bl = false;
                if (((QrCodePainter)object).getOptions().getShapes().getCentralSymmetry()) {
                    float f2;
                    switch (((Ref.IntRef)object2).element) {
                        case 0: {
                            f2 = 0.0f;
                            break;
                        }
                        case 1: {
                            f2 = -90.0f;
                            break;
                        }
                        case 2: {
                            f2 = 90.0f;
                            break;
                        }
                        default: {
                            f2 = 180.0f;
                        }
                    }
                    float angle = f2;
                    QrCodePainterKt.access$rotate-0AR0LA0($this$invoke_u24lambda_u240, angle, OffsetKt.Offset(f / (float)2, f / (float)2));
                }
                object = this.$number;
                object2 = this.this$0;
                Path it = path;
                boolean bl2 = false;
                ((Ref.IntRef)object).element = (((Ref.IntRef)object).element + 1) % (((QrCodePainter)object2).getOptions().getFourEyed() ? 4 : 3);
                return path;
            }
        });
    }

    private final Lazy<Brush> eyeBrushFactory(QrBrush brush2, float pixelSize) {
        QrBrush qrBrush;
        QrBrush it = qrBrush = brush2;
        boolean bl = false;
        QrBrush qrBrush2 = QrBrushKt.isSpecified(it) ? qrBrush : null;
        if (qrBrush2 == null) {
            qrBrush2 = QrBrush.Companion.getDefault();
        }
        QrBrush b2 = qrBrush2;
        Ref.IntRef number = new Ref.IntRef();
        Function0 factory2 = new Function0<Brush>(b2, pixelSize, number, this){
            final /* synthetic */ QrBrush $b;
            final /* synthetic */ float $pixelSize;
            final /* synthetic */ Ref.IntRef $number;
            final /* synthetic */ QrCodePainter this$0;
            {
                this.$b = $b;
                this.$pixelSize = $pixelSize;
                this.$number = $number;
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Brush invoke() {
                Brush brush2 = this.$b.brush(this.$pixelSize, QrCodePainterKt.access$forEyeWithNumber(Neighbors.Companion, this.$number.element, this.this$0.getOptions().getFourEyed()));
                Ref.IntRef intRef = this.$number;
                QrCodePainter qrCodePainter = this.this$0;
                Brush it = brush2;
                boolean bl = false;
                intRef.element = (intRef.element + 1) % (qrCodePainter.getOptions().getFourEyed() ? 4 : 3);
                return brush2;
            }
        };
        return new Recreating(factory2);
    }

    private final NeighborsBasedFactory<Brush> pixelBrushFactory(QrBrush brush2, boolean separate, float pixelSize) {
        float size2 = separate ? pixelSize : (float)this.codeMatrix.getSize() * pixelSize;
        Lazy joinBrush$delegate = LazyKt.lazy((Function0)new Function0<Brush>(brush2, size2){
            final /* synthetic */ QrBrush $brush;
            final /* synthetic */ float $size;
            {
                this.$brush = $brush;
                this.$size = $size;
                super(0);
            }

            @NotNull
            public final Brush invoke() {
                return this.$brush.brush(this.$size, Neighbors.Companion.getEmpty());
            }
        });
        return arg_0 -> QrCodePainter.pixelBrushFactory$lambda$33(separate, brush2, size2, joinBrush$delegate, arg_0);
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        QrCodePainter cfr_ignored_0 = (QrCodePainter)other;
        if (!Intrinsics.areEqual(this.data, ((QrCodePainter)other).data)) {
            return false;
        }
        return Intrinsics.areEqual(this.options, ((QrCodePainter)other).options);
    }

    private static final Brush drawBalls$lambda$13(Lazy<? extends Brush> $brush$delegate) {
        Lazy<? extends Brush> lazy = $brush$delegate;
        return lazy.getValue();
    }

    private static final Path drawBalls$lambda$14(Lazy<? extends Path> $path$delegate) {
        Lazy<? extends Path> lazy = $path$delegate;
        return lazy.getValue();
    }

    private static final Brush drawFrames$lambda$17(Lazy<? extends Brush> $ballBrush$delegate) {
        Lazy<? extends Brush> lazy = $ballBrush$delegate;
        return lazy.getValue();
    }

    private static final Path drawFrames$lambda$18(Lazy<? extends Path> $ballPath$delegate) {
        Lazy<? extends Path> lazy = $ballPath$delegate;
        return lazy.getValue();
    }

    private static final Path createMainElements$lambda$23(Lazy<? extends Path> $rotatedFramePath$delegate) {
        Lazy<? extends Path> lazy = $rotatedFramePath$delegate;
        return lazy.getValue();
    }

    private static final Path createMainElements$lambda$24(Lazy<? extends Path> $rotatedBallPath$delegate) {
        Lazy<? extends Path> lazy = $rotatedBallPath$delegate;
        return lazy.getValue();
    }

    private static final Path pixelPathFactory$lambda$27(Path $path, QrShapeModifier $shape, float $pixelSize, Neighbors it) {
        Path path;
        Intrinsics.checkNotNullParameter($path, "$path");
        Intrinsics.checkNotNullParameter($shape, "$shape");
        Intrinsics.checkNotNullParameter(it, "it");
        $path.rewind();
        Path $this$pixelPathFactory_u24lambda_u2427_u24lambda_u2426 = path = $path;
        boolean bl = false;
        QrShapeModifier $this$pixelPathFactory_u24lambda_u2427_u24lambda_u2426_u24lambda_u2425 = $shape;
        boolean bl2 = false;
        $this$pixelPathFactory_u24lambda_u2427_u24lambda_u2426_u24lambda_u2425.path($this$pixelPathFactory_u24lambda_u2427_u24lambda_u2426, $pixelSize, it);
        return $path;
    }

    private static final Path rotatedPathFactory$lambda$30(Path $path, QrShapeModifier $shape, float $shapeSize, Neighbors it) {
        Path path;
        Intrinsics.checkNotNullParameter($path, "$path");
        Intrinsics.checkNotNullParameter($shape, "$shape");
        Intrinsics.checkNotNullParameter(it, "it");
        Path $this$rotatedPathFactory_u24lambda_u2430_u24lambda_u2429 = path = $path;
        boolean bl = false;
        $this$rotatedPathFactory_u24lambda_u2430_u24lambda_u2429.rewind();
        $this$rotatedPathFactory_u24lambda_u2430_u24lambda_u2429.setFillType-oQ8Xj4U(PathFillType.Companion.getEvenOdd-Rg-k1Os());
        QrShapeModifier $this$rotatedPathFactory_u24lambda_u2430_u24lambda_u2429_u24lambda_u2428 = $shape;
        boolean bl2 = false;
        $this$rotatedPathFactory_u24lambda_u2430_u24lambda_u2429_u24lambda_u2428.path($this$rotatedPathFactory_u24lambda_u2430_u24lambda_u2429, $shapeSize, it);
        return path;
    }

    private static final Brush pixelBrushFactory$lambda$32(Lazy<? extends Brush> $joinBrush$delegate) {
        Lazy<? extends Brush> lazy = $joinBrush$delegate;
        return lazy.getValue();
    }

    private static final Brush pixelBrushFactory$lambda$33(boolean $separate, QrBrush $brush, float $size, Lazy $joinBrush$delegate, Neighbors it) {
        Intrinsics.checkNotNullParameter($brush, "$brush");
        Intrinsics.checkNotNullParameter($joinBrush$delegate, "$joinBrush$delegate");
        Intrinsics.checkNotNullParameter(it, "it");
        return $separate ? $brush.brush($size, it) : QrCodePainter.pixelBrushFactory$lambda$32($joinBrush$delegate);
    }
}

