/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.platform.a11y;

import androidx.compose.ui.platform.a11y.ComposeAccessible;
import androidx.compose.ui.semantics.ProgressBarRangeInfo;
import javax.accessibility.AccessibleValue;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0004\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B\u0013\u0012\n\u0010\u0002\u001a\u00060\u0003R\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\r\u001a\u00020\u000eH\u0016J\u0012\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u000eH\u0016J\b\u0010\u0012\u001a\u00020\u000eH\u0016J\b\u0010\u0013\u001a\u00020\u000eH\u0016R\u0015\u0010\u0002\u001a\u00060\u0003R\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0016\u0010\t\u001a\u0004\u0018\u00010\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0014"}, d2={"Landroidx/compose/ui/platform/a11y/ProgressBarAccessibleValue;", "Ljavax/accessibility/AccessibleValue;", "component", "Landroidx/compose/ui/platform/a11y/ComposeAccessible$ComposeAccessibleComponent;", "Landroidx/compose/ui/platform/a11y/ComposeAccessible;", "<init>", "(Landroidx/compose/ui/platform/a11y/ComposeAccessible$ComposeAccessibleComponent;)V", "getComponent", "()Landroidx/compose/ui/platform/a11y/ComposeAccessible$ComposeAccessibleComponent;", "rangeInfo", "Landroidx/compose/ui/semantics/ProgressBarRangeInfo;", "getRangeInfo", "()Landroidx/compose/ui/semantics/ProgressBarRangeInfo;", "getCurrentAccessibleValue", "", "setCurrentAccessibleValue", "", "n", "getMinimumAccessibleValue", "getMaximumAccessibleValue", "ui"})
final class ProgressBarAccessibleValue
implements AccessibleValue {
    @NotNull
    private final ComposeAccessible.ComposeAccessibleComponent component;

    public ProgressBarAccessibleValue(@NotNull ComposeAccessible.ComposeAccessibleComponent component) {
        Intrinsics.checkNotNullParameter(component, "component");
        this.component = component;
    }

    @NotNull
    public final ComposeAccessible.ComposeAccessibleComponent getComponent() {
        return this.component;
    }

    private final ProgressBarRangeInfo getRangeInfo() {
        return this.component.getProgressBarRangeInfo();
    }

    @Override
    @NotNull
    public Number getCurrentAccessibleValue() {
        ProgressBarRangeInfo progressBarRangeInfo = this.getRangeInfo();
        return progressBarRangeInfo != null ? (Number)Float.valueOf(progressBarRangeInfo.getCurrent()) : (Number)Float.valueOf(0.0f);
    }

    @Override
    public boolean setCurrentAccessibleValue(@Nullable Number n) {
        return false;
    }

    @Override
    @NotNull
    public Number getMinimumAccessibleValue() {
        Object object = this.getRangeInfo();
        return object != null && (object = ((ProgressBarRangeInfo)object).getRange()) != null ? (Number)Float.valueOf(((Number)object.getStart()).floatValue()) : (Number)Float.valueOf(0.0f);
    }

    @Override
    @NotNull
    public Number getMaximumAccessibleValue() {
        Object object = this.getRangeInfo();
        return object != null && (object = ((ProgressBarRangeInfo)object).getRange()) != null ? (Number)Float.valueOf(((Number)object.getEndInclusive()).floatValue()) : (Number)Float.valueOf(1.0f);
    }
}

