/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.deser.std;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.StreamReadCapability;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.annotation.JacksonStdImpl;
import com.fasterxml.jackson.databind.deser.ContextualDeserializer;
import com.fasterxml.jackson.databind.deser.ResolvableDeserializer;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.deser.std.UntypedObjectDeserializerNR;
import com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import com.fasterxml.jackson.databind.type.LogicalType;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.fasterxml.jackson.databind.util.ClassUtil;
import com.fasterxml.jackson.databind.util.ObjectBuffer;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

@JacksonStdImpl
public class UntypedObjectDeserializer
extends StdDeserializer<Object>
implements ResolvableDeserializer,
ContextualDeserializer {
    private static final long serialVersionUID = 1L;
    protected static final Object[] NO_OBJECTS = new Object[0];
    protected JsonDeserializer<Object> _mapDeserializer;
    protected JsonDeserializer<Object> _listDeserializer;
    protected JsonDeserializer<Object> _stringDeserializer;
    protected JsonDeserializer<Object> _numberDeserializer;
    protected JavaType _listType;
    protected JavaType _mapType;
    protected final boolean _nonMerging;

    @Deprecated
    public UntypedObjectDeserializer() {
        this(null, null);
    }

    public UntypedObjectDeserializer(JavaType listType, JavaType mapType) {
        super(Object.class);
        this._listType = listType;
        this._mapType = mapType;
        this._nonMerging = false;
    }

    public UntypedObjectDeserializer(UntypedObjectDeserializer base2, JsonDeserializer<?> mapDeser, JsonDeserializer<?> listDeser, JsonDeserializer<?> stringDeser, JsonDeserializer<?> numberDeser) {
        super(Object.class);
        this._mapDeserializer = mapDeser;
        this._listDeserializer = listDeser;
        this._stringDeserializer = stringDeser;
        this._numberDeserializer = numberDeser;
        this._listType = base2._listType;
        this._mapType = base2._mapType;
        this._nonMerging = base2._nonMerging;
    }

    protected UntypedObjectDeserializer(UntypedObjectDeserializer base2, boolean nonMerging) {
        super(Object.class);
        this._mapDeserializer = base2._mapDeserializer;
        this._listDeserializer = base2._listDeserializer;
        this._stringDeserializer = base2._stringDeserializer;
        this._numberDeserializer = base2._numberDeserializer;
        this._listType = base2._listType;
        this._mapType = base2._mapType;
        this._nonMerging = nonMerging;
    }

    @Override
    public void resolve(DeserializationContext ctxt) throws JsonMappingException {
        JavaType obType = ctxt.constructType(Object.class);
        JavaType stringType = ctxt.constructType(String.class);
        TypeFactory tf = ctxt.getTypeFactory();
        this._listDeserializer = this._listType == null ? this._clearIfStdImpl(this._findCustomDeser(ctxt, tf.constructCollectionType(List.class, obType))) : this._findCustomDeser(ctxt, this._listType);
        this._mapDeserializer = this._mapType == null ? this._clearIfStdImpl(this._findCustomDeser(ctxt, tf.constructMapType(Map.class, stringType, obType))) : this._findCustomDeser(ctxt, this._mapType);
        this._stringDeserializer = this._clearIfStdImpl(this._findCustomDeser(ctxt, stringType));
        this._numberDeserializer = this._clearIfStdImpl(this._findCustomDeser(ctxt, tf.constructType((Type)((Object)Number.class))));
        JavaType unknown = TypeFactory.unknownType();
        this._mapDeserializer = ctxt.handleSecondaryContextualization(this._mapDeserializer, null, unknown);
        this._listDeserializer = ctxt.handleSecondaryContextualization(this._listDeserializer, null, unknown);
        this._stringDeserializer = ctxt.handleSecondaryContextualization(this._stringDeserializer, null, unknown);
        this._numberDeserializer = ctxt.handleSecondaryContextualization(this._numberDeserializer, null, unknown);
    }

    protected JsonDeserializer<Object> _findCustomDeser(DeserializationContext ctxt, JavaType type2) throws JsonMappingException {
        return ctxt.findNonContextualValueDeserializer(type2);
    }

    protected JsonDeserializer<Object> _clearIfStdImpl(JsonDeserializer<Object> deser) {
        return ClassUtil.isJacksonStdImpl(deser) ? null : deser;
    }

    @Override
    public JsonDeserializer<?> createContextual(DeserializationContext ctxt, BeanProperty property2) throws JsonMappingException {
        boolean preventMerge;
        boolean bl = preventMerge = property2 == null && Boolean.FALSE.equals(ctxt.getConfig().getDefaultMergeable(Object.class));
        if (this._stringDeserializer == null && this._numberDeserializer == null && this._mapDeserializer == null && this._listDeserializer == null && this.getClass() == UntypedObjectDeserializer.class) {
            return UntypedObjectDeserializerNR.instance(preventMerge);
        }
        if (preventMerge != this._nonMerging) {
            return new UntypedObjectDeserializer(this, preventMerge);
        }
        return this;
    }

    @Override
    public boolean isCachable() {
        return true;
    }

    @Override
    public LogicalType logicalType() {
        return LogicalType.Untyped;
    }

    @Override
    public Boolean supportsUpdate(DeserializationConfig config2) {
        return null;
    }

    @Override
    public Object deserialize(JsonParser p2, DeserializationContext ctxt) throws IOException {
        switch (p2.currentTokenId()) {
            case 1: 
            case 2: 
            case 5: {
                if (this._mapDeserializer != null) {
                    return this._mapDeserializer.deserialize(p2, ctxt);
                }
                return this.mapObject(p2, ctxt);
            }
            case 3: {
                if (ctxt.isEnabled(DeserializationFeature.USE_JAVA_ARRAY_FOR_JSON_ARRAY)) {
                    return this.mapArrayToArray(p2, ctxt);
                }
                if (this._listDeserializer != null) {
                    return this._listDeserializer.deserialize(p2, ctxt);
                }
                return this.mapArray(p2, ctxt);
            }
            case 12: {
                return p2.getEmbeddedObject();
            }
            case 6: {
                if (this._stringDeserializer != null) {
                    return this._stringDeserializer.deserialize(p2, ctxt);
                }
                return p2.getText();
            }
            case 7: {
                if (this._numberDeserializer != null) {
                    return this._numberDeserializer.deserialize(p2, ctxt);
                }
                if (ctxt.hasSomeOfFeatures(F_MASK_INT_COERCIONS)) {
                    return this._coerceIntegral(p2, ctxt);
                }
                return p2.getNumberValue();
            }
            case 8: {
                if (this._numberDeserializer != null) {
                    return this._numberDeserializer.deserialize(p2, ctxt);
                }
                return this._deserializeFP(p2, ctxt);
            }
            case 9: {
                return Boolean.TRUE;
            }
            case 10: {
                return Boolean.FALSE;
            }
            case 11: {
                return null;
            }
        }
        return ctxt.handleUnexpectedToken(Object.class, p2);
    }

    @Override
    public Object deserializeWithType(JsonParser p2, DeserializationContext ctxt, TypeDeserializer typeDeserializer) throws IOException {
        switch (p2.currentTokenId()) {
            case 1: 
            case 3: 
            case 5: {
                return typeDeserializer.deserializeTypedFromAny(p2, ctxt);
            }
            case 12: {
                return p2.getEmbeddedObject();
            }
            case 6: {
                if (this._stringDeserializer != null) {
                    return this._stringDeserializer.deserialize(p2, ctxt);
                }
                return p2.getText();
            }
            case 7: {
                if (this._numberDeserializer != null) {
                    return this._numberDeserializer.deserialize(p2, ctxt);
                }
                if (ctxt.hasSomeOfFeatures(F_MASK_INT_COERCIONS)) {
                    return this._coerceIntegral(p2, ctxt);
                }
                return p2.getNumberValue();
            }
            case 8: {
                if (this._numberDeserializer != null) {
                    return this._numberDeserializer.deserialize(p2, ctxt);
                }
                return this._deserializeFP(p2, ctxt);
            }
            case 9: {
                return Boolean.TRUE;
            }
            case 10: {
                return Boolean.FALSE;
            }
            case 11: {
                return null;
            }
        }
        return ctxt.handleUnexpectedToken(Object.class, p2);
    }

    @Override
    public Object deserialize(JsonParser p2, DeserializationContext ctxt, Object intoValue) throws IOException {
        if (this._nonMerging) {
            return this.deserialize(p2, ctxt);
        }
        switch (p2.currentTokenId()) {
            case 1: 
            case 2: 
            case 5: {
                if (this._mapDeserializer != null) {
                    return this._mapDeserializer.deserialize(p2, ctxt, intoValue);
                }
                if (intoValue instanceof Map) {
                    return this.mapObject(p2, ctxt, (Map)intoValue);
                }
                return this.mapObject(p2, ctxt);
            }
            case 3: {
                if (this._listDeserializer != null) {
                    return this._listDeserializer.deserialize(p2, ctxt, intoValue);
                }
                if (intoValue instanceof Collection) {
                    return this.mapArray(p2, ctxt, (Collection)intoValue);
                }
                if (ctxt.isEnabled(DeserializationFeature.USE_JAVA_ARRAY_FOR_JSON_ARRAY)) {
                    return this.mapArrayToArray(p2, ctxt);
                }
                return this.mapArray(p2, ctxt);
            }
            case 12: {
                return p2.getEmbeddedObject();
            }
            case 6: {
                if (this._stringDeserializer != null) {
                    return this._stringDeserializer.deserialize(p2, ctxt, intoValue);
                }
                return p2.getText();
            }
            case 7: {
                if (this._numberDeserializer != null) {
                    return this._numberDeserializer.deserialize(p2, ctxt, intoValue);
                }
                if (ctxt.hasSomeOfFeatures(F_MASK_INT_COERCIONS)) {
                    return this._coerceIntegral(p2, ctxt);
                }
                return p2.getNumberValue();
            }
            case 8: {
                if (this._numberDeserializer != null) {
                    return this._numberDeserializer.deserialize(p2, ctxt, intoValue);
                }
                return this._deserializeFP(p2, ctxt);
            }
            case 9: {
                return Boolean.TRUE;
            }
            case 10: {
                return Boolean.FALSE;
            }
            case 11: {
                return null;
            }
        }
        return this.deserialize(p2, ctxt);
    }

    protected Object mapArray(JsonParser p2, DeserializationContext ctxt) throws IOException {
        if (p2.nextToken() == JsonToken.END_ARRAY) {
            return new ArrayList(2);
        }
        Object value = this.deserialize(p2, ctxt);
        if (p2.nextToken() == JsonToken.END_ARRAY) {
            ArrayList<Object> l = new ArrayList<Object>(2);
            l.add(value);
            return l;
        }
        Object value2 = this.deserialize(p2, ctxt);
        if (p2.nextToken() == JsonToken.END_ARRAY) {
            ArrayList<Object> l = new ArrayList<Object>(2);
            l.add(value);
            l.add(value2);
            return l;
        }
        ObjectBuffer buffer = ctxt.leaseObjectBuffer();
        Object[] values2 = buffer.resetAndStart();
        int ptr = 0;
        values2[ptr++] = value;
        values2[ptr++] = value2;
        int totalSize = ptr;
        do {
            value = this.deserialize(p2, ctxt);
            ++totalSize;
            if (ptr >= values2.length) {
                values2 = buffer.appendCompletedChunk(values2);
                ptr = 0;
            }
            values2[ptr++] = value;
        } while (p2.nextToken() != JsonToken.END_ARRAY);
        ArrayList<Object> result2 = new ArrayList<Object>(totalSize);
        buffer.completeAndClearBuffer(values2, ptr, result2);
        ctxt.returnObjectBuffer(buffer);
        return result2;
    }

    protected Object mapArray(JsonParser p2, DeserializationContext ctxt, Collection<Object> result2) throws IOException {
        while (p2.nextToken() != JsonToken.END_ARRAY) {
            result2.add(this.deserialize(p2, ctxt));
        }
        return result2;
    }

    protected Object mapObject(JsonParser p2, DeserializationContext ctxt) throws IOException {
        String key1;
        JsonToken t = p2.currentToken();
        if (t == JsonToken.START_OBJECT) {
            key1 = p2.nextFieldName();
        } else if (t == JsonToken.FIELD_NAME) {
            key1 = p2.currentName();
        } else {
            if (t != JsonToken.END_OBJECT) {
                return ctxt.handleUnexpectedToken(this.handledType(), p2);
            }
            key1 = null;
        }
        if (key1 == null) {
            return new LinkedHashMap(2);
        }
        p2.nextToken();
        Object value1 = this.deserialize(p2, ctxt);
        String key2 = p2.nextFieldName();
        if (key2 == null) {
            LinkedHashMap<String, Object> result2 = new LinkedHashMap<String, Object>(2);
            result2.put(key1, value1);
            return result2;
        }
        p2.nextToken();
        Object value2 = this.deserialize(p2, ctxt);
        String key = p2.nextFieldName();
        if (key == null) {
            LinkedHashMap<String, Object> result3 = new LinkedHashMap<String, Object>(4);
            result3.put(key1, value1);
            if (result3.put(key2, value2) != null) {
                return this._mapObjectWithDups(p2, ctxt, result3, key1, value1, value2, key);
            }
            return result3;
        }
        LinkedHashMap<String, Object> result4 = new LinkedHashMap<String, Object>();
        result4.put(key1, value1);
        if (result4.put(key2, value2) != null) {
            return this._mapObjectWithDups(p2, ctxt, result4, key1, value1, value2, key);
        }
        do {
            p2.nextToken();
            Object newValue = this.deserialize(p2, ctxt);
            Object oldValue = result4.put(key, newValue);
            if (oldValue == null) continue;
            return this._mapObjectWithDups(p2, ctxt, result4, key, oldValue, newValue, p2.nextFieldName());
        } while ((key = p2.nextFieldName()) != null);
        return result4;
    }

    protected Object _mapObjectWithDups(JsonParser p2, DeserializationContext ctxt, Map<String, Object> result2, String key, Object oldValue, Object newValue, String nextKey) throws IOException {
        boolean squashDups = ctxt.isEnabled(StreamReadCapability.DUPLICATE_PROPERTIES);
        if (squashDups) {
            this._squashDups(result2, key, oldValue, newValue);
        }
        while (nextKey != null) {
            p2.nextToken();
            newValue = this.deserialize(p2, ctxt);
            oldValue = result2.put(nextKey, newValue);
            if (oldValue != null && squashDups) {
                this._squashDups(result2, key, oldValue, newValue);
            }
            nextKey = p2.nextFieldName();
        }
        return result2;
    }

    private void _squashDups(Map<String, Object> result2, String key, Object oldValue, Object newValue) {
        if (oldValue instanceof List) {
            ((List)oldValue).add(newValue);
            result2.put(key, oldValue);
        } else {
            ArrayList<Object> l = new ArrayList<Object>();
            l.add(oldValue);
            l.add(newValue);
            result2.put(key, l);
        }
    }

    protected Object[] mapArrayToArray(JsonParser p2, DeserializationContext ctxt) throws IOException {
        if (p2.nextToken() == JsonToken.END_ARRAY) {
            return NO_OBJECTS;
        }
        ObjectBuffer buffer = ctxt.leaseObjectBuffer();
        Object[] values2 = buffer.resetAndStart();
        int ptr = 0;
        do {
            Object value = this.deserialize(p2, ctxt);
            if (ptr >= values2.length) {
                values2 = buffer.appendCompletedChunk(values2);
                ptr = 0;
            }
            values2[ptr++] = value;
        } while (p2.nextToken() != JsonToken.END_ARRAY);
        Object[] result2 = buffer.completeAndClearBuffer(values2, ptr);
        ctxt.returnObjectBuffer(buffer);
        return result2;
    }

    protected Object mapObject(JsonParser p2, DeserializationContext ctxt, Map<Object, Object> m) throws IOException {
        JsonToken t = p2.currentToken();
        if (t == JsonToken.START_OBJECT) {
            t = p2.nextToken();
        }
        if (t == JsonToken.END_OBJECT) {
            return m;
        }
        String key = p2.currentName();
        do {
            p2.nextToken();
            Object old = m.get(key);
            Object newV = old != null ? this.deserialize(p2, ctxt, old) : this.deserialize(p2, ctxt);
            if (newV == old) continue;
            m.put(key, newV);
        } while ((key = p2.nextFieldName()) != null);
        return m;
    }

    protected Object _deserializeFP(JsonParser p2, DeserializationContext ctxt) throws IOException {
        JsonParser.NumberTypeFP nt = p2.getNumberTypeFP();
        if (nt == JsonParser.NumberTypeFP.BIG_DECIMAL) {
            return p2.getDecimalValue();
        }
        if (!p2.isNaN() && ctxt.isEnabled(DeserializationFeature.USE_BIG_DECIMAL_FOR_FLOATS)) {
            return p2.getDecimalValue();
        }
        if (nt == JsonParser.NumberTypeFP.FLOAT32) {
            return Float.valueOf(p2.getFloatValue());
        }
        return p2.getDoubleValue();
    }

    @JacksonStdImpl
    @Deprecated
    public static class Vanilla
    extends StdDeserializer<Object> {
        private static final long serialVersionUID = 1L;
        public static final Vanilla std = new Vanilla();
        protected final boolean _nonMerging;

        public Vanilla() {
            this(false);
        }

        protected Vanilla(boolean nonMerging) {
            super(Object.class);
            this._nonMerging = nonMerging;
        }

        public static Vanilla instance(boolean nonMerging) {
            if (nonMerging) {
                return new Vanilla(true);
            }
            return std;
        }

        @Override
        public LogicalType logicalType() {
            return LogicalType.Untyped;
        }

        @Override
        public Boolean supportsUpdate(DeserializationConfig config2) {
            return this._nonMerging ? Boolean.FALSE : null;
        }

        @Override
        public Object deserialize(JsonParser p2, DeserializationContext ctxt) throws IOException {
            switch (p2.currentTokenId()) {
                case 1: {
                    JsonToken t = p2.nextToken();
                    if (t == JsonToken.END_OBJECT) {
                        return new LinkedHashMap(2);
                    }
                }
                case 5: {
                    return this.mapObject(p2, ctxt);
                }
                case 3: {
                    JsonToken t = p2.nextToken();
                    if (t == JsonToken.END_ARRAY) {
                        if (ctxt.isEnabled(DeserializationFeature.USE_JAVA_ARRAY_FOR_JSON_ARRAY)) {
                            return NO_OBJECTS;
                        }
                        return new ArrayList(2);
                    }
                    if (ctxt.isEnabled(DeserializationFeature.USE_JAVA_ARRAY_FOR_JSON_ARRAY)) {
                        return this.mapArrayToArray(p2, ctxt);
                    }
                    return this.mapArray(p2, ctxt);
                }
                case 12: {
                    return p2.getEmbeddedObject();
                }
                case 6: {
                    return p2.getText();
                }
                case 7: {
                    if (ctxt.hasSomeOfFeatures(F_MASK_INT_COERCIONS)) {
                        return this._coerceIntegral(p2, ctxt);
                    }
                    return p2.getNumberValue();
                }
                case 8: {
                    return this._deserializeFP(p2, ctxt);
                }
                case 9: {
                    return Boolean.TRUE;
                }
                case 10: {
                    return Boolean.FALSE;
                }
                case 2: {
                    return new LinkedHashMap(2);
                }
                case 11: {
                    return null;
                }
            }
            return ctxt.handleUnexpectedToken(Object.class, p2);
        }

        @Override
        public Object deserializeWithType(JsonParser p2, DeserializationContext ctxt, TypeDeserializer typeDeserializer) throws IOException {
            switch (p2.currentTokenId()) {
                case 1: 
                case 3: 
                case 5: {
                    return typeDeserializer.deserializeTypedFromAny(p2, ctxt);
                }
                case 6: {
                    return p2.getText();
                }
                case 7: {
                    if (ctxt.isEnabled(DeserializationFeature.USE_BIG_INTEGER_FOR_INTS)) {
                        return p2.getBigIntegerValue();
                    }
                    return p2.getNumberValue();
                }
                case 8: {
                    return this._deserializeFP(p2, ctxt);
                }
                case 9: {
                    return Boolean.TRUE;
                }
                case 10: {
                    return Boolean.FALSE;
                }
                case 12: {
                    return p2.getEmbeddedObject();
                }
                case 11: {
                    return null;
                }
            }
            return ctxt.handleUnexpectedToken(Object.class, p2);
        }

        @Override
        public Object deserialize(JsonParser p2, DeserializationContext ctxt, Object intoValue) throws IOException {
            if (this._nonMerging) {
                return this.deserialize(p2, ctxt);
            }
            switch (p2.currentTokenId()) {
                case 2: 
                case 4: {
                    return intoValue;
                }
                case 1: {
                    JsonToken t = p2.nextToken();
                    if (t == JsonToken.END_OBJECT) {
                        return intoValue;
                    }
                }
                case 5: {
                    if (!(intoValue instanceof Map)) break;
                    Map m = (Map)intoValue;
                    String key = p2.currentName();
                    do {
                        p2.nextToken();
                        Object old = m.get(key);
                        Object newV = old != null ? this.deserialize(p2, ctxt, old) : this.deserialize(p2, ctxt);
                        if (newV == old) continue;
                        m.put(key, newV);
                    } while ((key = p2.nextFieldName()) != null);
                    return intoValue;
                }
                case 3: {
                    JsonToken t = p2.nextToken();
                    if (t == JsonToken.END_ARRAY) {
                        return intoValue;
                    }
                    if (!(intoValue instanceof Collection)) break;
                    Collection c = (Collection)intoValue;
                    do {
                        c.add(this.deserialize(p2, ctxt));
                    } while (p2.nextToken() != JsonToken.END_ARRAY);
                    return intoValue;
                }
            }
            return this.deserialize(p2, ctxt);
        }

        protected Object _deserializeFP(JsonParser p2, DeserializationContext ctxt) throws IOException {
            JsonParser.NumberTypeFP nt = p2.getNumberTypeFP();
            if (nt == JsonParser.NumberTypeFP.BIG_DECIMAL) {
                return p2.getDecimalValue();
            }
            if (!p2.isNaN() && ctxt.isEnabled(DeserializationFeature.USE_BIG_DECIMAL_FOR_FLOATS)) {
                return p2.getDecimalValue();
            }
            if (nt == JsonParser.NumberTypeFP.FLOAT32) {
                return Float.valueOf(p2.getFloatValue());
            }
            return p2.getDoubleValue();
        }

        protected Object mapArray(JsonParser p2, DeserializationContext ctxt) throws IOException {
            Object value = this.deserialize(p2, ctxt);
            if (p2.nextToken() == JsonToken.END_ARRAY) {
                ArrayList<Object> l = new ArrayList<Object>(2);
                l.add(value);
                return l;
            }
            ObjectBuffer buffer = ctxt.leaseObjectBuffer();
            Object[] values2 = buffer.resetAndStart();
            int ptr = 0;
            values2[ptr++] = value;
            int totalSize = ptr;
            do {
                value = this.deserialize(p2, ctxt);
                ++totalSize;
                if (ptr >= values2.length) {
                    values2 = buffer.appendCompletedChunk(values2);
                    ptr = 0;
                }
                values2[ptr++] = value;
            } while (p2.nextToken() != JsonToken.END_ARRAY);
            ArrayList<Object> result2 = new ArrayList<Object>(totalSize);
            buffer.completeAndClearBuffer(values2, ptr, result2);
            ctxt.returnObjectBuffer(buffer);
            return result2;
        }

        protected Object[] mapArrayToArray(JsonParser p2, DeserializationContext ctxt) throws IOException {
            ObjectBuffer buffer = ctxt.leaseObjectBuffer();
            Object[] values2 = buffer.resetAndStart();
            int ptr = 0;
            do {
                Object value = this.deserialize(p2, ctxt);
                if (ptr >= values2.length) {
                    values2 = buffer.appendCompletedChunk(values2);
                    ptr = 0;
                }
                values2[ptr++] = value;
            } while (p2.nextToken() != JsonToken.END_ARRAY);
            Object[] result2 = buffer.completeAndClearBuffer(values2, ptr);
            ctxt.returnObjectBuffer(buffer);
            return result2;
        }

        protected Object mapObject(JsonParser p2, DeserializationContext ctxt) throws IOException {
            String key1 = p2.currentName();
            p2.nextToken();
            Object value1 = this.deserialize(p2, ctxt);
            String key = p2.nextFieldName();
            if (key == null) {
                LinkedHashMap<String, Object> result2 = new LinkedHashMap<String, Object>(2);
                result2.put(key1, value1);
                return result2;
            }
            LinkedHashMap<String, Object> result3 = new LinkedHashMap<String, Object>();
            result3.put(key1, value1);
            do {
                p2.nextToken();
                Object newValue = this.deserialize(p2, ctxt);
                Object oldValue = result3.put(key, newValue);
                if (oldValue == null) continue;
                return this._mapObjectWithDups(p2, ctxt, result3, key, oldValue, newValue, p2.nextFieldName());
            } while ((key = p2.nextFieldName()) != null);
            return result3;
        }

        protected Object _mapObjectWithDups(JsonParser p2, DeserializationContext ctxt, Map<String, Object> result2, String initialKey, Object oldValue, Object newValue, String nextKey) throws IOException {
            boolean squashDups = ctxt.isEnabled(StreamReadCapability.DUPLICATE_PROPERTIES);
            if (squashDups) {
                this._squashDups(result2, initialKey, oldValue, newValue);
            }
            while (nextKey != null) {
                p2.nextToken();
                newValue = this.deserialize(p2, ctxt);
                oldValue = result2.put(nextKey, newValue);
                if (oldValue != null && squashDups) {
                    this._squashDups(result2, nextKey, oldValue, newValue);
                }
                nextKey = p2.nextFieldName();
            }
            return result2;
        }

        private void _squashDups(Map<String, Object> result2, String key, Object oldValue, Object newValue) {
            if (oldValue instanceof List) {
                ((List)oldValue).add(newValue);
                result2.put(key, oldValue);
            } else {
                ArrayList<Object> l = new ArrayList<Object>();
                l.add(oldValue);
                l.add(newValue);
                result2.put(key, l);
            }
        }
    }
}

