/*
 * Decompiled with CFR 0.152.
 */
package org.yaml.snakeyaml.serializer;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.comments.CommentLine;
import org.yaml.snakeyaml.emitter.Emitable;
import org.yaml.snakeyaml.events.AliasEvent;
import org.yaml.snakeyaml.events.CommentEvent;
import org.yaml.snakeyaml.events.DocumentEndEvent;
import org.yaml.snakeyaml.events.DocumentStartEvent;
import org.yaml.snakeyaml.events.ImplicitTuple;
import org.yaml.snakeyaml.events.MappingEndEvent;
import org.yaml.snakeyaml.events.MappingStartEvent;
import org.yaml.snakeyaml.events.ScalarEvent;
import org.yaml.snakeyaml.events.SequenceEndEvent;
import org.yaml.snakeyaml.events.SequenceStartEvent;
import org.yaml.snakeyaml.events.StreamEndEvent;
import org.yaml.snakeyaml.events.StreamStartEvent;
import org.yaml.snakeyaml.nodes.AnchorNode;
import org.yaml.snakeyaml.nodes.MappingNode;
import org.yaml.snakeyaml.nodes.Node;
import org.yaml.snakeyaml.nodes.NodeId;
import org.yaml.snakeyaml.nodes.NodeTuple;
import org.yaml.snakeyaml.nodes.ScalarNode;
import org.yaml.snakeyaml.nodes.SequenceNode;
import org.yaml.snakeyaml.nodes.Tag;
import org.yaml.snakeyaml.resolver.Resolver;
import org.yaml.snakeyaml.serializer.AnchorGenerator;
import org.yaml.snakeyaml.serializer.SerializerException;
import org.yaml.snakeyaml.util.MergeUtils;

public final class Serializer {
    private final Emitable emitter;
    private final Resolver resolver;
    private final boolean explicitStart;
    private final boolean explicitEnd;
    private DumperOptions.Version useVersion;
    private final Map<String, String> useTags;
    private final Set<Node> serializedNodes;
    private final Map<Node, String> anchors;
    private final AnchorGenerator anchorGenerator;
    private Boolean closed;
    private final Tag explicitRoot;
    private final boolean dereferenceAliases;
    private final Set<Node> recursive;
    private final MergeUtils mergeUtils;

    public Serializer(Emitable emitter, Resolver resolver, DumperOptions opts, Tag rootTag) {
        if (emitter == null) {
            throw new NullPointerException("Emitter must  be provided");
        }
        if (resolver == null) {
            throw new NullPointerException("Resolver must  be provided");
        }
        if (opts == null) {
            throw new NullPointerException("DumperOptions must  be provided");
        }
        this.emitter = emitter;
        this.resolver = resolver;
        this.explicitStart = opts.isExplicitStart();
        this.explicitEnd = opts.isExplicitEnd();
        if (opts.getVersion() != null) {
            this.useVersion = opts.getVersion();
        }
        this.useTags = opts.getTags();
        this.serializedNodes = new HashSet<Node>();
        this.anchors = new HashMap<Node, String>();
        this.anchorGenerator = opts.getAnchorGenerator();
        this.dereferenceAliases = opts.isDereferenceAliases();
        this.recursive = Collections.newSetFromMap(new IdentityHashMap());
        this.closed = null;
        this.explicitRoot = rootTag;
        this.mergeUtils = new MergeUtils(){

            @Override
            public MappingNode asMappingNode(Node node2) {
                if (node2 instanceof MappingNode) {
                    return (MappingNode)node2;
                }
                throw new SerializerException("expecting MappingNode while processing merge.");
            }
        };
    }

    public void open() throws IOException {
        if (this.closed != null) {
            if (Boolean.TRUE.equals(this.closed)) {
                throw new SerializerException("serializer is closed");
            }
            throw new SerializerException("serializer is already opened");
        }
        this.emitter.emit(new StreamStartEvent(null, null));
        this.closed = Boolean.FALSE;
    }

    public void close() throws IOException {
        if (this.closed == null) {
            throw new SerializerException("serializer is not opened");
        }
        if (!Boolean.TRUE.equals(this.closed)) {
            this.emitter.emit(new StreamEndEvent(null, null));
            this.closed = Boolean.TRUE;
            this.serializedNodes.clear();
            this.anchors.clear();
            this.recursive.clear();
        }
    }

    public void serialize(Node node2) throws IOException {
        if (this.closed == null) {
            throw new SerializerException("serializer is not opened");
        }
        if (this.closed.booleanValue()) {
            throw new SerializerException("serializer is closed");
        }
        this.emitter.emit(new DocumentStartEvent(null, null, this.explicitStart, this.useVersion, this.useTags));
        this.anchorNode(node2);
        if (this.explicitRoot != null) {
            node2.setTag(this.explicitRoot);
        }
        this.serializeNode(node2, null);
        this.emitter.emit(new DocumentEndEvent(null, null, this.explicitEnd));
        this.serializedNodes.clear();
        this.anchors.clear();
        this.recursive.clear();
    }

    private void anchorNode(Node node2) {
        if (node2.getNodeId() == NodeId.anchor) {
            node2 = ((AnchorNode)node2).getRealNode();
        }
        if (this.anchors.containsKey(node2)) {
            String anchor = this.anchors.get(node2);
            if (null == anchor) {
                anchor = this.anchorGenerator.nextAnchor(node2);
                this.anchors.put(node2, anchor);
            }
        } else {
            this.anchors.put(node2, node2.getAnchor() != null ? this.anchorGenerator.nextAnchor(node2) : null);
            switch (node2.getNodeId()) {
                case sequence: {
                    SequenceNode seqNode = (SequenceNode)node2;
                    List<Node> list2 = seqNode.getValue();
                    for (Node item2 : list2) {
                        this.anchorNode(item2);
                    }
                    break;
                }
                case mapping: {
                    MappingNode mnode = (MappingNode)node2;
                    List<NodeTuple> map2 = mnode.getValue();
                    for (NodeTuple object : map2) {
                        Node key = object.getKeyNode();
                        Node value = object.getValueNode();
                        this.anchorNode(key);
                        this.anchorNode(value);
                    }
                    break;
                }
            }
        }
    }

    private void serializeNode(Node node2, Node parent) throws IOException {
        String tAlias;
        if (node2.getNodeId() == NodeId.anchor) {
            node2 = ((AnchorNode)node2).getRealNode();
        }
        if (this.dereferenceAliases && this.recursive.contains(node2)) {
            throw new SerializerException("Cannot dereferenceAliases for recursive structures.");
        }
        this.recursive.add(node2);
        String string2 = tAlias = !this.dereferenceAliases ? this.anchors.get(node2) : null;
        if (!this.dereferenceAliases && this.serializedNodes.contains(node2)) {
            this.emitter.emit(new AliasEvent(tAlias, null, null));
        } else {
            this.serializedNodes.add(node2);
            switch (node2.getNodeId()) {
                case scalar: {
                    ScalarNode scalarNode = (ScalarNode)node2;
                    this.serializeComments(node2.getBlockComments());
                    Tag detectedTag = this.resolver.resolve(NodeId.scalar, scalarNode.getValue(), true);
                    Tag defaultTag = this.resolver.resolve(NodeId.scalar, scalarNode.getValue(), false);
                    ImplicitTuple tuple = new ImplicitTuple(node2.getTag().equals(detectedTag), node2.getTag().equals(defaultTag));
                    ScalarEvent event = new ScalarEvent(tAlias, node2.getTag().getValue(), tuple, scalarNode.getValue(), null, null, scalarNode.getScalarStyle());
                    this.emitter.emit(event);
                    this.serializeComments(node2.getInLineComments());
                    this.serializeComments(node2.getEndComments());
                    break;
                }
                case sequence: {
                    SequenceNode seqNode = (SequenceNode)node2;
                    this.serializeComments(node2.getBlockComments());
                    boolean implicitS = node2.getTag().equals(this.resolver.resolve(NodeId.sequence, null, true));
                    this.emitter.emit(new SequenceStartEvent(tAlias, node2.getTag().getValue(), implicitS, null, null, seqNode.getFlowStyle()));
                    List<Node> list2 = seqNode.getValue();
                    for (Node item2 : list2) {
                        this.serializeNode(item2, node2);
                    }
                    this.emitter.emit(new SequenceEndEvent(null, null));
                    this.serializeComments(node2.getInLineComments());
                    this.serializeComments(node2.getEndComments());
                    break;
                }
                default: {
                    this.serializeComments(node2.getBlockComments());
                    if (node2.getTag() == Tag.COMMENT) break;
                    Tag implicitTag = this.resolver.resolve(NodeId.mapping, null, true);
                    boolean implicitM = node2.getTag().equals(implicitTag);
                    MappingNode mnode = (MappingNode)node2;
                    List<NodeTuple> map2 = mnode.getValue();
                    if (this.dereferenceAliases && mnode.isMerged()) {
                        map2 = this.mergeUtils.flatten(mnode);
                    }
                    this.emitter.emit(new MappingStartEvent(tAlias, mnode.getTag().getValue(), implicitM, null, null, mnode.getFlowStyle()));
                    for (NodeTuple row : map2) {
                        Node key = row.getKeyNode();
                        Node value = row.getValueNode();
                        this.serializeNode(key, mnode);
                        this.serializeNode(value, mnode);
                    }
                    this.emitter.emit(new MappingEndEvent(null, null));
                    this.serializeComments(node2.getInLineComments());
                    this.serializeComments(node2.getEndComments());
                }
            }
        }
        this.recursive.remove(node2);
    }

    private void serializeComments(List<CommentLine> comments) throws IOException {
        if (comments == null) {
            return;
        }
        for (CommentLine line : comments) {
            CommentEvent commentEvent = new CommentEvent(line.getCommentType(), line.getValue(), line.getStartMark(), line.getEndMark());
            this.emitter.emit(commentEvent);
        }
    }
}

