/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.km.jvm;

import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.km.jvm.JvmMemberSignature;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JvmFieldSignature
extends JvmMemberSignature {
    @NotNull
    private final String name;
    @NotNull
    private final String descriptor;

    public JvmFieldSignature(@NotNull String name, @NotNull String descriptor2) {
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
        super(null);
        this.name = name;
        this.descriptor = descriptor2;
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    @NotNull
    public String getDescriptor() {
        return this.descriptor;
    }

    @Override
    @NotNull
    public String toString() {
        return this.getName() + ':' + this.getDescriptor();
    }

    public int hashCode() {
        int result2 = this.name.hashCode();
        result2 = result2 * 31 + this.descriptor.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof JvmFieldSignature)) {
            return false;
        }
        JvmFieldSignature jvmFieldSignature = (JvmFieldSignature)other;
        if (!Intrinsics.areEqual(this.name, jvmFieldSignature.name)) {
            return false;
        }
        return Intrinsics.areEqual(this.descriptor, jvmFieldSignature.descriptor);
    }
}

