/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.data.extension;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.webauthn4j.data.extension.UvmEntry;
import com.webauthn4j.util.AssertUtil;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UvmEntries
extends AbstractList<UvmEntry> {
    private final int size;
    private final UvmEntry[] array;

    @JsonCreator
    public UvmEntries(@NotNull List<UvmEntry> value) {
        AssertUtil.notNull(value, "value must not be null");
        this.size = value.size();
        this.array = value.toArray(new UvmEntry[this.size]);
    }

    public UvmEntries() {
        this(Collections.emptyList());
    }

    @Override
    @NotNull
    public UvmEntry get(int index2) {
        return this.array[index2];
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        UvmEntries that = (UvmEntries)o;
        return this.size == that.size && Arrays.equals(this.array, that.array);
    }

    @Override
    public int hashCode() {
        int result2 = Objects.hash(super.hashCode(), this.size);
        result2 = 31 * result2 + Arrays.hashCode(this.array);
        return result2;
    }
}

