/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.deser.std;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.std.BaseNodeDeserializer;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;

public class JsonNodeDeserializer
extends BaseNodeDeserializer<JsonNode> {
    private static final JsonNodeDeserializer instance = new JsonNodeDeserializer();

    protected JsonNodeDeserializer() {
        super(JsonNode.class, null);
    }

    protected JsonNodeDeserializer(JsonNodeDeserializer base2, boolean mergeArrays, boolean mergeObjects) {
        super(base2, mergeArrays, mergeObjects);
    }

    @Override
    protected JsonDeserializer<?> _createWithMerge(boolean mergeArrays, boolean mergeObjects) {
        return new JsonNodeDeserializer(this, mergeArrays, mergeObjects);
    }

    public static JsonDeserializer<? extends JsonNode> getDeserializer(Class<?> nodeClass) {
        if (nodeClass == ObjectNode.class) {
            return ObjectDeserializer.getInstance();
        }
        if (nodeClass == ArrayNode.class) {
            return ArrayDeserializer.getInstance();
        }
        return instance;
    }

    @Override
    public JsonNode getNullValue(DeserializationContext ctxt) {
        return ctxt.getNodeFactory().nullNode();
    }

    @Override
    public Object getAbsentValue(DeserializationContext ctxt) {
        return null;
    }

    @Override
    public JsonNode deserialize(JsonParser p2, DeserializationContext ctxt) throws IOException {
        BaseNodeDeserializer.ContainerStack stack = new BaseNodeDeserializer.ContainerStack();
        JsonNodeFactory nodeF = ctxt.getNodeFactory();
        switch (p2.currentTokenId()) {
            case 1: {
                return this._deserializeContainerNoRecursion(p2, ctxt, nodeF, stack, nodeF.objectNode());
            }
            case 2: {
                return nodeF.objectNode();
            }
            case 3: {
                return this._deserializeContainerNoRecursion(p2, ctxt, nodeF, stack, nodeF.arrayNode());
            }
            case 5: {
                return this._deserializeObjectAtName(p2, ctxt, nodeF, stack);
            }
        }
        return this._deserializeAnyScalar(p2, ctxt);
    }

    @Override
    public Boolean supportsUpdate(DeserializationConfig config2) {
        return this._supportsUpdates;
    }

    static final class ArrayDeserializer
    extends BaseNodeDeserializer<ArrayNode> {
        private static final long serialVersionUID = 1L;
        protected static final ArrayDeserializer _instance = new ArrayDeserializer();

        protected ArrayDeserializer() {
            super(ArrayNode.class, true);
        }

        public static ArrayDeserializer getInstance() {
            return _instance;
        }

        protected ArrayDeserializer(ArrayDeserializer base2, boolean mergeArrays, boolean mergeObjects) {
            super(base2, mergeArrays, mergeObjects);
        }

        @Override
        protected JsonDeserializer<?> _createWithMerge(boolean mergeArrays, boolean mergeObjects) {
            return new ArrayDeserializer(this, mergeArrays, mergeObjects);
        }

        @Override
        public ArrayNode deserialize(JsonParser p2, DeserializationContext ctxt) throws IOException {
            if (p2.isExpectedStartArrayToken()) {
                JsonNodeFactory nodeF = ctxt.getNodeFactory();
                ArrayNode arrayNode = nodeF.arrayNode();
                this._deserializeContainerNoRecursion(p2, ctxt, nodeF, new BaseNodeDeserializer.ContainerStack(), arrayNode);
                return arrayNode;
            }
            return (ArrayNode)ctxt.handleUnexpectedToken(ArrayNode.class, p2);
        }

        @Override
        public ArrayNode deserialize(JsonParser p2, DeserializationContext ctxt, ArrayNode arrayNode) throws IOException {
            if (p2.isExpectedStartArrayToken()) {
                this._deserializeContainerNoRecursion(p2, ctxt, ctxt.getNodeFactory(), new BaseNodeDeserializer.ContainerStack(), arrayNode);
                return arrayNode;
            }
            return (ArrayNode)ctxt.handleUnexpectedToken(ArrayNode.class, p2);
        }
    }

    static final class ObjectDeserializer
    extends BaseNodeDeserializer<ObjectNode> {
        private static final long serialVersionUID = 1L;
        protected static final ObjectDeserializer _instance = new ObjectDeserializer();

        protected ObjectDeserializer() {
            super(ObjectNode.class, true);
        }

        public static ObjectDeserializer getInstance() {
            return _instance;
        }

        protected ObjectDeserializer(ObjectDeserializer base2, boolean mergeArrays, boolean mergeObjects) {
            super(base2, mergeArrays, mergeObjects);
        }

        @Override
        protected JsonDeserializer<?> _createWithMerge(boolean mergeArrays, boolean mergeObjects) {
            return new ObjectDeserializer(this, mergeArrays, mergeObjects);
        }

        @Override
        public ObjectNode deserialize(JsonParser p2, DeserializationContext ctxt) throws IOException {
            JsonNodeFactory nodeF = ctxt.getNodeFactory();
            if (p2.isExpectedStartObjectToken()) {
                ObjectNode root = nodeF.objectNode();
                this._deserializeContainerNoRecursion(p2, ctxt, nodeF, new BaseNodeDeserializer.ContainerStack(), root);
                return root;
            }
            if (p2.hasToken(JsonToken.FIELD_NAME)) {
                return this._deserializeObjectAtName(p2, ctxt, nodeF, new BaseNodeDeserializer.ContainerStack());
            }
            if (p2.hasToken(JsonToken.END_OBJECT)) {
                return nodeF.objectNode();
            }
            return (ObjectNode)ctxt.handleUnexpectedToken(ObjectNode.class, p2);
        }

        @Override
        public ObjectNode deserialize(JsonParser p2, DeserializationContext ctxt, ObjectNode node2) throws IOException {
            if (p2.isExpectedStartObjectToken() || p2.hasToken(JsonToken.FIELD_NAME)) {
                return (ObjectNode)this.updateObject(p2, ctxt, node2, new BaseNodeDeserializer.ContainerStack());
            }
            return (ObjectNode)ctxt.handleUnexpectedToken(ObjectNode.class, p2);
        }
    }
}

