/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.runtime.tooling;

import androidx.compose.runtime.tooling.ParseException;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0010\u0001\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\n\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0003J\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0010\u001a\u00020\u0011J\u000e\u0010\u0017\u001a\u00020\t2\u0006\u0010\u0018\u001a\u00020\u0003J\u000e\u0010\u0019\u001a\u00020\u00032\u0006\u0010\u0018\u001a\u00020\u0003J\u0006\u0010\u001a\u001a\u00020\u0003J\u000e\u0010\u001b\u001a\u00020\u000f2\u0006\u0010\u0018\u001a\u00020\u0003J\u0010\u0010\u001c\u001a\u00020\u000f2\b\b\u0002\u0010\u001d\u001a\u00020\tJ\u0006\u0010\u001e\u001a\u00020\u0011J\u0006\u0010\u001f\u001a\u00020\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\r\u00a8\u0006 "}, d2={"Landroidx/compose/runtime/tooling/SourceInfoParserState;", "", "data", "", "<init>", "(Ljava/lang/String;)V", "getData", "()Ljava/lang/String;", "i", "", "getI", "()I", "setI", "(I)V", "expect", "", "char", "", "throwParseError", "", "message", "matches", "", "takeIntUntil", "separator", "takeUntil", "takeUntilEnd", "skipUntil", "advance", "count", "current", "atEnd", "runtime"})
final class SourceInfoParserState {
    @NotNull
    private final String data;
    private int i;

    public SourceInfoParserState(@NotNull String data2) {
        this.data = data2;
    }

    @NotNull
    public final String getData() {
        return this.data;
    }

    public final int getI() {
        return this.i;
    }

    public final void setI(int n) {
        this.i = n;
    }

    public final void expect(char c) {
        if (!this.matches(c)) {
            this.throwParseError("expected " + c);
            throw new KotlinNothingValueException();
        }
    }

    @NotNull
    public final Void throwParseError(@NotNull String message) {
        int end = Math.min(this.i, this.data.length());
        String string2 = this.data.substring(0, end);
        Intrinsics.checkNotNullExpressionValue(string2, "substring(...)");
        String string3 = this.data.substring(end);
        Intrinsics.checkNotNullExpressionValue(string3, "substring(...)");
        throw new ParseException("Error while parsing source information: " + message + " at " + string2 + "|" + string3);
    }

    public final boolean matches(char c) {
        return this.i < this.data.length() && this.data.charAt(this.i) == c;
    }

    public final int takeIntUntil(@NotNull String separator) {
        Integer n;
        Integer n2 = n = StringsKt.toIntOrNull(this.takeUntil(separator));
        if (n2 == null) {
            this.throwParseError("expected int");
            throw new KotlinNothingValueException();
        }
        return n2;
    }

    @NotNull
    public final String takeUntil(@NotNull String separator) {
        String string2;
        int start2 = this.i;
        this.skipUntil(separator);
        if (this.i > start2) {
            String string3 = this.data.substring(start2, this.i);
            string2 = string3;
            Intrinsics.checkNotNullExpressionValue(string3, "substring(...)");
        } else {
            string2 = "";
        }
        return string2;
    }

    @NotNull
    public final String takeUntilEnd() {
        String string2 = this.data.substring(this.i, this.data.length());
        Intrinsics.checkNotNullExpressionValue(string2, "substring(...)");
        return string2;
    }

    public final void skipUntil(@NotNull String separator) {
        while (this.i < this.data.length() && !StringsKt.contains$default((CharSequence)separator, this.data.charAt(this.i), false, 2, null)) {
            int n = this.i;
            this.i = n + 1;
        }
    }

    public final void advance(int count2) {
        this.i += count2;
    }

    public static /* synthetic */ void advance$default(SourceInfoParserState sourceInfoParserState, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 1;
        }
        sourceInfoParserState.advance(n);
    }

    public final char current() {
        return this.data.charAt(this.i);
    }

    public final boolean atEnd() {
        return this.i >= this.data.length();
    }
}

