/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.libcache.db.dao;

import androidx.room.EntityInsertAdapter;
import androidx.room.RoomDatabase;
import androidx.room.coroutines.FlowUtil;
import androidx.room.util.DBUtil;
import androidx.room.util.SQLiteStatementUtil;
import androidx.room.util.StringUtil;
import androidx.sqlite.SQLiteConnection;
import androidx.sqlite.SQLiteStatement;
import com.ustadmobile.libcache.db.composites.NeighborCacheEntryAndNeighborCache;
import com.ustadmobile.libcache.db.dao.NeighborCacheEntryDao;
import com.ustadmobile.libcache.db.entities.NeighborCache;
import com.ustadmobile.libcache.db.entities.NeighborCacheEntry;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KClass;
import kotlinx.coroutines.flow.Flow;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001c\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\b0\fH\u0096@\u00a2\u0006\u0002\u0010\rJ\u0014\u0010\u000e\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\f0\u000fH\u0016J\"\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\f2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00110\fH\u0096@\u00a2\u0006\u0002\u0010\rJ\u001c\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\f2\u0006\u0010\u0015\u001a\u00020\u0011H\u0096@\u00a2\u0006\u0002\u0010\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/ustadmobile/libcache/db/dao/NeighborCacheEntryDao_Impl;", "Lcom/ustadmobile/libcache/db/dao/NeighborCacheEntryDao;", "__db", "Landroidx/room/RoomDatabase;", "<init>", "(Landroidx/room/RoomDatabase;)V", "__insertAdapterOfNeighborCacheEntry", "Landroidx/room/EntityInsertAdapter;", "Lcom/ustadmobile/libcache/db/entities/NeighborCacheEntry;", "upsertList", "", "neighborCacheEntryList", "", "(Ljava/util/List;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "allEntriesAsFlow", "Lkotlinx/coroutines/flow/Flow;", "findAvailableEntries", "", "urlHashes", "findAvailableNeighborsByUrlHash", "Lcom/ustadmobile/libcache/db/composites/NeighborCacheEntryAndNeighborCache;", "urlHash", "(JLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Companion", "respect-lib-cache_release"})
public final class NeighborCacheEntryDao_Impl
extends NeighborCacheEntryDao {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final RoomDatabase __db;
    @NotNull
    private final EntityInsertAdapter<NeighborCacheEntry> __insertAdapterOfNeighborCacheEntry;

    public NeighborCacheEntryDao_Impl(@NotNull RoomDatabase __db) {
        Intrinsics.checkNotNullParameter((Object)__db, (String)"__db");
        this.__db = __db;
        this.__insertAdapterOfNeighborCacheEntry = (EntityInsertAdapter)new EntityInsertAdapter<NeighborCacheEntry>(){

            protected String createQuery() {
                return "INSERT OR REPLACE INTO `NeighborCacheEntry` (`nceNeighborUid`,`nceUrlHash`) VALUES (?,?)";
            }

            protected void bind(SQLiteStatement statement, NeighborCacheEntry entity) {
                Intrinsics.checkNotNullParameter((Object)statement, (String)"statement");
                Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
                statement.bindLong(1, entity.getNceNeighborUid());
                statement.bindLong(2, entity.getNceUrlHash());
            }
        };
    }

    @Override
    @Nullable
    public Object upsertList(@NotNull List<NeighborCacheEntry> neighborCacheEntryList, @NotNull Continuation<? super Unit> $completion) {
        Object object = DBUtil.performSuspending((RoomDatabase)this.__db, (boolean)false, (boolean)true, arg_0 -> NeighborCacheEntryDao_Impl.upsertList$lambda$0(this, neighborCacheEntryList, arg_0), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @Override
    @NotNull
    public Flow<List<NeighborCacheEntry>> allEntriesAsFlow() {
        String _sql = "\n        SELECT NeighborCacheEntry.* \n          FROM NeighborCacheEntry\n    ";
        String[] stringArray = new String[]{"NeighborCacheEntry"};
        return FlowUtil.createFlow((RoomDatabase)this.__db, (boolean)false, (String[])stringArray, arg_0 -> NeighborCacheEntryDao_Impl.allEntriesAsFlow$lambda$0(_sql, arg_0));
    }

    @Override
    @Nullable
    public Object findAvailableEntries(@NotNull List<Long> urlHashes, @NotNull Continuation<? super List<Long>> $completion) {
        StringBuilder _stringBuilder = new StringBuilder();
        _stringBuilder.append("\n");
        _stringBuilder.append("        SELECT NeighborCacheEntry.nceUrlHash");
        _stringBuilder.append("\n");
        _stringBuilder.append("          FROM NeighborCacheEntry");
        _stringBuilder.append("\n");
        _stringBuilder.append("         WHERE NeighborCacheEntry.nceUrlHash IN (");
        int _inputSize = urlHashes.size();
        StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize);
        _stringBuilder.append(") ");
        _stringBuilder.append("\n");
        _stringBuilder.append("    ");
        String string = _stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String _sql = string;
        return DBUtil.performSuspending((RoomDatabase)this.__db, (boolean)true, (boolean)false, arg_0 -> NeighborCacheEntryDao_Impl.findAvailableEntries$lambda$0(_sql, urlHashes, arg_0), $completion);
    }

    @Override
    @Nullable
    public Object findAvailableNeighborsByUrlHash(long urlHash, @NotNull Continuation<? super List<NeighborCacheEntryAndNeighborCache>> $completion) {
        String _sql = "\n        SELECT NeighborCacheEntry.*,\n               NeighborCache.*\n          FROM NeighborCacheEntry\n               JOIN NeighborCache\n                    ON NeighborCache.neighborUid = NeighborCacheEntry.nceNeighborUid\n         WHERE NeighborCacheEntry.nceUrlHash = ?\n           AND NeighborCache.neighborStatus = 1\n    ";
        return DBUtil.performSuspending((RoomDatabase)this.__db, (boolean)true, (boolean)false, arg_0 -> NeighborCacheEntryDao_Impl.findAvailableNeighborsByUrlHash$lambda$0(_sql, urlHash, arg_0), $completion);
    }

    private static final Unit upsertList$lambda$0(NeighborCacheEntryDao_Impl this$0, List $neighborCacheEntryList, SQLiteConnection _connection) {
        Intrinsics.checkNotNullParameter((Object)_connection, (String)"_connection");
        this$0.__insertAdapterOfNeighborCacheEntry.insert(_connection, (Iterable)$neighborCacheEntryList);
        return Unit.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final List allEntriesAsFlow$lambda$0(String $_sql, SQLiteConnection _connection) {
        List list;
        Intrinsics.checkNotNullParameter((Object)_connection, (String)"_connection");
        try (SQLiteStatement _stmt = _connection.prepare($_sql);){
            int _columnIndexOfNceNeighborUid = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"nceNeighborUid");
            int _columnIndexOfNceUrlHash = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"nceUrlHash");
            List _result = new ArrayList();
            while (_stmt.step()) {
                NeighborCacheEntry _item = null;
                long _tmpNceNeighborUid = 0L;
                _tmpNceNeighborUid = _stmt.getLong(_columnIndexOfNceNeighborUid);
                long _tmpNceUrlHash = 0L;
                _tmpNceUrlHash = _stmt.getLong(_columnIndexOfNceUrlHash);
                _item = new NeighborCacheEntry(_tmpNceNeighborUid, _tmpNceUrlHash);
                _result.add(_item);
            }
            list = _result;
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final List findAvailableEntries$lambda$0(String $_sql, List $urlHashes, SQLiteConnection _connection) {
        List list;
        Intrinsics.checkNotNullParameter((Object)_connection, (String)"_connection");
        try (SQLiteStatement _stmt = _connection.prepare($_sql);){
            int _argIndex = 1;
            Iterator iterator = $urlHashes.iterator();
            while (iterator.hasNext()) {
                long _item = ((Number)iterator.next()).longValue();
                _stmt.bindLong(_argIndex, _item);
                ++_argIndex;
            }
            List _result = new ArrayList();
            while (_stmt.step()) {
                long _item_1 = 0L;
                _item_1 = _stmt.getLong(0);
                _result.add(_item_1);
            }
            list = _result;
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final List findAvailableNeighborsByUrlHash$lambda$0(String $_sql, long $urlHash, SQLiteConnection _connection) {
        List list;
        Intrinsics.checkNotNullParameter((Object)_connection, (String)"_connection");
        try (SQLiteStatement _stmt = _connection.prepare($_sql);){
            int _argIndex = 1;
            _stmt.bindLong(_argIndex, $urlHash);
            int _columnIndexOfNceNeighborUid = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"nceNeighborUid");
            int _columnIndexOfNceUrlHash = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"nceUrlHash");
            int _columnIndexOfNeighborUid = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"neighborUid");
            int _columnIndexOfNeighborDeviceName = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"neighborDeviceName");
            int _columnIndexOfNeighborIp = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"neighborIp");
            int _columnIndexOfNeighborUdpPort = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"neighborUdpPort");
            int _columnIndexOfNeighborHttpPort = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"neighborHttpPort");
            int _columnIndexOfNeighborDiscovered = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"neighborDiscovered");
            int _columnIndexOfNeighborPingTime = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"neighborPingTime");
            int _columnIndexOfNeighborLastSeen = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"neighborLastSeen");
            int _columnIndexOfNeighborStatus = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"neighborStatus");
            List _result = new ArrayList();
            while (_stmt.step()) {
                NeighborCacheEntryAndNeighborCache _item = null;
                NeighborCacheEntry _tmpNeighborCacheEntry = null;
                long _tmpNceNeighborUid = 0L;
                _tmpNceNeighborUid = _stmt.getLong(_columnIndexOfNceNeighborUid);
                long _tmpNceUrlHash = 0L;
                _tmpNceUrlHash = _stmt.getLong(_columnIndexOfNceUrlHash);
                _tmpNeighborCacheEntry = new NeighborCacheEntry(_tmpNceNeighborUid, _tmpNceUrlHash);
                NeighborCache _tmpNeighborCache = null;
                long _tmpNeighborUid = 0L;
                _tmpNeighborUid = _stmt.getLong(_columnIndexOfNeighborUid);
                String _tmpNeighborDeviceName = null;
                _tmpNeighborDeviceName = _stmt.getText(_columnIndexOfNeighborDeviceName);
                String _tmpNeighborIp = null;
                _tmpNeighborIp = _stmt.getText(_columnIndexOfNeighborIp);
                int _tmpNeighborUdpPort = 0;
                _tmpNeighborUdpPort = (int)_stmt.getLong(_columnIndexOfNeighborUdpPort);
                int _tmpNeighborHttpPort = 0;
                _tmpNeighborHttpPort = (int)_stmt.getLong(_columnIndexOfNeighborHttpPort);
                long _tmpNeighborDiscovered = 0L;
                _tmpNeighborDiscovered = _stmt.getLong(_columnIndexOfNeighborDiscovered);
                int _tmpNeighborPingTime = 0;
                _tmpNeighborPingTime = (int)_stmt.getLong(_columnIndexOfNeighborPingTime);
                long _tmpNeighborLastSeen = 0L;
                _tmpNeighborLastSeen = _stmt.getLong(_columnIndexOfNeighborLastSeen);
                int _tmpNeighborStatus = 0;
                _tmpNeighborStatus = (int)_stmt.getLong(_columnIndexOfNeighborStatus);
                _tmpNeighborCache = new NeighborCache(_tmpNeighborUid, _tmpNeighborDeviceName, _tmpNeighborIp, _tmpNeighborUdpPort, _tmpNeighborHttpPort, _tmpNeighborDiscovered, _tmpNeighborPingTime, _tmpNeighborLastSeen, _tmpNeighborStatus);
                _item = new NeighborCacheEntryAndNeighborCache(_tmpNeighborCache, _tmpNeighborCacheEntry);
                _result.add(_item);
            }
            list = _result;
        }
        return list;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00060\u0005\u00a8\u0006\u0007"}, d2={"Lcom/ustadmobile/libcache/db/dao/NeighborCacheEntryDao_Impl$Companion;", "", "<init>", "()V", "getRequiredConverters", "", "Lkotlin/reflect/KClass;", "respect-lib-cache_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final List<KClass<?>> getRequiredConverters() {
            return CollectionsKt.emptyList();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

