/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.foundation.text;

import androidx.compose.foundation.gestures.Orientation;
import androidx.compose.runtime.FloatState;
import androidx.compose.runtime.IntState;
import androidx.compose.runtime.MutableFloatState;
import androidx.compose.runtime.MutableIntState;
import androidx.compose.runtime.MutableState;
import androidx.compose.runtime.PrimitiveSnapshotStateKt;
import androidx.compose.runtime.SnapshotIntStateKt;
import androidx.compose.runtime.SnapshotStateKt;
import androidx.compose.runtime.Stable;
import androidx.compose.runtime.State;
import androidx.compose.runtime.saveable.ListSaverKt;
import androidx.compose.runtime.saveable.Saver;
import androidx.compose.runtime.saveable.SaverScope;
import androidx.compose.ui.geometry.Rect;
import androidx.compose.ui.text.TextRange;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u000f\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u0002\n\u0002\b\r\b\u0001\u0018\u0000 :2\u00020\u0001:\u0001:B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007B\t\b\u0016\u00a2\u0006\u0004\b\u0006\u0010\bJ&\u0010-\u001a\u00020.2\u0006\u0010&\u001a\u00020\u00032\u0006\u0010/\u001a\u00020\u001e2\u0006\u00100\u001a\u00020\u00152\u0006\u00101\u001a\u00020\u0015J%\u00102\u001a\u00020.2\u0006\u00103\u001a\u00020\u00052\u0006\u00104\u001a\u00020\u00052\u0006\u00100\u001a\u00020\u0015H\u0000\u00a2\u0006\u0002\b5J\u0015\u00106\u001a\u00020\u00152\u0006\u00107\u001a\u00020 \u00a2\u0006\u0004\b8\u00109R+\u0010\n\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u00058F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u000f\u0010\u0010\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR+\u0010\u0011\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u00058F@BX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u0014\u0010\u0010\u001a\u0004\b\u0012\u0010\f\"\u0004\b\u0013\u0010\u000eR+\u0010\u0016\u001a\u00020\u00152\u0006\u0010\t\u001a\u00020\u00158F@BX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u001b\u0010\u001c\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u001f\u001a\u00020 X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010%\u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$R+\u0010&\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\u00038F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b+\u0010,\u001a\u0004\b'\u0010(\"\u0004\b)\u0010*\u00a8\u0006;"}, d2={"Landroidx/compose/foundation/text/TextFieldScrollerPosition;", "", "initialOrientation", "Landroidx/compose/foundation/gestures/Orientation;", "initial", "", "<init>", "(Landroidx/compose/foundation/gestures/Orientation;F)V", "()V", "<set-?>", "offset", "getOffset", "()F", "setOffset", "(F)V", "offset$delegate", "Landroidx/compose/runtime/MutableFloatState;", "maximum", "getMaximum", "setMaximum", "maximum$delegate", "", "viewportSize", "getViewportSize", "()I", "setViewportSize", "(I)V", "viewportSize$delegate", "Landroidx/compose/runtime/MutableIntState;", "previousCursorRect", "Landroidx/compose/ui/geometry/Rect;", "previousSelection", "Landroidx/compose/ui/text/TextRange;", "getPreviousSelection-d9O1mEE", "()J", "setPreviousSelection-5zc-tL8", "(J)V", "J", "orientation", "getOrientation", "()Landroidx/compose/foundation/gestures/Orientation;", "setOrientation", "(Landroidx/compose/foundation/gestures/Orientation;)V", "orientation$delegate", "Landroidx/compose/runtime/MutableState;", "update", "", "cursorRect", "containerSize", "textFieldSize", "coerceOffset", "cursorStart", "cursorEnd", "coerceOffset$foundation", "getOffsetToFollow", "selection", "getOffsetToFollow-5zc-tL8", "(J)I", "Companion", "foundation"})
@Stable
@SourceDebugExtension(value={"SMAP\nTextFieldScroll.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TextFieldScroll.kt\nandroidx/compose/foundation/text/TextFieldScrollerPosition\n+ 2 SnapshotFloatState.kt\nandroidx/compose/runtime/PrimitiveSnapshotStateKt__SnapshotFloatStateKt\n+ 3 SnapshotIntState.kt\nandroidx/compose/runtime/SnapshotIntStateKt__SnapshotIntStateKt\n+ 4 SnapshotState.kt\nandroidx/compose/runtime/SnapshotStateKt__SnapshotStateKt\n*L\n1#1,400:1\n81#2:401\n114#2,2:402\n81#2:404\n114#2,2:405\n78#3:407\n111#3,2:408\n85#4:410\n117#4,2:411\n*S KotlinDebug\n*F\n+ 1 TextFieldScroll.kt\nandroidx/compose/foundation/text/TextFieldScrollerPosition\n*L\n281#1:401\n281#1:402,2\n287#1:404\n287#1:405,2\n291#1:407\n291#1:408,2\n306#1:410\n306#1:411,2\n*E\n"})
public final class TextFieldScrollerPosition {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final MutableFloatState offset$delegate;
    @NotNull
    private final MutableFloatState maximum$delegate;
    @NotNull
    private final MutableIntState viewportSize$delegate;
    @NotNull
    private Rect previousCursorRect;
    private long previousSelection;
    @NotNull
    private final MutableState orientation$delegate;
    public static final int $stable;
    @NotNull
    private static final Saver<TextFieldScrollerPosition, Object> Saver;

    public TextFieldScrollerPosition(@NotNull Orientation initialOrientation, float initial) {
        Intrinsics.checkNotNullParameter((Object)initialOrientation, "initialOrientation");
        this.offset$delegate = PrimitiveSnapshotStateKt.mutableFloatStateOf(initial);
        this.maximum$delegate = PrimitiveSnapshotStateKt.mutableFloatStateOf(0.0f);
        this.viewportSize$delegate = SnapshotIntStateKt.mutableIntStateOf(0);
        this.previousCursorRect = Rect.Companion.getZero();
        this.previousSelection = TextRange.Companion.getZero-d9O1mEE();
        this.orientation$delegate = SnapshotStateKt.mutableStateOf(initialOrientation, SnapshotStateKt.structuralEqualityPolicy());
    }

    public /* synthetic */ TextFieldScrollerPosition(Orientation orientation, float f, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            f = 0.0f;
        }
        this(orientation, f);
    }

    public TextFieldScrollerPosition() {
        this(Orientation.Vertical, 0.0f, 2, null);
    }

    /*
     * WARNING - void declaration
     */
    public final float getOffset() {
        void $this$getValue$iv;
        FloatState floatState = this.offset$delegate;
        Object property$iv = null;
        boolean $i$f$getValue = false;
        return $this$getValue$iv.getFloatValue();
    }

    /*
     * WARNING - void declaration
     */
    public final void setOffset(float f) {
        void $this$setValue$iv;
        MutableFloatState mutableFloatState = this.offset$delegate;
        Object property$iv = null;
        boolean $i$f$setValue = false;
        $this$setValue$iv.setFloatValue(f);
    }

    /*
     * WARNING - void declaration
     */
    public final float getMaximum() {
        void $this$getValue$iv;
        FloatState floatState = this.maximum$delegate;
        Object property$iv = null;
        boolean $i$f$getValue = false;
        return $this$getValue$iv.getFloatValue();
    }

    /*
     * WARNING - void declaration
     */
    private final void setMaximum(float f) {
        void $this$setValue$iv;
        MutableFloatState mutableFloatState = this.maximum$delegate;
        Object property$iv = null;
        boolean $i$f$setValue = false;
        $this$setValue$iv.setFloatValue(f);
    }

    /*
     * WARNING - void declaration
     */
    public final int getViewportSize() {
        void $this$getValue$iv;
        IntState intState = this.viewportSize$delegate;
        Object property$iv = null;
        boolean $i$f$getValue = false;
        return $this$getValue$iv.getIntValue();
    }

    /*
     * WARNING - void declaration
     */
    private final void setViewportSize(int n) {
        void $this$setValue$iv;
        MutableIntState mutableIntState = this.viewportSize$delegate;
        Object property$iv = null;
        boolean $i$f$setValue = false;
        $this$setValue$iv.setIntValue(n);
    }

    public final long getPreviousSelection-d9O1mEE() {
        return this.previousSelection;
    }

    public final void setPreviousSelection-5zc-tL8(long l) {
        this.previousSelection = l;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Orientation getOrientation() {
        void $this$getValue$iv;
        State state2 = this.orientation$delegate;
        Object property$iv = null;
        boolean $i$f$getValue = false;
        return (Orientation)((Object)$this$getValue$iv.getValue());
    }

    /*
     * WARNING - void declaration
     */
    public final void setOrientation(@NotNull Orientation orientation) {
        void $this$setValue$iv;
        Intrinsics.checkNotNullParameter((Object)orientation, "<set-?>");
        MutableState mutableState = this.orientation$delegate;
        Object property$iv = null;
        boolean $i$f$setValue = false;
        $this$setValue$iv.setValue(orientation);
    }

    public final void update(@NotNull Orientation orientation, @NotNull Rect cursorRect, int containerSize2, int textFieldSize) {
        Intrinsics.checkNotNullParameter((Object)orientation, "orientation");
        Intrinsics.checkNotNullParameter(cursorRect, "cursorRect");
        float difference = textFieldSize - containerSize2;
        this.setMaximum(difference);
        if (!(cursorRect.getLeft() == this.previousCursorRect.getLeft()) || !(cursorRect.getTop() == this.previousCursorRect.getTop())) {
            boolean vertical = orientation == Orientation.Vertical;
            float cursorStart = vertical ? cursorRect.getTop() : cursorRect.getLeft();
            float cursorEnd = vertical ? cursorRect.getBottom() : cursorRect.getRight();
            this.coerceOffset$foundation(cursorStart, cursorEnd, containerSize2);
            this.previousCursorRect = cursorRect;
        }
        this.setOffset(RangesKt.coerceIn(this.getOffset(), 0.0f, difference));
        this.setViewportSize(containerSize2);
    }

    public final void coerceOffset$foundation(float cursorStart, float cursorEnd, int containerSize2) {
        float startVisibleBound = this.getOffset();
        float endVisibleBound = startVisibleBound + (float)containerSize2;
        float offsetDifference = cursorEnd > endVisibleBound ? cursorEnd - endVisibleBound : (cursorStart < startVisibleBound && cursorEnd - cursorStart > (float)containerSize2 ? cursorEnd - endVisibleBound : (cursorStart < startVisibleBound && cursorEnd - cursorStart <= (float)containerSize2 ? cursorStart - startVisibleBound : 0.0f));
        this.setOffset(this.getOffset() + offsetDifference);
    }

    public final int getOffsetToFollow-5zc-tL8(long selection) {
        return TextRange.getStart-impl(selection) != TextRange.getStart-impl(this.previousSelection) ? TextRange.getStart-impl(selection) : (TextRange.getEnd-impl(selection) != TextRange.getEnd-impl(this.previousSelection) ? TextRange.getEnd-impl(selection) : TextRange.getMin-impl(selection));
    }

    private static final List Saver$lambda$0(SaverScope $this$listSaver, TextFieldScrollerPosition it) {
        Intrinsics.checkNotNullParameter($this$listSaver, "$this$listSaver");
        Intrinsics.checkNotNullParameter(it, "it");
        Object[] objectArray = new Object[]{Float.valueOf(it.getOffset()), it.getOrientation() == Orientation.Vertical};
        return CollectionsKt.listOf(objectArray);
    }

    private static final TextFieldScrollerPosition Saver$lambda$1(List restored) {
        Intrinsics.checkNotNullParameter(restored, "restored");
        Object e = restored.get(1);
        Intrinsics.checkNotNull(e, "null cannot be cast to non-null type kotlin.Boolean");
        Orientation orientation = (Boolean)e != false ? Orientation.Vertical : Orientation.Horizontal;
        Object e2 = restored.get(0);
        Intrinsics.checkNotNull(e2, "null cannot be cast to non-null type kotlin.Float");
        return new TextFieldScrollerPosition(orientation, ((Float)e2).floatValue());
    }

    static {
        Saver = ListSaverKt.listSaver(TextFieldScrollerPosition::Saver$lambda$0, TextFieldScrollerPosition::Saver$lambda$1);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001d\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Landroidx/compose/foundation/text/TextFieldScrollerPosition$Companion;", "", "<init>", "()V", "Saver", "Landroidx/compose/runtime/saveable/Saver;", "Landroidx/compose/foundation/text/TextFieldScrollerPosition;", "getSaver", "()Landroidx/compose/runtime/saveable/Saver;", "foundation"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Saver<TextFieldScrollerPosition, Object> getSaver() {
            return Saver;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

