/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.html.dom;

import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.html.Entities;
import kotlinx.html.Tag;
import kotlinx.html.TagConsumer;
import kotlinx.html.Unsafe;
import kotlinx.html.dom.HTMLDOMBuilder;
import kotlinx.html.org.w3c.dom.events.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000m\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\r\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0004*\u0001-\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\"\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u0019H\u0016J,\u0010\u001b\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u001c\u001a\u00020\u00192\u0012\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020\u00140\u001dH\u0016J\u0010\u0010\u001f\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010 \u001a\u00020\u00142\u0006\u0010!\u001a\u00020\"H\u0016J\u0010\u0010#\u001a\u00020\u00142\u0006\u0010!\u001a\u00020\"H\u0016J\u0010\u0010$\u001a\u00020\u00142\u0006\u0010%\u001a\u00020&H\u0016J\b\u0010'\u001a\u00020\u0002H\u0016J!\u0010(\u001a\u00020\u00142\u0017\u0010)\u001a\u0013\u0012\u0004\u0012\u00020*\u0012\u0004\u0012\u00020\u00140\u001d\u00a2\u0006\u0002\b+H\u0016J\f\u0010/\u001a\u00020\u0014*\u00020\u0002H\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001e\u0010\t\u001a\u0012\u0012\u0004\u0012\u00020\u00020\nj\b\u0012\u0004\u0012\u00020\u0002`\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\u0002X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001b\u0010\r\u001a\u00020\u000e8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0011\u0010\u0012\u001a\u0004\b\u000f\u0010\u0010R\u0010\u0010,\u001a\u00020-X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010.\u00a8\u00060"}, d2={"Lkotlinx/html/dom/HTMLDOMBuilder;", "Lkotlinx/html/TagConsumer;", "Lorg/w3c/dom/Element;", "document", "Lorg/w3c/dom/Document;", "<init>", "(Lorg/w3c/dom/Document;)V", "getDocument", "()Lorg/w3c/dom/Document;", "path", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "lastLeaved", "documentBuilder", "Ljavax/xml/parsers/DocumentBuilder;", "getDocumentBuilder", "()Ljavax/xml/parsers/DocumentBuilder;", "documentBuilder$delegate", "Lkotlin/Lazy;", "onTagStart", "", "tag", "Lkotlinx/html/Tag;", "onTagAttributeChange", "attribute", "", "value", "onTagEvent", "event", "Lkotlin/Function1;", "Lkotlinx/html/org/w3c/dom/events/Event;", "onTagEnd", "onTagContent", "content", "", "onTagComment", "onTagContentEntity", "entity", "Lkotlinx/html/Entities;", "finalize", "onTagContentUnsafe", "block", "Lkotlinx/html/Unsafe;", "Lkotlin/ExtensionFunctionType;", "UnsafeImpl", "kotlinx/html/dom/HTMLDOMBuilder$UnsafeImpl$1", "Lkotlinx/html/dom/HTMLDOMBuilder$UnsafeImpl$1;", "setIdAttributeName", "kotlinx-html"})
@SourceDebugExtension(value={"SMAP\ndom-jvm.kt\nKotlin\n*S Kotlin\n*F\n+ 1 dom-jvm.kt\nkotlinx/html/dom/HTMLDOMBuilder\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,207:1\n1863#2,2:208\n*S KotlinDebug\n*F\n+ 1 dom-jvm.kt\nkotlinx/html/dom/HTMLDOMBuilder\n*L\n38#1:208,2\n*E\n"})
public final class HTMLDOMBuilder
implements TagConsumer<Element> {
    @NotNull
    private final Document document;
    @NotNull
    private final ArrayList<Element> path;
    @Nullable
    private Element lastLeaved;
    @NotNull
    private final Lazy documentBuilder$delegate;
    @NotNull
    private final UnsafeImpl.1 UnsafeImpl;

    public HTMLDOMBuilder(@NotNull Document document) {
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        this.document = document;
        this.path = new ArrayList();
        this.documentBuilder$delegate = LazyKt.lazy(HTMLDOMBuilder::documentBuilder_delegate$lambda$0);
        this.UnsafeImpl = new Unsafe(this){
            final /* synthetic */ HTMLDOMBuilder this$0;
            {
                this.this$0 = $receiver;
            }

            public void unaryPlus(String $this$unaryPlus) {
                Intrinsics.checkNotNullParameter((Object)$this$unaryPlus, (String)"<this>");
                Element element = HTMLDOMBuilder.access$getDocumentBuilder(this.this$0).parse(new InputSource(new StringReader("<unsafeRoot>" + $this$unaryPlus + "</unsafeRoot>"))).getDocumentElement();
                Node importNode = this.this$0.getDocument().importNode(element, true);
                if (!Intrinsics.areEqual((Object)importNode.getNodeName(), (Object)"unsafeRoot")) {
                    boolean bl = false;
                    String string = "the document factory hasn't created an unsafeRoot node";
                    throw new IllegalStateException(string.toString());
                }
                Element last = (Element)CollectionsKt.last((List)HTMLDOMBuilder.access$getPath$p(this.this$0));
                while (importNode.hasChildNodes()) {
                    last.appendChild(importNode.removeChild(importNode.getFirstChild()));
                }
            }

            public void unaryPlus(Entities $this$unaryPlus) {
                Unsafe.DefaultImpls.unaryPlus(this, $this$unaryPlus);
            }

            public void raw(String s2) {
                Unsafe.DefaultImpls.raw((Unsafe)this, s2);
            }

            public void raw(Entities entity) {
                Unsafe.DefaultImpls.raw((Unsafe)this, entity);
            }

            public void raw(Number n) {
                Unsafe.DefaultImpls.raw((Unsafe)this, n);
            }
        };
    }

    @NotNull
    public final Document getDocument() {
        return this.document;
    }

    private final DocumentBuilder getDocumentBuilder() {
        Lazy lazy = this.documentBuilder$delegate;
        Object object = lazy.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getValue(...)");
        return (DocumentBuilder)object;
    }

    @Override
    public void onTagStart(@NotNull Tag tag) {
        Element element;
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        if (tag.getNamespace() != null) {
            String string = tag.getNamespace();
            Intrinsics.checkNotNull((Object)string);
            element = this.document.createElementNS(string, tag.getTagName());
        } else {
            element = this.document.createElement(tag.getTagName());
        }
        Element element2 = element;
        Iterable $this$forEach$iv = tag.getAttributesEntries();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Map.Entry it = (Map.Entry)element$iv;
            boolean bl = false;
            element2.setAttribute((String)it.getKey(), (String)it.getValue());
        }
        if (!((Collection)this.path).isEmpty()) {
            ((Element)CollectionsKt.last((List)this.path)).appendChild(element2);
        }
        this.path.add(element2);
    }

    @Override
    public void onTagAttributeChange(@NotNull Tag tag, @NotNull String attribute, @Nullable String value) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)attribute, (String)"attribute");
        if (this.path.isEmpty()) {
            throw new IllegalStateException("No current tag");
        }
        Element node = (Element)CollectionsKt.last((List)this.path);
        boolean bl = false;
        if (value == null) {
            node.removeAttribute(attribute);
        } else {
            node.setAttribute(attribute, value);
        }
    }

    @Override
    public void onTagEvent(@NotNull Tag tag, @NotNull String event, @NotNull Function1<? super Event, Unit> value) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Intrinsics.checkNotNullParameter(value, (String)"value");
        throw new UnsupportedOperationException("You can't assign lambda event handler on JVM");
    }

    @Override
    public void onTagEnd(@NotNull Tag tag) {
        block3: {
            block2: {
                Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
                if (this.path.isEmpty()) break block2;
                String string = ((Element)CollectionsKt.last((List)this.path)).getTagName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getTagName(...)");
                String string2 = string.toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
                String string3 = tag.getTagName().toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
                if (Intrinsics.areEqual((Object)string2, (Object)string3)) break block3;
            }
            throw new IllegalStateException("We haven't entered tag " + tag.getTagName() + " but trying to leave");
        }
        Element element = this.path.remove(CollectionsKt.getLastIndex((List)this.path));
        Intrinsics.checkNotNullExpressionValue((Object)element, (String)"removeAt(...)");
        Element element2 = element;
        this.setIdAttributeName(element2);
        this.lastLeaved = element2;
    }

    @Override
    public void onTagContent(@NotNull CharSequence content) {
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        if (this.path.isEmpty()) {
            throw new IllegalStateException("No current DOM node");
        }
        ((Element)CollectionsKt.last((List)this.path)).appendChild(this.document.createTextNode(((Object)content).toString()));
    }

    @Override
    public void onTagComment(@NotNull CharSequence content) {
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        if (this.path.isEmpty()) {
            throw new IllegalStateException("No current DOM node");
        }
        ((Element)CollectionsKt.last((List)this.path)).appendChild(this.document.createComment(((Object)content).toString()));
    }

    @Override
    public void onTagContentEntity(@NotNull Entities entity) {
        Intrinsics.checkNotNullParameter((Object)((Object)entity), (String)"entity");
        if (this.path.isEmpty()) {
            throw new IllegalStateException("No current DOM node");
        }
        ((Element)CollectionsKt.last((List)this.path)).appendChild(this.document.createEntityReference(entity.name()));
    }

    @Override
    @NotNull
    public Element finalize() {
        Element element = this.lastLeaved;
        if (element == null) {
            throw new IllegalStateException("No tags were emitted");
        }
        return element;
    }

    @Override
    public void onTagContentUnsafe(@NotNull Function1<? super Unsafe, Unit> block) {
        Intrinsics.checkNotNullParameter(block, (String)"block");
        block.invoke((Object)this.UnsafeImpl);
    }

    private final void setIdAttributeName(Element $this$setIdAttributeName) {
        if ($this$setIdAttributeName.hasAttribute("id")) {
            $this$setIdAttributeName.setIdAttribute("id", true);
        }
    }

    private static final DocumentBuilder documentBuilder_delegate$lambda$0() {
        return DocumentBuilderFactory.newInstance().newDocumentBuilder();
    }

    public static final /* synthetic */ DocumentBuilder access$getDocumentBuilder(HTMLDOMBuilder $this) {
        return $this.getDocumentBuilder();
    }

    public static final /* synthetic */ ArrayList access$getPath$p(HTMLDOMBuilder $this) {
        return $this.path;
    }
}

