package world.respect.datalayer.db.school.daos

import androidx.paging.PagingSource
import androidx.room.EntityInsertAdapter
import androidx.room.RoomDatabase
import androidx.room.RoomRawQuery
import androidx.room.coroutines.createFlow
import androidx.room.paging.LimitOffsetPagingSource
import androidx.room.util.appendPlaceholders
import androidx.room.util.getColumnIndexOrThrow
import androidx.room.util.performSuspending
import androidx.sqlite.SQLiteStatement
import io.ktor.http.Url
import javax.`annotation`.processing.Generated
import kotlin.Boolean
import kotlin.Int
import kotlin.Long
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.MutableList
import kotlin.collections.mutableListOf
import kotlin.reflect.KClass
import kotlin.text.StringBuilder
import kotlin.time.Instant
import kotlinx.coroutines.flow.Flow
import world.respect.datalayer.db.school.SchoolTypeConverters
import world.respect.datalayer.db.school.entities.SchoolAppEntity
import world.respect.datalayer.db.shared.SharedConverters
import world.respect.datalayer.school.model.StatusEnum

@Generated(value = ["androidx.room.RoomProcessor"])
@Suppress(names = ["UNCHECKED_CAST", "DEPRECATION", "REDUNDANT_PROJECTION", "REMOVAL"])
public class SchoolAppEntityDao_Impl(
  __db: RoomDatabase,
) : SchoolAppEntityDao {
  private val __db: RoomDatabase

  private val __insertAdapterOfSchoolAppEntity: EntityInsertAdapter<SchoolAppEntity>

  private val __sharedConverters: SharedConverters = SharedConverters()

  private val __schoolTypeConverters: SchoolTypeConverters = SchoolTypeConverters()
  init {
    this.__db = __db
    this.__insertAdapterOfSchoolAppEntity = object : EntityInsertAdapter<SchoolAppEntity>() {
      protected override fun createQuery(): String = "INSERT OR REPLACE INTO `SchoolAppEntity` (`saUid`,`saUidNum`,`saManifestUrl`,`saStatus`,`saLastModified`,`saStored`) VALUES (?,?,?,?,?,?)"

      protected override fun bind(statement: SQLiteStatement, entity: SchoolAppEntity) {
        statement.bindText(1, entity.saUid)
        statement.bindLong(2, entity.saUidNum)
        val _tmp: String? = __sharedConverters.fromUrl(entity.saManifestUrl)
        if (_tmp == null) {
          statement.bindNull(3)
        } else {
          statement.bindText(3, _tmp)
        }
        val _tmp_1: Int = __schoolTypeConverters.fromStatusEnum(entity.saStatus)
        statement.bindLong(4, _tmp_1.toLong())
        val _tmp_2: Long? = __sharedConverters.fromInstant(entity.saLastModified)
        if (_tmp_2 == null) {
          statement.bindNull(5)
        } else {
          statement.bindLong(5, _tmp_2)
        }
        val _tmp_3: Long? = __sharedConverters.fromInstant(entity.saStored)
        if (_tmp_3 == null) {
          statement.bindNull(6)
        } else {
          statement.bindLong(6, _tmp_3)
        }
      }
    }
  }

  public override suspend fun upsert(list: List<SchoolAppEntity>): Unit = performSuspending(__db, false, true) { _connection ->
    __insertAdapterOfSchoolAppEntity.insert(_connection, list)
  }

  public override suspend fun getLastModifiedByUidNum(uidNum: Long): Long? {
    val _sql: String = """
        |
        |        SELECT SchoolAppEntity.saLastModified
        |          FROM SchoolAppEntity
        |         WHERE SchoolAppEntity.saUidNum = ?
        |    
        """.trimMargin()
    return performSuspending(__db, true, false) { _connection ->
      val _stmt: SQLiteStatement = _connection.prepare(_sql)
      try {
        var _argIndex: Int = 1
        _stmt.bindLong(_argIndex, uidNum)
        val _result: Long?
        if (_stmt.step()) {
          if (_stmt.isNull(0)) {
            _result = null
          } else {
            _result = _stmt.getLong(0)
          }
        } else {
          _result = null
        }
        _result
      } finally {
        _stmt.close()
      }
    }
  }

  public override suspend fun findByUidNumList(uidNumList: List<Long>): List<SchoolAppEntity> {
    val _stringBuilder: StringBuilder = StringBuilder()
    _stringBuilder.append("""
        |
        |""".trimMargin())
    _stringBuilder.append("        SELECT SchoolAppEntity.*")
    _stringBuilder.append("""
        |
        |""".trimMargin())
    _stringBuilder.append("          FROM SchoolAppEntity")
    _stringBuilder.append("""
        |
        |""".trimMargin())
    _stringBuilder.append("         WHERE SchoolAppEntity.saUidNum IN (")
    val _inputSize: Int = uidNumList.size
    appendPlaceholders(_stringBuilder, _inputSize)
    _stringBuilder.append(")")
    _stringBuilder.append("""
        |
        |""".trimMargin())
    _stringBuilder.append("    ")
    val _sql: String = _stringBuilder.toString()
    return performSuspending(__db, true, false) { _connection ->
      val _stmt: SQLiteStatement = _connection.prepare(_sql)
      try {
        var _argIndex: Int = 1
        for (_item: Long in uidNumList) {
          _stmt.bindLong(_argIndex, _item)
          _argIndex++
        }
        val _columnIndexOfSaUid: Int = getColumnIndexOrThrow(_stmt, "saUid")
        val _columnIndexOfSaUidNum: Int = getColumnIndexOrThrow(_stmt, "saUidNum")
        val _columnIndexOfSaManifestUrl: Int = getColumnIndexOrThrow(_stmt, "saManifestUrl")
        val _columnIndexOfSaStatus: Int = getColumnIndexOrThrow(_stmt, "saStatus")
        val _columnIndexOfSaLastModified: Int = getColumnIndexOrThrow(_stmt, "saLastModified")
        val _columnIndexOfSaStored: Int = getColumnIndexOrThrow(_stmt, "saStored")
        val _result: MutableList<SchoolAppEntity> = mutableListOf()
        while (_stmt.step()) {
          val _item_1: SchoolAppEntity
          val _tmpSaUid: String
          _tmpSaUid = _stmt.getText(_columnIndexOfSaUid)
          val _tmpSaUidNum: Long
          _tmpSaUidNum = _stmt.getLong(_columnIndexOfSaUidNum)
          val _tmpSaManifestUrl: Url
          val _tmp: String?
          if (_stmt.isNull(_columnIndexOfSaManifestUrl)) {
            _tmp = null
          } else {
            _tmp = _stmt.getText(_columnIndexOfSaManifestUrl)
          }
          val _tmp_1: Url? = __sharedConverters.toUrl(_tmp)
          if (_tmp_1 == null) {
            error("Expected NON-NULL 'io.ktor.http.Url', but it was NULL.")
          } else {
            _tmpSaManifestUrl = _tmp_1
          }
          val _tmpSaStatus: StatusEnum
          val _tmp_2: Int
          _tmp_2 = _stmt.getLong(_columnIndexOfSaStatus).toInt()
          _tmpSaStatus = __schoolTypeConverters.toStatusEnum(_tmp_2)
          val _tmpSaLastModified: Instant
          val _tmp_3: Long?
          if (_stmt.isNull(_columnIndexOfSaLastModified)) {
            _tmp_3 = null
          } else {
            _tmp_3 = _stmt.getLong(_columnIndexOfSaLastModified)
          }
          val _tmp_4: Instant? = __sharedConverters.toInstant(_tmp_3)
          if (_tmp_4 == null) {
            error("Expected NON-NULL 'kotlin.time.Instant', but it was NULL.")
          } else {
            _tmpSaLastModified = _tmp_4
          }
          val _tmpSaStored: Instant
          val _tmp_5: Long?
          if (_stmt.isNull(_columnIndexOfSaStored)) {
            _tmp_5 = null
          } else {
            _tmp_5 = _stmt.getLong(_columnIndexOfSaStored)
          }
          val _tmp_6: Instant? = __sharedConverters.toInstant(_tmp_5)
          if (_tmp_6 == null) {
            error("Expected NON-NULL 'kotlin.time.Instant', but it was NULL.")
          } else {
            _tmpSaStored = _tmp_6
          }
          _item_1 = SchoolAppEntity(_tmpSaUid,_tmpSaUidNum,_tmpSaManifestUrl,_tmpSaStatus,_tmpSaLastModified,_tmpSaStored)
          _result.add(_item_1)
        }
        _result
      } finally {
        _stmt.close()
      }
    }
  }

  public override suspend fun list(includeDeleted: Boolean): List<SchoolAppEntity> {
    val _sql: String = """
        |
        |        SELECT SchoolAppEntity.*
        |          FROM SchoolAppEntity 
        |         WHERE (? OR SchoolAppEntity.saStatus = 1) 
        |    
        """.trimMargin()
    return performSuspending(__db, true, false) { _connection ->
      val _stmt: SQLiteStatement = _connection.prepare(_sql)
      try {
        var _argIndex: Int = 1
        val _tmp: Int = if (includeDeleted) 1 else 0
        _stmt.bindLong(_argIndex, _tmp.toLong())
        val _columnIndexOfSaUid: Int = getColumnIndexOrThrow(_stmt, "saUid")
        val _columnIndexOfSaUidNum: Int = getColumnIndexOrThrow(_stmt, "saUidNum")
        val _columnIndexOfSaManifestUrl: Int = getColumnIndexOrThrow(_stmt, "saManifestUrl")
        val _columnIndexOfSaStatus: Int = getColumnIndexOrThrow(_stmt, "saStatus")
        val _columnIndexOfSaLastModified: Int = getColumnIndexOrThrow(_stmt, "saLastModified")
        val _columnIndexOfSaStored: Int = getColumnIndexOrThrow(_stmt, "saStored")
        val _result: MutableList<SchoolAppEntity> = mutableListOf()
        while (_stmt.step()) {
          val _item: SchoolAppEntity
          val _tmpSaUid: String
          _tmpSaUid = _stmt.getText(_columnIndexOfSaUid)
          val _tmpSaUidNum: Long
          _tmpSaUidNum = _stmt.getLong(_columnIndexOfSaUidNum)
          val _tmpSaManifestUrl: Url
          val _tmp_1: String?
          if (_stmt.isNull(_columnIndexOfSaManifestUrl)) {
            _tmp_1 = null
          } else {
            _tmp_1 = _stmt.getText(_columnIndexOfSaManifestUrl)
          }
          val _tmp_2: Url? = __sharedConverters.toUrl(_tmp_1)
          if (_tmp_2 == null) {
            error("Expected NON-NULL 'io.ktor.http.Url', but it was NULL.")
          } else {
            _tmpSaManifestUrl = _tmp_2
          }
          val _tmpSaStatus: StatusEnum
          val _tmp_3: Int
          _tmp_3 = _stmt.getLong(_columnIndexOfSaStatus).toInt()
          _tmpSaStatus = __schoolTypeConverters.toStatusEnum(_tmp_3)
          val _tmpSaLastModified: Instant
          val _tmp_4: Long?
          if (_stmt.isNull(_columnIndexOfSaLastModified)) {
            _tmp_4 = null
          } else {
            _tmp_4 = _stmt.getLong(_columnIndexOfSaLastModified)
          }
          val _tmp_5: Instant? = __sharedConverters.toInstant(_tmp_4)
          if (_tmp_5 == null) {
            error("Expected NON-NULL 'kotlin.time.Instant', but it was NULL.")
          } else {
            _tmpSaLastModified = _tmp_5
          }
          val _tmpSaStored: Instant
          val _tmp_6: Long?
          if (_stmt.isNull(_columnIndexOfSaStored)) {
            _tmp_6 = null
          } else {
            _tmp_6 = _stmt.getLong(_columnIndexOfSaStored)
          }
          val _tmp_7: Instant? = __sharedConverters.toInstant(_tmp_6)
          if (_tmp_7 == null) {
            error("Expected NON-NULL 'kotlin.time.Instant', but it was NULL.")
          } else {
            _tmpSaStored = _tmp_7
          }
          _item = SchoolAppEntity(_tmpSaUid,_tmpSaUidNum,_tmpSaManifestUrl,_tmpSaStatus,_tmpSaLastModified,_tmpSaStored)
          _result.add(_item)
        }
        _result
      } finally {
        _stmt.close()
      }
    }
  }

  public override fun listAsPagingSource(includeDeleted: Boolean): PagingSource<Int, SchoolAppEntity> {
    val _sql: String = """
        |
        |        SELECT SchoolAppEntity.*
        |          FROM SchoolAppEntity 
        |         WHERE (? OR SchoolAppEntity.saStatus = 1)  
        |    
        """.trimMargin()
    val _rawQuery: RoomRawQuery = RoomRawQuery(_sql) { _stmt ->
      var _argIndex: Int = 1
      val _tmp: Int = if (includeDeleted) 1 else 0
      _stmt.bindLong(_argIndex, _tmp.toLong())
    }
    return object : LimitOffsetPagingSource<SchoolAppEntity>(_rawQuery, __db, "SchoolAppEntity") {
      protected override suspend fun convertRows(limitOffsetQuery: RoomRawQuery, itemCount: Int): List<SchoolAppEntity> = performSuspending(__db, true, false) { _connection ->
        val _stmt: SQLiteStatement = _connection.prepare(limitOffsetQuery.sql)
        limitOffsetQuery.getBindingFunction().invoke(_stmt)
        try {
          val _columnIndexOfSaUid: Int = getColumnIndexOrThrow(_stmt, "saUid")
          val _columnIndexOfSaUidNum: Int = getColumnIndexOrThrow(_stmt, "saUidNum")
          val _columnIndexOfSaManifestUrl: Int = getColumnIndexOrThrow(_stmt, "saManifestUrl")
          val _columnIndexOfSaStatus: Int = getColumnIndexOrThrow(_stmt, "saStatus")
          val _columnIndexOfSaLastModified: Int = getColumnIndexOrThrow(_stmt, "saLastModified")
          val _columnIndexOfSaStored: Int = getColumnIndexOrThrow(_stmt, "saStored")
          val _result: MutableList<SchoolAppEntity> = mutableListOf()
          while (_stmt.step()) {
            val _item: SchoolAppEntity
            val _tmpSaUid: String
            _tmpSaUid = _stmt.getText(_columnIndexOfSaUid)
            val _tmpSaUidNum: Long
            _tmpSaUidNum = _stmt.getLong(_columnIndexOfSaUidNum)
            val _tmpSaManifestUrl: Url
            val _tmp_1: String?
            if (_stmt.isNull(_columnIndexOfSaManifestUrl)) {
              _tmp_1 = null
            } else {
              _tmp_1 = _stmt.getText(_columnIndexOfSaManifestUrl)
            }
            val _tmp_2: Url? = __sharedConverters.toUrl(_tmp_1)
            if (_tmp_2 == null) {
              error("Expected NON-NULL 'io.ktor.http.Url', but it was NULL.")
            } else {
              _tmpSaManifestUrl = _tmp_2
            }
            val _tmpSaStatus: StatusEnum
            val _tmp_3: Int
            _tmp_3 = _stmt.getLong(_columnIndexOfSaStatus).toInt()
            _tmpSaStatus = __schoolTypeConverters.toStatusEnum(_tmp_3)
            val _tmpSaLastModified: Instant
            val _tmp_4: Long?
            if (_stmt.isNull(_columnIndexOfSaLastModified)) {
              _tmp_4 = null
            } else {
              _tmp_4 = _stmt.getLong(_columnIndexOfSaLastModified)
            }
            val _tmp_5: Instant? = __sharedConverters.toInstant(_tmp_4)
            if (_tmp_5 == null) {
              error("Expected NON-NULL 'kotlin.time.Instant', but it was NULL.")
            } else {
              _tmpSaLastModified = _tmp_5
            }
            val _tmpSaStored: Instant
            val _tmp_6: Long?
            if (_stmt.isNull(_columnIndexOfSaStored)) {
              _tmp_6 = null
            } else {
              _tmp_6 = _stmt.getLong(_columnIndexOfSaStored)
            }
            val _tmp_7: Instant? = __sharedConverters.toInstant(_tmp_6)
            if (_tmp_7 == null) {
              error("Expected NON-NULL 'kotlin.time.Instant', but it was NULL.")
            } else {
              _tmpSaStored = _tmp_7
            }
            _item = SchoolAppEntity(_tmpSaUid,_tmpSaUidNum,_tmpSaManifestUrl,_tmpSaStatus,_tmpSaLastModified,_tmpSaStored)
            _result.add(_item)
          }
          _result
        } finally {
          _stmt.close()
        }
      }
    }
  }

  public override fun listAsFlow(includeDeleted: Boolean): Flow<List<SchoolAppEntity>> {
    val _sql: String = """
        |
        |        SELECT SchoolAppEntity.*
        |          FROM SchoolAppEntity 
        |         WHERE (? OR SchoolAppEntity.saStatus = 1)  
        |    
        """.trimMargin()
    return createFlow(__db, false, arrayOf("SchoolAppEntity")) { _connection ->
      val _stmt: SQLiteStatement = _connection.prepare(_sql)
      try {
        var _argIndex: Int = 1
        val _tmp: Int = if (includeDeleted) 1 else 0
        _stmt.bindLong(_argIndex, _tmp.toLong())
        val _columnIndexOfSaUid: Int = getColumnIndexOrThrow(_stmt, "saUid")
        val _columnIndexOfSaUidNum: Int = getColumnIndexOrThrow(_stmt, "saUidNum")
        val _columnIndexOfSaManifestUrl: Int = getColumnIndexOrThrow(_stmt, "saManifestUrl")
        val _columnIndexOfSaStatus: Int = getColumnIndexOrThrow(_stmt, "saStatus")
        val _columnIndexOfSaLastModified: Int = getColumnIndexOrThrow(_stmt, "saLastModified")
        val _columnIndexOfSaStored: Int = getColumnIndexOrThrow(_stmt, "saStored")
        val _result: MutableList<SchoolAppEntity> = mutableListOf()
        while (_stmt.step()) {
          val _item: SchoolAppEntity
          val _tmpSaUid: String
          _tmpSaUid = _stmt.getText(_columnIndexOfSaUid)
          val _tmpSaUidNum: Long
          _tmpSaUidNum = _stmt.getLong(_columnIndexOfSaUidNum)
          val _tmpSaManifestUrl: Url
          val _tmp_1: String?
          if (_stmt.isNull(_columnIndexOfSaManifestUrl)) {
            _tmp_1 = null
          } else {
            _tmp_1 = _stmt.getText(_columnIndexOfSaManifestUrl)
          }
          val _tmp_2: Url? = __sharedConverters.toUrl(_tmp_1)
          if (_tmp_2 == null) {
            error("Expected NON-NULL 'io.ktor.http.Url', but it was NULL.")
          } else {
            _tmpSaManifestUrl = _tmp_2
          }
          val _tmpSaStatus: StatusEnum
          val _tmp_3: Int
          _tmp_3 = _stmt.getLong(_columnIndexOfSaStatus).toInt()
          _tmpSaStatus = __schoolTypeConverters.toStatusEnum(_tmp_3)
          val _tmpSaLastModified: Instant
          val _tmp_4: Long?
          if (_stmt.isNull(_columnIndexOfSaLastModified)) {
            _tmp_4 = null
          } else {
            _tmp_4 = _stmt.getLong(_columnIndexOfSaLastModified)
          }
          val _tmp_5: Instant? = __sharedConverters.toInstant(_tmp_4)
          if (_tmp_5 == null) {
            error("Expected NON-NULL 'kotlin.time.Instant', but it was NULL.")
          } else {
            _tmpSaLastModified = _tmp_5
          }
          val _tmpSaStored: Instant
          val _tmp_6: Long?
          if (_stmt.isNull(_columnIndexOfSaStored)) {
            _tmp_6 = null
          } else {
            _tmp_6 = _stmt.getLong(_columnIndexOfSaStored)
          }
          val _tmp_7: Instant? = __sharedConverters.toInstant(_tmp_6)
          if (_tmp_7 == null) {
            error("Expected NON-NULL 'kotlin.time.Instant', but it was NULL.")
          } else {
            _tmpSaStored = _tmp_7
          }
          _item = SchoolAppEntity(_tmpSaUid,_tmpSaUidNum,_tmpSaManifestUrl,_tmpSaStatus,_tmpSaLastModified,_tmpSaStored)
          _result.add(_item)
        }
        _result
      } finally {
        _stmt.close()
      }
    }
  }

  public companion object {
    public fun getRequiredConverters(): List<KClass<*>> = emptyList()
  }
}
