package world.respect.datalayer.db.schooldirectory.daos

import androidx.collection.LongSparseArray
import androidx.room.EntityInsertAdapter
import androidx.room.RoomDatabase
import androidx.room.coroutines.createFlow
import androidx.room.util.appendPlaceholders
import androidx.room.util.getColumnIndex
import androidx.room.util.getColumnIndexOrThrow
import androidx.room.util.performSuspending
import androidx.room.util.recursiveFetchLongSparseArray
import androidx.sqlite.SQLiteConnection
import androidx.sqlite.SQLiteStatement
import io.ktor.http.Url
import javax.`annotation`.processing.Generated
import kotlin.Int
import kotlin.Long
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.MutableList
import kotlin.collections.mutableListOf
import kotlin.reflect.KClass
import kotlin.text.StringBuilder
import kotlin.time.Instant
import kotlinx.coroutines.flow.Flow
import world.respect.datalayer.db.schooldirectory.adapters.SchoolDirectoryEntryEntities
import world.respect.datalayer.db.schooldirectory.entities.SchoolDirectoryEntryEntity
import world.respect.datalayer.db.schooldirectory.entities.SchoolDirectoryEntryLangMapEntity
import world.respect.datalayer.db.shared.SharedConverters

@Generated(value = ["androidx.room.RoomProcessor"])
@Suppress(names = ["UNCHECKED_CAST", "DEPRECATION", "REDUNDANT_PROJECTION", "REMOVAL"])
public class SchoolDirectoryEntryEntityDao_Impl(
  __db: RoomDatabase,
) : SchoolDirectoryEntryEntityDao {
  private val __db: RoomDatabase

  private val __insertAdapterOfSchoolDirectoryEntryEntity:
      EntityInsertAdapter<SchoolDirectoryEntryEntity>

  private val __sharedConverters: SharedConverters = SharedConverters()
  init {
    this.__db = __db
    this.__insertAdapterOfSchoolDirectoryEntryEntity = object : EntityInsertAdapter<SchoolDirectoryEntryEntity>() {
      protected override fun createQuery(): String = "INSERT OR REPLACE INTO `SchoolDirectoryEntryEntity` (`reUid`,`reSelf`,`reXapi`,`reOneRoster`,`reRespectExt`,`reRpId`,`reLastModified`,`reStored`) VALUES (?,?,?,?,?,?,?,?)"

      protected override fun bind(statement: SQLiteStatement, entity: SchoolDirectoryEntryEntity) {
        statement.bindLong(1, entity.reUid)
        val _tmp: String? = __sharedConverters.fromUrl(entity.reSelf)
        if (_tmp == null) {
          statement.bindNull(2)
        } else {
          statement.bindText(2, _tmp)
        }
        val _tmp_1: String? = __sharedConverters.fromUrl(entity.reXapi)
        if (_tmp_1 == null) {
          statement.bindNull(3)
        } else {
          statement.bindText(3, _tmp_1)
        }
        val _tmp_2: String? = __sharedConverters.fromUrl(entity.reOneRoster)
        if (_tmp_2 == null) {
          statement.bindNull(4)
        } else {
          statement.bindText(4, _tmp_2)
        }
        val _tmpReRespectExt: Url? = entity.reRespectExt
        val _tmp_3: String? = __sharedConverters.fromUrl(_tmpReRespectExt)
        if (_tmp_3 == null) {
          statement.bindNull(5)
        } else {
          statement.bindText(5, _tmp_3)
        }
        val _tmpReRpId: String? = entity.reRpId
        if (_tmpReRpId == null) {
          statement.bindNull(6)
        } else {
          statement.bindText(6, _tmpReRpId)
        }
        val _tmp_4: Long? = __sharedConverters.fromInstant(entity.reLastModified)
        if (_tmp_4 == null) {
          statement.bindNull(7)
        } else {
          statement.bindLong(7, _tmp_4)
        }
        val _tmp_5: Long? = __sharedConverters.fromInstant(entity.reStored)
        if (_tmp_5 == null) {
          statement.bindNull(8)
        } else {
          statement.bindLong(8, _tmp_5)
        }
      }
    }
  }

  public override suspend fun upsert(realmEntity: SchoolDirectoryEntryEntity): Unit = performSuspending(__db, false, true) { _connection ->
    __insertAdapterOfSchoolDirectoryEntryEntity.insert(_connection, realmEntity)
  }

  public override suspend fun findByUid(uid: Long): SchoolDirectoryEntryEntities? {
    val _sql: String = """
        |
        |        SELECT * 
        |         FROM SchoolDirectoryEntryEntity
        |        WHERE reUid = ?
        |    
        """.trimMargin()
    return performSuspending(__db, true, false) { _connection ->
      val _stmt: SQLiteStatement = _connection.prepare(_sql)
      try {
        var _argIndex: Int = 1
        _stmt.bindLong(_argIndex, uid)
        val _columnIndexOfReUid: Int = getColumnIndexOrThrow(_stmt, "reUid")
        val _columnIndexOfReSelf: Int = getColumnIndexOrThrow(_stmt, "reSelf")
        val _columnIndexOfReXapi: Int = getColumnIndexOrThrow(_stmt, "reXapi")
        val _columnIndexOfReOneRoster: Int = getColumnIndexOrThrow(_stmt, "reOneRoster")
        val _columnIndexOfReRespectExt: Int = getColumnIndexOrThrow(_stmt, "reRespectExt")
        val _columnIndexOfReRpId: Int = getColumnIndexOrThrow(_stmt, "reRpId")
        val _columnIndexOfReLastModified: Int = getColumnIndexOrThrow(_stmt, "reLastModified")
        val _columnIndexOfReStored: Int = getColumnIndexOrThrow(_stmt, "reStored")
        val _collectionLangMapEntities: LongSparseArray<MutableList<SchoolDirectoryEntryLangMapEntity>> = LongSparseArray<MutableList<SchoolDirectoryEntryLangMapEntity>>()
        while (_stmt.step()) {
          val _tmpKey: Long
          _tmpKey = _stmt.getLong(_columnIndexOfReUid)
          if (!_collectionLangMapEntities.containsKey(_tmpKey)) {
            _collectionLangMapEntities.put(_tmpKey, mutableListOf())
          }
        }
        _stmt.reset()
        __fetchRelationshipSchoolDirectoryEntryLangMapEntityAsworldRespectDatalayerDbSchooldirectoryEntitiesSchoolDirectoryEntryLangMapEntity(_connection, _collectionLangMapEntities)
        val _result: SchoolDirectoryEntryEntities?
        if (_stmt.step()) {
          val _tmpSchool: SchoolDirectoryEntryEntity
          val _tmpReUid: Long
          _tmpReUid = _stmt.getLong(_columnIndexOfReUid)
          val _tmpReSelf: Url
          val _tmp: String?
          if (_stmt.isNull(_columnIndexOfReSelf)) {
            _tmp = null
          } else {
            _tmp = _stmt.getText(_columnIndexOfReSelf)
          }
          val _tmp_1: Url? = __sharedConverters.toUrl(_tmp)
          if (_tmp_1 == null) {
            error("Expected NON-NULL 'io.ktor.http.Url', but it was NULL.")
          } else {
            _tmpReSelf = _tmp_1
          }
          val _tmpReXapi: Url
          val _tmp_2: String?
          if (_stmt.isNull(_columnIndexOfReXapi)) {
            _tmp_2 = null
          } else {
            _tmp_2 = _stmt.getText(_columnIndexOfReXapi)
          }
          val _tmp_3: Url? = __sharedConverters.toUrl(_tmp_2)
          if (_tmp_3 == null) {
            error("Expected NON-NULL 'io.ktor.http.Url', but it was NULL.")
          } else {
            _tmpReXapi = _tmp_3
          }
          val _tmpReOneRoster: Url
          val _tmp_4: String?
          if (_stmt.isNull(_columnIndexOfReOneRoster)) {
            _tmp_4 = null
          } else {
            _tmp_4 = _stmt.getText(_columnIndexOfReOneRoster)
          }
          val _tmp_5: Url? = __sharedConverters.toUrl(_tmp_4)
          if (_tmp_5 == null) {
            error("Expected NON-NULL 'io.ktor.http.Url', but it was NULL.")
          } else {
            _tmpReOneRoster = _tmp_5
          }
          val _tmpReRespectExt: Url?
          val _tmp_6: String?
          if (_stmt.isNull(_columnIndexOfReRespectExt)) {
            _tmp_6 = null
          } else {
            _tmp_6 = _stmt.getText(_columnIndexOfReRespectExt)
          }
          _tmpReRespectExt = __sharedConverters.toUrl(_tmp_6)
          val _tmpReRpId: String?
          if (_stmt.isNull(_columnIndexOfReRpId)) {
            _tmpReRpId = null
          } else {
            _tmpReRpId = _stmt.getText(_columnIndexOfReRpId)
          }
          val _tmpReLastModified: Instant
          val _tmp_7: Long?
          if (_stmt.isNull(_columnIndexOfReLastModified)) {
            _tmp_7 = null
          } else {
            _tmp_7 = _stmt.getLong(_columnIndexOfReLastModified)
          }
          val _tmp_8: Instant? = __sharedConverters.toInstant(_tmp_7)
          if (_tmp_8 == null) {
            error("Expected NON-NULL 'kotlin.time.Instant', but it was NULL.")
          } else {
            _tmpReLastModified = _tmp_8
          }
          val _tmpReStored: Instant
          val _tmp_9: Long?
          if (_stmt.isNull(_columnIndexOfReStored)) {
            _tmp_9 = null
          } else {
            _tmp_9 = _stmt.getLong(_columnIndexOfReStored)
          }
          val _tmp_10: Instant? = __sharedConverters.toInstant(_tmp_9)
          if (_tmp_10 == null) {
            error("Expected NON-NULL 'kotlin.time.Instant', but it was NULL.")
          } else {
            _tmpReStored = _tmp_10
          }
          _tmpSchool = SchoolDirectoryEntryEntity(_tmpReUid,_tmpReSelf,_tmpReXapi,_tmpReOneRoster,_tmpReRespectExt,_tmpReRpId,_tmpReLastModified,_tmpReStored)
          val _tmpLangMapEntitiesCollection: MutableList<SchoolDirectoryEntryLangMapEntity>
          val _tmpKey_1: Long
          _tmpKey_1 = _stmt.getLong(_columnIndexOfReUid)
          _tmpLangMapEntitiesCollection = checkNotNull(_collectionLangMapEntities.get(_tmpKey_1))
          _result = SchoolDirectoryEntryEntities(_tmpSchool,_tmpLangMapEntitiesCollection)
        } else {
          _result = null
        }
        _result
      } finally {
        _stmt.close()
      }
    }
  }

  public override fun searchSchoolsByName(query: String): Flow<List<SchoolDirectoryEntryEntity>> {
    val _sql: String = """
        |
        |        SELECT SchoolDirectoryEntryEntity.*
        |          FROM SchoolDirectoryEntryEntity
        |               JOIN LangMapEntity
        |                    ON LangMapEntity.lmeTopParentUid1 = SchoolDirectoryEntryEntity.reUid
        |         WHERE LangMapEntity.lmeValue LIKE ?
        |     
        """.trimMargin()
    return createFlow(__db, false, arrayOf("SchoolDirectoryEntryEntity", "LangMapEntity")) { _connection ->
      val _stmt: SQLiteStatement = _connection.prepare(_sql)
      try {
        var _argIndex: Int = 1
        _stmt.bindText(_argIndex, query)
        val _columnIndexOfReUid: Int = getColumnIndexOrThrow(_stmt, "reUid")
        val _columnIndexOfReSelf: Int = getColumnIndexOrThrow(_stmt, "reSelf")
        val _columnIndexOfReXapi: Int = getColumnIndexOrThrow(_stmt, "reXapi")
        val _columnIndexOfReOneRoster: Int = getColumnIndexOrThrow(_stmt, "reOneRoster")
        val _columnIndexOfReRespectExt: Int = getColumnIndexOrThrow(_stmt, "reRespectExt")
        val _columnIndexOfReRpId: Int = getColumnIndexOrThrow(_stmt, "reRpId")
        val _columnIndexOfReLastModified: Int = getColumnIndexOrThrow(_stmt, "reLastModified")
        val _columnIndexOfReStored: Int = getColumnIndexOrThrow(_stmt, "reStored")
        val _result: MutableList<SchoolDirectoryEntryEntity> = mutableListOf()
        while (_stmt.step()) {
          val _item: SchoolDirectoryEntryEntity
          val _tmpReUid: Long
          _tmpReUid = _stmt.getLong(_columnIndexOfReUid)
          val _tmpReSelf: Url
          val _tmp: String?
          if (_stmt.isNull(_columnIndexOfReSelf)) {
            _tmp = null
          } else {
            _tmp = _stmt.getText(_columnIndexOfReSelf)
          }
          val _tmp_1: Url? = __sharedConverters.toUrl(_tmp)
          if (_tmp_1 == null) {
            error("Expected NON-NULL 'io.ktor.http.Url', but it was NULL.")
          } else {
            _tmpReSelf = _tmp_1
          }
          val _tmpReXapi: Url
          val _tmp_2: String?
          if (_stmt.isNull(_columnIndexOfReXapi)) {
            _tmp_2 = null
          } else {
            _tmp_2 = _stmt.getText(_columnIndexOfReXapi)
          }
          val _tmp_3: Url? = __sharedConverters.toUrl(_tmp_2)
          if (_tmp_3 == null) {
            error("Expected NON-NULL 'io.ktor.http.Url', but it was NULL.")
          } else {
            _tmpReXapi = _tmp_3
          }
          val _tmpReOneRoster: Url
          val _tmp_4: String?
          if (_stmt.isNull(_columnIndexOfReOneRoster)) {
            _tmp_4 = null
          } else {
            _tmp_4 = _stmt.getText(_columnIndexOfReOneRoster)
          }
          val _tmp_5: Url? = __sharedConverters.toUrl(_tmp_4)
          if (_tmp_5 == null) {
            error("Expected NON-NULL 'io.ktor.http.Url', but it was NULL.")
          } else {
            _tmpReOneRoster = _tmp_5
          }
          val _tmpReRespectExt: Url?
          val _tmp_6: String?
          if (_stmt.isNull(_columnIndexOfReRespectExt)) {
            _tmp_6 = null
          } else {
            _tmp_6 = _stmt.getText(_columnIndexOfReRespectExt)
          }
          _tmpReRespectExt = __sharedConverters.toUrl(_tmp_6)
          val _tmpReRpId: String?
          if (_stmt.isNull(_columnIndexOfReRpId)) {
            _tmpReRpId = null
          } else {
            _tmpReRpId = _stmt.getText(_columnIndexOfReRpId)
          }
          val _tmpReLastModified: Instant
          val _tmp_7: Long?
          if (_stmt.isNull(_columnIndexOfReLastModified)) {
            _tmp_7 = null
          } else {
            _tmp_7 = _stmt.getLong(_columnIndexOfReLastModified)
          }
          val _tmp_8: Instant? = __sharedConverters.toInstant(_tmp_7)
          if (_tmp_8 == null) {
            error("Expected NON-NULL 'kotlin.time.Instant', but it was NULL.")
          } else {
            _tmpReLastModified = _tmp_8
          }
          val _tmpReStored: Instant
          val _tmp_9: Long?
          if (_stmt.isNull(_columnIndexOfReStored)) {
            _tmp_9 = null
          } else {
            _tmp_9 = _stmt.getLong(_columnIndexOfReStored)
          }
          val _tmp_10: Instant? = __sharedConverters.toInstant(_tmp_9)
          if (_tmp_10 == null) {
            error("Expected NON-NULL 'kotlin.time.Instant', but it was NULL.")
          } else {
            _tmpReStored = _tmp_10
          }
          _item = SchoolDirectoryEntryEntity(_tmpReUid,_tmpReSelf,_tmpReXapi,_tmpReOneRoster,_tmpReRespectExt,_tmpReRpId,_tmpReLastModified,_tmpReStored)
          _result.add(_item)
        }
        _result
      } finally {
        _stmt.close()
      }
    }
  }

  public override fun listAsFlow(name: String?): Flow<List<SchoolDirectoryEntryEntities>> {
    val _sql: String = """
        |
        |        SELECT SchoolDirectoryEntryEntity.*
        |          FROM SchoolDirectoryEntryEntity
        |         WHERE (? IS NULL OR SchoolDirectoryEntryEntity.reUid IN
        |                (SELECT SchoolDirectoryEntryLangMapEntity.sdelReUid
        |                   FROM SchoolDirectoryEntryLangMapEntity
        |                  WHERE SchoolDirectoryEntryLangMapEntity.sdelValue LIKE ?))
        |        
        """.trimMargin()
    return createFlow(__db, true, arrayOf("SchoolDirectoryEntryLangMapEntity", "SchoolDirectoryEntryEntity")) { _connection ->
      val _stmt: SQLiteStatement = _connection.prepare(_sql)
      try {
        var _argIndex: Int = 1
        if (name == null) {
          _stmt.bindNull(_argIndex)
        } else {
          _stmt.bindText(_argIndex, name)
        }
        _argIndex = 2
        if (name == null) {
          _stmt.bindNull(_argIndex)
        } else {
          _stmt.bindText(_argIndex, name)
        }
        val _columnIndexOfReUid: Int = getColumnIndexOrThrow(_stmt, "reUid")
        val _columnIndexOfReSelf: Int = getColumnIndexOrThrow(_stmt, "reSelf")
        val _columnIndexOfReXapi: Int = getColumnIndexOrThrow(_stmt, "reXapi")
        val _columnIndexOfReOneRoster: Int = getColumnIndexOrThrow(_stmt, "reOneRoster")
        val _columnIndexOfReRespectExt: Int = getColumnIndexOrThrow(_stmt, "reRespectExt")
        val _columnIndexOfReRpId: Int = getColumnIndexOrThrow(_stmt, "reRpId")
        val _columnIndexOfReLastModified: Int = getColumnIndexOrThrow(_stmt, "reLastModified")
        val _columnIndexOfReStored: Int = getColumnIndexOrThrow(_stmt, "reStored")
        val _collectionLangMapEntities: LongSparseArray<MutableList<SchoolDirectoryEntryLangMapEntity>> = LongSparseArray<MutableList<SchoolDirectoryEntryLangMapEntity>>()
        while (_stmt.step()) {
          val _tmpKey: Long
          _tmpKey = _stmt.getLong(_columnIndexOfReUid)
          if (!_collectionLangMapEntities.containsKey(_tmpKey)) {
            _collectionLangMapEntities.put(_tmpKey, mutableListOf())
          }
        }
        _stmt.reset()
        __fetchRelationshipSchoolDirectoryEntryLangMapEntityAsworldRespectDatalayerDbSchooldirectoryEntitiesSchoolDirectoryEntryLangMapEntity(_connection, _collectionLangMapEntities)
        val _result: MutableList<SchoolDirectoryEntryEntities> = mutableListOf()
        while (_stmt.step()) {
          val _item: SchoolDirectoryEntryEntities
          val _tmpSchool: SchoolDirectoryEntryEntity
          val _tmpReUid: Long
          _tmpReUid = _stmt.getLong(_columnIndexOfReUid)
          val _tmpReSelf: Url
          val _tmp: String?
          if (_stmt.isNull(_columnIndexOfReSelf)) {
            _tmp = null
          } else {
            _tmp = _stmt.getText(_columnIndexOfReSelf)
          }
          val _tmp_1: Url? = __sharedConverters.toUrl(_tmp)
          if (_tmp_1 == null) {
            error("Expected NON-NULL 'io.ktor.http.Url', but it was NULL.")
          } else {
            _tmpReSelf = _tmp_1
          }
          val _tmpReXapi: Url
          val _tmp_2: String?
          if (_stmt.isNull(_columnIndexOfReXapi)) {
            _tmp_2 = null
          } else {
            _tmp_2 = _stmt.getText(_columnIndexOfReXapi)
          }
          val _tmp_3: Url? = __sharedConverters.toUrl(_tmp_2)
          if (_tmp_3 == null) {
            error("Expected NON-NULL 'io.ktor.http.Url', but it was NULL.")
          } else {
            _tmpReXapi = _tmp_3
          }
          val _tmpReOneRoster: Url
          val _tmp_4: String?
          if (_stmt.isNull(_columnIndexOfReOneRoster)) {
            _tmp_4 = null
          } else {
            _tmp_4 = _stmt.getText(_columnIndexOfReOneRoster)
          }
          val _tmp_5: Url? = __sharedConverters.toUrl(_tmp_4)
          if (_tmp_5 == null) {
            error("Expected NON-NULL 'io.ktor.http.Url', but it was NULL.")
          } else {
            _tmpReOneRoster = _tmp_5
          }
          val _tmpReRespectExt: Url?
          val _tmp_6: String?
          if (_stmt.isNull(_columnIndexOfReRespectExt)) {
            _tmp_6 = null
          } else {
            _tmp_6 = _stmt.getText(_columnIndexOfReRespectExt)
          }
          _tmpReRespectExt = __sharedConverters.toUrl(_tmp_6)
          val _tmpReRpId: String?
          if (_stmt.isNull(_columnIndexOfReRpId)) {
            _tmpReRpId = null
          } else {
            _tmpReRpId = _stmt.getText(_columnIndexOfReRpId)
          }
          val _tmpReLastModified: Instant
          val _tmp_7: Long?
          if (_stmt.isNull(_columnIndexOfReLastModified)) {
            _tmp_7 = null
          } else {
            _tmp_7 = _stmt.getLong(_columnIndexOfReLastModified)
          }
          val _tmp_8: Instant? = __sharedConverters.toInstant(_tmp_7)
          if (_tmp_8 == null) {
            error("Expected NON-NULL 'kotlin.time.Instant', but it was NULL.")
          } else {
            _tmpReLastModified = _tmp_8
          }
          val _tmpReStored: Instant
          val _tmp_9: Long?
          if (_stmt.isNull(_columnIndexOfReStored)) {
            _tmp_9 = null
          } else {
            _tmp_9 = _stmt.getLong(_columnIndexOfReStored)
          }
          val _tmp_10: Instant? = __sharedConverters.toInstant(_tmp_9)
          if (_tmp_10 == null) {
            error("Expected NON-NULL 'kotlin.time.Instant', but it was NULL.")
          } else {
            _tmpReStored = _tmp_10
          }
          _tmpSchool = SchoolDirectoryEntryEntity(_tmpReUid,_tmpReSelf,_tmpReXapi,_tmpReOneRoster,_tmpReRespectExt,_tmpReRpId,_tmpReLastModified,_tmpReStored)
          val _tmpLangMapEntitiesCollection: MutableList<SchoolDirectoryEntryLangMapEntity>
          val _tmpKey_1: Long
          _tmpKey_1 = _stmt.getLong(_columnIndexOfReUid)
          _tmpLangMapEntitiesCollection = checkNotNull(_collectionLangMapEntities.get(_tmpKey_1))
          _item = SchoolDirectoryEntryEntities(_tmpSchool,_tmpLangMapEntitiesCollection)
          _result.add(_item)
        }
        _result
      } finally {
        _stmt.close()
      }
    }
  }

  public override suspend fun list(name: String?): List<SchoolDirectoryEntryEntities> {
    val _sql: String = """
        |
        |        SELECT SchoolDirectoryEntryEntity.*
        |          FROM SchoolDirectoryEntryEntity
        |         WHERE (? IS NULL OR SchoolDirectoryEntryEntity.reUid IN
        |                (SELECT SchoolDirectoryEntryLangMapEntity.sdelReUid
        |                   FROM SchoolDirectoryEntryLangMapEntity
        |                  WHERE SchoolDirectoryEntryLangMapEntity.sdelValue LIKE ?))
        |        
        """.trimMargin()
    return performSuspending(__db, true, true) { _connection ->
      val _stmt: SQLiteStatement = _connection.prepare(_sql)
      try {
        var _argIndex: Int = 1
        if (name == null) {
          _stmt.bindNull(_argIndex)
        } else {
          _stmt.bindText(_argIndex, name)
        }
        _argIndex = 2
        if (name == null) {
          _stmt.bindNull(_argIndex)
        } else {
          _stmt.bindText(_argIndex, name)
        }
        val _columnIndexOfReUid: Int = getColumnIndexOrThrow(_stmt, "reUid")
        val _columnIndexOfReSelf: Int = getColumnIndexOrThrow(_stmt, "reSelf")
        val _columnIndexOfReXapi: Int = getColumnIndexOrThrow(_stmt, "reXapi")
        val _columnIndexOfReOneRoster: Int = getColumnIndexOrThrow(_stmt, "reOneRoster")
        val _columnIndexOfReRespectExt: Int = getColumnIndexOrThrow(_stmt, "reRespectExt")
        val _columnIndexOfReRpId: Int = getColumnIndexOrThrow(_stmt, "reRpId")
        val _columnIndexOfReLastModified: Int = getColumnIndexOrThrow(_stmt, "reLastModified")
        val _columnIndexOfReStored: Int = getColumnIndexOrThrow(_stmt, "reStored")
        val _collectionLangMapEntities: LongSparseArray<MutableList<SchoolDirectoryEntryLangMapEntity>> = LongSparseArray<MutableList<SchoolDirectoryEntryLangMapEntity>>()
        while (_stmt.step()) {
          val _tmpKey: Long
          _tmpKey = _stmt.getLong(_columnIndexOfReUid)
          if (!_collectionLangMapEntities.containsKey(_tmpKey)) {
            _collectionLangMapEntities.put(_tmpKey, mutableListOf())
          }
        }
        _stmt.reset()
        __fetchRelationshipSchoolDirectoryEntryLangMapEntityAsworldRespectDatalayerDbSchooldirectoryEntitiesSchoolDirectoryEntryLangMapEntity(_connection, _collectionLangMapEntities)
        val _result: MutableList<SchoolDirectoryEntryEntities> = mutableListOf()
        while (_stmt.step()) {
          val _item: SchoolDirectoryEntryEntities
          val _tmpSchool: SchoolDirectoryEntryEntity
          val _tmpReUid: Long
          _tmpReUid = _stmt.getLong(_columnIndexOfReUid)
          val _tmpReSelf: Url
          val _tmp: String?
          if (_stmt.isNull(_columnIndexOfReSelf)) {
            _tmp = null
          } else {
            _tmp = _stmt.getText(_columnIndexOfReSelf)
          }
          val _tmp_1: Url? = __sharedConverters.toUrl(_tmp)
          if (_tmp_1 == null) {
            error("Expected NON-NULL 'io.ktor.http.Url', but it was NULL.")
          } else {
            _tmpReSelf = _tmp_1
          }
          val _tmpReXapi: Url
          val _tmp_2: String?
          if (_stmt.isNull(_columnIndexOfReXapi)) {
            _tmp_2 = null
          } else {
            _tmp_2 = _stmt.getText(_columnIndexOfReXapi)
          }
          val _tmp_3: Url? = __sharedConverters.toUrl(_tmp_2)
          if (_tmp_3 == null) {
            error("Expected NON-NULL 'io.ktor.http.Url', but it was NULL.")
          } else {
            _tmpReXapi = _tmp_3
          }
          val _tmpReOneRoster: Url
          val _tmp_4: String?
          if (_stmt.isNull(_columnIndexOfReOneRoster)) {
            _tmp_4 = null
          } else {
            _tmp_4 = _stmt.getText(_columnIndexOfReOneRoster)
          }
          val _tmp_5: Url? = __sharedConverters.toUrl(_tmp_4)
          if (_tmp_5 == null) {
            error("Expected NON-NULL 'io.ktor.http.Url', but it was NULL.")
          } else {
            _tmpReOneRoster = _tmp_5
          }
          val _tmpReRespectExt: Url?
          val _tmp_6: String?
          if (_stmt.isNull(_columnIndexOfReRespectExt)) {
            _tmp_6 = null
          } else {
            _tmp_6 = _stmt.getText(_columnIndexOfReRespectExt)
          }
          _tmpReRespectExt = __sharedConverters.toUrl(_tmp_6)
          val _tmpReRpId: String?
          if (_stmt.isNull(_columnIndexOfReRpId)) {
            _tmpReRpId = null
          } else {
            _tmpReRpId = _stmt.getText(_columnIndexOfReRpId)
          }
          val _tmpReLastModified: Instant
          val _tmp_7: Long?
          if (_stmt.isNull(_columnIndexOfReLastModified)) {
            _tmp_7 = null
          } else {
            _tmp_7 = _stmt.getLong(_columnIndexOfReLastModified)
          }
          val _tmp_8: Instant? = __sharedConverters.toInstant(_tmp_7)
          if (_tmp_8 == null) {
            error("Expected NON-NULL 'kotlin.time.Instant', but it was NULL.")
          } else {
            _tmpReLastModified = _tmp_8
          }
          val _tmpReStored: Instant
          val _tmp_9: Long?
          if (_stmt.isNull(_columnIndexOfReStored)) {
            _tmp_9 = null
          } else {
            _tmp_9 = _stmt.getLong(_columnIndexOfReStored)
          }
          val _tmp_10: Instant? = __sharedConverters.toInstant(_tmp_9)
          if (_tmp_10 == null) {
            error("Expected NON-NULL 'kotlin.time.Instant', but it was NULL.")
          } else {
            _tmpReStored = _tmp_10
          }
          _tmpSchool = SchoolDirectoryEntryEntity(_tmpReUid,_tmpReSelf,_tmpReXapi,_tmpReOneRoster,_tmpReRespectExt,_tmpReRpId,_tmpReLastModified,_tmpReStored)
          val _tmpLangMapEntitiesCollection: MutableList<SchoolDirectoryEntryLangMapEntity>
          val _tmpKey_1: Long
          _tmpKey_1 = _stmt.getLong(_columnIndexOfReUid)
          _tmpLangMapEntitiesCollection = checkNotNull(_collectionLangMapEntities.get(_tmpKey_1))
          _item = SchoolDirectoryEntryEntities(_tmpSchool,_tmpLangMapEntitiesCollection)
          _result.add(_item)
        }
        _result
      } finally {
        _stmt.close()
      }
    }
  }

  private fun __fetchRelationshipSchoolDirectoryEntryLangMapEntityAsworldRespectDatalayerDbSchooldirectoryEntitiesSchoolDirectoryEntryLangMapEntity(_connection: SQLiteConnection, _map: LongSparseArray<MutableList<SchoolDirectoryEntryLangMapEntity>>) {
    if (_map.isEmpty()) {
      return
    }
    if (_map.size() > 999) {
      recursiveFetchLongSparseArray(_map, true) { _tmpMap ->
        __fetchRelationshipSchoolDirectoryEntryLangMapEntityAsworldRespectDatalayerDbSchooldirectoryEntitiesSchoolDirectoryEntryLangMapEntity(_connection, _tmpMap)
      }
      return
    }
    val _stringBuilder: StringBuilder = StringBuilder()
    _stringBuilder.append("SELECT `sdelUid`,`sdelReUid`,`sdelLang`,`sdelRegion`,`sdelValue`,`sdelPropId` FROM `SchoolDirectoryEntryLangMapEntity` WHERE `sdelReUid` IN (")
    val _inputSize: Int = _map.size()
    appendPlaceholders(_stringBuilder, _inputSize)
    _stringBuilder.append(")")
    val _sql: String = _stringBuilder.toString()
    val _stmt: SQLiteStatement = _connection.prepare(_sql)
    var _argIndex: Int = 1
    for (i in 0 until _map.size()) {
      val _item: Long = _map.keyAt(i)
      _stmt.bindLong(_argIndex, _item)
      _argIndex++
    }
    try {
      val _itemKeyIndex: Int = getColumnIndex(_stmt, "sdelReUid")
      if (_itemKeyIndex == -1) {
        return
      }
      val _columnIndexOfSdelUid: Int = 0
      val _columnIndexOfSdelReUid: Int = 1
      val _columnIndexOfSdelLang: Int = 2
      val _columnIndexOfSdelRegion: Int = 3
      val _columnIndexOfSdelValue: Int = 4
      val _columnIndexOfSdelPropId: Int = 5
      while (_stmt.step()) {
        val _tmpKey: Long
        _tmpKey = _stmt.getLong(_itemKeyIndex)
        val _tmpRelation: MutableList<SchoolDirectoryEntryLangMapEntity>? = _map.get(_tmpKey)
        if (_tmpRelation != null) {
          val _item_1: SchoolDirectoryEntryLangMapEntity
          val _tmpSdelUid: Int
          _tmpSdelUid = _stmt.getLong(_columnIndexOfSdelUid).toInt()
          val _tmpSdelReUid: Long
          _tmpSdelReUid = _stmt.getLong(_columnIndexOfSdelReUid)
          val _tmpSdelLang: String
          _tmpSdelLang = _stmt.getText(_columnIndexOfSdelLang)
          val _tmpSdelRegion: String?
          if (_stmt.isNull(_columnIndexOfSdelRegion)) {
            _tmpSdelRegion = null
          } else {
            _tmpSdelRegion = _stmt.getText(_columnIndexOfSdelRegion)
          }
          val _tmpSdelValue: String
          _tmpSdelValue = _stmt.getText(_columnIndexOfSdelValue)
          val _tmpSdelPropId: Int
          _tmpSdelPropId = _stmt.getLong(_columnIndexOfSdelPropId).toInt()
          _item_1 = SchoolDirectoryEntryLangMapEntity(_tmpSdelUid,_tmpSdelReUid,_tmpSdelLang,_tmpSdelRegion,_tmpSdelValue,_tmpSdelPropId)
          _tmpRelation.add(_item_1)
        }
      }
    } finally {
      _stmt.close()
    }
  }

  public companion object {
    public fun getRequiredConverters(): List<KClass<*>> = emptyList()
  }
}
