package world.respect.datalayer.db.school.daos

import androidx.paging.PagingSource
import androidx.room.EntityInsertAdapter
import androidx.room.RoomDatabase
import androidx.room.RoomRawQuery
import androidx.room.coroutines.createFlow
import androidx.room.paging.LimitOffsetPagingSource
import androidx.room.util.appendPlaceholders
import androidx.room.util.getColumnIndexOrThrow
import androidx.room.util.performSuspending
import androidx.sqlite.SQLiteStatement
import javax.`annotation`.processing.Generated
import kotlin.Boolean
import kotlin.Int
import kotlin.Long
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.MutableList
import kotlin.collections.mutableListOf
import kotlin.reflect.KClass
import kotlin.text.StringBuilder
import kotlinx.coroutines.flow.Flow
import world.respect.datalayer.db.school.SchoolTypeConverters
import world.respect.datalayer.db.school.entities.InviteEntity
import world.respect.datalayer.school.model.EnrollmentRoleEnum
import world.respect.datalayer.school.model.PersonRoleEnum

@Generated(value = ["androidx.room.RoomProcessor"])
@Suppress(names = ["UNCHECKED_CAST", "DEPRECATION", "REDUNDANT_PROJECTION", "REMOVAL"])
public class InviteEntityDao_Impl(
  __db: RoomDatabase,
) : InviteEntityDao {
  private val __db: RoomDatabase

  private val __insertAdapterOfInviteEntity: EntityInsertAdapter<InviteEntity>

  private val __schoolTypeConverters: SchoolTypeConverters = SchoolTypeConverters()
  init {
    this.__db = __db
    this.__insertAdapterOfInviteEntity = object : EntityInsertAdapter<InviteEntity>() {
      protected override fun createQuery(): String = "INSERT OR REPLACE INTO `InviteEntity` (`iGuid`,`iGuidHash`,`iCode`,`iNewRole`,`iForFamilyOfGuid`,`iForFamilyOfGuidHash`,`iForClassGuid`,`iForClassName`,`iSchoolName`,`iForClassGuidHash`,`iForClassRole`,`iInviteMultipleAllowed`,`iIsFirstUser`,`iApprovalRequired`,`iLastModified`,`iExpiration`,`iInviteStatus`) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)"

      protected override fun bind(statement: SQLiteStatement, entity: InviteEntity) {
        statement.bindText(1, entity.iGuid)
        statement.bindLong(2, entity.iGuidHash)
        statement.bindText(3, entity.iCode)
        val _tmpINewRole: PersonRoleEnum? = entity.iNewRole
        val _tmp: Int?
        if (_tmpINewRole == null) {
          _tmp = null
        } else {
          _tmp = __schoolTypeConverters.fromPersonRoleType(_tmpINewRole)
        }
        if (_tmp == null) {
          statement.bindNull(4)
        } else {
          statement.bindLong(4, _tmp.toLong())
        }
        val _tmpIForFamilyOfGuid: String? = entity.iForFamilyOfGuid
        if (_tmpIForFamilyOfGuid == null) {
          statement.bindNull(5)
        } else {
          statement.bindText(5, _tmpIForFamilyOfGuid)
        }
        val _tmpIForFamilyOfGuidHash: Long? = entity.iForFamilyOfGuidHash
        if (_tmpIForFamilyOfGuidHash == null) {
          statement.bindNull(6)
        } else {
          statement.bindLong(6, _tmpIForFamilyOfGuidHash)
        }
        val _tmpIForClassGuid: String? = entity.iForClassGuid
        if (_tmpIForClassGuid == null) {
          statement.bindNull(7)
        } else {
          statement.bindText(7, _tmpIForClassGuid)
        }
        val _tmpIForClassName: String? = entity.iForClassName
        if (_tmpIForClassName == null) {
          statement.bindNull(8)
        } else {
          statement.bindText(8, _tmpIForClassName)
        }
        val _tmpISchoolName: String? = entity.iSchoolName
        if (_tmpISchoolName == null) {
          statement.bindNull(9)
        } else {
          statement.bindText(9, _tmpISchoolName)
        }
        val _tmpIForClassGuidHash: Long? = entity.iForClassGuidHash
        if (_tmpIForClassGuidHash == null) {
          statement.bindNull(10)
        } else {
          statement.bindLong(10, _tmpIForClassGuidHash)
        }
        val _tmpIForClassRole: EnrollmentRoleEnum? = entity.iForClassRole
        val _tmp_1: Int?
        if (_tmpIForClassRole == null) {
          _tmp_1 = null
        } else {
          _tmp_1 = __schoolTypeConverters.fromEnrollmentRoleEnum(_tmpIForClassRole)
        }
        if (_tmp_1 == null) {
          statement.bindNull(11)
        } else {
          statement.bindLong(11, _tmp_1.toLong())
        }
        val _tmp_2: Int = if (entity.iInviteMultipleAllowed) 1 else 0
        statement.bindLong(12, _tmp_2.toLong())
        val _tmp_3: Int = if (entity.iIsFirstUser) 1 else 0
        statement.bindLong(13, _tmp_3.toLong())
        val _tmp_4: Int = if (entity.iApprovalRequired) 1 else 0
        statement.bindLong(14, _tmp_4.toLong())
        statement.bindLong(15, entity.iLastModified)
        statement.bindLong(16, entity.iExpiration)
        statement.bindLong(17, entity.iInviteStatus.toLong())
      }
    }
  }

  public override suspend fun insert(inviteEntity: InviteEntity): Unit = performSuspending(__db, false, true) { _connection ->
    __insertAdapterOfInviteEntity.insert(_connection, inviteEntity)
  }

  public override suspend fun insertAll(invites: List<InviteEntity>): Unit = performSuspending(__db, false, true) { _connection ->
    __insertAdapterOfInviteEntity.insert(_connection, invites)
  }

  public override suspend fun getLastModifiedByGuid(guidHash: Long): Long? {
    val _sql: String = """
        |
        |        SELECT InviteEntity.iLastModified
        |          FROM InviteEntity
        |         WHERE InviteEntity.iGuidHash = ?
        |         LIMIT 1
        |    
        """.trimMargin()
    return performSuspending(__db, true, false) { _connection ->
      val _stmt: SQLiteStatement = _connection.prepare(_sql)
      try {
        var _argIndex: Int = 1
        _stmt.bindLong(_argIndex, guidHash)
        val _result: Long?
        if (_stmt.step()) {
          if (_stmt.isNull(0)) {
            _result = null
          } else {
            _result = _stmt.getLong(0)
          }
        } else {
          _result = null
        }
        _result
      } finally {
        _stmt.close()
      }
    }
  }

  public override suspend fun getInviteByInviteCode(code: String): InviteEntity? {
    val _sql: String = """
        |
        |        SELECT * 
        |          FROM InviteEntity
        |         WHERE iCode = ?
        |         LIMIT 1
        |    
        """.trimMargin()
    return performSuspending(__db, true, false) { _connection ->
      val _stmt: SQLiteStatement = _connection.prepare(_sql)
      try {
        var _argIndex: Int = 1
        _stmt.bindText(_argIndex, code)
        val _columnIndexOfIGuid: Int = getColumnIndexOrThrow(_stmt, "iGuid")
        val _columnIndexOfIGuidHash: Int = getColumnIndexOrThrow(_stmt, "iGuidHash")
        val _columnIndexOfICode: Int = getColumnIndexOrThrow(_stmt, "iCode")
        val _columnIndexOfINewRole: Int = getColumnIndexOrThrow(_stmt, "iNewRole")
        val _columnIndexOfIForFamilyOfGuid: Int = getColumnIndexOrThrow(_stmt, "iForFamilyOfGuid")
        val _columnIndexOfIForFamilyOfGuidHash: Int = getColumnIndexOrThrow(_stmt, "iForFamilyOfGuidHash")
        val _columnIndexOfIForClassGuid: Int = getColumnIndexOrThrow(_stmt, "iForClassGuid")
        val _columnIndexOfIForClassName: Int = getColumnIndexOrThrow(_stmt, "iForClassName")
        val _columnIndexOfISchoolName: Int = getColumnIndexOrThrow(_stmt, "iSchoolName")
        val _columnIndexOfIForClassGuidHash: Int = getColumnIndexOrThrow(_stmt, "iForClassGuidHash")
        val _columnIndexOfIForClassRole: Int = getColumnIndexOrThrow(_stmt, "iForClassRole")
        val _columnIndexOfIInviteMultipleAllowed: Int = getColumnIndexOrThrow(_stmt, "iInviteMultipleAllowed")
        val _columnIndexOfIIsFirstUser: Int = getColumnIndexOrThrow(_stmt, "iIsFirstUser")
        val _columnIndexOfIApprovalRequired: Int = getColumnIndexOrThrow(_stmt, "iApprovalRequired")
        val _columnIndexOfILastModified: Int = getColumnIndexOrThrow(_stmt, "iLastModified")
        val _columnIndexOfIExpiration: Int = getColumnIndexOrThrow(_stmt, "iExpiration")
        val _columnIndexOfIInviteStatus: Int = getColumnIndexOrThrow(_stmt, "iInviteStatus")
        val _result: InviteEntity?
        if (_stmt.step()) {
          val _tmpIGuid: String
          _tmpIGuid = _stmt.getText(_columnIndexOfIGuid)
          val _tmpIGuidHash: Long
          _tmpIGuidHash = _stmt.getLong(_columnIndexOfIGuidHash)
          val _tmpICode: String
          _tmpICode = _stmt.getText(_columnIndexOfICode)
          val _tmpINewRole: PersonRoleEnum?
          val _tmp: Int?
          if (_stmt.isNull(_columnIndexOfINewRole)) {
            _tmp = null
          } else {
            _tmp = _stmt.getLong(_columnIndexOfINewRole).toInt()
          }
          if (_tmp == null) {
            _tmpINewRole = null
          } else {
            _tmpINewRole = __schoolTypeConverters.toPersonRoleType(_tmp)
          }
          val _tmpIForFamilyOfGuid: String?
          if (_stmt.isNull(_columnIndexOfIForFamilyOfGuid)) {
            _tmpIForFamilyOfGuid = null
          } else {
            _tmpIForFamilyOfGuid = _stmt.getText(_columnIndexOfIForFamilyOfGuid)
          }
          val _tmpIForFamilyOfGuidHash: Long?
          if (_stmt.isNull(_columnIndexOfIForFamilyOfGuidHash)) {
            _tmpIForFamilyOfGuidHash = null
          } else {
            _tmpIForFamilyOfGuidHash = _stmt.getLong(_columnIndexOfIForFamilyOfGuidHash)
          }
          val _tmpIForClassGuid: String?
          if (_stmt.isNull(_columnIndexOfIForClassGuid)) {
            _tmpIForClassGuid = null
          } else {
            _tmpIForClassGuid = _stmt.getText(_columnIndexOfIForClassGuid)
          }
          val _tmpIForClassName: String?
          if (_stmt.isNull(_columnIndexOfIForClassName)) {
            _tmpIForClassName = null
          } else {
            _tmpIForClassName = _stmt.getText(_columnIndexOfIForClassName)
          }
          val _tmpISchoolName: String?
          if (_stmt.isNull(_columnIndexOfISchoolName)) {
            _tmpISchoolName = null
          } else {
            _tmpISchoolName = _stmt.getText(_columnIndexOfISchoolName)
          }
          val _tmpIForClassGuidHash: Long?
          if (_stmt.isNull(_columnIndexOfIForClassGuidHash)) {
            _tmpIForClassGuidHash = null
          } else {
            _tmpIForClassGuidHash = _stmt.getLong(_columnIndexOfIForClassGuidHash)
          }
          val _tmpIForClassRole: EnrollmentRoleEnum?
          val _tmp_1: Int?
          if (_stmt.isNull(_columnIndexOfIForClassRole)) {
            _tmp_1 = null
          } else {
            _tmp_1 = _stmt.getLong(_columnIndexOfIForClassRole).toInt()
          }
          if (_tmp_1 == null) {
            _tmpIForClassRole = null
          } else {
            _tmpIForClassRole = __schoolTypeConverters.toEnrollmentRoleEnum(_tmp_1)
          }
          val _tmpIInviteMultipleAllowed: Boolean
          val _tmp_2: Int
          _tmp_2 = _stmt.getLong(_columnIndexOfIInviteMultipleAllowed).toInt()
          _tmpIInviteMultipleAllowed = _tmp_2 != 0
          val _tmpIIsFirstUser: Boolean
          val _tmp_3: Int
          _tmp_3 = _stmt.getLong(_columnIndexOfIIsFirstUser).toInt()
          _tmpIIsFirstUser = _tmp_3 != 0
          val _tmpIApprovalRequired: Boolean
          val _tmp_4: Int
          _tmp_4 = _stmt.getLong(_columnIndexOfIApprovalRequired).toInt()
          _tmpIApprovalRequired = _tmp_4 != 0
          val _tmpILastModified: Long
          _tmpILastModified = _stmt.getLong(_columnIndexOfILastModified)
          val _tmpIExpiration: Long
          _tmpIExpiration = _stmt.getLong(_columnIndexOfIExpiration)
          val _tmpIInviteStatus: Int
          _tmpIInviteStatus = _stmt.getLong(_columnIndexOfIInviteStatus).toInt()
          _result = InviteEntity(_tmpIGuid,_tmpIGuidHash,_tmpICode,_tmpINewRole,_tmpIForFamilyOfGuid,_tmpIForFamilyOfGuidHash,_tmpIForClassGuid,_tmpIForClassName,_tmpISchoolName,_tmpIForClassGuidHash,_tmpIForClassRole,_tmpIInviteMultipleAllowed,_tmpIIsFirstUser,_tmpIApprovalRequired,_tmpILastModified,_tmpIExpiration,_tmpIInviteStatus)
        } else {
          _result = null
        }
        _result
      } finally {
        _stmt.close()
      }
    }
  }

  public override suspend fun findByGuidHash(guidHash: Long): InviteEntity? {
    val _sql: String = """
        |
        |        SELECT * 
        |          FROM InviteEntity
        |         WHERE iGuidHash = ?
        |         LIMIT 1
        |    
        """.trimMargin()
    return performSuspending(__db, true, false) { _connection ->
      val _stmt: SQLiteStatement = _connection.prepare(_sql)
      try {
        var _argIndex: Int = 1
        _stmt.bindLong(_argIndex, guidHash)
        val _columnIndexOfIGuid: Int = getColumnIndexOrThrow(_stmt, "iGuid")
        val _columnIndexOfIGuidHash: Int = getColumnIndexOrThrow(_stmt, "iGuidHash")
        val _columnIndexOfICode: Int = getColumnIndexOrThrow(_stmt, "iCode")
        val _columnIndexOfINewRole: Int = getColumnIndexOrThrow(_stmt, "iNewRole")
        val _columnIndexOfIForFamilyOfGuid: Int = getColumnIndexOrThrow(_stmt, "iForFamilyOfGuid")
        val _columnIndexOfIForFamilyOfGuidHash: Int = getColumnIndexOrThrow(_stmt, "iForFamilyOfGuidHash")
        val _columnIndexOfIForClassGuid: Int = getColumnIndexOrThrow(_stmt, "iForClassGuid")
        val _columnIndexOfIForClassName: Int = getColumnIndexOrThrow(_stmt, "iForClassName")
        val _columnIndexOfISchoolName: Int = getColumnIndexOrThrow(_stmt, "iSchoolName")
        val _columnIndexOfIForClassGuidHash: Int = getColumnIndexOrThrow(_stmt, "iForClassGuidHash")
        val _columnIndexOfIForClassRole: Int = getColumnIndexOrThrow(_stmt, "iForClassRole")
        val _columnIndexOfIInviteMultipleAllowed: Int = getColumnIndexOrThrow(_stmt, "iInviteMultipleAllowed")
        val _columnIndexOfIIsFirstUser: Int = getColumnIndexOrThrow(_stmt, "iIsFirstUser")
        val _columnIndexOfIApprovalRequired: Int = getColumnIndexOrThrow(_stmt, "iApprovalRequired")
        val _columnIndexOfILastModified: Int = getColumnIndexOrThrow(_stmt, "iLastModified")
        val _columnIndexOfIExpiration: Int = getColumnIndexOrThrow(_stmt, "iExpiration")
        val _columnIndexOfIInviteStatus: Int = getColumnIndexOrThrow(_stmt, "iInviteStatus")
        val _result: InviteEntity?
        if (_stmt.step()) {
          val _tmpIGuid: String
          _tmpIGuid = _stmt.getText(_columnIndexOfIGuid)
          val _tmpIGuidHash: Long
          _tmpIGuidHash = _stmt.getLong(_columnIndexOfIGuidHash)
          val _tmpICode: String
          _tmpICode = _stmt.getText(_columnIndexOfICode)
          val _tmpINewRole: PersonRoleEnum?
          val _tmp: Int?
          if (_stmt.isNull(_columnIndexOfINewRole)) {
            _tmp = null
          } else {
            _tmp = _stmt.getLong(_columnIndexOfINewRole).toInt()
          }
          if (_tmp == null) {
            _tmpINewRole = null
          } else {
            _tmpINewRole = __schoolTypeConverters.toPersonRoleType(_tmp)
          }
          val _tmpIForFamilyOfGuid: String?
          if (_stmt.isNull(_columnIndexOfIForFamilyOfGuid)) {
            _tmpIForFamilyOfGuid = null
          } else {
            _tmpIForFamilyOfGuid = _stmt.getText(_columnIndexOfIForFamilyOfGuid)
          }
          val _tmpIForFamilyOfGuidHash: Long?
          if (_stmt.isNull(_columnIndexOfIForFamilyOfGuidHash)) {
            _tmpIForFamilyOfGuidHash = null
          } else {
            _tmpIForFamilyOfGuidHash = _stmt.getLong(_columnIndexOfIForFamilyOfGuidHash)
          }
          val _tmpIForClassGuid: String?
          if (_stmt.isNull(_columnIndexOfIForClassGuid)) {
            _tmpIForClassGuid = null
          } else {
            _tmpIForClassGuid = _stmt.getText(_columnIndexOfIForClassGuid)
          }
          val _tmpIForClassName: String?
          if (_stmt.isNull(_columnIndexOfIForClassName)) {
            _tmpIForClassName = null
          } else {
            _tmpIForClassName = _stmt.getText(_columnIndexOfIForClassName)
          }
          val _tmpISchoolName: String?
          if (_stmt.isNull(_columnIndexOfISchoolName)) {
            _tmpISchoolName = null
          } else {
            _tmpISchoolName = _stmt.getText(_columnIndexOfISchoolName)
          }
          val _tmpIForClassGuidHash: Long?
          if (_stmt.isNull(_columnIndexOfIForClassGuidHash)) {
            _tmpIForClassGuidHash = null
          } else {
            _tmpIForClassGuidHash = _stmt.getLong(_columnIndexOfIForClassGuidHash)
          }
          val _tmpIForClassRole: EnrollmentRoleEnum?
          val _tmp_1: Int?
          if (_stmt.isNull(_columnIndexOfIForClassRole)) {
            _tmp_1 = null
          } else {
            _tmp_1 = _stmt.getLong(_columnIndexOfIForClassRole).toInt()
          }
          if (_tmp_1 == null) {
            _tmpIForClassRole = null
          } else {
            _tmpIForClassRole = __schoolTypeConverters.toEnrollmentRoleEnum(_tmp_1)
          }
          val _tmpIInviteMultipleAllowed: Boolean
          val _tmp_2: Int
          _tmp_2 = _stmt.getLong(_columnIndexOfIInviteMultipleAllowed).toInt()
          _tmpIInviteMultipleAllowed = _tmp_2 != 0
          val _tmpIIsFirstUser: Boolean
          val _tmp_3: Int
          _tmp_3 = _stmt.getLong(_columnIndexOfIIsFirstUser).toInt()
          _tmpIIsFirstUser = _tmp_3 != 0
          val _tmpIApprovalRequired: Boolean
          val _tmp_4: Int
          _tmp_4 = _stmt.getLong(_columnIndexOfIApprovalRequired).toInt()
          _tmpIApprovalRequired = _tmp_4 != 0
          val _tmpILastModified: Long
          _tmpILastModified = _stmt.getLong(_columnIndexOfILastModified)
          val _tmpIExpiration: Long
          _tmpIExpiration = _stmt.getLong(_columnIndexOfIExpiration)
          val _tmpIInviteStatus: Int
          _tmpIInviteStatus = _stmt.getLong(_columnIndexOfIInviteStatus).toInt()
          _result = InviteEntity(_tmpIGuid,_tmpIGuidHash,_tmpICode,_tmpINewRole,_tmpIForFamilyOfGuid,_tmpIForFamilyOfGuidHash,_tmpIForClassGuid,_tmpIForClassName,_tmpISchoolName,_tmpIForClassGuidHash,_tmpIForClassRole,_tmpIInviteMultipleAllowed,_tmpIIsFirstUser,_tmpIApprovalRequired,_tmpILastModified,_tmpIExpiration,_tmpIInviteStatus)
        } else {
          _result = null
        }
        _result
      } finally {
        _stmt.close()
      }
    }
  }

  public override suspend fun findByGuid(guid: String): InviteEntity? {
    val _sql: String = """
        |
        |        SELECT * 
        |          FROM InviteEntity
        |         WHERE iGuid = ?
        |         LIMIT 1
        |    
        """.trimMargin()
    return performSuspending(__db, true, false) { _connection ->
      val _stmt: SQLiteStatement = _connection.prepare(_sql)
      try {
        var _argIndex: Int = 1
        _stmt.bindText(_argIndex, guid)
        val _columnIndexOfIGuid: Int = getColumnIndexOrThrow(_stmt, "iGuid")
        val _columnIndexOfIGuidHash: Int = getColumnIndexOrThrow(_stmt, "iGuidHash")
        val _columnIndexOfICode: Int = getColumnIndexOrThrow(_stmt, "iCode")
        val _columnIndexOfINewRole: Int = getColumnIndexOrThrow(_stmt, "iNewRole")
        val _columnIndexOfIForFamilyOfGuid: Int = getColumnIndexOrThrow(_stmt, "iForFamilyOfGuid")
        val _columnIndexOfIForFamilyOfGuidHash: Int = getColumnIndexOrThrow(_stmt, "iForFamilyOfGuidHash")
        val _columnIndexOfIForClassGuid: Int = getColumnIndexOrThrow(_stmt, "iForClassGuid")
        val _columnIndexOfIForClassName: Int = getColumnIndexOrThrow(_stmt, "iForClassName")
        val _columnIndexOfISchoolName: Int = getColumnIndexOrThrow(_stmt, "iSchoolName")
        val _columnIndexOfIForClassGuidHash: Int = getColumnIndexOrThrow(_stmt, "iForClassGuidHash")
        val _columnIndexOfIForClassRole: Int = getColumnIndexOrThrow(_stmt, "iForClassRole")
        val _columnIndexOfIInviteMultipleAllowed: Int = getColumnIndexOrThrow(_stmt, "iInviteMultipleAllowed")
        val _columnIndexOfIIsFirstUser: Int = getColumnIndexOrThrow(_stmt, "iIsFirstUser")
        val _columnIndexOfIApprovalRequired: Int = getColumnIndexOrThrow(_stmt, "iApprovalRequired")
        val _columnIndexOfILastModified: Int = getColumnIndexOrThrow(_stmt, "iLastModified")
        val _columnIndexOfIExpiration: Int = getColumnIndexOrThrow(_stmt, "iExpiration")
        val _columnIndexOfIInviteStatus: Int = getColumnIndexOrThrow(_stmt, "iInviteStatus")
        val _result: InviteEntity?
        if (_stmt.step()) {
          val _tmpIGuid: String
          _tmpIGuid = _stmt.getText(_columnIndexOfIGuid)
          val _tmpIGuidHash: Long
          _tmpIGuidHash = _stmt.getLong(_columnIndexOfIGuidHash)
          val _tmpICode: String
          _tmpICode = _stmt.getText(_columnIndexOfICode)
          val _tmpINewRole: PersonRoleEnum?
          val _tmp: Int?
          if (_stmt.isNull(_columnIndexOfINewRole)) {
            _tmp = null
          } else {
            _tmp = _stmt.getLong(_columnIndexOfINewRole).toInt()
          }
          if (_tmp == null) {
            _tmpINewRole = null
          } else {
            _tmpINewRole = __schoolTypeConverters.toPersonRoleType(_tmp)
          }
          val _tmpIForFamilyOfGuid: String?
          if (_stmt.isNull(_columnIndexOfIForFamilyOfGuid)) {
            _tmpIForFamilyOfGuid = null
          } else {
            _tmpIForFamilyOfGuid = _stmt.getText(_columnIndexOfIForFamilyOfGuid)
          }
          val _tmpIForFamilyOfGuidHash: Long?
          if (_stmt.isNull(_columnIndexOfIForFamilyOfGuidHash)) {
            _tmpIForFamilyOfGuidHash = null
          } else {
            _tmpIForFamilyOfGuidHash = _stmt.getLong(_columnIndexOfIForFamilyOfGuidHash)
          }
          val _tmpIForClassGuid: String?
          if (_stmt.isNull(_columnIndexOfIForClassGuid)) {
            _tmpIForClassGuid = null
          } else {
            _tmpIForClassGuid = _stmt.getText(_columnIndexOfIForClassGuid)
          }
          val _tmpIForClassName: String?
          if (_stmt.isNull(_columnIndexOfIForClassName)) {
            _tmpIForClassName = null
          } else {
            _tmpIForClassName = _stmt.getText(_columnIndexOfIForClassName)
          }
          val _tmpISchoolName: String?
          if (_stmt.isNull(_columnIndexOfISchoolName)) {
            _tmpISchoolName = null
          } else {
            _tmpISchoolName = _stmt.getText(_columnIndexOfISchoolName)
          }
          val _tmpIForClassGuidHash: Long?
          if (_stmt.isNull(_columnIndexOfIForClassGuidHash)) {
            _tmpIForClassGuidHash = null
          } else {
            _tmpIForClassGuidHash = _stmt.getLong(_columnIndexOfIForClassGuidHash)
          }
          val _tmpIForClassRole: EnrollmentRoleEnum?
          val _tmp_1: Int?
          if (_stmt.isNull(_columnIndexOfIForClassRole)) {
            _tmp_1 = null
          } else {
            _tmp_1 = _stmt.getLong(_columnIndexOfIForClassRole).toInt()
          }
          if (_tmp_1 == null) {
            _tmpIForClassRole = null
          } else {
            _tmpIForClassRole = __schoolTypeConverters.toEnrollmentRoleEnum(_tmp_1)
          }
          val _tmpIInviteMultipleAllowed: Boolean
          val _tmp_2: Int
          _tmp_2 = _stmt.getLong(_columnIndexOfIInviteMultipleAllowed).toInt()
          _tmpIInviteMultipleAllowed = _tmp_2 != 0
          val _tmpIIsFirstUser: Boolean
          val _tmp_3: Int
          _tmp_3 = _stmt.getLong(_columnIndexOfIIsFirstUser).toInt()
          _tmpIIsFirstUser = _tmp_3 != 0
          val _tmpIApprovalRequired: Boolean
          val _tmp_4: Int
          _tmp_4 = _stmt.getLong(_columnIndexOfIApprovalRequired).toInt()
          _tmpIApprovalRequired = _tmp_4 != 0
          val _tmpILastModified: Long
          _tmpILastModified = _stmt.getLong(_columnIndexOfILastModified)
          val _tmpIExpiration: Long
          _tmpIExpiration = _stmt.getLong(_columnIndexOfIExpiration)
          val _tmpIInviteStatus: Int
          _tmpIInviteStatus = _stmt.getLong(_columnIndexOfIInviteStatus).toInt()
          _result = InviteEntity(_tmpIGuid,_tmpIGuidHash,_tmpICode,_tmpINewRole,_tmpIForFamilyOfGuid,_tmpIForFamilyOfGuidHash,_tmpIForClassGuid,_tmpIForClassName,_tmpISchoolName,_tmpIForClassGuidHash,_tmpIForClassRole,_tmpIInviteMultipleAllowed,_tmpIIsFirstUser,_tmpIApprovalRequired,_tmpILastModified,_tmpIExpiration,_tmpIInviteStatus)
        } else {
          _result = null
        }
        _result
      } finally {
        _stmt.close()
      }
    }
  }

  public override fun findByGuidHashAsFlow(guidHash: Long): Flow<InviteEntity?> {
    val _sql: String = """
        |
        |        SELECT * 
        |          FROM InviteEntity
        |         WHERE iGuidHash = ?
        |         LIMIT 1
        |    
        """.trimMargin()
    return createFlow(__db, false, arrayOf("InviteEntity")) { _connection ->
      val _stmt: SQLiteStatement = _connection.prepare(_sql)
      try {
        var _argIndex: Int = 1
        _stmt.bindLong(_argIndex, guidHash)
        val _columnIndexOfIGuid: Int = getColumnIndexOrThrow(_stmt, "iGuid")
        val _columnIndexOfIGuidHash: Int = getColumnIndexOrThrow(_stmt, "iGuidHash")
        val _columnIndexOfICode: Int = getColumnIndexOrThrow(_stmt, "iCode")
        val _columnIndexOfINewRole: Int = getColumnIndexOrThrow(_stmt, "iNewRole")
        val _columnIndexOfIForFamilyOfGuid: Int = getColumnIndexOrThrow(_stmt, "iForFamilyOfGuid")
        val _columnIndexOfIForFamilyOfGuidHash: Int = getColumnIndexOrThrow(_stmt, "iForFamilyOfGuidHash")
        val _columnIndexOfIForClassGuid: Int = getColumnIndexOrThrow(_stmt, "iForClassGuid")
        val _columnIndexOfIForClassName: Int = getColumnIndexOrThrow(_stmt, "iForClassName")
        val _columnIndexOfISchoolName: Int = getColumnIndexOrThrow(_stmt, "iSchoolName")
        val _columnIndexOfIForClassGuidHash: Int = getColumnIndexOrThrow(_stmt, "iForClassGuidHash")
        val _columnIndexOfIForClassRole: Int = getColumnIndexOrThrow(_stmt, "iForClassRole")
        val _columnIndexOfIInviteMultipleAllowed: Int = getColumnIndexOrThrow(_stmt, "iInviteMultipleAllowed")
        val _columnIndexOfIIsFirstUser: Int = getColumnIndexOrThrow(_stmt, "iIsFirstUser")
        val _columnIndexOfIApprovalRequired: Int = getColumnIndexOrThrow(_stmt, "iApprovalRequired")
        val _columnIndexOfILastModified: Int = getColumnIndexOrThrow(_stmt, "iLastModified")
        val _columnIndexOfIExpiration: Int = getColumnIndexOrThrow(_stmt, "iExpiration")
        val _columnIndexOfIInviteStatus: Int = getColumnIndexOrThrow(_stmt, "iInviteStatus")
        val _result: InviteEntity?
        if (_stmt.step()) {
          val _tmpIGuid: String
          _tmpIGuid = _stmt.getText(_columnIndexOfIGuid)
          val _tmpIGuidHash: Long
          _tmpIGuidHash = _stmt.getLong(_columnIndexOfIGuidHash)
          val _tmpICode: String
          _tmpICode = _stmt.getText(_columnIndexOfICode)
          val _tmpINewRole: PersonRoleEnum?
          val _tmp: Int?
          if (_stmt.isNull(_columnIndexOfINewRole)) {
            _tmp = null
          } else {
            _tmp = _stmt.getLong(_columnIndexOfINewRole).toInt()
          }
          if (_tmp == null) {
            _tmpINewRole = null
          } else {
            _tmpINewRole = __schoolTypeConverters.toPersonRoleType(_tmp)
          }
          val _tmpIForFamilyOfGuid: String?
          if (_stmt.isNull(_columnIndexOfIForFamilyOfGuid)) {
            _tmpIForFamilyOfGuid = null
          } else {
            _tmpIForFamilyOfGuid = _stmt.getText(_columnIndexOfIForFamilyOfGuid)
          }
          val _tmpIForFamilyOfGuidHash: Long?
          if (_stmt.isNull(_columnIndexOfIForFamilyOfGuidHash)) {
            _tmpIForFamilyOfGuidHash = null
          } else {
            _tmpIForFamilyOfGuidHash = _stmt.getLong(_columnIndexOfIForFamilyOfGuidHash)
          }
          val _tmpIForClassGuid: String?
          if (_stmt.isNull(_columnIndexOfIForClassGuid)) {
            _tmpIForClassGuid = null
          } else {
            _tmpIForClassGuid = _stmt.getText(_columnIndexOfIForClassGuid)
          }
          val _tmpIForClassName: String?
          if (_stmt.isNull(_columnIndexOfIForClassName)) {
            _tmpIForClassName = null
          } else {
            _tmpIForClassName = _stmt.getText(_columnIndexOfIForClassName)
          }
          val _tmpISchoolName: String?
          if (_stmt.isNull(_columnIndexOfISchoolName)) {
            _tmpISchoolName = null
          } else {
            _tmpISchoolName = _stmt.getText(_columnIndexOfISchoolName)
          }
          val _tmpIForClassGuidHash: Long?
          if (_stmt.isNull(_columnIndexOfIForClassGuidHash)) {
            _tmpIForClassGuidHash = null
          } else {
            _tmpIForClassGuidHash = _stmt.getLong(_columnIndexOfIForClassGuidHash)
          }
          val _tmpIForClassRole: EnrollmentRoleEnum?
          val _tmp_1: Int?
          if (_stmt.isNull(_columnIndexOfIForClassRole)) {
            _tmp_1 = null
          } else {
            _tmp_1 = _stmt.getLong(_columnIndexOfIForClassRole).toInt()
          }
          if (_tmp_1 == null) {
            _tmpIForClassRole = null
          } else {
            _tmpIForClassRole = __schoolTypeConverters.toEnrollmentRoleEnum(_tmp_1)
          }
          val _tmpIInviteMultipleAllowed: Boolean
          val _tmp_2: Int
          _tmp_2 = _stmt.getLong(_columnIndexOfIInviteMultipleAllowed).toInt()
          _tmpIInviteMultipleAllowed = _tmp_2 != 0
          val _tmpIIsFirstUser: Boolean
          val _tmp_3: Int
          _tmp_3 = _stmt.getLong(_columnIndexOfIIsFirstUser).toInt()
          _tmpIIsFirstUser = _tmp_3 != 0
          val _tmpIApprovalRequired: Boolean
          val _tmp_4: Int
          _tmp_4 = _stmt.getLong(_columnIndexOfIApprovalRequired).toInt()
          _tmpIApprovalRequired = _tmp_4 != 0
          val _tmpILastModified: Long
          _tmpILastModified = _stmt.getLong(_columnIndexOfILastModified)
          val _tmpIExpiration: Long
          _tmpIExpiration = _stmt.getLong(_columnIndexOfIExpiration)
          val _tmpIInviteStatus: Int
          _tmpIInviteStatus = _stmt.getLong(_columnIndexOfIInviteStatus).toInt()
          _result = InviteEntity(_tmpIGuid,_tmpIGuidHash,_tmpICode,_tmpINewRole,_tmpIForFamilyOfGuid,_tmpIForFamilyOfGuidHash,_tmpIForClassGuid,_tmpIForClassName,_tmpISchoolName,_tmpIForClassGuidHash,_tmpIForClassRole,_tmpIInviteMultipleAllowed,_tmpIIsFirstUser,_tmpIApprovalRequired,_tmpILastModified,_tmpIExpiration,_tmpIInviteStatus)
        } else {
          _result = null
        }
        _result
      } finally {
        _stmt.close()
      }
    }
  }

  public override fun findAllAsPagingSource(guidHash: Long, code: String?): PagingSource<Int, InviteEntity> {
    val _sql: String = """
        |  
        |        SELECT InviteEntity.* 
        |         FROM InviteEntity
        |        WHERE (? = 0 OR InviteEntity.iGuidHash = ?)
        |          AND (? IS NULL 
        |                OR InviteEntity.iCode = ?)
        |          
        """.trimMargin()
    val _rawQuery: RoomRawQuery = RoomRawQuery(_sql) { _stmt ->
      var _argIndex: Int = 1
      _stmt.bindLong(_argIndex, guidHash)
      _argIndex = 2
      _stmt.bindLong(_argIndex, guidHash)
      _argIndex = 3
      if (code == null) {
        _stmt.bindNull(_argIndex)
      } else {
        _stmt.bindText(_argIndex, code)
      }
      _argIndex = 4
      if (code == null) {
        _stmt.bindNull(_argIndex)
      } else {
        _stmt.bindText(_argIndex, code)
      }
    }
    return object : LimitOffsetPagingSource<InviteEntity>(_rawQuery, __db, "InviteEntity") {
      protected override suspend fun convertRows(limitOffsetQuery: RoomRawQuery, itemCount: Int): List<InviteEntity> = performSuspending(__db, true, false) { _connection ->
        val _stmt: SQLiteStatement = _connection.prepare(limitOffsetQuery.sql)
        limitOffsetQuery.getBindingFunction().invoke(_stmt)
        try {
          val _columnIndexOfIGuid: Int = getColumnIndexOrThrow(_stmt, "iGuid")
          val _columnIndexOfIGuidHash: Int = getColumnIndexOrThrow(_stmt, "iGuidHash")
          val _columnIndexOfICode: Int = getColumnIndexOrThrow(_stmt, "iCode")
          val _columnIndexOfINewRole: Int = getColumnIndexOrThrow(_stmt, "iNewRole")
          val _columnIndexOfIForFamilyOfGuid: Int = getColumnIndexOrThrow(_stmt, "iForFamilyOfGuid")
          val _columnIndexOfIForFamilyOfGuidHash: Int = getColumnIndexOrThrow(_stmt, "iForFamilyOfGuidHash")
          val _columnIndexOfIForClassGuid: Int = getColumnIndexOrThrow(_stmt, "iForClassGuid")
          val _columnIndexOfIForClassName: Int = getColumnIndexOrThrow(_stmt, "iForClassName")
          val _columnIndexOfISchoolName: Int = getColumnIndexOrThrow(_stmt, "iSchoolName")
          val _columnIndexOfIForClassGuidHash: Int = getColumnIndexOrThrow(_stmt, "iForClassGuidHash")
          val _columnIndexOfIForClassRole: Int = getColumnIndexOrThrow(_stmt, "iForClassRole")
          val _columnIndexOfIInviteMultipleAllowed: Int = getColumnIndexOrThrow(_stmt, "iInviteMultipleAllowed")
          val _columnIndexOfIIsFirstUser: Int = getColumnIndexOrThrow(_stmt, "iIsFirstUser")
          val _columnIndexOfIApprovalRequired: Int = getColumnIndexOrThrow(_stmt, "iApprovalRequired")
          val _columnIndexOfILastModified: Int = getColumnIndexOrThrow(_stmt, "iLastModified")
          val _columnIndexOfIExpiration: Int = getColumnIndexOrThrow(_stmt, "iExpiration")
          val _columnIndexOfIInviteStatus: Int = getColumnIndexOrThrow(_stmt, "iInviteStatus")
          val _result: MutableList<InviteEntity> = mutableListOf()
          while (_stmt.step()) {
            val _item: InviteEntity
            val _tmpIGuid: String
            _tmpIGuid = _stmt.getText(_columnIndexOfIGuid)
            val _tmpIGuidHash: Long
            _tmpIGuidHash = _stmt.getLong(_columnIndexOfIGuidHash)
            val _tmpICode: String
            _tmpICode = _stmt.getText(_columnIndexOfICode)
            val _tmpINewRole: PersonRoleEnum?
            val _tmp: Int?
            if (_stmt.isNull(_columnIndexOfINewRole)) {
              _tmp = null
            } else {
              _tmp = _stmt.getLong(_columnIndexOfINewRole).toInt()
            }
            if (_tmp == null) {
              _tmpINewRole = null
            } else {
              _tmpINewRole = __schoolTypeConverters.toPersonRoleType(_tmp)
            }
            val _tmpIForFamilyOfGuid: String?
            if (_stmt.isNull(_columnIndexOfIForFamilyOfGuid)) {
              _tmpIForFamilyOfGuid = null
            } else {
              _tmpIForFamilyOfGuid = _stmt.getText(_columnIndexOfIForFamilyOfGuid)
            }
            val _tmpIForFamilyOfGuidHash: Long?
            if (_stmt.isNull(_columnIndexOfIForFamilyOfGuidHash)) {
              _tmpIForFamilyOfGuidHash = null
            } else {
              _tmpIForFamilyOfGuidHash = _stmt.getLong(_columnIndexOfIForFamilyOfGuidHash)
            }
            val _tmpIForClassGuid: String?
            if (_stmt.isNull(_columnIndexOfIForClassGuid)) {
              _tmpIForClassGuid = null
            } else {
              _tmpIForClassGuid = _stmt.getText(_columnIndexOfIForClassGuid)
            }
            val _tmpIForClassName: String?
            if (_stmt.isNull(_columnIndexOfIForClassName)) {
              _tmpIForClassName = null
            } else {
              _tmpIForClassName = _stmt.getText(_columnIndexOfIForClassName)
            }
            val _tmpISchoolName: String?
            if (_stmt.isNull(_columnIndexOfISchoolName)) {
              _tmpISchoolName = null
            } else {
              _tmpISchoolName = _stmt.getText(_columnIndexOfISchoolName)
            }
            val _tmpIForClassGuidHash: Long?
            if (_stmt.isNull(_columnIndexOfIForClassGuidHash)) {
              _tmpIForClassGuidHash = null
            } else {
              _tmpIForClassGuidHash = _stmt.getLong(_columnIndexOfIForClassGuidHash)
            }
            val _tmpIForClassRole: EnrollmentRoleEnum?
            val _tmp_1: Int?
            if (_stmt.isNull(_columnIndexOfIForClassRole)) {
              _tmp_1 = null
            } else {
              _tmp_1 = _stmt.getLong(_columnIndexOfIForClassRole).toInt()
            }
            if (_tmp_1 == null) {
              _tmpIForClassRole = null
            } else {
              _tmpIForClassRole = __schoolTypeConverters.toEnrollmentRoleEnum(_tmp_1)
            }
            val _tmpIInviteMultipleAllowed: Boolean
            val _tmp_2: Int
            _tmp_2 = _stmt.getLong(_columnIndexOfIInviteMultipleAllowed).toInt()
            _tmpIInviteMultipleAllowed = _tmp_2 != 0
            val _tmpIIsFirstUser: Boolean
            val _tmp_3: Int
            _tmp_3 = _stmt.getLong(_columnIndexOfIIsFirstUser).toInt()
            _tmpIIsFirstUser = _tmp_3 != 0
            val _tmpIApprovalRequired: Boolean
            val _tmp_4: Int
            _tmp_4 = _stmt.getLong(_columnIndexOfIApprovalRequired).toInt()
            _tmpIApprovalRequired = _tmp_4 != 0
            val _tmpILastModified: Long
            _tmpILastModified = _stmt.getLong(_columnIndexOfILastModified)
            val _tmpIExpiration: Long
            _tmpIExpiration = _stmt.getLong(_columnIndexOfIExpiration)
            val _tmpIInviteStatus: Int
            _tmpIInviteStatus = _stmt.getLong(_columnIndexOfIInviteStatus).toInt()
            _item = InviteEntity(_tmpIGuid,_tmpIGuidHash,_tmpICode,_tmpINewRole,_tmpIForFamilyOfGuid,_tmpIForFamilyOfGuidHash,_tmpIForClassGuid,_tmpIForClassName,_tmpISchoolName,_tmpIForClassGuidHash,_tmpIForClassRole,_tmpIInviteMultipleAllowed,_tmpIIsFirstUser,_tmpIApprovalRequired,_tmpILastModified,_tmpIExpiration,_tmpIInviteStatus)
            _result.add(_item)
          }
          _result
        } finally {
          _stmt.close()
        }
      }
    }
  }

  public override suspend fun findByUidList(uidNums: List<Long>): List<InviteEntity> {
    val _stringBuilder: StringBuilder = StringBuilder()
    _stringBuilder.append("""
        |
        |""".trimMargin())
    _stringBuilder.append("        SELECT * ")
    _stringBuilder.append("""
        |
        |""".trimMargin())
    _stringBuilder.append("          FROM InviteEntity")
    _stringBuilder.append("""
        |
        |""".trimMargin())
    _stringBuilder.append("         WHERE iGuidHash IN (")
    val _inputSize: Int = uidNums.size
    appendPlaceholders(_stringBuilder, _inputSize)
    _stringBuilder.append(")")
    _stringBuilder.append("""
        |
        |""".trimMargin())
    _stringBuilder.append("    ")
    val _sql: String = _stringBuilder.toString()
    return performSuspending(__db, true, false) { _connection ->
      val _stmt: SQLiteStatement = _connection.prepare(_sql)
      try {
        var _argIndex: Int = 1
        for (_item: Long in uidNums) {
          _stmt.bindLong(_argIndex, _item)
          _argIndex++
        }
        val _columnIndexOfIGuid: Int = getColumnIndexOrThrow(_stmt, "iGuid")
        val _columnIndexOfIGuidHash: Int = getColumnIndexOrThrow(_stmt, "iGuidHash")
        val _columnIndexOfICode: Int = getColumnIndexOrThrow(_stmt, "iCode")
        val _columnIndexOfINewRole: Int = getColumnIndexOrThrow(_stmt, "iNewRole")
        val _columnIndexOfIForFamilyOfGuid: Int = getColumnIndexOrThrow(_stmt, "iForFamilyOfGuid")
        val _columnIndexOfIForFamilyOfGuidHash: Int = getColumnIndexOrThrow(_stmt, "iForFamilyOfGuidHash")
        val _columnIndexOfIForClassGuid: Int = getColumnIndexOrThrow(_stmt, "iForClassGuid")
        val _columnIndexOfIForClassName: Int = getColumnIndexOrThrow(_stmt, "iForClassName")
        val _columnIndexOfISchoolName: Int = getColumnIndexOrThrow(_stmt, "iSchoolName")
        val _columnIndexOfIForClassGuidHash: Int = getColumnIndexOrThrow(_stmt, "iForClassGuidHash")
        val _columnIndexOfIForClassRole: Int = getColumnIndexOrThrow(_stmt, "iForClassRole")
        val _columnIndexOfIInviteMultipleAllowed: Int = getColumnIndexOrThrow(_stmt, "iInviteMultipleAllowed")
        val _columnIndexOfIIsFirstUser: Int = getColumnIndexOrThrow(_stmt, "iIsFirstUser")
        val _columnIndexOfIApprovalRequired: Int = getColumnIndexOrThrow(_stmt, "iApprovalRequired")
        val _columnIndexOfILastModified: Int = getColumnIndexOrThrow(_stmt, "iLastModified")
        val _columnIndexOfIExpiration: Int = getColumnIndexOrThrow(_stmt, "iExpiration")
        val _columnIndexOfIInviteStatus: Int = getColumnIndexOrThrow(_stmt, "iInviteStatus")
        val _result: MutableList<InviteEntity> = mutableListOf()
        while (_stmt.step()) {
          val _item_1: InviteEntity
          val _tmpIGuid: String
          _tmpIGuid = _stmt.getText(_columnIndexOfIGuid)
          val _tmpIGuidHash: Long
          _tmpIGuidHash = _stmt.getLong(_columnIndexOfIGuidHash)
          val _tmpICode: String
          _tmpICode = _stmt.getText(_columnIndexOfICode)
          val _tmpINewRole: PersonRoleEnum?
          val _tmp: Int?
          if (_stmt.isNull(_columnIndexOfINewRole)) {
            _tmp = null
          } else {
            _tmp = _stmt.getLong(_columnIndexOfINewRole).toInt()
          }
          if (_tmp == null) {
            _tmpINewRole = null
          } else {
            _tmpINewRole = __schoolTypeConverters.toPersonRoleType(_tmp)
          }
          val _tmpIForFamilyOfGuid: String?
          if (_stmt.isNull(_columnIndexOfIForFamilyOfGuid)) {
            _tmpIForFamilyOfGuid = null
          } else {
            _tmpIForFamilyOfGuid = _stmt.getText(_columnIndexOfIForFamilyOfGuid)
          }
          val _tmpIForFamilyOfGuidHash: Long?
          if (_stmt.isNull(_columnIndexOfIForFamilyOfGuidHash)) {
            _tmpIForFamilyOfGuidHash = null
          } else {
            _tmpIForFamilyOfGuidHash = _stmt.getLong(_columnIndexOfIForFamilyOfGuidHash)
          }
          val _tmpIForClassGuid: String?
          if (_stmt.isNull(_columnIndexOfIForClassGuid)) {
            _tmpIForClassGuid = null
          } else {
            _tmpIForClassGuid = _stmt.getText(_columnIndexOfIForClassGuid)
          }
          val _tmpIForClassName: String?
          if (_stmt.isNull(_columnIndexOfIForClassName)) {
            _tmpIForClassName = null
          } else {
            _tmpIForClassName = _stmt.getText(_columnIndexOfIForClassName)
          }
          val _tmpISchoolName: String?
          if (_stmt.isNull(_columnIndexOfISchoolName)) {
            _tmpISchoolName = null
          } else {
            _tmpISchoolName = _stmt.getText(_columnIndexOfISchoolName)
          }
          val _tmpIForClassGuidHash: Long?
          if (_stmt.isNull(_columnIndexOfIForClassGuidHash)) {
            _tmpIForClassGuidHash = null
          } else {
            _tmpIForClassGuidHash = _stmt.getLong(_columnIndexOfIForClassGuidHash)
          }
          val _tmpIForClassRole: EnrollmentRoleEnum?
          val _tmp_1: Int?
          if (_stmt.isNull(_columnIndexOfIForClassRole)) {
            _tmp_1 = null
          } else {
            _tmp_1 = _stmt.getLong(_columnIndexOfIForClassRole).toInt()
          }
          if (_tmp_1 == null) {
            _tmpIForClassRole = null
          } else {
            _tmpIForClassRole = __schoolTypeConverters.toEnrollmentRoleEnum(_tmp_1)
          }
          val _tmpIInviteMultipleAllowed: Boolean
          val _tmp_2: Int
          _tmp_2 = _stmt.getLong(_columnIndexOfIInviteMultipleAllowed).toInt()
          _tmpIInviteMultipleAllowed = _tmp_2 != 0
          val _tmpIIsFirstUser: Boolean
          val _tmp_3: Int
          _tmp_3 = _stmt.getLong(_columnIndexOfIIsFirstUser).toInt()
          _tmpIIsFirstUser = _tmp_3 != 0
          val _tmpIApprovalRequired: Boolean
          val _tmp_4: Int
          _tmp_4 = _stmt.getLong(_columnIndexOfIApprovalRequired).toInt()
          _tmpIApprovalRequired = _tmp_4 != 0
          val _tmpILastModified: Long
          _tmpILastModified = _stmt.getLong(_columnIndexOfILastModified)
          val _tmpIExpiration: Long
          _tmpIExpiration = _stmt.getLong(_columnIndexOfIExpiration)
          val _tmpIInviteStatus: Int
          _tmpIInviteStatus = _stmt.getLong(_columnIndexOfIInviteStatus).toInt()
          _item_1 = InviteEntity(_tmpIGuid,_tmpIGuidHash,_tmpICode,_tmpINewRole,_tmpIForFamilyOfGuid,_tmpIForFamilyOfGuidHash,_tmpIForClassGuid,_tmpIForClassName,_tmpISchoolName,_tmpIForClassGuidHash,_tmpIForClassRole,_tmpIInviteMultipleAllowed,_tmpIIsFirstUser,_tmpIApprovalRequired,_tmpILastModified,_tmpIExpiration,_tmpIInviteStatus)
          _result.add(_item_1)
        }
        _result
      } finally {
        _stmt.close()
      }
    }
  }

  public override suspend fun updateInviteStatus(
    guid: String,
    status: Int,
    lastModified: Long,
  ) {
    val _sql: String = """
        |
        |        UPDATE InviteEntity
        |        SET iInviteStatus = ?,
        |            iLastModified = ?
        |        WHERE iGuid = ?
        |    
        """.trimMargin()
    return performSuspending(__db, false, true) { _connection ->
      val _stmt: SQLiteStatement = _connection.prepare(_sql)
      try {
        var _argIndex: Int = 1
        _stmt.bindLong(_argIndex, status.toLong())
        _argIndex = 2
        _stmt.bindLong(_argIndex, lastModified)
        _argIndex = 3
        _stmt.bindText(_argIndex, guid)
        _stmt.step()
      } finally {
        _stmt.close()
      }
    }
  }

  public override suspend fun deleteByGuidHash(guidHash: Long) {
    val _sql: String = """
        |
        |        DELETE FROM InviteEntity
        |         WHERE iGuidHash = ?
        |    
        """.trimMargin()
    return performSuspending(__db, false, true) { _connection ->
      val _stmt: SQLiteStatement = _connection.prepare(_sql)
      try {
        var _argIndex: Int = 1
        _stmt.bindLong(_argIndex, guidHash)
        _stmt.step()
      } finally {
        _stmt.close()
      }
    }
  }

  public companion object {
    public fun getRequiredConverters(): List<KClass<*>> = emptyList()
  }
}
