/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.libcache.cachecontrol;

import com.ustadmobile.libcache.cachecontrol.CacheControlDirectivesUtilKt;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0017\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cBO\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0002\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0002\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0002\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\u0006\u0012\u0006\u0010\t\u001a\u00020\u0006\u0012\u0006\u0010\n\u001a\u00020\u0006\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\u0002\u00a2\u0006\u0004\b\f\u0010\rR\u0019\u0010\u0003\u001a\u0004\u0018\u00010\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u000e\u001a\u0004\b\u000f\u0010\u0010R\u0019\u0010\u0004\u001a\u0004\u0018\u00010\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0004\u0010\u000e\u001a\u0004\b\u0011\u0010\u0010R\u0019\u0010\u0005\u001a\u0004\u0018\u00010\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u000e\u001a\u0004\b\u0012\u0010\u0010R\u0017\u0010\u0007\u001a\u00020\u00068\u0006\u00a2\u0006\f\n\u0004\b\u0007\u0010\u0013\u001a\u0004\b\u0014\u0010\u0015R\u0017\u0010\b\u001a\u00020\u00068\u0006\u00a2\u0006\f\n\u0004\b\b\u0010\u0013\u001a\u0004\b\u0016\u0010\u0015R\u0017\u0010\t\u001a\u00020\u00068\u0006\u00a2\u0006\f\n\u0004\b\t\u0010\u0013\u001a\u0004\b\u0017\u0010\u0015R\u0017\u0010\n\u001a\u00020\u00068\u0006\u00a2\u0006\f\n\u0004\b\n\u0010\u0013\u001a\u0004\b\u0018\u0010\u0015R\u0019\u0010\u000b\u001a\u0004\u0018\u00010\u00028\u0006\u00a2\u0006\f\n\u0004\b\u000b\u0010\u000e\u001a\u0004\b\u0019\u0010\u0010R\u0013\u0010\u001b\u001a\u0004\u0018\u00010\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u0010\u00a8\u0006\u001d"}, d2={"Lcom/ustadmobile/libcache/cachecontrol/RequestCacheControlHeader;", "", "", "maxAge", "maxStale", "minFresh", "", "noCache", "noStore", "noTransform", "onlyIfCached", "staleIfError", "<init>", "(Ljava/lang/Long;Ljava/lang/Long;Ljava/lang/Long;ZZZZLjava/lang/Long;)V", "Ljava/lang/Long;", "getMaxAge", "()Ljava/lang/Long;", "getMaxStale", "getMinFresh", "Z", "getNoCache", "()Z", "getNoStore", "getNoTransform", "getOnlyIfCached", "getStaleIfError", "getStaleAtAge", "staleAtAge", "Companion", "respect-lib-cache"})
public final class RequestCacheControlHeader {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final Long maxAge;
    @Nullable
    private final Long maxStale;
    @Nullable
    private final Long minFresh;
    private final boolean noCache;
    private final boolean noStore;
    private final boolean noTransform;
    private final boolean onlyIfCached;
    @Nullable
    private final Long staleIfError;

    public RequestCacheControlHeader(@Nullable Long maxAge, @Nullable Long maxStale, @Nullable Long minFresh, boolean noCache, boolean noStore, boolean noTransform, boolean onlyIfCached, @Nullable Long staleIfError) {
        this.maxAge = maxAge;
        this.maxStale = maxStale;
        this.minFresh = minFresh;
        this.noCache = noCache;
        this.noStore = noStore;
        this.noTransform = noTransform;
        this.onlyIfCached = onlyIfCached;
        this.staleIfError = staleIfError;
    }

    @Nullable
    public final Long getMaxAge() {
        return this.maxAge;
    }

    @Nullable
    public final Long getMaxStale() {
        return this.maxStale;
    }

    @Nullable
    public final Long getMinFresh() {
        return this.minFresh;
    }

    public final boolean getNoCache() {
        return this.noCache;
    }

    public final boolean getNoStore() {
        return this.noStore;
    }

    public final boolean getNoTransform() {
        return this.noTransform;
    }

    public final boolean getOnlyIfCached() {
        return this.onlyIfCached;
    }

    @Nullable
    public final Long getStaleIfError() {
        return this.staleIfError;
    }

    @Nullable
    public final Long getStaleAtAge() {
        Long l;
        if (this.maxAge != null && this.minFresh != null) {
            l = Math.max(this.maxAge, this.minFresh);
        } else {
            l = this.maxAge;
            if (l == null) {
                l = this.minFresh;
            }
        }
        return l;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lcom/ustadmobile/libcache/cachecontrol/RequestCacheControlHeader$Companion;", "", "<init>", "()V", "", "header", "Lcom/ustadmobile/libcache/cachecontrol/RequestCacheControlHeader;", "parse", "(Ljava/lang/String;)Lcom/ustadmobile/libcache/cachecontrol/RequestCacheControlHeader;", "respect-lib-cache"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final RequestCacheControlHeader parse(@NotNull String header2) {
            Intrinsics.checkNotNullParameter(header2, "header");
            Map<String, String> directivesMap = CacheControlDirectivesUtilKt.headerDirectivesToMap(header2);
            String string2 = directivesMap.get("max-age");
            Long maxAge = string2 != null ? Long.valueOf(Long.parseLong(string2)) : null;
            String string3 = directivesMap.get("max-stale");
            Long maxStale = string3 != null ? Long.valueOf(Long.parseLong(string3)) : null;
            String string4 = directivesMap.get("min-fresh");
            Long minFresh = string4 != null ? Long.valueOf(Long.parseLong(string4)) : null;
            boolean noCache = directivesMap.containsKey("no-cache");
            boolean noStore = directivesMap.containsKey("no-store");
            boolean noTransform = directivesMap.containsKey("no-transform");
            boolean onlyIfCached = directivesMap.containsKey("only-if-cached");
            String string5 = directivesMap.get("stale-if-error");
            Long staleIfError = string5 != null ? Long.valueOf(Long.parseLong(string5)) : null;
            return new RequestCacheControlHeader(maxAge, maxStale, minFresh, noCache, noStore, noTransform, onlyIfCached, staleIfError);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

