/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.libcache.distributed.model;

import com.ustadmobile.libcache.distributed.model.DistributedCachePacket;
import com.ustadmobile.libcache.distributed.model.DistributedCacheWhatWithIdAndPayload;
import com.ustadmobile.libcache.util.ByteBufferExtKt;
import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\r\u0018\u0000 \u00122\u00020\u00012\u00020\u0002:\u0001\u0012B\u001f\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\u000f\u0010\n\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\n\u0010\u000bR\u001a\u0010\u0004\u001a\u00020\u00038\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u0004\u0010\f\u001a\u0004\b\r\u0010\u000eR\u001a\u0010\u0005\u001a\u00020\u00038\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u0005\u0010\f\u001a\u0004\b\u000f\u0010\u000eR\u001a\u0010\u0007\u001a\u00020\u00068\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u0007\u0010\u0010\u001a\u0004\b\u0011\u0010\u000b\u00a8\u0006\u0013"}, d2={"Lcom/ustadmobile/libcache/distributed/model/DistributedCachePong;", "Lcom/ustadmobile/libcache/distributed/model/DistributedCachePacket;", "Lcom/ustadmobile/libcache/distributed/model/DistributedCacheWhatWithIdAndPayload;", "", "id", "httpPort", "", "payload", "<init>", "(II[B)V", "toBytes", "()[B", "I", "getId", "()I", "getHttpPort", "[B", "getPayload", "Companion", "respect-lib-cache"})
public final class DistributedCachePong
extends DistributedCachePacket
implements DistributedCacheWhatWithIdAndPayload {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int id;
    private final int httpPort;
    @NotNull
    private final byte[] payload;
    public static final int OVERHEAD_SIZE = 11;

    public DistributedCachePong(int id, int httpPort, @NotNull byte[] payload) {
        Intrinsics.checkNotNullParameter(payload, "payload");
        super(null);
        this.id = id;
        this.httpPort = httpPort;
        this.payload = payload;
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public int getHttpPort() {
        return this.httpPort;
    }

    @Override
    @NotNull
    public byte[] getPayload() {
        return this.payload;
    }

    @Override
    @NotNull
    public byte[] toBytes() {
        ByteBuffer byteBuf = ByteBuffer.allocate(11 + this.getPayload().length);
        byteBuf.put((byte)3);
        byteBuf.putInt(this.getHttpPort());
        byteBuf.putInt(this.getId());
        Intrinsics.checkNotNull(byteBuf);
        ByteBufferExtKt.writePayload(byteBuf, this.getPayload());
        byte[] byArray = byteBuf.array();
        Intrinsics.checkNotNullExpressionValue(byArray, "array(...)");
        return byArray;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0019\u0010\b\u001a\u00020\u0007*\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u00058\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lcom/ustadmobile/libcache/distributed/model/DistributedCachePong$Companion;", "", "<init>", "()V", "Ljava/nio/ByteBuffer;", "", "httpPort", "Lcom/ustadmobile/libcache/distributed/model/DistributedCachePong;", "readDistributedCachePong", "(Ljava/nio/ByteBuffer;I)Lcom/ustadmobile/libcache/distributed/model/DistributedCachePong;", "OVERHEAD_SIZE", "I", "respect-lib-cache"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final DistributedCachePong readDistributedCachePong(@NotNull ByteBuffer $this$readDistributedCachePong, int httpPort) {
            Intrinsics.checkNotNullParameter($this$readDistributedCachePong, "<this>");
            int id = $this$readDistributedCachePong.getInt();
            byte[] payload = ByteBufferExtKt.readPayload($this$readDistributedCachePong);
            return new DistributedCachePong(id, httpPort, payload);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

