/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.data;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.webauthn4j.data.AuthenticatorTransport;
import com.webauthn4j.data.PublicKeyCredentialType;
import com.webauthn4j.util.ArrayUtil;
import com.webauthn4j.util.AssertUtil;
import com.webauthn4j.util.CollectionUtil;
import java.util.Arrays;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PublicKeyCredentialDescriptor {
    private final PublicKeyCredentialType type;
    private final byte[] id;
    private final Set<AuthenticatorTransport> transports;

    @JsonCreator
    public PublicKeyCredentialDescriptor(@JsonProperty(value="type") @NotNull PublicKeyCredentialType type2, @JsonProperty(value="id") @NotNull byte[] id, @JsonProperty(value="transports") @Nullable Set<AuthenticatorTransport> transports) {
        AssertUtil.notNull(type2, "type must not be null");
        AssertUtil.notNull(id, "id must not be null");
        this.type = type2;
        this.id = ArrayUtil.clone(id);
        this.transports = CollectionUtil.unmodifiableSet(transports);
    }

    public PublicKeyCredentialType getType() {
        return this.type;
    }

    public byte[] getId() {
        return ArrayUtil.clone(this.id);
    }

    public Set<AuthenticatorTransport> getTransports() {
        return this.transports;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PublicKeyCredentialDescriptor that = (PublicKeyCredentialDescriptor)o;
        return Objects.equals(this.type, that.type) && Arrays.equals(this.id, that.id) && Objects.equals(this.transports, that.transports);
    }

    public int hashCode() {
        int result2 = Objects.hash(this.type, this.transports);
        result2 = 31 * result2 + Arrays.hashCode(this.id);
        return result2;
    }

    public String toString() {
        return "PublicKeyCredentialDescriptor(type=" + this.type + ", id=" + ArrayUtil.toHexString(this.id) + ", transports=" + this.transports + ")";
    }
}

