/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.server;

import com.webauthn4j.data.client.Origin;
import com.webauthn4j.data.client.challenge.Challenge;
import com.webauthn4j.server.CoreServerProperty;
import com.webauthn4j.util.ArrayUtil;
import com.webauthn4j.util.AssertUtil;
import java.util.Arrays;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ServerProperty
extends CoreServerProperty {
    private final Set<Origin> origins;
    private final byte[] tokenBindingId;

    public ServerProperty(@NotNull Origin origin2, @NotNull String rpId, @Nullable Challenge challenge2, @Nullable byte[] tokenBindingId) {
        super(rpId, challenge2);
        AssertUtil.notNull(origin2, "origin must not be null");
        this.origins = Collections.singleton(origin2);
        this.tokenBindingId = tokenBindingId;
    }

    public ServerProperty(@NotNull Set<Origin> origins, @NotNull String rpId, @Nullable Challenge challenge2, @Nullable byte[] tokenBindingId) {
        super(rpId, challenge2);
        AssertUtil.notNull(origins, "origins must not be null");
        this.origins = Collections.unmodifiableSet(origins);
        this.tokenBindingId = tokenBindingId;
    }

    @NotNull
    public Set<Origin> getOrigins() {
        return this.origins;
    }

    @Nullable
    public byte[] getTokenBindingId() {
        return this.tokenBindingId;
    }

    @Override
    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ServerProperty that = (ServerProperty)o;
        return Objects.equals(this.origins, that.origins) && Arrays.equals(this.tokenBindingId, that.tokenBindingId);
    }

    @Override
    public int hashCode() {
        int result2 = Objects.hash(super.hashCode(), this.origins);
        result2 = 31 * result2 + Arrays.hashCode(this.tokenBindingId);
        return result2;
    }

    @Override
    public String toString() {
        return "ServerProperty{rpId=" + this.getRpId() + ", challenge=" + this.getChallenge() + "origins=" + this.origins + ", tokenBindingId=" + ArrayUtil.toHexString(this.tokenBindingId) + "}";
    }
}

