/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.data.attestation.statement;

import com.webauthn4j.data.attestation.statement.TPMGenerated;
import com.webauthn4j.data.attestation.statement.TPMISTAttest;
import com.webauthn4j.data.attestation.statement.TPMSClockInfo;
import com.webauthn4j.data.attestation.statement.TPMUAttest;
import com.webauthn4j.data.attestation.statement.TPMUtil;
import com.webauthn4j.util.ArrayUtil;
import com.webauthn4j.util.UnsignedNumberUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TPMSAttest {
    private final TPMGenerated magic;
    private final TPMISTAttest type;
    private final byte[] qualifiedSigner;
    private final byte[] extraData;
    private final TPMSClockInfo clockInfo;
    private final BigInteger firmwareVersion;
    private final TPMUAttest attested;

    public TPMSAttest(@NotNull TPMGenerated magic, @NotNull TPMISTAttest type, @NotNull byte[] qualifiedSigner, @NotNull byte[] extraData, @NotNull TPMSClockInfo clockInfo, @NotNull BigInteger firmwareVersion, @NotNull TPMUAttest attested) {
        this.magic = magic;
        this.type = type;
        this.qualifiedSigner = qualifiedSigner;
        this.extraData = extraData;
        this.clockInfo = clockInfo;
        this.firmwareVersion = firmwareVersion;
        this.attested = attested;
    }

    @NotNull
    public TPMGenerated getMagic() {
        return this.magic;
    }

    @NotNull
    public TPMISTAttest getType() {
        return this.type;
    }

    @NotNull
    public byte[] getQualifiedSigner() {
        return ArrayUtil.clone((byte[])this.qualifiedSigner);
    }

    @NotNull
    public byte[] getExtraData() {
        return ArrayUtil.clone((byte[])this.extraData);
    }

    @NotNull
    public TPMSClockInfo getClockInfo() {
        return this.clockInfo;
    }

    @NotNull
    public BigInteger getFirmwareVersion() {
        return this.firmwareVersion;
    }

    @NotNull
    public TPMUAttest getAttested() {
        return this.attested;
    }

    @NotNull
    public byte[] getBytes() {
        try {
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            stream.write(this.getMagic().getValue());
            stream.write(this.getType().getValue());
            TPMUtil.writeSizedArray(stream, this.getQualifiedSigner());
            TPMUtil.writeSizedArray(stream, this.getExtraData());
            stream.write(this.getClockInfo().getBytes());
            stream.write(UnsignedNumberUtil.toBytes((BigInteger)this.getFirmwareVersion()));
            stream.write(this.getAttested().getBytes());
            return stream.toByteArray();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TPMSAttest that = (TPMSAttest)o;
        return this.magic == that.magic && this.type == that.type && Arrays.equals(this.qualifiedSigner, that.qualifiedSigner) && Arrays.equals(this.extraData, that.extraData) && Objects.equals(this.clockInfo, that.clockInfo) && Objects.equals(this.firmwareVersion, that.firmwareVersion) && Objects.equals(this.attested, that.attested);
    }

    public int hashCode() {
        int result = Objects.hash(new Object[]{this.magic, this.type, this.clockInfo, this.firmwareVersion, this.attested});
        result = 31 * result + Arrays.hashCode(this.qualifiedSigner);
        result = 31 * result + Arrays.hashCode(this.extraData);
        return result;
    }
}

